/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.math.tfloat;

import cern.jet.math.tfloat.FloatConstants;

public class FloatArithmetic
extends FloatConstants {
    private static final float[] stirlingCorrection = new float[]{0.0f, 0.08106147f, 0.041340698f, 0.027677925f, 0.020790672f, 0.01664469f, 0.013876129f, 0.01189671f, 0.010411265f, 0.009255462f, 0.008330563f, 0.0075736754f, 0.0069428403f, 0.006408994f, 0.00595137f, 0.005554734f, 0.005207656f, 0.004901396f, 0.0046291538f, 0.0043855603f, 0.0041663195f, 0.0039679543f, 0.0037876181f, 0.0036229603f, 0.0034720213f, 0.0033331555f, 0.0032049702f, 0.0030862787f, 0.002976064f, 0.0028734494f, 0.002777675f};
    protected static final float[] logFactorials = new float[]{0.0f, 0.0f, 0.6931472f, 1.7917595f, 3.1780539f, 4.787492f, 6.5792513f, 8.525162f, 10.604603f, 12.801827f, 15.104413f, 17.502308f, 19.987215f, 22.552164f, 25.191221f, 27.899271f, 30.67186f, 33.505074f, 36.395447f, 39.339886f, 42.335617f, 45.38014f, 48.47118f, 51.606674f, 54.78473f, 58.003605f, 61.261703f, 64.55754f, 67.88974f, 71.25704f};
    protected static final long[] longFactorials = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L, 3628800L, 39916800L, 479001600L, 6227020800L, 87178291200L, 1307674368000L, 20922789888000L, 355687428096000L, 6402373705728000L, 121645100408832000L, 2432902008176640000L};
    protected static final float[] floatFactorials = new float[]{5.109094E19f, 1.1240007E21f, 2.5852017E22f, 6.204484E23f, 1.551121E25f, 4.0329146E26f, 1.0888869E28f, 3.0488833E29f, 8.841762E30f, 2.6525285E32f, 8.2228384E33f, 2.6313083E35f, 8.683318E36f, 2.952328E38f};

    protected FloatArithmetic() {
    }

    public static float binomial(float n, long k) {
        if (k < 0L) {
            return 0.0f;
        }
        if (k == 0L) {
            return 1.0f;
        }
        if (k == 1L) {
            return n;
        }
        float a = n - (float)k + 1.0f;
        float b = 1.0f;
        float binomial = 1.0f;
        long i = k;
        while (i-- > 0L) {
            float f = a;
            a = f + 1.0f;
            float f2 = b;
            b = f2 + 1.0f;
            binomial *= f / f2;
        }
        return binomial;
    }

    public static float binomial(long n, long k) {
        if (k < 0L) {
            return 0.0f;
        }
        if (k == 0L || k == n) {
            return 1.0f;
        }
        if (k == 1L || k == n - 1L) {
            return n;
        }
        if (n > k) {
            int max = longFactorials.length + floatFactorials.length;
            if (n < (long)max) {
                float n_fac = FloatArithmetic.factorial((int)n);
                float k_fac = FloatArithmetic.factorial((int)k);
                float n_minus_k_fac = FloatArithmetic.factorial((int)(n - k));
                float nk = n_minus_k_fac * k_fac;
                if (nk != Float.POSITIVE_INFINITY) {
                    return n_fac / nk;
                }
            }
            if (k > n / 2L) {
                k = n - k;
            }
        }
        long a = n - k + 1L;
        long b = 1L;
        float binomial = 1.0f;
        long i = k;
        while (i-- > 0L) {
            binomial *= (float)a++ / (float)b++;
        }
        return binomial;
    }

    public static long ceil(float value) {
        return Math.round(Math.ceil(value));
    }

    public static float chbevl(float x, float[] coef, int N) throws ArithmeticException {
        float b2;
        int p = 0;
        float b0 = coef[p++];
        float b1 = 0.0f;
        int i = N - 1;
        do {
            b2 = b1;
            b1 = b0;
            b0 = x * b1 - b2 + coef[p++];
        } while (--i > 0);
        return 0.5f * (b0 - b2);
    }

    private static long fac1(int j) {
        long i = j;
        if (j < 0) {
            i = Math.abs(j);
        }
        if (i > (long)longFactorials.length) {
            throw new IllegalArgumentException("Overflow");
        }
        long d = 1L;
        while (i > 1L) {
            d *= i--;
        }
        if (j < 0) {
            return -d;
        }
        return d;
    }

    private static float fac2(int j) {
        long i = j;
        if (j < 0) {
            i = Math.abs(j);
        }
        float d = 1.0f;
        while (i > 1L) {
            d *= (float)i--;
        }
        if (j < 0) {
            return -d;
        }
        return d;
    }

    public static float factorial(int k) {
        if (k < 0) {
            throw new IllegalArgumentException();
        }
        int length1 = longFactorials.length;
        if (k < length1) {
            return longFactorials[k];
        }
        int length2 = floatFactorials.length;
        if (k < length1 + length2) {
            return floatFactorials[k - length1];
        }
        return Float.POSITIVE_INFINITY;
    }

    public static long floor(float value) {
        return Math.round(Math.floor(value));
    }

    public static float log(float base, float value) {
        return (float)(Math.log(value) / Math.log(base));
    }

    public static float log10(float value) {
        return (float)(Math.log(value) * 0.43429448190325176);
    }

    public static float log2(float value) {
        return (float)(Math.log(value) * 1.4426950408889634);
    }

    public static float logFactorial(int k) {
        if (k >= 30) {
            float C0 = 0.9189385f;
            float C1 = 0.083333336f;
            float C3 = -0.0027777778f;
            float C5 = 7.936508E-4f;
            float C7 = -5.952381E-4f;
            float r = 1.0f / (float)k;
            float rr = r * r;
            return (float)(((double)k + 0.5) * Math.log(k) - (double)k + 0.9189385175704956 + (double)(r * (0.083333336f + rr * (-0.0027777778f + rr * (7.936508E-4f + rr * -5.952381E-4f)))));
        }
        return logFactorials[k];
    }

    public static long longFactorial(int k) throws IllegalArgumentException {
        if (k < 0) {
            throw new IllegalArgumentException("Negative k");
        }
        if (k < longFactorials.length) {
            return longFactorials[k];
        }
        throw new IllegalArgumentException("Overflow");
    }

    public static float stirlingCorrection(int k) {
        float C1 = 0.083333336f;
        float C3 = -0.0027777778f;
        float C5 = 7.936508E-4f;
        float C7 = -5.952381E-4f;
        if (k > 30) {
            float r = 1.0f / (float)k;
            float rr = r * r;
            return r * (0.083333336f + rr * (-0.0027777778f + rr * (7.936508E-4f + rr * -5.952381E-4f)));
        }
        return stirlingCorrection[k];
    }

    private static long xlongBinomial(long n, long k) {
        return Math.round(FloatArithmetic.binomial(n, k));
    }
}

