/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random.tdouble;

import cern.jet.random.tdouble.AbstractContinousDoubleDistribution;
import cern.jet.random.tdouble.Fun;
import cern.jet.random.tdouble.engine.DoubleRandomEngine;
import cern.jet.stat.tdouble.Probability;

public class ChiSquare
extends AbstractContinousDoubleDistribution {
    private static final long serialVersionUID = 1L;
    protected double freedom;
    private double freedom_in = -1.0;
    private double b;
    private double vm;
    private double vp;
    private double vd;
    protected static ChiSquare shared = new ChiSquare(1.0, ChiSquare.makeDefaultGenerator());

    public ChiSquare(double freedom, DoubleRandomEngine randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.setState(freedom);
    }

    public double cdf(double x) {
        return Probability.chiSquare(this.freedom, x);
    }

    @Override
    public double nextDouble() {
        return this.nextDouble(this.freedom);
    }

    public double nextDouble(double freedom) {
        double z;
        if (freedom == 1.0) {
            double z2;
            while (true) {
                double u = this.randomGenerator.raw();
                double v = this.randomGenerator.raw() * 0.857763884960707;
                z2 = v / u;
                if (z2 < 0.0) continue;
                double zz = z2 * z2;
                double r = 2.5 - zz;
                if (z2 < 0.0) {
                    r += zz * z2 / (3.0 * z2);
                }
                if (u < r * 0.3894003915) {
                    return z2 * z2;
                }
                if (!(zz > 1.036961043 / u + 1.4) && 2.0 * Math.log(u) < -zz * 0.5) break;
            }
            return z2 * z2;
        }
        if (freedom != this.freedom_in) {
            this.b = Math.sqrt(freedom - 1.0);
            this.vm = -0.6065306597 * (1.0 - 0.25 / (this.b * this.b + 1.0));
            this.vm = -this.b > this.vm ? -this.b : this.vm;
            this.vp = 0.6065306597 * (0.7071067812 + this.b) / (0.5 + this.b);
            this.vd = this.vp - this.vm;
            this.freedom_in = freedom;
        }
        while (true) {
            double u = this.randomGenerator.raw();
            double v = this.randomGenerator.raw() * this.vd + this.vm;
            z = v / u;
            if (z < -this.b) continue;
            double zz = z * z;
            double r = 2.5 - zz;
            if (z < 0.0) {
                r += zz * z / (3.0 * (z + this.b));
            }
            if (u < r * 0.3894003915) {
                return (z + this.b) * (z + this.b);
            }
            if (!(zz > 1.036961043 / u + 1.4) && 2.0 * Math.log(u) < Math.log(1.0 + z / this.b) * this.b * this.b - zz * 0.5 - z * this.b) break;
        }
        return (z + this.b) * (z + this.b);
    }

    public double pdf(double x) {
        if (x <= 0.0) {
            throw new IllegalArgumentException();
        }
        double logGamma = Fun.logGamma(this.freedom / 2.0);
        return Math.exp((this.freedom / 2.0 - 1.0) * Math.log(x / 2.0) - x / 2.0 - logGamma) / 2.0;
    }

    public void setState(double freedom) {
        if (freedom < 1.0) {
            throw new IllegalArgumentException();
        }
        this.freedom = freedom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double staticNextDouble(double freedom) {
        ChiSquare chiSquare = shared;
        synchronized (chiSquare) {
            return shared.nextDouble(freedom);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "(" + this.freedom + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void xstaticSetRandomGenerator(DoubleRandomEngine randomGenerator) {
        ChiSquare chiSquare = shared;
        synchronized (chiSquare) {
            shared.setRandomGenerator(randomGenerator);
        }
    }
}

