/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.tdouble.quantile;

import cern.colt.PersistentObject;
import java.util.Arrays;

public class DoubleEquiDepthHistogram
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    protected double[] binBoundaries;

    public DoubleEquiDepthHistogram(double[] quantileElements) {
        this.binBoundaries = quantileElements;
    }

    public int binOfElement(double element) {
        int index = Arrays.binarySearch(this.binBoundaries, element);
        if (index >= 0) {
            if (index == this.binBoundaries.length - 1) {
                --index;
            }
        } else {
            if (++index == 0 || index == this.binBoundaries.length) {
                throw new IllegalArgumentException("Element=" + element + " not contained in any bin.");
            }
            --index;
        }
        return index;
    }

    public int bins() {
        return this.binBoundaries.length - 1;
    }

    public double endOfBin(int binIndex) {
        return this.binBoundaries[binIndex + 1];
    }

    public double percentFromTo(double from, double to) {
        return this.phi(to) - this.phi(from);
    }

    public double phi(double element) {
        int size = this.binBoundaries.length;
        if (element <= this.binBoundaries[0]) {
            return 0.0;
        }
        if (element >= this.binBoundaries[size - 1]) {
            return 1.0;
        }
        double binWidth = 1.0 / (double)(size - 1);
        int index = Arrays.binarySearch(this.binBoundaries, element);
        if (index >= 0) {
            return binWidth * (double)index;
        }
        int insertionPoint = -index - 1;
        double from = this.binBoundaries[insertionPoint - 1];
        double to = this.binBoundaries[insertionPoint] - from;
        double p = (element - from) / to;
        return binWidth * (p + (double)(insertionPoint - 1));
    }

    @Deprecated
    public int size() {
        return this.binBoundaries.length;
    }

    public double startOfBin(int binIndex) {
        return this.binBoundaries[binIndex];
    }

    public static void test(double element) {
        double[] quantileElements = new double[]{50.0, 100.0, 200.0, 300.0, 1400.0, 1500.0, 1600.0, 1700.0, 1800.0, 1900.0, 2000.0};
        DoubleEquiDepthHistogram histo = new DoubleEquiDepthHistogram(quantileElements);
        System.out.println("elem=" + element + ", phi=" + histo.phi(element));
    }
}

