/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.tfloat.quantile;

import cern.colt.list.tfloat.FloatArrayList;
import cern.jet.stat.Buffer;
import cern.jet.stat.tfloat.FloatDescriptive;

class FloatBuffer
extends Buffer {
    private static final long serialVersionUID = 1L;
    protected FloatArrayList values = new FloatArrayList(0);
    protected boolean isSorted = false;

    public FloatBuffer(int k) {
        super(k);
    }

    public void add(float value) {
        if (!this.isAllocated) {
            this.allocate();
        }
        this.values.add(value);
        this.isSorted = false;
    }

    public void addAllOfFromTo(FloatArrayList elements, int from, int to) {
        if (!this.isAllocated) {
            this.allocate();
        }
        this.values.addAllOfFromTo(elements, from, to);
        this.isSorted = false;
    }

    protected void allocate() {
        this.isAllocated = true;
        this.values.ensureCapacity(this.k);
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public Object clone() {
        FloatBuffer copy = (FloatBuffer)super.clone();
        if (this.values != null) {
            copy.values = copy.values.copy();
        }
        return copy;
    }

    public boolean contains(float element) {
        this.sort();
        return this.values.contains(element);
    }

    @Override
    public boolean isEmpty() {
        return this.values.size() == 0;
    }

    @Override
    public boolean isFull() {
        return this.values.size() == this.k;
    }

    public int memory() {
        return this.values.elements().length;
    }

    public float rank(float element) {
        this.sort();
        return FloatDescriptive.rankInterpolated(this.values, element);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public void sort() {
        if (!this.isSorted) {
            this.values.sort();
            this.isSorted = true;
        }
    }

    public String toString() {
        return "k=" + this.k + ", w=" + Long.toString(this.weight()) + ", l=" + Integer.toString(this.level()) + ", size=" + this.values.size();
    }
}

