/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.util.listenable;

import com.ochafik.util.listenable.Adapter;
import com.ochafik.util.listenable.CollectionEvent;
import com.ochafik.util.listenable.CollectionListener;
import com.ochafik.util.listenable.ListenableCollection;
import com.ochafik.util.listenable.ListenableSupport;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class AdaptedCollection<U, V>
extends AbstractCollection<V>
implements ListenableCollection<V> {
    protected final Collection<U> collection;
    protected final Adapter<U, V> forwardAdapter;
    protected final Adapter<V, U> backwardAdapter;
    protected ListenableSupport<V> collectionSupport;
    protected boolean currentlyCausingChange = false;

    public AdaptedCollection(Collection<U> collection, Adapter<U, V> forwardAdapter) {
        this(collection, forwardAdapter, null);
    }

    public AdaptedCollection(Collection<U> collection, Adapter<U, V> forwardAdapter, Adapter<V, U> backwardAdapter) {
        if (forwardAdapter == null) {
            throw new NullPointerException("AdaptedCollection needs a non-null forward adapter");
        }
        this.collection = collection;
        this.forwardAdapter = forwardAdapter;
        this.backwardAdapter = backwardAdapter;
    }

    public Adapter<U, V> getForwardAdapter() {
        return this.forwardAdapter;
    }

    public Adapter<V, U> getBackwardAdapter() {
        return this.backwardAdapter;
    }

    @Override
    public Iterator<V> iterator() {
        return new IteratorAdapter(this.collection.iterator());
    }

    @Override
    public int size() {
        return this.collection.size();
    }

    @Override
    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        if (this.collectionSupport != null && this.collectionSupport.hasListeners()) {
            try {
                this.currentlyCausingChange = true;
                ArrayList removedElements = new ArrayList(this);
                this.collection.clear();
                this.collectionSupport.fireRemoved(this, removedElements, 0, removedElements.size() - 1);
            }
            finally {
                this.currentlyCausingChange = false;
            }
        } else {
            this.collection.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(V value) {
        if (this.backwardAdapter == null) {
            throw new UnsupportedOperationException("No backward adapter in this AdapterCollection");
        }
        try {
            this.currentlyCausingChange = true;
            if (this.collection.add(this.backwardAdapter.adapt(value))) {
                if (this.collectionSupport != null && this.collectionSupport.hasListeners()) {
                    this.collectionSupport.fireAdded(this, Collections.singleton(value));
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.currentlyCausingChange = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object value) {
        if (this.backwardAdapter == null) {
            int i = 0;
            Iterator<U> it = this.collection.iterator();
            while (it.hasNext()) {
                if (this.forwardAdapter.adapt(it.next()).equals(value)) {
                    try {
                        this.currentlyCausingChange = true;
                        it.remove();
                        if (this.collectionSupport != null && this.collectionSupport.hasListeners()) {
                            this.collectionSupport.fireRemoved(this, Collections.singleton(value), i, i);
                        }
                        boolean bl = true;
                        return bl;
                    }
                    finally {
                        this.currentlyCausingChange = false;
                    }
                }
                ++i;
            }
            return false;
        }
        return this.removeWithoutBackWardAdapter(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeWithoutBackWardAdapter(Object value) {
        try {
            this.currentlyCausingChange = true;
            if (this.collection.remove(this.backwardAdapter.adapt(value))) {
                if (this.collectionSupport != null && this.collectionSupport.hasListeners()) {
                    this.collectionSupport.fireRemoved(this, Collections.singleton(value));
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.currentlyCausingChange = false;
        }
    }

    @Override
    public boolean contains(Object value) {
        if (this.backwardAdapter != null) {
            return this.collection.contains(this.backwardAdapter.adapt(value));
        }
        for (U element : this.collection) {
            if (!this.forwardAdapter.adapt(element).equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addCollectionListener(CollectionListener<V> l) {
        if (this.collectionSupport == null) {
            this.collectionSupport = new ListenableSupport();
            if (this.collection instanceof ListenableCollection) {
                ((ListenableCollection)this.collection).addCollectionListener(new CollectionListener<U>(){

                    @Override
                    public void collectionChanged(CollectionEvent<U> e) {
                        if (AdaptedCollection.this.currentlyCausingChange) {
                            return;
                        }
                        if (AdaptedCollection.this.collectionSupport == null || !AdaptedCollection.this.collectionSupport.hasListeners()) {
                            return;
                        }
                        AdaptedCollection.this.collectionSupport.fireEvent(AdaptedCollection.this, new AdaptedCollection(e.getElements(), AdaptedCollection.this.forwardAdapter, AdaptedCollection.this.backwardAdapter), e.getType(), e.getFirstIndex(), e.getLastIndex());
                    }
                });
            }
        }
        this.collectionSupport.addCollectionListener(l);
    }

    @Override
    public void removeCollectionListener(CollectionListener<V> l) {
        if (this.collectionSupport == null) {
            return;
        }
        this.collectionSupport.removeCollectionListener(l);
    }

    protected class IteratorAdapter
    implements Iterator<V> {
        protected Iterator<U> iterator;
        protected V lastValue;

        public IteratorAdapter(Iterator<U> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public V next() {
            this.lastValue = AdaptedCollection.this.forwardAdapter.adapt(this.iterator.next());
            return this.lastValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            try {
                AdaptedCollection.this.currentlyCausingChange = true;
                this.iterator.remove();
                if (AdaptedCollection.this.collectionSupport != null && AdaptedCollection.this.collectionSupport.hasListeners()) {
                    AdaptedCollection.this.collectionSupport.fireRemoved(AdaptedCollection.this, Collections.singleton(this.lastValue));
                }
            }
            finally {
                AdaptedCollection.this.currentlyCausingChange = false;
            }
            this.lastValue = null;
        }
    }
}

