/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled.spi;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public abstract class FormatConversionProvider {
    public abstract AudioFormat.Encoding[] getSourceEncodings();

    public abstract AudioFormat.Encoding[] getTargetEncodings();

    public boolean isSourceEncodingSupported(AudioFormat.Encoding sourceEncoding) {
        AudioFormat.Encoding[] sourceEncodings = this.getSourceEncodings();
        int i = 0;
        while (i < sourceEncodings.length) {
            if (sourceEncoding.equals(sourceEncodings[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isTargetEncodingSupported(AudioFormat.Encoding targetEncoding) {
        AudioFormat.Encoding[] targetEncodings = this.getTargetEncodings();
        int i = 0;
        while (i < targetEncodings.length) {
            if (targetEncoding.equals(targetEncodings[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public abstract AudioFormat.Encoding[] getTargetEncodings(AudioFormat var1);

    public boolean isConversionSupported(AudioFormat.Encoding targetEncoding, AudioFormat sourceFormat) {
        AudioFormat.Encoding[] targetEncodings = this.getTargetEncodings(sourceFormat);
        int i = 0;
        while (i < targetEncodings.length) {
            if (targetEncoding.equals(targetEncodings[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public abstract AudioFormat[] getTargetFormats(AudioFormat.Encoding var1, AudioFormat var2);

    public boolean isConversionSupported(AudioFormat targetFormat, AudioFormat sourceFormat) {
        AudioFormat[] targetFormats = this.getTargetFormats(targetFormat.getEncoding(), sourceFormat);
        int i = 0;
        while (i < targetFormats.length) {
            if (targetFormat.matches(targetFormats[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public abstract AudioInputStream getAudioInputStream(AudioFormat.Encoding var1, AudioInputStream var2);

    public abstract AudioInputStream getAudioInputStream(AudioFormat var1, AudioInputStream var2);
}

