/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.hessenberg;

import org.ejml.EjmlParameters;
import org.ejml.alg.block.decomposition.hessenberg.TridiagonalDecompositionBlockHouseholder;
import org.ejml.alg.dense.decomposition.BaseDecompositionBlock64;
import org.ejml.alg.dense.decomposition.hessenberg.TridiagonalSimilarDecomposition;
import org.ejml.data.BlockMatrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class TridiagonalDecompositionBlock
extends BaseDecompositionBlock64
implements TridiagonalSimilarDecomposition<DenseMatrix64F> {
    public TridiagonalDecompositionBlock() {
        this(EjmlParameters.BLOCK_WIDTH);
    }

    public TridiagonalDecompositionBlock(int n) {
        super(new TridiagonalDecompositionBlockHouseholder(), n);
    }

    @Override
    public DenseMatrix64F getT(DenseMatrix64F denseMatrix64F) {
        int n = this.Ablock.numRows;
        if (denseMatrix64F == null) {
            denseMatrix64F = new DenseMatrix64F(n, n);
        } else {
            CommonOps.set(denseMatrix64F, 0.0);
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        ((TridiagonalDecompositionBlockHouseholder)this.alg).getDiagonal(dArray, dArray2);
        denseMatrix64F.unsafe_set(0, 0, dArray[0]);
        for (int i = 1; i < n; ++i) {
            denseMatrix64F.unsafe_set(i, i, dArray[i]);
            denseMatrix64F.unsafe_set(i, i - 1, dArray2[i - 1]);
            denseMatrix64F.unsafe_set(i - 1, i, dArray2[i - 1]);
        }
        return denseMatrix64F;
    }

    @Override
    public DenseMatrix64F getQ(DenseMatrix64F denseMatrix64F, boolean bl) {
        if (denseMatrix64F == null) {
            denseMatrix64F = new DenseMatrix64F(this.Ablock.numRows, this.Ablock.numCols);
        }
        BlockMatrix64F blockMatrix64F = new BlockMatrix64F();
        blockMatrix64F.numRows = denseMatrix64F.numRows;
        blockMatrix64F.numCols = denseMatrix64F.numCols;
        blockMatrix64F.blockLength = this.blockLength;
        blockMatrix64F.data = denseMatrix64F.data;
        ((TridiagonalDecompositionBlockHouseholder)this.alg).getQ(blockMatrix64F, bl);
        this.convertBlockToRow(denseMatrix64F.numRows, denseMatrix64F.numCols, this.Ablock.blockLength, denseMatrix64F.data);
        return denseMatrix64F;
    }

    @Override
    public void getDiagonal(double[] dArray, double[] dArray2) {
        ((TridiagonalDecompositionBlockHouseholder)this.alg).getDiagonal(dArray, dArray2);
    }
}

