/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import org.ejml.UtilEjml;
import org.ejml.alg.dense.decomposition.EigenDecomposition;
import org.ejml.alg.dense.decomposition.eig.EigenPowerMethod;
import org.ejml.alg.dense.linsol.LinearSolver;
import org.ejml.alg.dense.linsol.LinearSolverFactory;
import org.ejml.alg.dense.mult.VectorVectorMult;
import org.ejml.data.Complex64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Eigenpair;
import org.ejml.ops.CommonOps;
import org.ejml.ops.MatrixFeatures;
import org.ejml.ops.NormOps;
import org.ejml.ops.SpecializedOps;

public class EigenOps {
    public static double computeEigenValue(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        double d = VectorVectorMult.innerProd(denseMatrix64F2, denseMatrix64F2);
        double d2 = VectorVectorMult.innerProdA(denseMatrix64F2, denseMatrix64F, denseMatrix64F2);
        return d2 / d;
    }

    public static Eigenpair computeEigenVector(DenseMatrix64F denseMatrix64F, double d) {
        if (denseMatrix64F.numRows != denseMatrix64F.numCols) {
            throw new IllegalArgumentException("Must be a square matrix.");
        }
        DenseMatrix64F denseMatrix64F2 = new DenseMatrix64F(denseMatrix64F.numRows, denseMatrix64F.numCols);
        DenseMatrix64F denseMatrix64F3 = new DenseMatrix64F(denseMatrix64F.numRows, 1);
        DenseMatrix64F denseMatrix64F4 = new DenseMatrix64F(denseMatrix64F.numRows, 1);
        CommonOps.set(denseMatrix64F4, 1.0);
        double d2 = d;
        SpecializedOps.addIdentity(denseMatrix64F, denseMatrix64F2, -d);
        double d3 = NormOps.normPInf(denseMatrix64F) * UtilEjml.EPS;
        double d4 = Double.MAX_VALUE;
        boolean bl = false;
        LinearSolver<DenseMatrix64F> linearSolver = LinearSolverFactory.linear(denseMatrix64F2.numRows);
        double d5 = 1.0E-4;
        for (int i = 0; i < 200; ++i) {
            double d6;
            boolean bl2 = false;
            if (!linearSolver.setA(denseMatrix64F2)) {
                bl2 = true;
            } else {
                linearSolver.solve(denseMatrix64F4, denseMatrix64F3);
            }
            if (MatrixFeatures.hasUncountable(denseMatrix64F3)) {
                bl2 = true;
            }
            if (bl2) {
                if (!bl) {
                    d6 = i % 2 == 0 ? 1.0 - d5 : 1.0 + d5;
                    d = d2 * Math.pow(d6, i / 2 + 1);
                    SpecializedOps.addIdentity(denseMatrix64F, denseMatrix64F2, -d);
                    continue;
                }
                return new Eigenpair(d, denseMatrix64F4);
            }
            bl = true;
            denseMatrix64F4.set(denseMatrix64F3);
            NormOps.normalizeF(denseMatrix64F4);
            CommonOps.mult(denseMatrix64F2, denseMatrix64F4, denseMatrix64F3);
            d6 = NormOps.normPInf(denseMatrix64F3);
            if (d6 - d4 > UtilEjml.EPS * 10.0) {
                d4 = Double.MAX_VALUE;
                bl = false;
                double d7 = i % 2 == 0 ? 1.0 - d5 : 1.0 + d5;
                d = d2 * Math.pow(d7, 1.0);
            } else {
                if (d6 <= d3 || Math.abs(d4 - d6) <= UtilEjml.EPS) {
                    return new Eigenpair(d, denseMatrix64F4);
                }
                d4 = d6;
                d = VectorVectorMult.innerProdA(denseMatrix64F4, denseMatrix64F, denseMatrix64F4);
            }
            SpecializedOps.addIdentity(denseMatrix64F, denseMatrix64F2, -d);
        }
        return null;
    }

    public static Eigenpair dominantEigenpair(DenseMatrix64F denseMatrix64F) {
        EigenPowerMethod eigenPowerMethod = new EigenPowerMethod(denseMatrix64F.numRows);
        if (!eigenPowerMethod.computeShiftInvert(denseMatrix64F, 0.1)) {
            return null;
        }
        return null;
    }

    public static double[] boundLargestEigenValue(DenseMatrix64F denseMatrix64F, double[] dArray) {
        if (denseMatrix64F.numRows != denseMatrix64F.numCols) {
            throw new IllegalArgumentException("A must be a square matrix.");
        }
        double d = Double.MAX_VALUE;
        double d2 = 0.0;
        int n = denseMatrix64F.numRows;
        for (int i = 0; i < n; ++i) {
            double d3 = 0.0;
            for (int j = 0; j < n; ++j) {
                double d4 = denseMatrix64F.get(i, j);
                if (d4 < 0.0) {
                    throw new IllegalArgumentException("Matrix must be positive");
                }
                d3 += d4;
            }
            if (d3 < d) {
                d = d3;
            }
            if (!(d3 > d2)) continue;
            d2 = d3;
        }
        if (dArray == null) {
            dArray = new double[]{d, d2};
        }
        return dArray;
    }

    public static DenseMatrix64F createMatrixD(EigenDecomposition eigenDecomposition) {
        int n = eigenDecomposition.getNumberOfEigenvalues();
        DenseMatrix64F denseMatrix64F = new DenseMatrix64F(n, n);
        for (int i = 0; i < n; ++i) {
            Complex64F complex64F = eigenDecomposition.getEigenvalue(i);
            if (!complex64F.isReal()) continue;
            denseMatrix64F.set(i, i, complex64F.real);
        }
        return denseMatrix64F;
    }

    public static DenseMatrix64F createMatrixV(EigenDecomposition<DenseMatrix64F> eigenDecomposition) {
        int n = eigenDecomposition.getNumberOfEigenvalues();
        DenseMatrix64F denseMatrix64F = new DenseMatrix64F(n, n);
        for (int i = 0; i < n; ++i) {
            DenseMatrix64F denseMatrix64F2;
            Complex64F complex64F = eigenDecomposition.getEigenvalue(i);
            if (!complex64F.isReal() || (denseMatrix64F2 = eigenDecomposition.getEigenVector(i)) == null) continue;
            for (int j = 0; j < n; ++j) {
                denseMatrix64F.set(j, i, denseMatrix64F2.get(j, 0));
            }
        }
        return denseMatrix64F;
    }
}

