/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import javax.swing.text.View;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.lafwidget.animation.AnimationConfigurationManager;
import org.pushingpixels.lafwidget.animation.AnimationFacet;
import org.pushingpixels.lafwidget.animation.effects.GhostPaintingUtils;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.api.shaper.SubstanceButtonShaper;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.utils.ButtonBackgroundDelegate;
import org.pushingpixels.substance.internal.utils.ButtonVisualStateTracker;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;
import org.pushingpixels.substance.internal.utils.border.SubstanceButtonBorder;
import org.pushingpixels.substance.internal.utils.icon.GlowingIcon;

public class SubstanceToggleButtonUI
extends BasicToggleButtonUI
implements TransitionAwareUI {
    protected boolean iconGhostingMarker;
    protected Set lafWidgets;
    private ButtonBackgroundDelegate delegate;
    protected GlowingIcon glowingIcon;
    protected PropertyChangeListener substancePropertyListener;
    protected ButtonVisualStateTracker substanceVisualStateTracker;
    protected JToggleButton toggleButton;
    private Rectangle viewRect = new Rectangle();
    private Rectangle iconRect = new Rectangle();
    private Rectangle textRect = new Rectangle();

    @Override
    protected void paintIcon(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle) {
        abstractButton.putClientProperty("icon.bounds", new Rectangle(rectangle));
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        GhostPaintingUtils.paintGhostIcon((Graphics2D)graphics2D, (AbstractButton)abstractButton, (Rectangle)rectangle);
        graphics2D.dispose();
        this.__org__pushingpixels__substance__internal__ui__SubstanceToggleButtonUI__icon__paintIcon(graphics, abstractButton, rectangle);
    }

    public void __org__pushingpixels__substance__internal__ui__SubstanceToggleButtonUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__pushingpixels__substance__internal__ui__SubstanceToggleButtonUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    public void installDefaults(AbstractButton abstractButton) {
        this.__org__pushingpixels__substance__internal__ui__SubstanceToggleButtonUI__installDefaults(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void installListeners(AbstractButton abstractButton) {
        this.__org__pushingpixels__substance__internal__ui__SubstanceToggleButtonUI__installListeners(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    protected void uninstallListeners(AbstractButton abstractButton) {
        this.__org__pushingpixels__substance__internal__ui__SubstanceToggleButtonUI__uninstallListeners(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    public void __org__pushingpixels__substance__internal__ui__SubstanceToggleButtonUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.__org__pushingpixels__substance__internal__ui__SubstanceToggleButtonUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    public void uninstallDefaults(AbstractButton abstractButton) {
        this.__org__pushingpixels__substance__internal__ui__SubstanceToggleButtonUI__uninstallDefaults(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints((Graphics2D)graphics2D, (Component)jComponent);
        this.__org__pushingpixels__substance__internal__ui__SubstanceToggleButtonUI__update(graphics2D, jComponent);
        graphics2D.dispose();
    }

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceToggleButtonUI((JToggleButton)comp);
    }

    public SubstanceToggleButtonUI(JToggleButton toggleButton) {
        this.toggleButton = toggleButton;
        this.delegate = new ButtonBackgroundDelegate();
    }

    public void __org__pushingpixels__substance__internal__ui__SubstanceToggleButtonUI__installDefaults(AbstractButton b) {
        super.installDefaults(b);
        if (b.getClientProperty("substancelaf.buttonborderoriginal") == null) {
            b.putClientProperty("substancelaf.buttonborderoriginal", b.getBorder());
        }
        if (b.getClientProperty("substancelaf.buttonborderoriginal") == null) {
            b.putClientProperty("substancelaf.buttonborderoriginal", b.getBorder());
        }
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(b);
        if (b.getClientProperty("substancelaf.buttonbordercomputed") == null) {
            b.setBorder(shaper.getButtonBorder(b));
        } else {
            Border currBorder = b.getBorder();
            if (!(currBorder instanceof SubstanceButtonBorder)) {
                b.setBorder(shaper.getButtonBorder(b));
            } else {
                SubstanceButtonBorder sbCurrBorder = (SubstanceButtonBorder)currBorder;
                if (shaper.getClass() != sbCurrBorder.getButtonShaperClass()) {
                    b.setBorder(shaper.getButtonBorder(b));
                }
            }
        }
        b.putClientProperty("substancelaf.buttonopacityoriginal", b.isOpaque());
        b.setOpaque(false);
        b.setRolloverEnabled(true);
        LookAndFeel.installProperty(b, "iconTextGap", SubstanceSizeUtils.getTextIconGap(SubstanceSizeUtils.getComponentFontSize(b)));
    }

    public void __org__pushingpixels__substance__internal__ui__SubstanceToggleButtonUI__uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        b.setBorder((Border)b.getClientProperty("substancelaf.buttonborderoriginal"));
        b.setOpaque((Boolean)b.getClientProperty("substancelaf.buttonopacityoriginal"));
        b.putClientProperty("substancelaf.buttonopacityoriginal", null);
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return null;
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstanceToggleButtonUI__installListeners(AbstractButton b) {
        super.installListeners(b);
        this.substanceVisualStateTracker = new ButtonVisualStateTracker();
        this.substanceVisualStateTracker.installListeners(b, true);
        this.trackGlowingIcon();
        this.substancePropertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("icon".equals(evt.getPropertyName())) {
                    SubstanceToggleButtonUI.this.trackGlowingIcon();
                }
            }
        };
        b.addPropertyChangeListener(this.substancePropertyListener);
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstanceToggleButtonUI__uninstallListeners(AbstractButton b) {
        this.substanceVisualStateTracker.uninstallListeners(b);
        this.substanceVisualStateTracker = null;
        b.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        super.uninstallListeners(b);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        FontMetrics fm = g.getFontMetrics();
        Insets i = c.getInsets();
        this.viewRect.x = i.left;
        this.viewRect.y = i.top;
        this.viewRect.width = b.getWidth() - (i.right + this.viewRect.x);
        this.viewRect.height = b.getHeight() - (i.bottom + this.viewRect.y);
        this.textRect.height = 0;
        this.textRect.width = 0;
        this.textRect.y = 0;
        this.textRect.x = 0;
        this.iconRect.height = 0;
        this.iconRect.width = 0;
        this.iconRect.y = 0;
        this.iconRect.x = 0;
        Font f = c.getFont();
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), this.viewRect, this.iconRect, this.textRect, b.getText() == null ? 0 : b.getIconTextGap());
        Graphics2D g2d = (Graphics2D)g.create();
        View v = (View)c.getClientProperty("html");
        g2d.setFont(f);
        this.delegate.updateBackground(g2d, b);
        if (v != null) {
            v.paint(g2d, this.textRect);
        } else {
            this.paintButtonText(g2d, b, this.textRect, text);
        }
        if (b.getIcon() != null) {
            this.paintIcon((Graphics)g2d, b, this.iconRect);
        }
        if (b.isFocusPainted()) {
            SubstanceCoreUtilities.paintFocus(g, b, b, this, null, this.textRect, 1.0f, SubstanceSizeUtils.getFocusRingPadding(SubstanceSizeUtils.getComponentFontSize(b)));
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        AbstractButton button = (AbstractButton)c;
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(button);
        Dimension superPref = super.getPreferredSize(button);
        if (superPref == null) {
            return null;
        }
        if (shaper == null) {
            return superPref;
        }
        return shaper.getPreferredSize(button, superPref);
    }

    @Override
    public boolean contains(JComponent c, int x, int y) {
        return ButtonBackgroundDelegate.contains((JToggleButton)c, x, y);
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstanceToggleButtonUI__icon__paintIcon(Graphics g, AbstractButton b, Rectangle iconRect) {
        Graphics2D graphics = (Graphics2D)g.create();
        Icon originalIcon = SubstanceCoreUtilities.getOriginalIcon(b, b.getIcon());
        Icon themedIcon = !(b instanceof JRadioButton) && !(b instanceof JCheckBox) && SubstanceCoreUtilities.useThemedDefaultIcon(b) ? SubstanceCoreUtilities.getThemedIcon(b, originalIcon) : originalIcon;
        graphics.setComposite(LafWidgetUtilities.getAlphaComposite((Component)b, (Graphics)g));
        float activeAmount = this.substanceVisualStateTracker.getStateTransitionTracker().getActiveStrength();
        if (activeAmount >= 0.0f) {
            if (AnimationConfigurationManager.getInstance().isAnimationAllowed(AnimationFacet.ICON_GLOW, (Component)b) && this.substanceVisualStateTracker.getStateTransitionTracker().getIconGlowTracker().isPlaying()) {
                this.glowingIcon.paintIcon(b, graphics, iconRect.x, iconRect.y);
            } else {
                themedIcon.paintIcon(b, graphics, iconRect.x, iconRect.y);
                graphics.setComposite(LafWidgetUtilities.getAlphaComposite((Component)b, (float)activeAmount, (Graphics)g));
                originalIcon.paintIcon(b, graphics, iconRect.x, iconRect.y);
            }
        } else {
            originalIcon.paintIcon(b, graphics, iconRect.x, iconRect.y);
        }
        graphics.dispose();
    }

    protected void paintButtonText(Graphics g, AbstractButton button, Rectangle textRect, String text) {
        SubstanceTextUtilities.paintText(g, button, textRect, text, button.getDisplayedMnemonicIndex());
    }

    protected void trackGlowingIcon() {
        Icon currIcon = this.toggleButton.getIcon();
        if (currIcon instanceof GlowingIcon) {
            return;
        }
        if (currIcon == null) {
            return;
        }
        this.glowingIcon = new GlowingIcon(currIcon, this.substanceVisualStateTracker.getStateTransitionTracker().getIconGlowTracker());
    }

    public void __org__pushingpixels__substance__internal__ui__SubstanceToggleButtonUI__update(Graphics g, JComponent c) {
        this.paint(g, c);
    }

    @Override
    public boolean isInside(MouseEvent me) {
        return this.contains(this.toggleButton, me.getX(), me.getY());
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.substanceVisualStateTracker.getStateTransitionTracker();
    }
}

