/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeval.function.math;

import java.util.ArrayList;
import net.sourceforge.jeval.Evaluator;
import net.sourceforge.jeval.function.Function;
import net.sourceforge.jeval.function.FunctionException;
import net.sourceforge.jeval.function.FunctionHelper;
import net.sourceforge.jeval.function.FunctionResult;

public class Pow
implements Function {
    public String getName() {
        return "pow";
    }

    public FunctionResult execute(Evaluator evaluator, String arguments) throws FunctionException {
        Double result = null;
        ArrayList numbers = FunctionHelper.getDoubles(arguments, ',');
        if (numbers.size() != 2) {
            throw new FunctionException("Two numeric arguments are required.");
        }
        try {
            double argumentOne = (Double)numbers.get(0);
            double argumentTwo = (Double)numbers.get(1);
            result = new Double(Math.pow(argumentOne, argumentTwo));
        }
        catch (Exception e) {
            throw new FunctionException("Two numeric arguments are required.", e);
        }
        return new FunctionResult(result.toString(), 0);
    }
}

