/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeval.function.string;

import java.util.ArrayList;
import net.sourceforge.jeval.Evaluator;
import net.sourceforge.jeval.function.Function;
import net.sourceforge.jeval.function.FunctionException;
import net.sourceforge.jeval.function.FunctionHelper;
import net.sourceforge.jeval.function.FunctionResult;

public class Substring
implements Function {
    public String getName() {
        return "substring";
    }

    public FunctionResult execute(Evaluator evaluator, String arguments) throws FunctionException {
        String result = null;
        String exceptionMessage = "One string argument and two integer arguments are required.";
        ArrayList values = FunctionHelper.getOneStringAndTwoIntegers(arguments, ',');
        if (values.size() != 3) {
            throw new FunctionException(exceptionMessage);
        }
        try {
            String argumentOne = FunctionHelper.trimAndRemoveQuoteChars((String)values.get(0), evaluator.getQuoteCharacter());
            int beginningIndex = (Integer)values.get(1);
            int endingIndex = (Integer)values.get(2);
            result = argumentOne.substring(beginningIndex, endingIndex);
        }
        catch (FunctionException fe) {
            throw new FunctionException(fe.getMessage(), fe);
        }
        catch (Exception e) {
            throw new FunctionException(exceptionMessage, e);
        }
        return new FunctionResult(result, 1);
    }
}

