/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.raw;

import java.util.ArrayList;
import net.phys2d.math.ROVector2f;
import net.phys2d.raw.Arbiter;
import net.phys2d.raw.ArbiterList;
import net.phys2d.raw.Body;
import net.phys2d.raw.BodyList;
import net.phys2d.raw.BroadCollisionStrategy;
import net.phys2d.raw.CollisionContext;
import net.phys2d.raw.CollisionEvent;
import net.phys2d.raw.CollisionListener;
import net.phys2d.raw.Contact;

public class CollisionSpace
implements CollisionContext {
    protected BodyList bodies = new BodyList();
    protected ArbiterList arbiters = new ArbiterList();
    protected BroadCollisionStrategy collisionStrategy;
    protected ArrayList listeners = new ArrayList();
    protected float totalTime;
    private long bitmask = -1L;

    public CollisionSpace(BroadCollisionStrategy strategy) {
        this.collisionStrategy = strategy;
    }

    public void addListener(CollisionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(CollisionListener listener) {
        this.listeners.remove(listener);
    }

    public void collide(float dt) {
        this.totalTime += dt;
        this.collisionStrategy.collideBodies(this, this.bodies, dt);
    }

    public void clear() {
        this.bodies.clear();
        this.arbiters.clear();
    }

    public void add(Body body) {
        body.setAdded(true);
        this.bodies.add(body);
    }

    public void remove(Body body) {
        body.setAdded(false);
        this.bodies.remove(body);
    }

    public BodyList getBodies() {
        return this.bodies;
    }

    public void setCollisionStrategy(BroadCollisionStrategy strategy) {
        this.collisionStrategy = strategy;
    }

    private void notifyCollision(Body body1, Body body2, ROVector2f point, ROVector2f normal, float depth) {
        if (this.listeners.size() == 0) {
            return;
        }
        CollisionEvent event = new CollisionEvent(this.totalTime, body1, body2, point, normal, depth);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((CollisionListener)this.listeners.get(i)).collisionOccured(event);
        }
    }

    public void resolve(BodyList bodyList, float dt) {
        for (int i = 0; i < bodyList.size(); ++i) {
            Body bi = bodyList.get(i);
            if (bi.disabled()) continue;
            for (int j = i + 1; j < bodyList.size(); ++j) {
                Body bj = bodyList.get(j);
                if (bj.disabled() || (bi.getBitmask() & bj.getBitmask()) != 0L || bi.getExcludedList().contains(bj) || bi.getInvMass() == 0.0f && bj.getInvMass() == 0.0f) continue;
                if (!bi.getShape().getBounds().touches(bi.getPosition().getX(), bi.getPosition().getY(), bj.getShape().getBounds(), bj.getPosition().getX(), bj.getPosition().getY())) {
                    this.arbiters.remove(new Arbiter(bi, bj));
                    continue;
                }
                Arbiter newArb = new Arbiter(bi, bj);
                newArb.collide(dt);
                if (newArb.getNumContacts() > 0) {
                    bi.collided(bj);
                    bj.collided(bi);
                    if (this.arbiters.contains(newArb)) {
                        int index = this.arbiters.indexOf(newArb);
                        Arbiter arb = this.arbiters.get(index);
                        arb.update(newArb.getContacts(), newArb.getNumContacts());
                        continue;
                    }
                    Contact c = newArb.getContact(0);
                    this.notifyCollision(bi, bj, c.getPosition(), c.getNormal(), c.getSeparation());
                    this.arbiters.add(newArb);
                    newArb.init();
                    continue;
                }
                this.arbiters.remove(newArb);
            }
        }
    }

    public long getBitmask() {
        return this.bitmask;
    }

    public void setBitmask(long bitmask) {
        this.bitmask = bitmask;
    }

    public void addBit(long bitmask) {
        this.bitmask |= bitmask;
    }

    public void removeBit(long bitmask) {
        this.bitmask -= bitmask & this.bitmask;
    }
}

