/*
 * Decompiled with CFR 0.152.
 */
package jogamp.openal;

import com.jogamp.common.nio.Buffers;
import com.jogamp.openal.ALCdevice;
import com.jogamp.openal.ALException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import jogamp.openal.ALCAbstractImpl;

public class ALCImpl
extends ALCAbstractImpl {
    @Override
    public String alcGetString(ALCdevice aLCdevice, int n) {
        if (aLCdevice == null && n == 4101) {
            throw new ALException("Call alcGetDeviceSpecifiers to fetch all available device names");
        }
        ByteBuffer byteBuffer = this.alcGetStringImpl(aLCdevice, n);
        if (byteBuffer == null) {
            return null;
        }
        byte[] byArray = new byte[byteBuffer.capacity()];
        byteBuffer.get(byArray);
        try {
            return new String(byArray, "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ALException(unsupportedEncodingException);
        }
    }

    public ByteBuffer alcGetStringImpl(ALCdevice aLCdevice, int n) {
        long l = ALCImpl.getALCProcAddressTable()._addressof_alcGetString;
        if (l == 0L) {
            throw new UnsupportedOperationException("Method \"alcGetStringImpl\" not available");
        }
        ByteBuffer byteBuffer = this.dispatch_alcGetStringImpl1(aLCdevice == null ? null : aLCdevice.getBuffer(), n, l);
        if (byteBuffer == null) {
            return null;
        }
        Buffers.nativeOrder((ByteBuffer)byteBuffer);
        return byteBuffer;
    }

    private native ByteBuffer dispatch_alcGetStringImpl1(ByteBuffer var1, int var2, long var3);

    @Override
    public String[] alcGetDeviceSpecifiers() {
        return this.getDoubleNullTerminatedString(4101);
    }

    @Override
    public String[] alcGetCaptureDeviceSpecifiers() {
        return this.getDoubleNullTerminatedString(784);
    }

    private String[] getDoubleNullTerminatedString(int n) {
        ByteBuffer byteBuffer = this.alcGetStringImpl(null, n);
        if (byteBuffer == null) {
            return null;
        }
        byte[] byArray = new byte[byteBuffer.capacity()];
        byteBuffer.get(byArray);
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < byArray.length; ++i) {
                int n2 = i;
                while (i < byArray.length && byArray[i] != 0) {
                    ++i;
                }
                arrayList.add(new String(byArray, n2, i - n2, "US-ASCII"));
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ALException(unsupportedEncodingException);
        }
    }
}

