/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.MetadataTools;
import loci.formats.UnsupportedCompressionException;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEGCodec;
import loci.formats.codec.MSRLECodec;
import loci.formats.codec.MSVideoCodec;
import loci.formats.meta.MetadataStore;

public class AVIReader
extends FormatReader {
    public static final String AVI_MAGIC_STRING = "RIFF";
    private static final int MSRLE = 1;
    private static final int MS_VIDEO = 1296126531;
    private static final int JPEG = 1196444237;
    private static final int Y8 = 538982489;
    private static final byte[] MJPEG_HUFFMAN_TABLE = new byte[]{-1, -60, 1, -94, 0, 0, 1, 5, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 1, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 16, 0, 2, 1, 3, 3, 2, 4, 3, 5, 5, 4, 4, 0, 0, 1, 125, 1, 2, 3, 0, 4, 17, 5, 18, 33, 49, 65, 6, 19, 81, 97, 7, 34, 113, 20, 50, -127, -111, -95, 8, 35, 66, -79, -63, 21, 82, -47, -16, 36, 51, 98, 114, -126, 9, 10, 22, 23, 24, 25, 26, 37, 38, 39, 40, 41, 42, 52, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, -125, -124, -123, -122, -121, -120, -119, -118, -110, -109, -108, -107, -106, -105, -104, -103, -102, -94, -93, -92, -91, -90, -89, -88, -87, -86, -78, -77, -76, -75, -74, -73, -72, -71, -70, -62, -61, -60, -59, -58, -57, -56, -55, -54, -46, -45, -44, -43, -42, -41, -40, -39, -38, -31, -30, -29, -28, -27, -26, -25, -24, -23, -22, -15, -14, -13, -12, -11, -10, -9, -8, -7, -6, 17, 0, 2, 1, 2, 4, 4, 3, 4, 7, 5, 4, 4, 0, 1, 2, 119, 0, 1, 2, 3, 17, 4, 5, 33, 49, 6, 18, 65, 81, 7, 97, 113, 19, 34, 50, -127, 8, 20, 66, -111, -95, -79, -63, 9, 35, 51, 82, -16, 21, 98, 114, -47, 10, 22, 36, 52, -31, 37, -15, 23, 24, 25, 26, 38, 39, 40, 41, 42, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, -126, -125, -124, -123, -122, -121, -120, -119, -118, -110, -109, -108, -107, -106, -105, -104, -103, -102, -94, -93, -92, -91, -90, -89, -88, -87, -86, -78, -77, -76, -75, -74, -73, -72, -71, -70, -62, -61, -60, -59, -58, -57, -56, -55, -54, -46, -45, -44, -43, -42, -41, -40, -39, -38, -30, -29, -28, -27, -26, -25, -24, -23, -22, -14, -13, -12, -11, -10, -9, -8, -7, -6};
    private List<Long> offsets;
    private List<Long> lengths;
    private String listString;
    private String type = "error";
    private String fcc = "error";
    private int size = -1;
    private long pos;
    private int bytesPerPlane;
    private int bmpColorsUsed;
    private int bmpWidth;
    private int bmpCompression;
    private int bmpScanLineSize;
    private short bmpBitsPerPixel;
    private byte[][] lut = null;
    private byte[] lastImage;
    private int lastImageNo;

    public AVIReader() {
        super("Audio Video Interleave", "avi");
        this.suffixNecessary = false;
        this.domains = new String[]{"Graphics"};
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 12;
        if (!FormatTools.validStream(stream, 12, false)) {
            return false;
        }
        String type = stream.readString(4);
        stream.skipBytes(4);
        String format = stream.readString(4);
        return type.equals(AVI_MAGIC_STRING) && format.equals("AVI ");
    }

    @Override
    public byte[][] get8BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.isRGB() ? (byte[][])null : this.lut;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int bytes = FormatTools.getBytesPerPixel(this.getPixelType());
        double p = (double)this.bmpScanLineSize / (double)this.bmpBitsPerPixel;
        int effectiveWidth = (int)((double)this.bmpScanLineSize / p);
        if (effectiveWidth == 0 || effectiveWidth < this.getSizeX()) {
            effectiveWidth = this.getSizeX();
        }
        long fileOff = this.offsets.get(no);
        long end = no < this.offsets.size() - 1 ? this.offsets.get(no + 1) : fileOff + this.lengths.get(no);
        long maxBytes = end - fileOff;
        this.in.seek(fileOff);
        if (this.bmpCompression != 0 && this.bmpCompression != 538982489) {
            byte[] b = this.uncompress(no, buf);
            int rowLen = FormatTools.getPlaneSize(this, w, 1);
            int inputRowLen = FormatTools.getPlaneSize(this, this.getSizeX(), 1);
            for (int row = 0; row < h; ++row) {
                System.arraycopy(b, (row + y) * inputRowLen + x * bytes, buf, row * rowLen, rowLen);
            }
            b = null;
            return buf;
        }
        if (this.bmpBitsPerPixel < 8) {
            int rawSize = FormatTools.getPlaneSize(this, effectiveWidth, this.getSizeY());
            int len = (rawSize /= 8 / this.bmpBitsPerPixel) / this.getSizeY();
            this.in.skipBits(this.bmpBitsPerPixel * len * (this.getSizeY() - h - y));
            for (int row = h; row >= y; --row) {
                this.in.skipBits(this.bmpBitsPerPixel * x);
                for (int col = 0; col < len; ++col) {
                    buf[(row - y) * len + col] = (byte)this.in.readBits(this.bmpBitsPerPixel);
                }
                this.in.skipBits(this.bmpBitsPerPixel * (this.getSizeX() - w - x));
            }
            return buf;
        }
        int pad = this.bmpScanLineSize / this.getRGBChannelCount() - this.getSizeX() * bytes;
        int scanline = w * bytes * (this.isInterleaved() ? this.getRGBChannelCount() : 1);
        if (this.bmpBitsPerPixel > 8 && pad == this.getRGBChannelCount()) {
            pad = bytes;
        }
        this.in.skipBytes((this.getSizeX() + pad) * (this.bmpBitsPerPixel / 8) * (this.getSizeY() - h - y));
        if (this.getSizeX() == w && pad == 0) {
            for (int row = 0; row < h; ++row) {
                int outputRow = this.bmpCompression == 538982489 ? row : h - row - 1;
                this.in.read(buf, outputRow * scanline, scanline);
            }
            if (this.bmpBitsPerPixel == 24 || this.bmpBitsPerPixel == 32) {
                for (int i = 0; i < buf.length / this.getRGBChannelCount(); ++i) {
                    byte r = buf[i * this.getRGBChannelCount() + 2];
                    buf[i * this.getRGBChannelCount() + 2] = buf[i * this.getRGBChannelCount()];
                    buf[i * this.getRGBChannelCount()] = r;
                }
            }
        } else {
            int skip = FormatTools.getPlaneSize(this, this.getSizeX() - w - x + pad, 1);
            if ((long)((this.getSizeX() + pad) * this.getSizeY() * this.getRGBChannelCount()) > maxBytes) {
                skip /= this.getRGBChannelCount();
            }
            for (int i = h - 1; i >= 0; --i) {
                this.in.skipBytes(x * (this.bmpBitsPerPixel / 8));
                this.in.read(buf, i * scanline, scanline);
                if (this.bmpBitsPerPixel == 24) {
                    for (int j = 0; j < w; ++j) {
                        byte r = buf[i * scanline + j * 3 + 2];
                        buf[i * scanline + j * 3 + 2] = buf[i * scanline + j * 3];
                        buf[i * scanline + j * 3] = r;
                    }
                }
                if (i <= 0) continue;
                this.in.skipBytes(skip);
            }
        }
        if (this.bmpBitsPerPixel == 16 && this.isRGB()) {
            ImageTools.bgrToRgb(buf, this.isInterleaved(), 2, this.getRGBChannelCount());
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.listString = null;
            this.offsets = null;
            this.lengths = null;
            this.type = null;
            this.fcc = null;
            this.size = -1;
            this.pos = 0L;
            this.bytesPerPlane = 0;
            this.bmpScanLineSize = 0;
            this.bmpCompression = 0;
            this.bmpWidth = 0;
            this.bmpColorsUsed = 0;
            this.bmpBitsPerPixel = 0;
            this.lut = null;
            this.lastImage = null;
            this.lastImageNo = -1;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        int effectiveWidth;
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.in.order(true);
        CoreMetadata ms0 = (CoreMetadata)this.core.get(0);
        LOGGER.info("Verifying AVI format");
        this.offsets = new ArrayList<Long>();
        this.lengths = new ArrayList<Long>();
        this.lastImageNo = -1;
        while (this.in.getFilePointer() < this.in.length() - 8L) {
            this.readChunk();
        }
        LOGGER.info("Populating metadata");
        ms0.imageCount = this.offsets.size();
        ms0.sizeZ = 1;
        ms0.sizeT = this.getImageCount();
        ms0.littleEndian = true;
        ms0.interleaved = this.bmpBitsPerPixel != 16;
        this.addGlobalMeta("Compression", this.getCodecName(this.bmpCompression));
        if (this.bmpCompression == 1196444237) {
            long fileOff = this.offsets.get(0);
            this.in.seek(fileOff);
            int planeSize = this.uncompress(0, null).length;
            int nBytes = planeSize / (this.getSizeX() * this.getSizeY());
            if (nBytes * this.getSizeX() * this.getSizeY() != planeSize) {
                ms0.sizeY /= 2;
                nBytes = planeSize / (this.getSizeX() * this.getSizeY());
            }
            if (this.bmpBitsPerPixel == 16) {
                nBytes /= 2;
            }
            ms0.sizeC = nBytes;
            ms0.rgb = this.getSizeC() > 1;
        } else if (this.bmpBitsPerPixel == 32) {
            ms0.sizeC = 4;
            ms0.rgb = true;
        } else if (this.bytesPerPlane == 0 || this.bmpBitsPerPixel == 24) {
            ms0.rgb = this.bmpBitsPerPixel > 8 || this.bmpCompression != 0 && this.lut == null;
            ms0.sizeC = this.isRGB() ? 3 : 1;
        } else if (this.bmpCompression == 1296126531) {
            ms0.sizeC = 3;
            ms0.rgb = true;
        } else {
            ms0.sizeC = this.bytesPerPlane / (this.getSizeX() * this.getSizeY() * (this.bmpBitsPerPixel / 8));
            ms0.rgb = this.getSizeC() > 1;
        }
        ms0.dimensionOrder = this.isRGB() ? "XYCTZ" : "XYTCZ";
        ms0.falseColor = false;
        ms0.metadataComplete = true;
        boolean bl = ms0.indexed = this.lut != null && !this.isRGB();
        if (this.bmpBitsPerPixel <= 8) {
            ms0.pixelType = 1;
            ms0.bitsPerPixel = this.bmpBitsPerPixel;
        } else if (this.bmpBitsPerPixel == 16) {
            ms0.pixelType = 3;
        } else if (this.bmpBitsPerPixel == 24 || this.bmpBitsPerPixel == 32) {
            ms0.pixelType = 1;
        } else {
            throw new FormatException("Unknown matching for pixel bit width of: " + this.bmpBitsPerPixel);
        }
        if (this.bmpCompression != 0) {
            ms0.pixelType = 1;
        }
        if ((effectiveWidth = this.bmpScanLineSize / (this.bmpBitsPerPixel / 8)) == 0) {
            effectiveWidth = this.getSizeX();
        }
        if (effectiveWidth < this.getSizeX()) {
            ms0.sizeX = effectiveWidth;
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
    }

    private byte[] uncompress(int no, byte[] buf) throws FormatException, IOException {
        if (this.lastImageNo == no) {
            buf = this.lastImage;
            return buf;
        }
        CodecOptions options = new CodecOptions();
        options.width = this.getSizeX();
        options.height = this.getSizeY();
        byte[] byArray = options.previousImage = this.lastImageNo == no - 1 ? this.lastImage : null;
        if (options.previousImage == null && this.bmpCompression != 1196444237) {
            while (this.lastImageNo < no - 1) {
                this.openBytes(this.lastImageNo + 1, buf);
            }
            options.previousImage = this.lastImage;
        }
        long fileOff = this.offsets.get(no);
        this.in.seek(fileOff);
        options.bitsPerSample = this.bmpBitsPerPixel;
        options.interleaved = this.isInterleaved();
        options.littleEndian = this.isLittleEndian();
        if (this.bmpCompression == 1) {
            byte[] b = new byte[(int)this.lengths.get(no).longValue()];
            this.in.read(b);
            MSRLECodec codec = new MSRLECodec();
            buf = codec.decompress(b, options);
        } else if (this.bmpCompression == 1296126531) {
            MSVideoCodec codec = new MSVideoCodec();
            buf = codec.decompress(this.in, options);
        } else if (this.bmpCompression == 1196444237) {
            boolean motionJPEG;
            JPEGCodec codec = new JPEGCodec();
            byte[] plane = new byte[(int)this.lengths.get(no).longValue()];
            this.in.read(plane);
            boolean bl = motionJPEG = plane.length >= 10 && new String(plane, 6, 4, "UTF-8").equals("AVI1");
            if (motionJPEG) {
                byte[] fixedPlane = new byte[plane.length + MJPEG_HUFFMAN_TABLE.length];
                System.arraycopy(plane, 0, fixedPlane, 0, 20);
                System.arraycopy(MJPEG_HUFFMAN_TABLE, 0, fixedPlane, 20, MJPEG_HUFFMAN_TABLE.length);
                System.arraycopy(plane, 20, fixedPlane, 20 + MJPEG_HUFFMAN_TABLE.length, plane.length - 20);
                plane = fixedPlane;
            }
            buf = plane.length > 0 ? codec.decompress(plane, options) : this.lastImage;
            if (!this.lengths.contains(0L)) {
                motionJPEG = false;
            }
            if (motionJPEG) {
                for (int i = 0; i < buf.length; i += 3) {
                    int y = buf[i] & 0xFF;
                    int cb = (buf[i + 1] & 0xFF) - 128;
                    int cr = (buf[i + 2] & 0xFF) - 128;
                    int red = (int)((double)y + 1.402 * (double)cr);
                    int green = (int)((double)y - 0.34414 * (double)cb - 0.71414 * (double)cr);
                    int blue = (int)((double)y + 1.772 * (double)cb);
                    if (red < 0) {
                        red = 0;
                    } else if (red > 255) {
                        red = 255;
                    }
                    if (green < 0) {
                        green = 0;
                    } else if (green > 255) {
                        green = 255;
                    }
                    if (blue < 0) {
                        blue = 0;
                    } else if (blue > 255) {
                        blue = 255;
                    }
                    buf[i] = (byte)(red & 0xFF);
                    buf[i + 1] = (byte)(green & 0xFF);
                    buf[i + 2] = (byte)(blue & 0xFF);
                }
            }
        } else {
            throw new UnsupportedCompressionException(this.bmpCompression + " not supported");
        }
        this.lastImage = buf;
        this.lastImageNo = no;
        return buf;
    }

    private void readChunkHeader() throws IOException {
        this.readTypeAndSize();
        this.fcc = this.in.readString(4);
    }

    private void readTypeAndSize() throws IOException {
        this.type = this.in.readString(4);
        this.size = this.in.readInt();
    }

    private void readChunk() throws FormatException, IOException {
        long originalOffset = this.in.getFilePointer();
        this.readChunkHeader();
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        if (this.type.equals(AVI_MAGIC_STRING)) {
            if (!this.fcc.startsWith("AVI")) {
                LOGGER.warn("Unrecognized chunk '{}' at offset {}", (Object)this.fcc, (Object)originalOffset);
                if (this.in.getFilePointer() + (long)this.size - 4L <= this.in.length()) {
                    this.in.skipBytes(this.size - 4);
                    return;
                }
            }
        } else {
            if (this.in.getFilePointer() == 12L) {
                throw new FormatException("Not an AVI file");
            }
            if (this.in.getFilePointer() + (long)this.size - 4L <= this.in.length()) {
                this.in.skipBytes(this.size - 4);
            }
            return;
        }
        long spos = this.pos = this.in.getFilePointer();
        LOGGER.info("Searching for image data");
        while (this.in.length() - this.in.getFilePointer() > 4L) {
            this.listString = this.in.readString(4);
            if (this.listString.equals(AVI_MAGIC_STRING)) {
                this.in.seek(this.in.getFilePointer() - 4L);
                return;
            }
            this.in.seek(this.pos);
            if (this.listString.equals(" JUN")) {
                this.in.skipBytes(1);
                ++this.pos;
            }
            if (this.listString.equals("JUNK")) {
                this.readTypeAndSize();
                if (this.type.equals("JUNK")) {
                    this.in.skipBytes(this.size);
                }
            } else if (this.listString.equals("IDIT")) {
                this.readTypeAndSize();
                this.in.skipBytes(this.size);
            } else if (this.listString.equals("LIST")) {
                spos = this.in.getFilePointer();
                this.readChunkHeader();
                this.in.seek(spos);
                if (this.fcc.equals("hdrl")) {
                    this.readChunkHeader();
                    if (this.type.equals("LIST") && this.fcc.equals("hdrl")) {
                        this.readTypeAndSize();
                        if (this.type.equals("avih")) {
                            spos = this.in.getFilePointer();
                            this.addGlobalMeta("Microseconds per frame", this.in.readInt());
                            this.addGlobalMeta("Max. bytes per second", this.in.readInt());
                            this.in.skipBytes(8);
                            this.addGlobalMeta("Total frames", this.in.readInt());
                            this.addGlobalMeta("Initial frames", this.in.readInt());
                            this.in.skipBytes(8);
                            m.sizeX = this.in.readInt();
                            this.addGlobalMeta("Frame height", this.in.readInt());
                            this.addGlobalMeta("Scale factor", this.in.readInt());
                            this.addGlobalMeta("Frame rate", this.in.readInt());
                            this.addGlobalMeta("Start time", this.in.readInt());
                            this.addGlobalMeta("Length", this.in.readInt());
                            this.addGlobalMeta("Frame width", this.getSizeX());
                            if (spos + (long)this.size <= this.in.length()) {
                                this.in.seek(spos + (long)this.size);
                            }
                        }
                    }
                } else if (this.fcc.equals("strl")) {
                    long startPos = this.in.getFilePointer();
                    long streamSize = this.size;
                    this.readChunkHeader();
                    if (this.type.equals("LIST")) {
                        if (this.fcc.equals("strl")) {
                            this.readTypeAndSize();
                            if (this.type.equals("strh")) {
                                spos = this.in.getFilePointer();
                                this.in.skipBytes(40);
                                this.addGlobalMeta("Stream quality", this.in.readInt());
                                this.bytesPerPlane = this.in.readInt();
                                this.addGlobalMeta("Stream sample size", this.bytesPerPlane);
                                if (spos + (long)this.size <= this.in.length()) {
                                    this.in.seek(spos + (long)this.size);
                                }
                            }
                            this.readTypeAndSize();
                            if (this.type.equals("strf")) {
                                spos = this.in.getFilePointer();
                                if (this.getSizeY() != 0) {
                                    this.in.skipBytes(this.size);
                                    this.readTypeAndSize();
                                    while (this.type.equals("indx")) {
                                        this.in.skipBytes(this.size);
                                        this.readTypeAndSize();
                                    }
                                    this.pos = this.in.getFilePointer() - 4L;
                                    this.in.seek(this.pos - 4L);
                                    continue;
                                }
                                this.in.skipBytes(4);
                                this.bmpWidth = this.in.readInt();
                                m.sizeY = this.in.readInt();
                                this.in.skipBytes(2);
                                this.bmpBitsPerPixel = this.in.readShort();
                                this.bmpCompression = this.in.readInt();
                                this.in.skipBytes(4);
                                this.addGlobalMeta("Horizontal resolution", this.in.readInt());
                                this.addGlobalMeta("Vertical resolution", this.in.readInt());
                                this.bmpColorsUsed = this.in.readInt();
                                this.in.skipBytes(4);
                                this.addGlobalMeta("Bitmap compression value", this.bmpCompression);
                                this.addGlobalMeta("Number of colors used", this.bmpColorsUsed);
                                this.addGlobalMeta("Bits per pixel", this.bmpBitsPerPixel);
                                int npad = this.bmpWidth % 4;
                                if (npad > 0) {
                                    npad = 4 - npad;
                                }
                                this.bmpScanLineSize = (this.bmpWidth + npad) * (this.bmpBitsPerPixel / 8);
                                int bmpActualColorsUsed = 0;
                                if (this.bmpColorsUsed != 0) {
                                    bmpActualColorsUsed = this.bmpColorsUsed;
                                } else if (this.bmpBitsPerPixel < 16) {
                                    this.bmpColorsUsed = bmpActualColorsUsed = 1 << this.bmpBitsPerPixel;
                                }
                                if (this.bmpCompression != 1 && this.bmpCompression != 0 && this.bmpCompression != 1296126531 && this.bmpCompression != 1196444237 && this.bmpCompression != 538982489) {
                                    throw new UnsupportedCompressionException(this.bmpCompression + " not supported");
                                }
                                if (this.bmpBitsPerPixel != 4 && this.bmpBitsPerPixel != 8 && this.bmpBitsPerPixel != 24 && this.bmpBitsPerPixel != 16 && this.bmpBitsPerPixel != 32) {
                                    throw new FormatException(this.bmpBitsPerPixel + " bits per pixel not supported");
                                }
                                if (bmpActualColorsUsed != 0) {
                                    this.lut = new byte[3][this.bmpColorsUsed];
                                    for (int i = 0; i < this.bmpColorsUsed; ++i) {
                                        if (this.bmpCompression != 538982489) {
                                            this.lut[2][i] = this.in.readByte();
                                            this.lut[1][i] = this.in.readByte();
                                            this.lut[0][i] = this.in.readByte();
                                            this.in.skipBytes(1);
                                            continue;
                                        }
                                        this.lut[0][i] = (byte)i;
                                        this.lut[1][i] = (byte)i;
                                        this.lut[2][i] = (byte)i;
                                    }
                                }
                                this.in.seek(spos + (long)this.size);
                            }
                        }
                        spos = this.in.getFilePointer();
                        this.readTypeAndSize();
                        if (this.type.equals("strd")) {
                            this.in.skipBytes(this.size);
                        } else {
                            this.in.seek(spos);
                        }
                        spos = this.in.getFilePointer();
                        this.readTypeAndSize();
                        if (this.type.equals("strn") || this.type.equals("indx")) {
                            this.in.skipBytes(this.size);
                        } else {
                            this.in.seek(spos);
                        }
                    }
                    if (startPos + streamSize + 8L <= this.in.length()) {
                        this.in.seek(startPos + 8L + streamSize);
                    }
                } else if (this.fcc.equals("movi")) {
                    this.readChunkHeader();
                    if (this.type.equals("LIST") && this.fcc.equals("movi")) {
                        spos = this.in.getFilePointer();
                        long startOfMovi = spos - 4L;
                        if (spos >= this.in.length() - 12L) break;
                        this.readChunkHeader();
                        if (!this.type.equals("LIST") || !this.fcc.equals("rec ") && !this.fcc.equals("movi")) {
                            this.in.seek(spos);
                        }
                        spos = this.in.getFilePointer();
                        boolean end = false;
                        while (!end && this.in.getFilePointer() < this.in.length() - 8L) {
                            this.readTypeAndSize();
                            String oldType = this.type;
                            while (this.type.startsWith("ix") || this.type.endsWith("tx") || this.type.equals("JUNK")) {
                                this.in.skipBytes(this.size);
                                this.readTypeAndSize();
                            }
                            String check = this.type.substring(2);
                            boolean foundPixels = false;
                            while (check.equals("db") || check.equals("dc") || check.equals("wb")) {
                                foundPixels = true;
                                if (check.startsWith("d")) {
                                    if (this.size > 0 || this.bmpCompression != 0) {
                                        this.offsets.add(new Long(this.in.getFilePointer()));
                                        this.lengths.add(new Long(this.size));
                                        this.in.skipBytes(this.size);
                                    }
                                } else if (check.equals("wb")) {
                                    this.in.skipBytes(this.size);
                                }
                                if ((spos = this.in.getFilePointer()) + 8L >= this.in.length()) {
                                    return;
                                }
                                this.readTypeAndSize();
                                if (this.type.equals("JUNK")) {
                                    this.in.skipBytes(this.size);
                                    spos = this.in.getFilePointer();
                                    if (spos + 8L >= this.in.length()) {
                                        return;
                                    }
                                    this.readTypeAndSize();
                                } else if (this.type.length() < 4 || this.type.endsWith("JUN")) {
                                    this.in.seek(spos + 1L);
                                    this.readTypeAndSize();
                                    this.in.skipBytes(this.size);
                                    spos = this.in.getFilePointer();
                                    if (spos + 8L >= this.in.length()) {
                                        return;
                                    }
                                    this.readTypeAndSize();
                                }
                                if (this.type.length() < 4) {
                                    return;
                                }
                                check = this.type.substring(2);
                                if (!check.equals("0d")) continue;
                                this.in.seek(spos + 1L);
                                this.readTypeAndSize();
                                check = this.type.substring(2);
                            }
                            this.in.seek(spos);
                            if (!oldType.startsWith("ix") && !foundPixels) {
                                if (check.equals("x1") && this.in.getFilePointer() < this.in.length() - 24L) {
                                    this.in.skipBytes(8);
                                    this.offsets.clear();
                                    this.lengths.clear();
                                    long tableEnd = this.in.getFilePointer() + (long)this.size;
                                    if (tableEnd <= 0L || tableEnd > this.in.length()) {
                                        tableEnd = this.in.length();
                                    }
                                    boolean useSOM = false;
                                    while (this.in.getFilePointer() + 16L <= tableEnd) {
                                        String chunkID = this.in.readString(4);
                                        int flags = this.in.readInt();
                                        int offset = this.in.readInt() + 8;
                                        int chunkSize = this.in.readInt();
                                        if (!chunkID.endsWith("db") && !chunkID.endsWith("dc")) continue;
                                        if (this.offsets.size() == 0) {
                                            boolean bl = useSOM = (long)offset < startOfMovi;
                                        }
                                        if (this.offsets.size() > 0 && (long)offset == this.offsets.get(this.offsets.size() - 1)) {
                                            chunkSize = this.lengths.get(this.lengths.size() - 1).intValue();
                                        }
                                        if (chunkSize == 0 && this.offsets.size() > 0 && this.bmpCompression == 0) {
                                            this.offsets.add(this.offsets.get(this.offsets.size() - 1));
                                        } else if (chunkSize > 0 || this.offsets.size() > 0) {
                                            this.offsets.add(new Long(useSOM ? startOfMovi + (long)offset : (long)offset));
                                        }
                                        this.lengths.add(new Long(chunkSize));
                                    }
                                    continue;
                                }
                                end = true;
                                continue;
                            }
                            if (!oldType.startsWith("ix") || foundPixels) continue;
                            end = true;
                        }
                    }
                } else {
                    int oldSize = this.size;
                    this.size = this.in.readInt() - 8;
                    if (this.size > oldSize) {
                        this.size = oldSize;
                        this.in.seek(this.in.getFilePointer() - 4L);
                    }
                    if (this.size + 8 >= 0) {
                        this.in.skipBytes(8 + this.size);
                    }
                }
            } else {
                if (this.in.getFilePointer() + 8L >= this.in.length()) break;
                this.readTypeAndSize();
                if (this.in.getFilePointer() + 8L < this.in.length() && !this.type.equals("idx1")) {
                    this.readTypeAndSize();
                } else if (!this.type.equals("idx1")) break;
                if (this.in.getFilePointer() + (long)this.size + 4L <= this.in.length()) {
                    this.in.skipBytes(this.size);
                }
                if (this.type.equals("idx1")) break;
            }
            this.pos = this.in.getFilePointer();
        }
    }

    private String getCodecName(int bmpCompression) {
        switch (bmpCompression) {
            case 0: {
                return "Raw (uncompressed)";
            }
            case 1: {
                return "Microsoft Run-Length Encoding (MSRLE)";
            }
            case 1296126531: {
                return "Microsoft Video (MSV1)";
            }
            case 1196444237: {
                return "JPEG";
            }
        }
        return "Unknown";
    }
}

