/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums;

import ome.units.quantity.ElectricPotential;
import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.handlers.UnitsElectricPotentialEnumHandler;
import ome.xml.model.primitives.PrimitiveNumber;

public enum UnitsElectricPotential implements Enumeration
{
    YOTTAVOLT("YV"),
    ZETTAVOLT("ZV"),
    EXAVOLT("EV"),
    PETAVOLT("PV"),
    TERAVOLT("TV"),
    GIGAVOLT("GV"),
    MEGAVOLT("MV"),
    KILOVOLT("kV"),
    HECTOVOLT("hV"),
    DECAVOLT("daV"),
    VOLT("V"),
    DECIVOLT("dV"),
    CENTIVOLT("cV"),
    MILLIVOLT("mV"),
    MICROVOLT("\u00b5V"),
    NANOVOLT("nV"),
    PICOVOLT("pV"),
    FEMTOVOLT("fV"),
    ATTOVOLT("aV"),
    ZEPTOVOLT("zV"),
    YOCTOVOLT("yV");

    private final String value;

    private UnitsElectricPotential(String value) {
        this.value = value;
    }

    public static UnitsElectricPotential fromString(String value) throws EnumerationException {
        if ("YV".equals(value)) {
            return YOTTAVOLT;
        }
        if ("ZV".equals(value)) {
            return ZETTAVOLT;
        }
        if ("EV".equals(value)) {
            return EXAVOLT;
        }
        if ("PV".equals(value)) {
            return PETAVOLT;
        }
        if ("TV".equals(value)) {
            return TERAVOLT;
        }
        if ("GV".equals(value)) {
            return GIGAVOLT;
        }
        if ("MV".equals(value)) {
            return MEGAVOLT;
        }
        if ("kV".equals(value)) {
            return KILOVOLT;
        }
        if ("hV".equals(value)) {
            return HECTOVOLT;
        }
        if ("daV".equals(value)) {
            return DECAVOLT;
        }
        if ("V".equals(value)) {
            return VOLT;
        }
        if ("dV".equals(value)) {
            return DECIVOLT;
        }
        if ("cV".equals(value)) {
            return CENTIVOLT;
        }
        if ("mV".equals(value)) {
            return MILLIVOLT;
        }
        if ("\u00b5V".equals(value)) {
            return MICROVOLT;
        }
        if ("nV".equals(value)) {
            return NANOVOLT;
        }
        if ("pV".equals(value)) {
            return PICOVOLT;
        }
        if ("fV".equals(value)) {
            return FEMTOVOLT;
        }
        if ("aV".equals(value)) {
            return ATTOVOLT;
        }
        if ("zV".equals(value)) {
            return ZEPTOVOLT;
        }
        if ("yV".equals(value)) {
            return YOCTOVOLT;
        }
        String s = String.format("'%s' not a supported value of '%s'", value, UnitsElectricPotential.class);
        throw new EnumerationException(s);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    public static <T extends PrimitiveNumber> ElectricPotential create(T newValue, UnitsElectricPotential newUnit) {
        ElectricPotential theQuantity = null;
        try {
            theQuantity = UnitsElectricPotentialEnumHandler.getQuantity(newValue, newUnit);
            return theQuantity;
        }
        finally {
            return theQuantity;
        }
    }

    public static <T extends Number> ElectricPotential create(T newValue, UnitsElectricPotential newUnit) {
        ElectricPotential theQuantity = null;
        try {
            theQuantity = UnitsElectricPotentialEnumHandler.getQuantity(newValue, newUnit);
            return theQuantity;
        }
        finally {
            return theQuantity;
        }
    }
}

