/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class FileWriterWithEncoding
extends Writer {
    private final Writer out;

    public FileWriterWithEncoding(String filename, String encoding) throws IOException {
        this(new File(filename), encoding, false);
    }

    public FileWriterWithEncoding(String filename, String encoding, boolean append) throws IOException {
        this(new File(filename), encoding, append);
    }

    public FileWriterWithEncoding(String filename, Charset encoding) throws IOException {
        this(new File(filename), encoding, false);
    }

    public FileWriterWithEncoding(String filename, Charset encoding, boolean append) throws IOException {
        this(new File(filename), encoding, append);
    }

    public FileWriterWithEncoding(String filename, CharsetEncoder encoding) throws IOException {
        this(new File(filename), encoding, false);
    }

    public FileWriterWithEncoding(String filename, CharsetEncoder encoding, boolean append) throws IOException {
        this(new File(filename), encoding, append);
    }

    public FileWriterWithEncoding(File file2, String encoding) throws IOException {
        this(file2, encoding, false);
    }

    public FileWriterWithEncoding(File file2, String encoding, boolean append) throws IOException {
        this.out = FileWriterWithEncoding.initWriter(file2, encoding, append);
    }

    public FileWriterWithEncoding(File file2, Charset encoding) throws IOException {
        this(file2, encoding, false);
    }

    public FileWriterWithEncoding(File file2, Charset encoding, boolean append) throws IOException {
        this.out = FileWriterWithEncoding.initWriter(file2, encoding, append);
    }

    public FileWriterWithEncoding(File file2, CharsetEncoder encoding) throws IOException {
        this(file2, encoding, false);
    }

    public FileWriterWithEncoding(File file2, CharsetEncoder encoding, boolean append) throws IOException {
        this.out = FileWriterWithEncoding.initWriter(file2, encoding, append);
    }

    private static Writer initWriter(File file2, Object encoding, boolean append) throws IOException {
        if (file2 == null) {
            throw new NullPointerException("File is missing");
        }
        if (encoding == null) {
            throw new NullPointerException("Encoding is missing");
        }
        boolean fileExistedAlready = file2.exists();
        FileOutputStream stream = null;
        OutputStreamWriter writer = null;
        try {
            stream = new FileOutputStream(file2, append);
            writer = encoding instanceof Charset ? new OutputStreamWriter((OutputStream)stream, (Charset)encoding) : (encoding instanceof CharsetEncoder ? new OutputStreamWriter((OutputStream)stream, (CharsetEncoder)encoding) : new OutputStreamWriter((OutputStream)stream, (String)encoding));
        }
        catch (IOException ex) {
            IOUtils.closeQuietly(writer);
            IOUtils.closeQuietly(stream);
            if (!fileExistedAlready) {
                FileUtils.deleteQuietly(file2);
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            IOUtils.closeQuietly(writer);
            IOUtils.closeQuietly(stream);
            if (!fileExistedAlready) {
                FileUtils.deleteQuietly(file2);
            }
            throw ex;
        }
        return writer;
    }

    @Override
    public void write(int idx) throws IOException {
        this.out.write(idx);
    }

    @Override
    public void write(char[] chr) throws IOException {
        this.out.write(chr);
    }

    @Override
    public void write(char[] chr, int st, int end) throws IOException {
        this.out.write(chr, st, end);
    }

    @Override
    public void write(String str) throws IOException {
        this.out.write(str);
    }

    @Override
    public void write(String str, int st, int end) throws IOException {
        this.out.write(str, st, end);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

