/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory.bdb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseStats;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentLockedException;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.inventory.MFile;
import ucar.nc2.constants.CDM;

public class MetadataManager {
    private static final Logger logger = LoggerFactory.getLogger(MetadataManager.class);
    private static final String UTF8 = "UTF-8";
    private static String root = null;
    private static long maxSizeBytes = 0L;
    private static int jvmPercent = 2;
    private static Environment myEnv = null;
    private static List<MetadataManager> openDatabases = new ArrayList<MetadataManager>();
    private static boolean readOnly = false;
    private static boolean debug = false;
    private String collectionName;
    private Database database;

    public static void setCacheDirectory(String dir, long _maxSizeBytes, int _jvmPercent) {
        root = dir;
        maxSizeBytes = _maxSizeBytes;
        jvmPercent = _jvmPercent;
    }

    private static synchronized void setup() throws DatabaseException {
        if (myEnv != null) {
            return;
        }
        logger.info("try to open bdb");
        EnvironmentConfig myEnvConfig = new EnvironmentConfig();
        myEnvConfig.setReadOnly(false);
        myEnvConfig.setAllowCreate(true);
        myEnvConfig.setSharedCache(true);
        if (maxSizeBytes > 0L) {
            myEnvConfig.setCacheSize(maxSizeBytes);
        } else {
            myEnvConfig.setCachePercent(jvmPercent);
        }
        File dir = new File(root);
        if (!dir.exists() && !dir.mkdirs()) {
            logger.warn("MetadataManager failed to make directory " + root);
        }
        try {
            myEnv = new Environment(dir, myEnvConfig);
            readOnly = false;
        }
        catch (EnvironmentLockedException e) {
            logger.warn("MetadataManager failed to open directory {}, try read-only", (Object)root);
            logger.error("failed to open bdb", e);
            logger.warn("myEnvConfig {}", (Object)myEnvConfig);
            readOnly = true;
            myEnvConfig.setReadOnly(true);
            myEnvConfig.setAllowCreate(false);
            myEnv = new Environment(dir, myEnvConfig);
        }
        logger.info("MetadataManager: open bdb at root " + root + " readOnly = " + readOnly);
    }

    public static synchronized void closeAll() {
        ArrayList<MetadataManager> closeDatabases = new ArrayList<MetadataManager>(openDatabases);
        for (MetadataManager mm : closeDatabases) {
            if (debug) {
                System.out.println("  close database " + mm.collectionName);
            }
            mm.close();
        }
        openDatabases = new ArrayList<MetadataManager>();
        if (myEnv != null) {
            try {
                myEnv.close();
                myEnv = null;
                logger.info("closed bdb caching");
            }
            catch (DatabaseException dbe) {
                logger.error("Error closing bdb: ", dbe);
            }
        }
    }

    public static void showEnvStats(Formatter f) {
        if (myEnv == null) {
            MetadataManager.setup();
        }
        try {
            EnvironmentStats stats = myEnv.getStats(null);
            f.format("EnvironmentStats%n%s%n", stats);
            f.format("%nDatabaseNames%n", new Object[0]);
            for (String dbName : myEnv.getDatabaseNames()) {
                f.format(" %s%n", dbName);
            }
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    public static String getCacheLocation() {
        return root;
    }

    public static void sync() {
        if (myEnv != null) {
            myEnv.sync();
        }
    }

    public static List<String> getCollectionNames() {
        if (myEnv == null) {
            MetadataManager.setup();
        }
        return myEnv.getDatabaseNames();
    }

    public static void deleteCollection(String collectionName) throws Exception {
        for (MetadataManager mm : openDatabases) {
            if (!mm.collectionName.equals(collectionName) || mm.database == null) continue;
            mm.database.close();
        }
        myEnv.removeDatabase(null, collectionName);
    }

    public static void delete(String collectionName, String key) {
        try {
            MetadataManager mm = new MetadataManager(collectionName);
            mm.delete(key);
            mm.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public MetadataManager(String collectionName) throws DatabaseException, IOException {
        this.collectionName = collectionName;
        if (myEnv == null) {
            MetadataManager.setup();
        }
    }

    private void openDatabase() {
        if (this.database != null) {
            return;
        }
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setReadOnly(readOnly);
        dbConfig.setAllowCreate(!readOnly);
        if (!readOnly) {
            dbConfig.setDeferredWrite(true);
        }
        this.database = myEnv.openDatabase(null, this.collectionName, dbConfig);
        openDatabases.add(this);
    }

    public void put(String key, String value) {
        if (readOnly) {
            return;
        }
        this.openDatabase();
        try {
            this.database.put(null, new DatabaseEntry(key.getBytes(UTF8)), new DatabaseEntry(value.getBytes(UTF8)));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void put(byte[] key, byte[] value) {
        if (readOnly) {
            return;
        }
        this.openDatabase();
        this.database.put(null, new DatabaseEntry(key), new DatabaseEntry(value));
    }

    public void put(String key, byte[] value) {
        if (readOnly) {
            return;
        }
        this.openDatabase();
        try {
            this.database.put(null, new DatabaseEntry(key.getBytes(UTF8)), new DatabaseEntry(value));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public byte[] get(byte[] key) {
        this.openDatabase();
        DatabaseEntry value = new DatabaseEntry();
        this.database.get(null, new DatabaseEntry(key), value, LockMode.DEFAULT);
        return value.getData();
    }

    public byte[] getBytes(String key) {
        this.openDatabase();
        try {
            DatabaseEntry value = new DatabaseEntry();
            this.database.get(null, new DatabaseEntry(key.getBytes(UTF8)), value, LockMode.DEFAULT);
            return value.getData();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String get(String key) {
        this.openDatabase();
        try {
            DatabaseEntry value = new DatabaseEntry();
            OperationStatus status = this.database.get(null, new DatabaseEntry(key.getBytes(UTF8)), value, LockMode.DEFAULT);
            if (status == OperationStatus.SUCCESS) {
                return new String(value.getData(), UTF8);
            }
            return null;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void delete(String theKey) {
        if (readOnly) {
            logger.warn("Cant delete - readOnly mode");
            return;
        }
        this.openDatabase();
        try {
            DatabaseEntry entry = new DatabaseEntry(theKey.getBytes(CDM.utf8Charset));
            this.database.delete(null, entry);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Map<String, MFile> current) {
        if (readOnly) {
            logger.warn("Cant delete - readOnly mode");
            return;
        }
        this.openDatabase();
        ArrayList<DatabaseEntry> result = new ArrayList<DatabaseEntry>();
        Cursor myCursor = null;
        try {
            myCursor = this.database.openCursor(null, null);
            DatabaseEntry foundKey = new DatabaseEntry();
            DatabaseEntry foundData = new DatabaseEntry();
            int count = 0;
            while (myCursor.getNext(foundKey, foundData, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                String key = new String(foundKey.getData(), UTF8);
                int pos = key.indexOf(35);
                if (pos <= 0) continue;
                String filename = key.substring(0, pos);
                if (null == current.get(filename)) {
                    logger.debug("{} not in current - want to delete from bdb", (Object)filename);
                    result.add(new DatabaseEntry(foundKey.getData()));
                    ++count;
                    continue;
                }
                logger.debug("{} is in current", (Object)filename);
            }
            int countDelete = 0;
            for (DatabaseEntry entry : result) {
                OperationStatus status = this.database.delete(null, entry);
                String key = new String(entry.getData(), UTF8);
                logger.debug("{} deleted {}", (Object)status, (Object)key);
                ++countDelete;
            }
            logger.info("{} #files deleted = {}", (Object)this.collectionName, (Object)countDelete);
        }
        catch (UnsupportedOperationException e) {
            logger.error("Trying to delete " + this.collectionName, e);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Trying to delete " + this.collectionName, e);
        }
        finally {
            if (null != myCursor) {
                myCursor.close();
            }
        }
    }

    public void close() {
        if (this.database != null) {
            this.database.close();
            openDatabases.remove(this);
            this.database = null;
        }
    }

    public void showStats(Formatter f) {
        this.openDatabase();
        try {
            DatabaseStats dstats = this.database.getStats(null);
            f.format("primary stats %n%s%n", dstats);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KeyValue> getContent() throws DatabaseException, UnsupportedEncodingException {
        this.openDatabase();
        ArrayList<KeyValue> result = new ArrayList<KeyValue>();
        Cursor myCursor = null;
        try {
            myCursor = this.database.openCursor(null, null);
            DatabaseEntry foundKey = new DatabaseEntry();
            DatabaseEntry foundData = new DatabaseEntry();
            while (myCursor.getNext(foundKey, foundData, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                String key = new String(foundKey.getData(), UTF8);
                String data = new String(foundData.getData(), UTF8);
                result.add(new KeyValue(key, data));
            }
        }
        finally {
            if (null != myCursor) {
                myCursor.close();
            }
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        MetadataManager indexer = new MetadataManager("dummy");
        indexer.showStats(new Formatter(System.out));
        MetadataManager.closeAll();
    }

    static {
        String home = System.getProperty("user.home");
        if (home == null) {
            home = System.getProperty("user.dir");
        }
        if (home == null) {
            home = ".";
        }
        root = home + "/.unidata/bdb/";
    }

    public class KeyValue {
        public String key;
        public String value;

        KeyValue(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

