/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition;

import org.ejml.EjmlParameters;
import org.ejml.alg.dense.decomposition.CholeskyDecomposition;
import org.ejml.alg.dense.decomposition.DecompositionInterface;
import org.ejml.alg.dense.decomposition.EigenDecomposition;
import org.ejml.alg.dense.decomposition.LUDecomposition;
import org.ejml.alg.dense.decomposition.QRDecomposition;
import org.ejml.alg.dense.decomposition.SingularValueDecomposition;
import org.ejml.alg.dense.decomposition.chol.CholeskyDecompositionBlock;
import org.ejml.alg.dense.decomposition.chol.CholeskyDecompositionBlock64;
import org.ejml.alg.dense.decomposition.chol.CholeskyDecompositionInner;
import org.ejml.alg.dense.decomposition.chol.CholeskyDecompositionLDL;
import org.ejml.alg.dense.decomposition.eig.SwitchingEigenDecomposition;
import org.ejml.alg.dense.decomposition.eig.SymmetricQRAlgorithmDecomposition;
import org.ejml.alg.dense.decomposition.eig.WatchedDoubleStepQRDecomposition;
import org.ejml.alg.dense.decomposition.hessenberg.TridiagonalDecompositionBlock;
import org.ejml.alg.dense.decomposition.hessenberg.TridiagonalDecompositionHouseholder;
import org.ejml.alg.dense.decomposition.hessenberg.TridiagonalSimilarDecomposition;
import org.ejml.alg.dense.decomposition.lu.LUDecompositionAlt;
import org.ejml.alg.dense.decomposition.qr.QRDecompositionHouseholderColumn;
import org.ejml.alg.dense.decomposition.svd.SvdImplicitQrDecompose;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.ops.EigenOps;
import org.ejml.ops.SpecializedOps;
import org.ejml.simple.SimpleMatrix;

public class DecompositionFactory {
    public static CholeskyDecomposition<DenseMatrix64F> chol(int n, boolean bl) {
        if (n < EjmlParameters.SWITCH_BLOCK64_CHOLESKY) {
            return new CholeskyDecompositionInner(bl);
        }
        if (EjmlParameters.MEMORY == EjmlParameters.MemoryUsage.FASTER) {
            return new CholeskyDecompositionBlock64(bl);
        }
        return new CholeskyDecompositionBlock(EjmlParameters.BLOCK_WIDTH_CHOL);
    }

    public static CholeskyDecompositionLDL cholLDL(int n) {
        return new CholeskyDecompositionLDL();
    }

    public static LUDecomposition<DenseMatrix64F> lu(int n) {
        return new LUDecompositionAlt();
    }

    public static SingularValueDecomposition<DenseMatrix64F> svd(int n, int n2) {
        return new SvdImplicitQrDecompose(false, true, true);
    }

    public static SingularValueDecomposition<DenseMatrix64F> svd(int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        return new SvdImplicitQrDecompose(bl3, bl, bl2);
    }

    public static QRDecomposition<DenseMatrix64F> qr(int n, int n2) {
        return new QRDecompositionHouseholderColumn();
    }

    public static EigenDecomposition<DenseMatrix64F> eig(int n) {
        return new SwitchingEigenDecomposition(n);
    }

    public static EigenDecomposition<DenseMatrix64F> eig(int n, boolean bl) {
        return new SwitchingEigenDecomposition(n, bl, 1.0E-8);
    }

    public static EigenDecomposition<DenseMatrix64F> eigGeneral(int n, boolean bl) {
        return new WatchedDoubleStepQRDecomposition(bl);
    }

    public static EigenDecomposition<DenseMatrix64F> eigSymm(int n, boolean bl) {
        TridiagonalSimilarDecomposition<DenseMatrix64F> tridiagonalSimilarDecomposition = DecompositionFactory.tridiagonal(n);
        return new SymmetricQRAlgorithmDecomposition(tridiagonalSimilarDecomposition, bl);
    }

    public static double quality(DenseMatrix64F denseMatrix64F, SingularValueDecomposition<DenseMatrix64F> singularValueDecomposition) {
        return DecompositionFactory.quality(denseMatrix64F, singularValueDecomposition.getU(false), singularValueDecomposition.getW(null), singularValueDecomposition.getV(true));
    }

    public static double quality(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, DenseMatrix64F denseMatrix64F3, DenseMatrix64F denseMatrix64F4) {
        SimpleMatrix simpleMatrix = SimpleMatrix.wrap(denseMatrix64F2);
        SimpleMatrix simpleMatrix2 = SimpleMatrix.wrap(denseMatrix64F3);
        SimpleMatrix simpleMatrix3 = SimpleMatrix.wrap(denseMatrix64F4);
        SimpleMatrix simpleMatrix4 = simpleMatrix.mult(simpleMatrix2).mult(simpleMatrix3);
        return SpecializedOps.diffNormF(denseMatrix64F, simpleMatrix4.getMatrix()) / simpleMatrix4.normF();
    }

    public static double quality(DenseMatrix64F denseMatrix64F, EigenDecomposition<DenseMatrix64F> eigenDecomposition) {
        SimpleMatrix simpleMatrix = SimpleMatrix.wrap(denseMatrix64F);
        SimpleMatrix simpleMatrix2 = SimpleMatrix.wrap(EigenOps.createMatrixV(eigenDecomposition));
        SimpleMatrix simpleMatrix3 = SimpleMatrix.wrap(EigenOps.createMatrixD(eigenDecomposition));
        SimpleMatrix simpleMatrix4 = simpleMatrix.mult(simpleMatrix2);
        SimpleMatrix simpleMatrix5 = simpleMatrix2.mult(simpleMatrix3);
        SimpleMatrix simpleMatrix6 = simpleMatrix4.minus(simpleMatrix5);
        double d = simpleMatrix6.normF();
        double d2 = simpleMatrix4.normF();
        double d3 = d / d2;
        return d3;
    }

    public static TridiagonalSimilarDecomposition<DenseMatrix64F> tridiagonal(int n) {
        if (n >= 1800) {
            return new TridiagonalDecompositionBlock();
        }
        return new TridiagonalDecompositionHouseholder();
    }

    public static <T extends Matrix64F> boolean decomposeSafe(DecompositionInterface<T> decompositionInterface, T t) {
        if (decompositionInterface.inputModified()) {
            return decompositionInterface.decompose(t.copy());
        }
        return decompositionInterface.decompose(t);
    }
}

