/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.chol;

import org.ejml.alg.dense.decomposition.CholeskyDecomposition;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public abstract class CholeskyDecompositionCommon
implements CholeskyDecomposition<DenseMatrix64F> {
    protected int maxWidth = -1;
    protected int n;
    protected DenseMatrix64F T;
    protected double[] t;
    protected double[] vv;
    protected boolean lower;

    public CholeskyDecompositionCommon(boolean bl) {
        this.lower = bl;
    }

    public void setExpectedMaxSize(int n, int n2) {
        if (n != n2) {
            throw new IllegalArgumentException("Can only decompose square matrices");
        }
        this.maxWidth = n2;
        this.vv = new double[this.maxWidth];
    }

    @Override
    public boolean isLower() {
        return this.lower;
    }

    @Override
    public boolean decompose(DenseMatrix64F denseMatrix64F) {
        if (denseMatrix64F.numRows > this.maxWidth) {
            this.setExpectedMaxSize(denseMatrix64F.numRows, denseMatrix64F.numCols);
        } else if (denseMatrix64F.numRows != denseMatrix64F.numCols) {
            throw new IllegalArgumentException("Must be a square matrix.");
        }
        this.n = denseMatrix64F.numRows;
        this.T = denseMatrix64F;
        this.t = this.T.data;
        if (this.lower) {
            return this.decomposeLower();
        }
        return this.decomposeUpper();
    }

    @Override
    public boolean inputModified() {
        return true;
    }

    protected abstract boolean decomposeLower();

    protected abstract boolean decomposeUpper();

    @Override
    public DenseMatrix64F getT(DenseMatrix64F denseMatrix64F) {
        if (denseMatrix64F == null) {
            denseMatrix64F = new DenseMatrix64F(this.n, this.n);
        } else {
            if (denseMatrix64F.numRows != this.n || denseMatrix64F.numCols != this.n) {
                throw new IllegalArgumentException("Unexpected matrix dimension for T.");
            }
            CommonOps.set(denseMatrix64F, 0.0);
        }
        if (this.lower) {
            for (int i = 0; i < this.n; ++i) {
                for (int j = 0; j <= i; ++j) {
                    denseMatrix64F.unsafe_set(i, j, this.T.unsafe_get(i, j));
                }
            }
        } else {
            for (int i = 0; i < this.n; ++i) {
                for (int j = i; j < this.n; ++j) {
                    denseMatrix64F.unsafe_set(i, j, this.T.unsafe_get(i, j));
                }
            }
        }
        return denseMatrix64F;
    }

    public DenseMatrix64F getT() {
        return this.T;
    }

    public double[] _getVV() {
        return this.vv;
    }
}

