/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.data;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.ejml.data.Matrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.ops.CommonOps;
import org.ejml.ops.MatrixIO;

public class DenseMatrix64F
extends RowD1Matrix64F {
    public DenseMatrix64F(int n, int n2, boolean bl, double ... dArray) {
        int n3 = n * n2;
        this.data = new double[n3];
        this.numRows = n;
        this.numCols = n2;
        this.set(n, n2, bl, dArray);
    }

    public DenseMatrix64F(double[][] dArray) {
        this.numRows = dArray.length;
        this.numCols = dArray[0].length;
        this.data = new double[this.numRows * this.numCols];
        int n = 0;
        for (int i = 0; i < this.numRows; ++i) {
            double[] dArray2 = dArray[i];
            if (dArray2.length != this.numCols) {
                throw new IllegalArgumentException("All rows must have the same length");
            }
            System.arraycopy(dArray2, 0, this.data, n, this.numCols);
            n += this.numCols;
        }
    }

    public DenseMatrix64F(int n, int n2) {
        this.data = new double[n * n2];
        this.numRows = n;
        this.numCols = n2;
    }

    public DenseMatrix64F(DenseMatrix64F denseMatrix64F) {
        this(denseMatrix64F.numRows, denseMatrix64F.numCols);
        System.arraycopy(denseMatrix64F.data, 0, this.data, 0, denseMatrix64F.getNumElements());
    }

    public DenseMatrix64F(int n) {
        this.data = new double[n];
    }

    public DenseMatrix64F() {
    }

    public DenseMatrix64F(Matrix64F matrix64F) {
        this(matrix64F.numRows, matrix64F.numCols);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                this.set(i, j, matrix64F.get(i, j));
            }
        }
    }

    public static DenseMatrix64F wrap(int n, int n2, double[] dArray) {
        DenseMatrix64F denseMatrix64F = new DenseMatrix64F();
        denseMatrix64F.data = dArray;
        denseMatrix64F.numRows = n;
        denseMatrix64F.numCols = n2;
        return denseMatrix64F;
    }

    @Override
    public void reshape(int n, int n2, boolean bl) {
        if (this.data.length < n * n2) {
            double[] dArray = new double[n * n2];
            if (bl) {
                System.arraycopy(this.data, 0, dArray, 0, this.getNumElements());
            }
            this.data = dArray;
        }
        this.numRows = n;
        this.numCols = n2;
    }

    public void reshape(int n) {
        if (this.data.length < n) {
            this.data = new double[n];
        }
    }

    @Override
    public void set(int n, int n2, double d) {
        if (n2 < 0 || n2 >= this.numCols || n < 0 || n >= this.numRows) {
            throw new IllegalArgumentException("Specified element is out of bounds: (" + n + " , " + n2 + ")");
        }
        this.data[n * this.numCols + n2] = d;
    }

    @Override
    public void unsafe_set(int n, int n2, double d) {
        this.data[n * this.numCols + n2] = d;
    }

    public void add(int n, int n2, double d) {
        if (n2 < 0 || n2 >= this.numCols || n < 0 || n >= this.numRows) {
            throw new IllegalArgumentException("Specified element is out of bounds");
        }
        int n3 = n * this.numCols + n2;
        this.data[n3] = this.data[n3] + d;
    }

    @Override
    public double get(int n, int n2) {
        if (n2 < 0 || n2 >= this.numCols || n < 0 || n >= this.numRows) {
            throw new IllegalArgumentException("Specified element is out of bounds: " + n + " " + n2);
        }
        return this.data[n * this.numCols + n2];
    }

    @Override
    public double unsafe_get(int n, int n2) {
        return this.data[n * this.numCols + n2];
    }

    @Override
    public int getIndex(int n, int n2) {
        return n * this.numCols + n2;
    }

    public boolean isInBounds(int n, int n2) {
        return n2 >= 0 && n2 < this.numCols && n >= 0 && n < this.numRows;
    }

    @Override
    public int getNumElements() {
        return this.numRows * this.numCols;
    }

    public void setReshape(DenseMatrix64F denseMatrix64F) {
        int n = denseMatrix64F.getNumElements();
        if (this.data.length < n) {
            this.data = new double[n];
        }
        this.numRows = denseMatrix64F.numRows;
        this.numCols = denseMatrix64F.numCols;
        System.arraycopy(denseMatrix64F.data, 0, this.data, 0, n);
    }

    public void set(int n, int n2, boolean bl, double ... dArray) {
        int n3 = n * n2;
        if (n != this.numRows || n2 != this.numCols) {
            throw new IllegalArgumentException("Unexpected matrix shape.");
        }
        if (n3 > this.data.length) {
            throw new IllegalArgumentException("The length of this matrix's data array is too small.");
        }
        if (bl) {
            System.arraycopy(dArray, 0, this.data, 0, n3);
        } else {
            int n4 = 0;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    this.data[n4++] = dArray[j * n + i];
                }
            }
        }
    }

    public void zero() {
        CommonOps.set(this, 0.0);
    }

    public DenseMatrix64F copy() {
        return new DenseMatrix64F(this);
    }

    @Override
    public void print() {
        MatrixIO.print(System.out, this);
    }

    public void print(String string) {
        MatrixIO.print(System.out, this, string);
    }

    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        MatrixIO.print(new PrintStream(byteArrayOutputStream), this);
        return byteArrayOutputStream.toString();
    }
}

