/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.utils;

import mcib3d.utils.ArrayUtil;

public class CDFTools {
    public static ArrayUtil cdf(ArrayUtil x) {
        int n = x.getSize();
        ArrayUtil y = new ArrayUtil(n);
        for (int i = 0; i < n; ++i) {
            y.putValue(i, (double)(i + 1) / (double)n);
        }
        return y;
    }

    public static ArrayUtil cdf(ArrayUtil x, ArrayUtil xEvals) {
        int n = x.getSize();
        int numEvals = xEvals.getSize();
        ArrayUtil y = new ArrayUtil(numEvals);
        int p = 0;
        for (int i = 0; i < n; ++i) {
            while (p < numEvals && xEvals.getValue(p) < x.getValue(i)) {
                y.putValue(p++, (double)i / (double)n);
            }
        }
        while (p < numEvals) {
            y.putValue(p++, 1.0);
        }
        return y;
    }

    public static ArrayUtil cdfAverage(ArrayUtil[] x) {
        int n = x.length;
        int total_size = 0;
        for (ArrayUtil aX : x) {
            total_size += aX.getSize();
        }
        ArrayUtil xEvals = new ArrayUtil(total_size);
        total_size = 0;
        for (ArrayUtil aX : x) {
            xEvals.insertValues(total_size, aX);
            total_size += aX.getSize();
        }
        return CDFTools.cdfAverage(x, xEvals);
    }

    public static ArrayUtil cdfAverage(ArrayUtil[] x, ArrayUtil xEvals) {
        int n = x.length;
        int numEvals = xEvals.getSize();
        ArrayUtil y = new ArrayUtil(numEvals);
        for (ArrayUtil aX : x) {
            y.addValueArray(CDFTools.cdf(aX, xEvals));
        }
        y.divideAll(n);
        return y;
    }

    public static ArrayUtil cdfPercentage(ArrayUtil[] x, ArrayUtil xEvals, double pc) {
        int n = x.length;
        int numEvals = xEvals.getSize();
        ArrayUtil y = new ArrayUtil(numEvals);
        ArrayUtil[] xCDF = new ArrayUtil[n];
        for (int i = 0; i < n; ++i) {
            xCDF[i] = CDFTools.cdf(x[i], xEvals);
        }
        for (int i = 0; i < numEvals; ++i) {
            ArrayUtil tmp = new ArrayUtil(n);
            for (int j = 0; j < n; ++j) {
                tmp.addValue(j, xCDF[j].getValue(i));
            }
            tmp.sort();
            y.addValue(i, tmp.getValue((int)Math.round(pc * (double)(n - 1))));
        }
        return y;
    }

    public static ArrayUtil[] cdfPercentage2(ArrayUtil[] x, ArrayUtil xEvals, double pc) {
        int n = x.length;
        int numEvals = xEvals.getSize();
        ArrayUtil y1 = new ArrayUtil(numEvals);
        ArrayUtil y2 = new ArrayUtil(numEvals);
        ArrayUtil[] xCDF = new ArrayUtil[n];
        for (int i = 0; i < n; ++i) {
            xCDF[i] = CDFTools.cdf(x[i], xEvals);
        }
        for (int i = 0; i < numEvals; ++i) {
            ArrayUtil tmp = new ArrayUtil(n);
            for (int j = 0; j < n; ++j) {
                tmp.addValue(j, xCDF[j].getValue(i));
            }
            tmp.sort();
            y1.addValue(i, tmp.getValue((int)Math.round(pc * (double)(n - 1))));
            y2.addValue(i, tmp.getValue((int)Math.round((1.0 - pc) * (double)(n - 1))));
        }
        return new ArrayUtil[]{y1, y2};
    }

    public static double[] cdfDifferences(ArrayUtil x1, ArrayUtil y1, ArrayUtil x2, ArrayUtil y2) {
        int n = x1.getSize();
        int m = x2.getSize();
        int i = 0;
        int j = 0;
        double[] maxDiffAbove = new double[2];
        double[] maxDiffBelow = new double[2];
        double v1 = 0.0;
        double v2 = 0.0;
        while (i < n && j < m) {
            int iprev = i;
            int jprev = j;
            if (x1.getValue(i) < x2.getValue(j)) {
                v1 = y1.getValue(i++);
            } else if (x2.getValue(j) < x1.getValue(i)) {
                v2 = y2.getValue(j++);
            } else {
                v1 = y1.getValue(i++);
                v2 = y2.getValue(j++);
            }
            double diff = v1 - v2;
            if (diff > 0.0 && diff > maxDiffAbove[1]) {
                maxDiffAbove[0] = 0.5 * (x1.getValue(iprev) + x2.getValue(jprev));
                maxDiffAbove[1] = diff;
            }
            if (!(diff < 0.0) || !(diff < maxDiffBelow[1])) continue;
            maxDiffBelow[0] = 0.5 * (x1.getValue(iprev) + x2.getValue(jprev));
            maxDiffBelow[1] = diff;
        }
        double[] maxDiff = maxDiffAbove[1] >= Math.abs(maxDiffBelow[1]) ? maxDiffAbove : maxDiffBelow;
        return maxDiff;
    }

    public static int rank(ArrayUtil x, ArrayUtil[] samples, ArrayUtil averageCDF, ArrayUtil xEvals) {
        int numSamples = samples.length;
        ArrayUtil maxDifferences = new ArrayUtil(1 + numSamples);
        double[] maxDiffBuffer = CDFTools.cdfDifferences(x, CDFTools.cdf(x), xEvals, averageCDF);
        double xMaxDiff = maxDiffBuffer[1];
        maxDifferences.putValue(0, xMaxDiff);
        for (int i = 0; i < numSamples; ++i) {
            maxDiffBuffer = CDFTools.cdfDifferences(samples[i], CDFTools.cdf(samples[i]), xEvals, averageCDF);
            maxDifferences.putValue(i + 1, maxDiffBuffer[1]);
        }
        maxDifferences.sort();
        return maxDifferences.indexOf(xMaxDiff);
    }

    public static double SDI(ArrayUtil x, ArrayUtil[] samples, ArrayUtil averageCDF, ArrayUtil xEvals) {
        int numSamples = samples.length;
        int rank = CDFTools.rank(x, samples, averageCDF, xEvals);
        return 1.0 - (double)rank / (double)numSamples;
    }

    public static ArrayUtil resampleCdf(ArrayUtil cdf, ArrayUtil xEvals, ArrayUtil newXEvals) {
        double[] cdfIn = cdf.getArray();
        double[] x = xEvals.getArray();
        double[] newX = newXEvals.getArray();
        double[] cdfOut = new double[newX.length];
        int start = 0;
        int p = 0;
        while (x[0] > newX[start]) {
            ++start;
        }
        cdfOut[start] = cdfIn[0];
        int lim = x.length - 1;
        for (int i = start + 1; i < newX.length; ++i) {
            while (p < lim && x[p + 1] <= newX[i]) {
                ++p;
            }
            cdfOut[i] = cdfIn[p];
        }
        return new ArrayUtil(cdfOut);
    }
}

