/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.AlternateAppearanceRetained;
import javax.media.j3d.Appearance;
import javax.media.j3d.AppearanceRetained;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroupRetained;
import javax.media.j3d.CompileState;
import javax.media.j3d.FogRetained;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.GeometryStripArrayRetained;
import javax.media.j3d.GeometryUpdater;
import javax.media.j3d.HashKey;
import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.IndexedGeometryArrayRetained;
import javax.media.j3d.IndexedGeometryStripArrayRetained;
import javax.media.j3d.IndexedLineArray;
import javax.media.j3d.IndexedLineStripArray;
import javax.media.j3d.IndexedLineStripArrayRetained;
import javax.media.j3d.IndexedPointArray;
import javax.media.j3d.IndexedQuadArray;
import javax.media.j3d.IndexedTriangleArray;
import javax.media.j3d.IndexedTriangleFanArray;
import javax.media.j3d.IndexedTriangleFanArrayRetained;
import javax.media.j3d.IndexedTriangleStripArray;
import javax.media.j3d.IndexedTriangleStripArrayRetained;
import javax.media.j3d.J3dDebug;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.LightRetained;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.LineStripArrayRetained;
import javax.media.j3d.ModelClipRetained;
import javax.media.j3d.Morph;
import javax.media.j3d.PickInfo;
import javax.media.j3d.PickShape;
import javax.media.j3d.PointArray;
import javax.media.j3d.QuadArray;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.SwitchRetained;
import javax.media.j3d.SwitchState;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleFanArray;
import javax.media.j3d.TriangleFanArrayRetained;
import javax.media.j3d.TriangleStripArray;
import javax.media.j3d.TriangleStripArrayRetained;
import javax.media.j3d.UnorderList;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Color3b;
import javax.vecmath.Color3f;
import javax.vecmath.Color4b;
import javax.vecmath.Color4f;
import javax.vecmath.Point3d;
import javax.vecmath.TexCoord3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3f;

class MorphRetained
extends LeafRetained
implements GeometryUpdater {
    static final int GEOMETRY_CHANGED = 1;
    static final int APPEARANCE_CHANGED = 2;
    static final int COLLISION_CHANGED = 4;
    static final int BOUNDS_CHANGED = 8;
    static final int APPEARANCEOVERRIDE_CHANGED = 16;
    static final int UPDATE_MORPH = 32;
    private static final double TOLERANCE = 1.0E-4;
    ArrayList mirrorShape3D = new ArrayList();
    static final int targetThreads = 192;
    AppearanceRetained appearance = null;
    GeometryArrayRetained[] geometryArrays;
    private int numGeometryArrays = 0;
    double[] weights;
    BranchGroupRetained[] branchGroupPath;
    boolean isPickable = true;
    boolean isCollidable = true;
    SwitchRetained closestSwitchParent = null;
    int closestSwitchIndex = -1;
    boolean visible = true;
    Bounds bounds = null;
    BoundingBox vwcBounds = new BoundingBox();
    Bounds collisionBound = null;
    Bounds collisionVwcBound = null;
    GeometryArray morphedGeometryArray = null;
    float[] Mcoord = null;
    float[] Mcolor = null;
    float[] Mnormal = null;
    float[][] MtexCoord = null;
    boolean appearanceOverrideEnable = false;
    int changedFrequent = 0;

    MorphRetained() {
        this.nodeType = 10;
        this.localBounds = new BoundingBox();
        ((BoundingBox)this.localBounds).setLower(1.0, 1.0, 1.0);
        ((BoundingBox)this.localBounds).setUpper(-1.0, -1.0, -1.0);
    }

    void setCollisionBounds(Bounds bounds) {
        this.collisionBound = bounds != null ? (Bounds)bounds.clone() : null;
        if (this.source.isLive()) {
            J3dMessage j3dMessage = new J3dMessage();
            j3dMessage.type = 34;
            j3dMessage.threads = 8192;
            j3dMessage.universe = this.universe;
            j3dMessage.args[1] = this.collisionBound;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    void setBounds(Bounds bounds) {
        super.setBounds(bounds);
        if (this.source.isLive() && !this.boundsAutoCompute) {
            J3dMessage j3dMessage = new J3dMessage();
            j3dMessage.type = 35;
            j3dMessage.threads = 8384;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = Shape3DRetained.getGeomAtomsArray(this.mirrorShape3D);
            j3dMessage.args[1] = this.localBounds;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    Bounds getCollisionBounds() {
        return this.collisionBound == null ? null : (Bounds)this.collisionBound.clone();
    }

    void setGeometryArrays(GeometryArray[] geometryArrayArray) {
        GeometryArrayRetained geometryArrayRetained;
        int n;
        if ((geometryArrayArray == null || geometryArrayArray.length == 0) && this.numGeometryArrays == 0) {
            return;
        }
        if (this.numGeometryArrays != 0 && (geometryArrayArray == null || this.numGeometryArrays != geometryArrayArray.length)) {
            throw new IllegalArgumentException(J3dI18N.getString("MorphRetained0"));
        }
        for (n = 1; n < geometryArrayArray.length; ++n) {
            if (geometryArrayArray[n] == null || geometryArrayArray[n - 1] == null) {
                throw new IllegalArgumentException(J3dI18N.getString("MorphRetained1"));
            }
            geometryArrayRetained = (GeometryArrayRetained)geometryArrayArray[n].retained;
            GeometryArrayRetained geometryArrayRetained2 = (GeometryArrayRetained)geometryArrayArray[n - 1].retained;
            if (geometryArrayRetained2 == null || geometryArrayRetained == null) {
                throw new IllegalArgumentException(J3dI18N.getString("MorphRetained1"));
            }
            this.doErrorCheck(geometryArrayRetained2, geometryArrayRetained);
        }
        geometryArrayRetained = (GeometryArrayRetained)geometryArrayArray[0].retained;
        if ((geometryArrayRetained.vertexFormat & 0x1000) != 0) {
            throw new UnsupportedOperationException(J3dI18N.getString("MorphRetained9"));
        }
        if (geometryArrayArray[0] != null) {
            geometryArrayRetained = (GeometryArrayRetained)geometryArrayArray[0].retained;
        }
        if (this.numGeometryArrays == 0) {
            this.geometryArrays = new GeometryArrayRetained[geometryArrayArray.length];
            this.numGeometryArrays = geometryArrayArray.length;
        }
        for (n = 0; n < this.numGeometryArrays; ++n) {
            geometryArrayRetained = (GeometryArrayRetained)geometryArrayArray[n].retained;
            if (((Morph)this.source).isLive()) {
                if (this.geometryArrays[n] != null) {
                    this.geometryArrays[n].clearLive(this.refCount);
                    this.geometryArrays[n].removeMorphUser(this);
                }
                if (geometryArrayRetained != null) {
                    geometryArrayRetained.setLive(this.inBackgroundGroup, this.refCount);
                    geometryArrayRetained.addMorphUser(this);
                }
            }
            this.geometryArrays[n] = geometryArrayRetained;
        }
        if (this.geometryArrays[0] == null) {
            return;
        }
        if (this.weights == null) {
            int n2;
            this.weights = new double[this.numGeometryArrays];
            this.weights[0] = 1.0;
            int n3 = this.geometryArrays[0].vertexFormat;
            int n4 = this.geometryArrays[0].getTexCoordSetCount();
            if (this.geometryArrays[0] instanceof IndexedGeometryArrayRetained) {
                this.Mcoord = new float[this.geometryArrays[0].getNumCoordCount() * 3];
                if ((n3 & 0xC) == 4) {
                    this.Mcolor = new float[this.geometryArrays[0].getNumColorCount() * 3];
                } else if ((n3 & 0xC) == 12) {
                    this.Mcolor = new float[this.geometryArrays[0].getNumColorCount() * 4];
                }
                this.MtexCoord = new float[n4][];
                if ((n3 & 2) != 0) {
                    this.Mnormal = new float[this.geometryArrays[0].getNumNormalCount() * 3];
                }
                for (n2 = 0; n2 < n4; ++n2) {
                    if ((n3 & 0x20) != 0) {
                        this.MtexCoord[n2] = new float[this.geometryArrays[0].getNumTexCoordCount(n2) * 2];
                        continue;
                    }
                    if ((n3 & 0x40) != 0) {
                        this.MtexCoord[n2] = new float[this.geometryArrays[0].getNumTexCoordCount(n2) * 3];
                        continue;
                    }
                    if ((n3 & 0x400) == 0) continue;
                    this.MtexCoord[n2] = new float[this.geometryArrays[0].getNumTexCoordCount(n2) * 4];
                }
            } else {
                this.Mcoord = new float[this.geometryArrays[0].validVertexCount * 3];
                if ((n3 & 0xC) == 4) {
                    this.Mcolor = new float[this.geometryArrays[0].validVertexCount * 3];
                } else if ((n3 & 0xC) == 12) {
                    this.Mcolor = new float[this.geometryArrays[0].validVertexCount * 4];
                }
                this.MtexCoord = new float[n4][];
                if ((n3 & 2) != 0) {
                    this.Mnormal = new float[this.geometryArrays[0].validVertexCount * 3];
                }
                for (n2 = 0; n2 < n4; ++n2) {
                    if ((n3 & 0x20) != 0) {
                        this.MtexCoord[n2] = new float[this.geometryArrays[0].validVertexCount * 2];
                        continue;
                    }
                    if ((n3 & 0x40) != 0) {
                        this.MtexCoord[n2] = new float[this.geometryArrays[0].validVertexCount * 3];
                        continue;
                    }
                    if ((n3 & 0x400) == 0) continue;
                    this.MtexCoord[n2] = new float[this.geometryArrays[0].validVertexCount * 4];
                }
            }
        }
        this.initMorphedGeometry();
        if (this.source.isLive()) {
            Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(0);
            shape3DRetained.setMorphGeometry(this.morphedGeometryArray, this.mirrorShape3D);
            J3dMessage j3dMessage = null;
            j3dMessage = new J3dMessage();
            j3dMessage.type = 16;
            j3dMessage.threads = 8256;
            if (this.geometryArrays[0] instanceof IndexedGeometryArrayRetained) {
                j3dMessage.threads |= 0x400;
            }
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(1);
            j3dMessage.args[3] = Shape3DRetained.getGeomAtomsArray(this.mirrorShape3D);
            j3dMessage.universe = this.universe;
            VirtualUniverse.mc.processMessage(j3dMessage);
            if (this.boundsAutoCompute) {
                GeometryArrayRetained geometryArrayRetained3 = (GeometryArrayRetained)this.morphedGeometryArray.retained;
                geometryArrayRetained3.incrComputeGeoBounds();
                geometryArrayRetained3.decrComputeGeoBounds();
            }
        }
    }

    GeometryArray getGeometryArray(int n) {
        return (GeometryArray)this.geometryArrays[n].source;
    }

    void setAppearance(Appearance appearance) {
        boolean bl = false;
        if (((Morph)this.source).isLive()) {
            int n;
            if (this.appearance != null) {
                this.appearance.clearLive(this.refCount);
                for (n = this.mirrorShape3D.size() - 1; n >= 0; --n) {
                    this.appearance.removeAMirrorUser((Shape3DRetained)this.mirrorShape3D.get(n));
                }
            }
            if (appearance != null) {
                ((AppearanceRetained)appearance.retained).setLive(this.inBackgroundGroup, this.refCount);
                this.appearance = (AppearanceRetained)appearance.retained;
                n = this.mirrorShape3D.size();
                for (int i = 0; i < n; ++i) {
                    this.appearance.addAMirrorUser((Shape3DRetained)this.mirrorShape3D.get(i));
                }
                if (this.appearance.renderingAttributes != null && this.visible != this.appearance.renderingAttributes.visible) {
                    this.visible = this.appearance.renderingAttributes.visible;
                    bl = true;
                }
            } else if (!this.visible) {
                this.visible = true;
                bl = true;
            }
            n = 0;
            n = bl ? 2 : 1;
            J3dMessage[] j3dMessageArray = new J3dMessage[n];
            j3dMessageArray[0] = new J3dMessage();
            j3dMessageArray[0].threads = 4224;
            j3dMessageArray[0].type = 16;
            j3dMessageArray[0].universe = this.universe;
            j3dMessageArray[0].args[0] = this;
            j3dMessageArray[0].args[1] = new Integer(2);
            Shape3DRetained[] shape3DRetainedArray = new Shape3DRetained[this.mirrorShape3D.size()];
            this.mirrorShape3D.toArray(shape3DRetainedArray);
            j3dMessageArray[0].args[2] = shape3DRetainedArray;
            Object[] objectArray = new Object[]{appearance == null ? null : this.appearance.mirror, new Integer(this.changedFrequent)};
            j3dMessageArray[0].args[3] = objectArray;
            j3dMessageArray[0].args[4] = Shape3DRetained.getGeomAtomsArray(this.mirrorShape3D);
            if (bl) {
                j3dMessageArray[1] = new J3dMessage();
                j3dMessageArray[1].threads = 64;
                j3dMessageArray[1].type = 24;
                j3dMessageArray[1].universe = this.universe;
                j3dMessageArray[1].args[0] = this;
                j3dMessageArray[1].args[1] = new Integer(2);
                j3dMessageArray[1].args[2] = this.visible ? Boolean.TRUE : Boolean.FALSE;
                j3dMessageArray[1].args[3] = j3dMessageArray[0].args[4];
            }
            VirtualUniverse.mc.processMessage(j3dMessageArray);
        } else {
            this.appearance = appearance == null ? null : (AppearanceRetained)appearance.retained;
        }
    }

    Appearance getAppearance() {
        return this.appearance == null ? null : (Appearance)this.appearance.source;
    }

    void setAppearanceOverrideEnable(boolean bl) {
        if (((Morph)this.source).isLive()) {
            J3dMessage j3dMessage = new J3dMessage();
            j3dMessage.threads = 4224;
            j3dMessage.type = 16;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(16);
            Shape3DRetained[] shape3DRetainedArray = new Shape3DRetained[this.mirrorShape3D.size()];
            this.mirrorShape3D.toArray(shape3DRetainedArray);
            j3dMessage.args[2] = shape3DRetainedArray;
            Object[] objectArray = new Object[]{bl ? Boolean.TRUE : Boolean.FALSE, new Integer(this.changedFrequent)};
            j3dMessage.args[3] = objectArray;
            j3dMessage.args[4] = Shape3DRetained.getGeomAtomsArray(this.mirrorShape3D);
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
        this.appearanceOverrideEnable = bl;
    }

    boolean getAppearanceOverrideEnable() {
        return this.appearanceOverrideEnable;
    }

    boolean intersect(PickInfo pickInfo, PickShape pickShape, int n) {
        Transform3D transform3D = pickInfo.getLocalToVWorldRef();
        Transform3D transform3D2 = new Transform3D();
        transform3D2.invert(transform3D);
        PickShape pickShape2 = pickShape.transform(transform3D2);
        GeometryRetained geometryRetained = (GeometryRetained)this.morphedGeometryArray.retained;
        if (geometryRetained.mirrorGeometry != null) {
            geometryRetained = geometryRetained.mirrorGeometry;
        }
        if ((n & 8) == 0 && (n & 0x10) == 0 && (n & 0x20) == 0 && (n & 0x40) == 0) {
            return geometryRetained.intersect(pickShape2, null, 0, null, null, 0);
        }
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        Point3d point3d3 = new Point3d();
        if (geometryRetained.intersect(pickShape2, pickInfo, n, point3d2, geometryRetained, 0)) {
            point3d3.set((Tuple3d)point3d2);
            transform3D.transform(point3d3);
            double d = pickShape.distance(point3d3);
            if ((n & 0x10) != 0) {
                pickInfo.setClosestDistance(d);
            }
            if ((n & 8) != 0) {
                pickInfo.setClosestIntersectionPoint(point3d2);
            }
            return true;
        }
        return false;
    }

    boolean intersect(SceneGraphPath sceneGraphPath, PickShape pickShape, double[] dArray) {
        PickInfo pickInfo = new PickInfo();
        Transform3D transform3D = sceneGraphPath.getTransform();
        if (transform3D == null) {
            throw new RuntimeException(J3dI18N.getString("MorphRetained5"));
        }
        pickInfo.setLocalToVWorldRef(transform3D);
        if (dArray == null) {
            return this.intersect(pickInfo, pickShape, 0);
        }
        int n = 16;
        if (this.intersect(pickInfo, pickShape, n)) {
            dArray[0] = pickInfo.getClosestDistance();
            return true;
        }
        return false;
    }

    void setWeights(double[] dArray) {
        int n;
        double d = 0.0;
        if (dArray.length != this.numGeometryArrays) {
            throw new IllegalArgumentException(J3dI18N.getString("MorphRetained7"));
        }
        for (n = dArray.length - 1; n >= 0; --n) {
            d += dArray[n];
        }
        if (Math.abs(d - 1.0) > 1.0E-4) {
            throw new IllegalArgumentException(J3dI18N.getString("MorphRetained8"));
        }
        for (n = this.numGeometryArrays - 1; n >= 0; --n) {
            this.weights[n] = dArray[n];
        }
        if (this.source.isLive()) {
            ((GeometryArrayRetained)this.morphedGeometryArray.retained).updateData(this);
            J3dMessage j3dMessage = null;
            j3dMessage = new J3dMessage();
            j3dMessage.type = 16;
            j3dMessage.threads = 8256;
            if (this.geometryArrays[0] instanceof IndexedGeometryArrayRetained) {
                j3dMessage.threads |= 0x400;
            }
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(1);
            j3dMessage.args[3] = Shape3DRetained.getGeomAtomsArray(this.mirrorShape3D);
            j3dMessage.universe = this.universe;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    double[] getWeights() {
        return (double[])this.weights.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bounds getBounds() {
        if (this.boundsAutoCompute) {
            GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)this.morphedGeometryArray.retained;
            if (geometryArrayRetained != null) {
                BoundingBox boundingBox = geometryArrayRetained.geoBounds;
                synchronized (boundingBox) {
                    return (Bounds)geometryArrayRetained.geoBounds.clone();
                }
            }
            return null;
        }
        return super.getBounds();
    }

    Bounds getEffectiveBounds() {
        if (this.boundsAutoCompute) {
            return this.getBounds();
        }
        return super.getEffectiveBounds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeCombineBounds(Bounds bounds) {
        if (this.boundsAutoCompute) {
            GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)this.morphedGeometryArray.retained;
            if (geometryArrayRetained != null) {
                BoundingBox boundingBox = geometryArrayRetained.geoBounds;
                synchronized (boundingBox) {
                    bounds.combine(geometryArrayRetained.geoBounds);
                }
            }
        } else {
            Bounds bounds2 = this.localBounds;
            synchronized (bounds2) {
                bounds.combine(this.localBounds);
            }
        }
    }

    int getNumGeometryArrays() {
        return this.numGeometryArrays;
    }

    void updateMorphedGeometryArray(GeometryArrayRetained geometryArrayRetained, boolean bl) {
        if (this.numGeometryArrays > 0) {
            if (this.geometryArrays[0] != geometryArrayRetained) {
                this.doErrorCheck(geometryArrayRetained, this.geometryArrays[0]);
            } else if (this.numGeometryArrays > 1) {
                this.doErrorCheck(geometryArrayRetained, this.geometryArrays[1]);
            }
        }
        ((GeometryArrayRetained)this.morphedGeometryArray.retained).updateData(this);
        if (this.boundsAutoCompute && bl) {
            GeometryArrayRetained geometryArrayRetained2 = (GeometryArrayRetained)this.morphedGeometryArray.retained;
            geometryArrayRetained2.incrComputeGeoBounds();
            geometryArrayRetained2.decrComputeGeoBounds();
        }
    }

    public void updateData(Geometry geometry) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        boolean bl = false;
        boolean bl2 = false;
        int n8 = 0;
        float[] fArray = new float[3];
        float[] fArray2 = new float[4];
        float[] fArray3 = new float[3];
        float[] fArray4 = new float[3];
        int n9 = this.geometryArrays[0].vertexFormat;
        int n10 = this.geometryArrays[0].geoType;
        n8 = this.geometryArrays[0].getTexCoordSetCount();
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        boolean bl3 = false;
        int n14 = 0;
        n14 = this.geometryArrays[0] instanceof IndexedGeometryArrayRetained ? this.geometryArrays[0].getNumCoordCount() : this.geometryArrays[0].validVertexCount;
        for (n7 = 0; n7 < n14; ++n7) {
            int n15 = n11++;
            int n16 = n11++;
            this.Mcoord[n11++] = 0.0f;
            this.Mcoord[n16] = 0.0f;
            this.Mcoord[n15] = 0.0f;
        }
        if ((n9 & 4) != 0) {
            n14 = this.geometryArrays[0] instanceof IndexedGeometryArrayRetained ? this.geometryArrays[0].getNumColorCount() : this.geometryArrays[0].validVertexCount;
            for (n7 = 0; n7 < n14; ++n7) {
                if ((n9 & 0xC) == 4) {
                    int n17 = n13++;
                    int n18 = n13++;
                    this.Mcolor[n13++] = 0.0f;
                    this.Mcolor[n18] = 0.0f;
                    this.Mcolor[n17] = 0.0f;
                    continue;
                }
                if ((n9 & 0xC) != 12) continue;
                int n19 = n13++;
                int n20 = n13++;
                int n21 = n13++;
                this.Mcolor[n13++] = 0.0f;
                this.Mcolor[n21] = 0.0f;
                this.Mcolor[n20] = 0.0f;
                this.Mcolor[n19] = 0.0f;
            }
        }
        if ((n9 & 2) != 0) {
            n14 = this.geometryArrays[0] instanceof IndexedGeometryArrayRetained ? this.geometryArrays[0].getNumNormalCount() : this.geometryArrays[0].validVertexCount;
            for (n7 = 0; n7 < n14; ++n7) {
                int n22 = n12++;
                int n23 = n12++;
                this.Mnormal[n12++] = 0.0f;
                this.Mnormal[n23] = 0.0f;
                this.Mnormal[n22] = 0.0f;
            }
        }
        if ((n9 & 0x460) != 0) {
            for (n6 = 0; n6 < n8; ++n6) {
                n14 = this.geometryArrays[0] instanceof IndexedGeometryArrayRetained ? this.geometryArrays[0].getNumTexCoordCount(n6) : this.geometryArrays[0].validVertexCount;
                n5 = 0;
                for (n7 = 0; n7 < n14; ++n7) {
                    int n24 = n5++;
                    this.MtexCoord[n6][n5++] = 0.0f;
                    this.MtexCoord[n6][n24] = 0.0f;
                    if ((n9 & 0x40) != 0) {
                        this.MtexCoord[n6][n5++] = 0.0f;
                        continue;
                    }
                    if ((n9 & 0x400) == 0) continue;
                    this.MtexCoord[n6][n5++] = 0.0f;
                    this.MtexCoord[n6][n5++] = 0.0f;
                }
            }
        }
        if ((n9 & 0x80) == 0) {
            n14 = 0;
            for (n4 = 0; n4 < this.numGeometryArrays; ++n4) {
                double d = this.weights[n4];
                if (d == 0.0) continue;
                n11 = 0;
                n12 = 0;
                n13 = 0;
                n3 = 0;
                if (this.geometryArrays[n4] instanceof IndexedGeometryArrayRetained) {
                    n3 = 0;
                    n14 = this.geometryArrays[n4].getNumCoordCount();
                } else {
                    n3 = this.geometryArrays[n4].getInitialVertexIndex();
                    n14 = this.geometryArrays[n4].validVertexCount;
                }
                n2 = n3 + n14;
                for (n7 = n3; n7 < n2; ++n7) {
                    this.geometryArrays[n4].getCoordinate(n7, fArray);
                    int n25 = n11++;
                    this.Mcoord[n25] = (float)((double)this.Mcoord[n25] + (double)fArray[0] * d);
                    int n26 = n11++;
                    this.Mcoord[n26] = (float)((double)this.Mcoord[n26] + (double)fArray[1] * d);
                    int n27 = n11++;
                    this.Mcoord[n27] = (float)((double)this.Mcoord[n27] + (double)fArray[2] * d);
                }
                if ((n9 & 4) != 0) {
                    if (this.geometryArrays[n4] instanceof IndexedGeometryArrayRetained) {
                        n14 = this.geometryArrays[n4].getNumColorCount();
                    }
                    n2 = n3 + n14;
                    for (n7 = n3; n7 < n2; ++n7) {
                        this.geometryArrays[n4].getColor(n7, fArray2);
                        int n28 = n13++;
                        this.Mcolor[n28] = (float)((double)this.Mcolor[n28] + (double)fArray2[0] * d);
                        int n29 = n13++;
                        this.Mcolor[n29] = (float)((double)this.Mcolor[n29] + (double)fArray2[1] * d);
                        int n30 = n13++;
                        this.Mcolor[n30] = (float)((double)this.Mcolor[n30] + (double)fArray2[2] * d);
                        if ((n9 & 8) == 0) continue;
                        int n31 = n13++;
                        this.Mcolor[n31] = (float)((double)this.Mcolor[n31] + (double)fArray2[3] * d);
                    }
                }
                if ((n9 & 2) != 0) {
                    if (this.geometryArrays[n4] instanceof IndexedGeometryArrayRetained) {
                        n14 = this.geometryArrays[n4].getNumNormalCount();
                    }
                    n2 = n3 + n14;
                    for (n7 = n3; n7 < n2; ++n7) {
                        this.geometryArrays[n4].getNormal(n7, fArray3);
                        int n32 = n12++;
                        this.Mnormal[n32] = (float)((double)this.Mnormal[n32] + (double)fArray3[0] * d);
                        int n33 = n12++;
                        this.Mnormal[n33] = (float)((double)this.Mnormal[n33] + (double)fArray3[1] * d);
                        int n34 = n12++;
                        this.Mnormal[n34] = (float)((double)this.Mnormal[n34] + (double)fArray3[2] * d);
                    }
                }
                if ((n9 & 0x460) == 0) continue;
                for (n6 = 0; n6 < n8; ++n6) {
                    n = 0;
                    if (this.geometryArrays[n4] instanceof IndexedGeometryArrayRetained) {
                        n14 = this.geometryArrays[n4].getNumTexCoordCount(n7);
                    }
                    n2 = n3 + n14;
                    for (n7 = n3; n7 < n2; ++n7) {
                        this.geometryArrays[n4].getTextureCoordinate(n6, n7, fArray4);
                        float[] fArray5 = this.MtexCoord[n6];
                        int n35 = n++;
                        fArray5[n35] = (float)((double)fArray5[n35] + (double)fArray4[0] * d);
                        float[] fArray6 = this.MtexCoord[n6];
                        int n36 = n++;
                        fArray6[n36] = (float)((double)fArray6[n36] + (double)fArray4[1] * d);
                        if ((n9 & 0x40) != 0) {
                            float[] fArray7 = this.MtexCoord[n6];
                            int n37 = n++;
                            fArray7[n37] = (float)((double)fArray7[n37] + (double)fArray4[2] * d);
                            continue;
                        }
                        if ((n9 & 0x400) == 0) continue;
                        float[] fArray8 = this.MtexCoord[n6];
                        int n38 = n++;
                        fArray8[n38] = (float)((double)fArray8[n38] + (double)fArray4[2] * d);
                        float[] fArray9 = this.MtexCoord[n6];
                        int n39 = n++;
                        fArray9[n39] = (float)((double)fArray9[n39] + (double)fArray4[3] * d);
                    }
                }
            }
        } else {
            int n40;
            n = 0;
            int n41 = 0;
            if ((n9 & 0x460) != 0) {
                n = (n9 & 0x20) != 0 ? 2 : ((n9 & 0x40) != 0 ? 3 : 4);
            }
            if ((n9 & 4) != 0) {
                n41 = 3;
                if ((n9 & 8) != 0) {
                    n41 = 4;
                }
            }
            if ((n9 & 0x100) != 0) {
                int n42 = this.geometryArrays[0].stride();
                int n43 = this.geometryArrays[0].colorOffset();
                int n44 = this.geometryArrays[0].normalOffset();
                int n45 = this.geometryArrays[0].coordinateOffset();
                int n46 = 0;
                boolean bl4 = false;
                for (n4 = 0; n4 < this.numGeometryArrays; ++n4) {
                    double d = this.weights[n4];
                    if (d == 0.0) continue;
                    n11 = 0;
                    n12 = 0;
                    n13 = 0;
                    bl3 = false;
                    float[] fArray10 = this.geometryArrays[n4].getInterleavedVertices();
                    if ((n9 & 0x460) != 0) {
                        for (n6 = 0; n6 < n8; ++n6) {
                            if (this.geometryArrays[n4] instanceof IndexedGeometryArrayRetained) {
                                n40 = 0;
                                n14 = this.geometryArrays[n4].getNumCoordCount();
                            } else {
                                n40 = this.geometryArrays[n4].getInitialVertexIndex();
                                n14 = this.geometryArrays[n4].validVertexCount;
                            }
                            n46 = n40 * n42 + n6 * n;
                            int n47 = 0;
                            n7 = 0;
                            while (n7 < n14) {
                                float[] fArray11 = this.MtexCoord[n6];
                                int n48 = n47++;
                                fArray11[n48] = (float)((double)fArray11[n48] + (double)fArray10[n46] * d);
                                float[] fArray12 = this.MtexCoord[n6];
                                int n49 = n47++;
                                fArray12[n49] = (float)((double)fArray12[n49] + (double)fArray10[n46 + 1] * d);
                                if ((n9 & 0x40) != 0) {
                                    float[] fArray13 = this.MtexCoord[n6];
                                    int n50 = n47++;
                                    fArray13[n50] = (float)((double)fArray13[n50] + (double)fArray10[n46 + 2] * d);
                                } else if ((n9 & 0x400) != 0) {
                                    float[] fArray14 = this.MtexCoord[n6];
                                    int n51 = n47++;
                                    fArray14[n51] = (float)((double)fArray14[n51] + (double)fArray10[n46 + 2] * d);
                                    float[] fArray15 = this.MtexCoord[n6];
                                    int n52 = n47++;
                                    fArray15[n52] = (float)((double)fArray15[n52] + (double)fArray10[n46 + 3] * d);
                                }
                                ++n7;
                                n46 += n42;
                            }
                        }
                    }
                    if ((n9 & 4) != 0) {
                        if (this.geometryArrays[n4] instanceof IndexedGeometryArrayRetained) {
                            n3 = 0;
                            n14 = this.geometryArrays[n4].getNumCoordCount();
                        } else {
                            n3 = this.geometryArrays[n4].getInitialVertexIndex();
                            n14 = this.geometryArrays[n4].validVertexCount;
                        }
                        n46 = n3 * n42 + n43;
                        n7 = 0;
                        while (n7 < n14) {
                            int n53 = n13++;
                            this.Mcolor[n53] = (float)((double)this.Mcolor[n53] + (double)fArray10[n46] * d);
                            int n54 = n13++;
                            this.Mcolor[n54] = (float)((double)this.Mcolor[n54] + (double)fArray10[n46 + 1] * d);
                            int n55 = n13++;
                            this.Mcolor[n55] = (float)((double)this.Mcolor[n55] + (double)fArray10[n46 + 2] * d);
                            if ((n9 & 8) != 0) {
                                int n56 = n13++;
                                this.Mcolor[n56] = (float)((double)this.Mcolor[n56] + (double)fArray10[n46 + 3] * d);
                            }
                            ++n7;
                            n46 += n42;
                        }
                    }
                    if ((n9 & 2) != 0) {
                        if (this.geometryArrays[n4] instanceof IndexedGeometryArrayRetained) {
                            n2 = 0;
                            n14 = this.geometryArrays[n4].getNumCoordCount();
                        } else {
                            n2 = this.geometryArrays[n4].getInitialVertexIndex();
                            n14 = this.geometryArrays[n4].validVertexCount;
                        }
                        n46 = n2 * n42 + n44;
                        n7 = 0;
                        while (n7 < n14) {
                            int n57 = n12++;
                            this.Mnormal[n57] = (float)((double)this.Mnormal[n57] + (double)fArray10[n46] * d);
                            int n58 = n12++;
                            this.Mnormal[n58] = (float)((double)this.Mnormal[n58] + (double)fArray10[n46 + 1] * d);
                            int n59 = n12++;
                            this.Mnormal[n59] = (float)((double)this.Mnormal[n59] + (double)fArray10[n46 + 2] * d);
                            ++n7;
                            n46 += n42;
                        }
                    }
                    if (this.geometryArrays[n4] instanceof IndexedGeometryArrayRetained) {
                        n5 = 0;
                        n14 = this.geometryArrays[n4].getNumCoordCount();
                    } else {
                        n5 = this.geometryArrays[n4].getInitialVertexIndex();
                        n14 = this.geometryArrays[n4].validVertexCount;
                    }
                    n46 = n5 * n42 + n45;
                    n7 = 0;
                    while (n7 < n14) {
                        int n60 = n11++;
                        this.Mcoord[n60] = (float)((double)this.Mcoord[n60] + (double)fArray10[n46] * d);
                        int n61 = n11++;
                        this.Mcoord[n61] = (float)((double)this.Mcoord[n61] + (double)fArray10[n46 + 1] * d);
                        int n62 = n11++;
                        this.Mcoord[n62] = (float)((double)this.Mcoord[n62] + (double)fArray10[n46 + 2] * d);
                        ++n7;
                        n46 += n42;
                    }
                }
            } else {
                float f = 0.003921569f;
                block40: for (n4 = 0; n4 < this.numGeometryArrays; ++n4) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    double d = this.weights[n4];
                    if (d == 0.0) continue;
                    if ((n9 & 0x460) != 0) {
                        switch (this.geometryArrays[n4].vertexType & 0x7000) {
                            case 4096: {
                                for (n6 = 0; n6 < n8; ++n6) {
                                    float[] fArray16 = this.geometryArrays[n4].getTexCoordRefFloat(n6);
                                    if (this.geometryArrays[n4] instanceof IndexedGeometryArrayRetained) {
                                        n40 = 0;
                                        n14 = this.geometryArrays[n4].getNumTexCoordCount(n6);
                                    } else {
                                        n40 = this.geometryArrays[n4].getInitialTexCoordIndex(n6);
                                        n14 = this.geometryArrays[n4].validVertexCount;
                                    }
                                    n40 *= n;
                                    int n63 = 0;
                                    for (n7 = 0; n7 < n14; ++n7) {
                                        float[] fArray17 = this.MtexCoord[n6];
                                        int n64 = n63++;
                                        fArray17[n64] = (float)((double)fArray17[n64] + (double)fArray16[n40++] * d);
                                        float[] fArray18 = this.MtexCoord[n6];
                                        int n65 = n63++;
                                        fArray18[n65] = (float)((double)fArray18[n65] + (double)fArray16[n40++] * d);
                                        if ((n9 & 0x40) == 0) continue;
                                        float[] fArray19 = this.MtexCoord[n6];
                                        int n66 = n63++;
                                        fArray19[n66] = (float)((double)fArray19[n66] + (double)fArray16[n40++] * d);
                                    }
                                }
                                break;
                            }
                            case 8192: {
                                for (n6 = 0; n6 < n8; ++n6) {
                                    int n67 = 0;
                                    float[] fArray20 = this.geometryArrays[n4].getTexCoordRefFloat(n6);
                                    if (this.geometryArrays[n4] instanceof IndexedGeometryArrayRetained) {
                                        n40 = 0;
                                        n14 = this.geometryArrays[n4].getNumTexCoordCount(n6);
                                    } else {
                                        n40 = this.geometryArrays[n4].getInitialTexCoordIndex(n6);
                                        n14 = this.geometryArrays[n4].validVertexCount;
                                    }
                                    objectArray2 = this.geometryArrays[n4].getTexCoordRef2f(n6);
                                    n7 = 0;
                                    while (n7 < n14) {
                                        float[] fArray21 = this.MtexCoord[n6];
                                        int n68 = n67++;
                                        fArray21[n68] = (float)((double)fArray21[n68] + (double)objectArray2[n40].x * d);
                                        float[] fArray22 = this.MtexCoord[n6];
                                        int n69 = n67++;
                                        fArray22[n69] = (float)((double)fArray22[n69] + (double)objectArray2[n40].y * d);
                                        ++n7;
                                        ++n40;
                                    }
                                }
                                break;
                            }
                            case 16384: {
                                for (n6 = 0; n6 < n8; ++n6) {
                                    int n70 = 0;
                                    TexCoord3f[] texCoord3fArray = this.geometryArrays[n4].getTexCoordRef3f(n6);
                                    if (this.geometryArrays[n4] instanceof IndexedGeometryArrayRetained) {
                                        n40 = 0;
                                        n14 = this.geometryArrays[n4].getNumTexCoordCount(n6);
                                    } else {
                                        n40 = this.geometryArrays[n4].getInitialTexCoordIndex(n6);
                                        n14 = this.geometryArrays[n4].validVertexCount;
                                    }
                                    n7 = 0;
                                    while (n7 < n14) {
                                        float[] fArray23 = this.MtexCoord[n6];
                                        int n71 = n70++;
                                        fArray23[n71] = (float)((double)fArray23[n71] + (double)texCoord3fArray[n40].x * d);
                                        float[] fArray24 = this.MtexCoord[n6];
                                        int n72 = n70++;
                                        fArray24[n72] = (float)((double)fArray24[n72] + (double)texCoord3fArray[n40].y * d);
                                        float[] fArray25 = this.MtexCoord[n6];
                                        int n73 = n70++;
                                        fArray25[n73] = (float)((double)fArray25[n73] + (double)texCoord3fArray[n40].z * d);
                                        ++n7;
                                        ++n40;
                                    }
                                }
                                break;
                            }
                        }
                    }
                    if ((n9 & 4) != 0) {
                        double d2 = (double)f * d;
                        if (this.geometryArrays[n4] instanceof IndexedGeometryArrayRetained) {
                            n3 = 0;
                            n14 = this.geometryArrays[n4].getNumColorCount();
                        } else {
                            n3 = this.geometryArrays[n4].getInitialColorIndex();
                            n14 = this.geometryArrays[n4].validVertexCount;
                        }
                        switch (this.geometryArrays[n4].vertexType & 0x3F0) {
                            case 16: {
                                objectArray2 = this.geometryArrays[n4].getColorRefFloat();
                                n13 = 0;
                                n3 *= n41;
                                for (n7 = 0; n7 < n14; ++n7) {
                                    int n74 = n13++;
                                    this.Mcolor[n74] = (float)((double)this.Mcolor[n74] + (double)objectArray2[n3++] * d);
                                    int n75 = n13++;
                                    this.Mcolor[n75] = (float)((double)this.Mcolor[n75] + (double)objectArray2[n3++] * d);
                                    int n76 = n13++;
                                    this.Mcolor[n76] = (float)((double)this.Mcolor[n76] + (double)objectArray2[n3++] * d);
                                    if ((n9 & 8) == 0) continue;
                                    int n77 = n13++;
                                    this.Mcolor[n77] = (float)((double)this.Mcolor[n77] + (double)objectArray2[n3++] * d);
                                }
                                break;
                            }
                            case 32: {
                                objectArray = this.geometryArrays[n4].getColorRefByte();
                                n13 = 0;
                                n3 *= n41;
                                for (n7 = 0; n7 < n14; ++n7) {
                                    int n78 = n13++;
                                    this.Mcolor[n78] = (float)((double)this.Mcolor[n78] + (double)(objectArray[n3++] & 0xFF) * d2);
                                    int n79 = n13++;
                                    this.Mcolor[n79] = (float)((double)this.Mcolor[n79] + (double)(objectArray[n3++] & 0xFF) * d2);
                                    int n80 = n13++;
                                    this.Mcolor[n80] = (float)((double)this.Mcolor[n80] + (double)(objectArray[n3++] & 0xFF) * d2);
                                    if ((n9 & 8) == 0) continue;
                                    int n81 = n13++;
                                    this.Mcolor[n81] = (float)((double)this.Mcolor[n81] + (double)(objectArray[n3++] & 0xFF) * d2);
                                }
                                break;
                            }
                            case 64: {
                                Color3f[] color3fArray = this.geometryArrays[n4].getColorRef3f();
                                n13 = 0;
                                n7 = 0;
                                while (n7 < n14) {
                                    int n82 = n13++;
                                    this.Mcolor[n82] = (float)((double)this.Mcolor[n82] + (double)color3fArray[n3].x * d);
                                    int n83 = n13++;
                                    this.Mcolor[n83] = (float)((double)this.Mcolor[n83] + (double)color3fArray[n3].y * d);
                                    int n84 = n13++;
                                    this.Mcolor[n84] = (float)((double)this.Mcolor[n84] + (double)color3fArray[n3].z * d);
                                    ++n7;
                                    ++n3;
                                }
                                break;
                            }
                            case 128: {
                                Color4f[] color4fArray = this.geometryArrays[n4].getColorRef4f();
                                n13 = 0;
                                n7 = 0;
                                while (n7 < n14) {
                                    int n85 = n13++;
                                    this.Mcolor[n85] = (float)((double)this.Mcolor[n85] + (double)color4fArray[n3].x * d);
                                    int n86 = n13++;
                                    this.Mcolor[n86] = (float)((double)this.Mcolor[n86] + (double)color4fArray[n3].y * d);
                                    int n87 = n13++;
                                    this.Mcolor[n87] = (float)((double)this.Mcolor[n87] + (double)color4fArray[n3].z * d);
                                    int n88 = n13++;
                                    this.Mcolor[n88] = (float)((double)this.Mcolor[n88] + (double)color4fArray[n3].w * d);
                                    ++n7;
                                    ++n3;
                                }
                                break;
                            }
                            case 256: {
                                Color3b[] color3bArray = this.geometryArrays[n4].getColorRef3b();
                                n13 = 0;
                                n7 = 0;
                                while (n7 < n14) {
                                    int n89 = n13++;
                                    this.Mcolor[n89] = (float)((double)this.Mcolor[n89] + (double)(color3bArray[n3].x & 0xFF) * d2);
                                    int n90 = n13++;
                                    this.Mcolor[n90] = (float)((double)this.Mcolor[n90] + (double)(color3bArray[n3].y & 0xFF) * d2);
                                    int n91 = n13++;
                                    this.Mcolor[n91] = (float)((double)this.Mcolor[n91] + (double)(color3bArray[n3].z & 0xFF) * d2);
                                    ++n7;
                                    ++n3;
                                }
                                break;
                            }
                            case 512: {
                                Color4b[] color4bArray = this.geometryArrays[n4].getColorRef4b();
                                n13 = 0;
                                n7 = 0;
                                while (n7 < n14) {
                                    int n92 = n13++;
                                    this.Mcolor[n92] = (float)((double)this.Mcolor[n92] + (double)(color4bArray[n3].x & 0xFF) * d2);
                                    int n93 = n13++;
                                    this.Mcolor[n93] = (float)((double)this.Mcolor[n93] + (double)(color4bArray[n3].y & 0xFF) * d2);
                                    int n94 = n13++;
                                    this.Mcolor[n94] = (float)((double)this.Mcolor[n94] + (double)(color4bArray[n3].z & 0xFF) * d2);
                                    int n95 = n13++;
                                    this.Mcolor[n95] = (float)((double)this.Mcolor[n95] + (double)(color4bArray[n3].w & 0xFF) * d2);
                                    ++n7;
                                    ++n3;
                                }
                                break;
                            }
                        }
                    }
                    if ((n9 & 2) != 0) {
                        n12 = 0;
                        if (this.geometryArrays[n4] instanceof IndexedGeometryArrayRetained) {
                            n2 = 0;
                            n14 = this.geometryArrays[n4].getNumNormalCount();
                        } else {
                            n2 = this.geometryArrays[n4].getInitialNormalIndex();
                            n14 = this.geometryArrays[n4].validVertexCount;
                        }
                        switch (this.geometryArrays[n4].vertexType & 0xC00) {
                            case 1024: {
                                float[] fArray26 = this.geometryArrays[n4].getNormalRefFloat();
                                n2 *= 3;
                                for (n7 = 0; n7 < n14; ++n7) {
                                    int n96 = n12++;
                                    this.Mnormal[n96] = (float)((double)this.Mnormal[n96] + (double)fArray26[n2++] * d);
                                    int n97 = n12++;
                                    this.Mnormal[n97] = (float)((double)this.Mnormal[n97] + (double)fArray26[n2++] * d);
                                    int n98 = n12++;
                                    this.Mnormal[n98] = (float)((double)this.Mnormal[n98] + (double)fArray26[n2++] * d);
                                }
                                break;
                            }
                            case 2048: {
                                Vector3f[] vector3fArray = this.geometryArrays[n4].getNormalRef3f();
                                n7 = 0;
                                while (n7 < n14) {
                                    int n99 = n12++;
                                    this.Mnormal[n99] = (float)((double)this.Mnormal[n99] + (double)vector3fArray[n2].x * d);
                                    int n100 = n12++;
                                    this.Mnormal[n100] = (float)((double)this.Mnormal[n100] + (double)vector3fArray[n2].y * d);
                                    int n101 = n12++;
                                    this.Mnormal[n101] = (float)((double)this.Mnormal[n101] + (double)vector3fArray[n2].z * d);
                                    ++n7;
                                    ++n2;
                                }
                                break;
                            }
                        }
                    }
                    n11 = 0;
                    if (this.geometryArrays[n4] instanceof IndexedGeometryArrayRetained) {
                        n5 = 0;
                        n14 = this.geometryArrays[n4].getNumCoordCount();
                    } else {
                        n5 = this.geometryArrays[n4].getInitialCoordIndex();
                        n14 = this.geometryArrays[n4].validVertexCount;
                    }
                    switch (this.geometryArrays[n4].vertexType & 0xF) {
                        case 1: {
                            float[] fArray27 = this.geometryArrays[n4].getCoordRefFloat();
                            n5 *= 3;
                            for (n7 = 0; n7 < n14; ++n7) {
                                int n102 = n11++;
                                this.Mcoord[n102] = (float)((double)this.Mcoord[n102] + (double)fArray27[n5++] * d);
                                int n103 = n11++;
                                this.Mcoord[n103] = (float)((double)this.Mcoord[n103] + (double)fArray27[n5++] * d);
                                int n104 = n11++;
                                this.Mcoord[n104] = (float)((double)this.Mcoord[n104] + (double)fArray27[n5++] * d);
                            }
                            continue block40;
                        }
                        case 2: {
                            double[] dArray = this.geometryArrays[n4].getCoordRefDouble();
                            n5 *= 3;
                            for (n7 = 0; n7 < n14; ++n7) {
                                int n105 = n11++;
                                this.Mcoord[n105] = (float)((double)this.Mcoord[n105] + (double)((float)dArray[n5++]) * d);
                                int n106 = n11++;
                                this.Mcoord[n106] = (float)((double)this.Mcoord[n106] + (double)((float)dArray[n5++]) * d);
                                int n107 = n11++;
                                this.Mcoord[n107] = (float)((double)this.Mcoord[n107] + (double)((float)dArray[n5++]) * d);
                            }
                            continue block40;
                        }
                        case 4: {
                            objectArray2 = this.geometryArrays[n4].getCoordRef3f();
                            n7 = 0;
                            while (n7 < n14) {
                                int n108 = n11++;
                                this.Mcoord[n108] = (float)((double)this.Mcoord[n108] + (double)objectArray2[n5].x * d);
                                int n109 = n11++;
                                this.Mcoord[n109] = (float)((double)this.Mcoord[n109] + (double)objectArray2[n5].y * d);
                                int n110 = n11++;
                                this.Mcoord[n110] = (float)((double)this.Mcoord[n110] + (double)objectArray2[n5].z * d);
                                ++n7;
                                ++n5;
                            }
                            continue block40;
                        }
                        case 8: {
                            objectArray = this.geometryArrays[n4].getCoordRef3d();
                            n7 = 0;
                            while (n7 < n14) {
                                int n111 = n11++;
                                this.Mcoord[n111] = (float)((double)this.Mcoord[n111] + (double)((float)objectArray[n5].x) * d);
                                int n112 = n11++;
                                this.Mcoord[n112] = (float)((double)this.Mcoord[n112] + (double)((float)objectArray[n5].y) * d);
                                int n113 = n11++;
                                this.Mcoord[n113] = (float)((double)this.Mcoord[n113] + (double)((float)objectArray[n5].z) * d);
                                ++n7;
                                ++n5;
                            }
                            continue block40;
                        }
                    }
                }
            }
        }
        GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)geometry.retained;
        geometryArrayRetained.setCoordRefFloat(this.Mcoord);
        if ((n9 & 4) != 0) {
            geometryArrayRetained.setColorRefFloat(this.Mcolor);
        }
        if ((n9 & 2) != 0) {
            geometryArrayRetained.setNormalRefFloat(this.Mnormal);
        }
        if ((n9 & 0x460) != 0) {
            for (n6 = 0; n6 < n8; ++n6) {
                geometryArrayRetained.setTexCoordRefFloat(n6, this.MtexCoord[n6]);
            }
        }
    }

    void updateImmediateMirrorObject(Object[] objectArray) {
        int n;
        int n2;
        Object[] objectArray2;
        int n3 = (Integer)objectArray[1];
        Shape3DRetained[] shape3DRetainedArray = (Shape3DRetained[])objectArray[2];
        if ((n3 & 2) != 0) {
            objectArray2 = (Object[])objectArray[3];
            n2 = (Integer)objectArray2[1];
            for (n = shape3DRetainedArray.length - 1; n >= 0; --n) {
                shape3DRetainedArray[n].appearance = (AppearanceRetained)objectArray2[0];
                shape3DRetainedArray[n].changedFrequent = n2;
            }
        }
        if ((n3 & 0x10) != 0) {
            objectArray2 = (Object[])objectArray[3];
            n2 = (Integer)objectArray2[1];
            System.err.println("ChangedFrequent = " + this.changedFrequent);
            for (n = shape3DRetainedArray.length - 1; n >= 0; --n) {
                shape3DRetainedArray[n].appearanceOverrideEnable = (Boolean)objectArray2[0];
                shape3DRetainedArray[n].changedFrequent = n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLive(SetLiveState setLiveState) {
        GeometryAtom geometryAtom;
        int n;
        Shape3DRetained shape3DRetained;
        Object object;
        int n2;
        ArrayList<Shape3DRetained> arrayList = new ArrayList<Shape3DRetained>();
        int n3 = this.refCount;
        super.doSetLive(setLiveState);
        this.nodeId = this.universe.getNodeId();
        for (n2 = 0; n2 < this.numGeometryArrays; ++n2) {
            object = this.geometryArrays[n2].liveStateLock;
            synchronized (object) {
                this.geometryArrays[n2].setLive(this.inBackgroundGroup, setLiveState.refCount);
                if (n3 <= 0) {
                    this.geometryArrays[n2].addMorphUser(this);
                }
                continue;
            }
        }
        if (this.morphedGeometryArray == null) {
            this.initMorphedGeometry();
        }
        ((GeometryArrayRetained)this.morphedGeometryArray.retained).setLive(this.inBackgroundGroup, setLiveState.refCount);
        if (this.boundsAutoCompute) {
            object = (GeometryArrayRetained)this.morphedGeometryArray.retained;
            ((GeometryRetained)object).incrComputeGeoBounds();
            ((GeometryRetained)object).decrComputeGeoBounds();
            this.localBounds.setWithLock(((GeometryArrayRetained)object).geoBounds);
        }
        if (this.inSharedGroup) {
            for (n2 = 0; n2 < setLiveState.keys.length; ++n2) {
                shape3DRetained = new Shape3DRetained();
                shape3DRetained.key = setLiveState.keys[n2];
                shape3DRetained.localToVworld = new Transform3D[1][];
                shape3DRetained.localToVworldIndex = new int[1][];
                int n4 = setLiveState.keys[n2].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                if (n4 < 0) {
                    System.err.println("MorphRetained : Can't find hashKey");
                }
                shape3DRetained.localToVworld[0] = this.localToVworld[n4];
                shape3DRetained.localToVworldIndex[0] = this.localToVworldIndex[n4];
                shape3DRetained.branchGroupPath = (BranchGroupRetained[])this.branchGroupPaths.get(n4);
                shape3DRetained.isPickable = setLiveState.pickable[n2];
                shape3DRetained.isCollidable = setLiveState.collidable[n2];
                shape3DRetained.initMirrorShape3D(setLiveState, this, n4);
                this.mirrorShape3D.add(n4, shape3DRetained);
                arrayList.add(shape3DRetained);
                if (setLiveState.lights != null && (object = (ArrayList)setLiveState.lights.get(n4)) != null) {
                    for (n = 0; n < ((ArrayList)object).size(); ++n) {
                        shape3DRetained.addLight((LightRetained)((ArrayList)object).get(n));
                    }
                }
                if (setLiveState.fogs != null && (object = (ArrayList)setLiveState.fogs.get(n4)) != null) {
                    for (n = 0; n < ((ArrayList)object).size(); ++n) {
                        shape3DRetained.addFog((FogRetained)((ArrayList)object).get(n));
                    }
                }
                if (setLiveState.modelClips != null && (object = (ArrayList)setLiveState.modelClips.get(n4)) != null) {
                    for (n = 0; n < ((ArrayList)object).size(); ++n) {
                        shape3DRetained.addModelClip((ModelClipRetained)((ArrayList)object).get(n));
                    }
                }
                if (setLiveState.altAppearances != null && (object = (ArrayList)setLiveState.altAppearances.get(n4)) != null) {
                    for (n = 0; n < ((ArrayList)object).size(); ++n) {
                        shape3DRetained.addAltApp((AlternateAppearanceRetained)((ArrayList)object).get(n));
                    }
                }
                shape3DRetained.viewList = setLiveState.viewLists != null ? (ArrayList)setLiveState.viewLists.get(n2) : null;
                geometryAtom = Shape3DRetained.getGeomAtom(shape3DRetained);
                setLiveState.nodeList.add(geometryAtom);
                if (setLiveState.transformTargets != null && setLiveState.transformTargets[n2] != null) {
                    setLiveState.transformTargets[n2].addNode(geometryAtom, 0);
                }
                if (setLiveState.switchTargets != null && setLiveState.switchTargets[n2] != null) {
                    setLiveState.switchTargets[n2].addNode(shape3DRetained, 0);
                    shape3DRetained.closestSwitchParent = setLiveState.closestSwitchParents[n2];
                    shape3DRetained.closestSwitchIndex = setLiveState.closestSwitchIndices[n2];
                }
                shape3DRetained.switchState = (SwitchState)setLiveState.switchStates.get(n4);
            }
        } else {
            shape3DRetained = new Shape3DRetained();
            shape3DRetained.localToVworld = new Transform3D[1][];
            shape3DRetained.localToVworldIndex = new int[1][];
            shape3DRetained.localToVworld[0] = this.localToVworld[0];
            shape3DRetained.localToVworldIndex[0] = this.localToVworldIndex[0];
            shape3DRetained.branchGroupPath = (BranchGroupRetained[])this.branchGroupPaths.get(0);
            shape3DRetained.isPickable = setLiveState.pickable[0];
            shape3DRetained.isCollidable = setLiveState.collidable[0];
            shape3DRetained.initMirrorShape3D(setLiveState, this, 0);
            this.mirrorShape3D.add(shape3DRetained);
            arrayList.add(shape3DRetained);
            if (setLiveState.lights != null && (object = (ArrayList)setLiveState.lights.get(0)) != null) {
                for (n = 0; n < ((ArrayList)object).size(); ++n) {
                    shape3DRetained.addLight((LightRetained)((ArrayList)object).get(n));
                }
            }
            if (setLiveState.fogs != null && (object = (ArrayList)setLiveState.fogs.get(0)) != null) {
                for (n = 0; n < ((ArrayList)object).size(); ++n) {
                    shape3DRetained.addFog((FogRetained)((ArrayList)object).get(n));
                }
            }
            if (setLiveState.modelClips != null && (object = (ArrayList)setLiveState.modelClips.get(0)) != null) {
                for (n = 0; n < ((ArrayList)object).size(); ++n) {
                    shape3DRetained.addModelClip((ModelClipRetained)((ArrayList)object).get(n));
                }
            }
            if (setLiveState.altAppearances != null && (object = (ArrayList)setLiveState.altAppearances.get(0)) != null) {
                for (n = 0; n < ((ArrayList)object).size(); ++n) {
                    shape3DRetained.addAltApp((AlternateAppearanceRetained)((ArrayList)object).get(n));
                }
            }
            shape3DRetained.viewList = setLiveState.viewLists != null ? (ArrayList)setLiveState.viewLists.get(0) : null;
            geometryAtom = Shape3DRetained.getGeomAtom(shape3DRetained);
            setLiveState.nodeList.add(geometryAtom);
            if (setLiveState.transformTargets != null && setLiveState.transformTargets[0] != null) {
                setLiveState.transformTargets[0].addNode(geometryAtom, 0);
            }
            if (setLiveState.switchTargets != null && setLiveState.switchTargets[0] != null) {
                setLiveState.switchTargets[0].addNode(shape3DRetained, 0);
                shape3DRetained.closestSwitchParent = setLiveState.closestSwitchParents[0];
                shape3DRetained.closestSwitchIndex = setLiveState.closestSwitchIndices[0];
            }
            shape3DRetained.switchState = (SwitchState)setLiveState.switchStates.get(0);
        }
        if (this.appearance != null) {
            object = this.appearance.liveStateLock;
            synchronized (object) {
                this.appearance.setLive(this.inBackgroundGroup, setLiveState.refCount);
                this.appearance.initMirrorObject();
                if (this.appearance.renderingAttributes != null) {
                    this.visible = this.appearance.renderingAttributes.visible;
                }
                for (n = 0; n < arrayList.size(); ++n) {
                    Shape3DRetained shape3DRetained2 = (Shape3DRetained)arrayList.get(n);
                    shape3DRetained2.appearance = (AppearanceRetained)this.appearance.mirror;
                    this.appearance.addAMirrorUser(shape3DRetained2);
                }
            }
        } else {
            for (int i = 0; i < arrayList.size(); ++i) {
                Shape3DRetained shape3DRetained3 = (Shape3DRetained)arrayList.get(i);
                shape3DRetained3.appearance = null;
            }
        }
        setLiveState.notifyThreads |= 0x24C0;
        if (this.refCount == 1 && this.geometryArrays[0] instanceof IndexedGeometryArrayRetained) {
            J3dMessage j3dMessage = new J3dMessage();
            j3dMessage.type = 16;
            j3dMessage.threads = 1024;
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(1);
            j3dMessage.universe = this.universe;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
        super.markAsLive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearLive(SetLiveState setLiveState) {
        GeometryAtom geometryAtom;
        Shape3DRetained shape3DRetained;
        Object object;
        int n;
        ArrayList<Shape3DRetained> arrayList = new ArrayList<Shape3DRetained>();
        super.clearLive(setLiveState);
        for (n = 0; n < this.numGeometryArrays; ++n) {
            object = this.geometryArrays[n].liveStateLock;
            synchronized (object) {
                this.geometryArrays[n].clearLive(setLiveState.refCount);
                if (this.refCount <= 0) {
                    this.geometryArrays[n].removeMorphUser(this);
                }
                continue;
            }
        }
        object = (GeometryArrayRetained)this.morphedGeometryArray.retained;
        ((GeometryArrayRetained)object).clearLive(setLiveState.refCount);
        if (this.inSharedGroup) {
            Object[] objectArray = this.mirrorShape3D.toArray();
            for (n = 0; n < setLiveState.keys.length; ++n) {
                for (int i = 0; i < objectArray.length; ++i) {
                    shape3DRetained = (Shape3DRetained)objectArray[i];
                    if (!shape3DRetained.key.equals((Object)setLiveState.keys[n])) continue;
                    this.mirrorShape3D.remove(i);
                    if (setLiveState.switchTargets != null && setLiveState.switchTargets[n] != null) {
                        setLiveState.switchTargets[n].addNode(shape3DRetained, 0);
                    }
                    if (this.appearance != null) {
                        arrayList.add(shape3DRetained);
                    }
                    geometryAtom = Shape3DRetained.getGeomAtom(shape3DRetained);
                    setLiveState.nodeList.add(geometryAtom);
                    if (setLiveState.transformTargets == null || setLiveState.transformTargets[n] == null) continue;
                    setLiveState.transformTargets[n].addNode(geometryAtom, 0);
                }
            }
        } else {
            shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(0);
            this.mirrorShape3D.remove(0);
            if (setLiveState.switchTargets != null && setLiveState.switchTargets[0] != null) {
                setLiveState.switchTargets[0].addNode(shape3DRetained, 0);
            }
            if (this.appearance != null) {
                arrayList.add(shape3DRetained);
            }
            geometryAtom = Shape3DRetained.getGeomAtom(shape3DRetained);
            setLiveState.nodeList.add(geometryAtom);
            if (setLiveState.transformTargets != null && setLiveState.transformTargets[0] != null) {
                setLiveState.transformTargets[0].addNode(geometryAtom, 0);
            }
        }
        if (this.appearance != null) {
            Object object2 = this.appearance.liveStateLock;
            synchronized (object2) {
                this.appearance.clearLive(setLiveState.refCount);
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.appearance.removeAMirrorUser((Shape3DRetained)arrayList.get(i));
                }
            }
        }
        setLiveState.notifyThreads |= 0x30C0;
    }

    void updatePickable(HashKey[] hashKeyArray, boolean[] blArray) {
        super.updatePickable(hashKeyArray, blArray);
        if (!this.inSharedGroup) {
            Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(0);
            shape3DRetained.isPickable = blArray[0];
        } else {
            int n = this.mirrorShape3D.size();
            block0: for (int i = 0; i < hashKeyArray.length; ++i) {
                for (int j = 0; j < n; ++j) {
                    Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(j);
                    if (!hashKeyArray[i].equals((Object)shape3DRetained.key)) continue;
                    shape3DRetained.isPickable = blArray[i];
                    continue block0;
                }
            }
        }
    }

    void updateCollidable(HashKey[] hashKeyArray, boolean[] blArray) {
        super.updateCollidable(hashKeyArray, blArray);
        if (!this.inSharedGroup) {
            Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(0);
            shape3DRetained.isCollidable = blArray[0];
        } else {
            int n = this.mirrorShape3D.size();
            block0: for (int i = 0; i < hashKeyArray.length; ++i) {
                for (int j = 0; j < n; ++j) {
                    Shape3DRetained shape3DRetained = (Shape3DRetained)this.mirrorShape3D.get(j);
                    if (!hashKeyArray[i].equals((Object)shape3DRetained.key)) continue;
                    shape3DRetained.isCollidable = blArray[i];
                    continue block0;
                }
            }
        }
    }

    Shape3DRetained getMirrorShape(SceneGraphPath sceneGraphPath) {
        if (!this.inSharedGroup) {
            return (Shape3DRetained)this.mirrorShape3D.get(0);
        }
        HashKey hashKey = new HashKey("");
        sceneGraphPath.getHashKey(hashKey);
        return this.getMirrorShape(hashKey);
    }

    Shape3DRetained getMirrorShape(HashKey hashKey) {
        int n = hashKey.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
        if (n >= 0) {
            return (Shape3DRetained)this.mirrorShape3D.get(n);
        }
        throw new RuntimeException("Shape3DRetained: MirrorShape Not found!");
    }

    void getMirrorObjects(ArrayList arrayList, HashKey hashKey) {
        Shape3DRetained shape3DRetained = this.inSharedGroup ? this.getMirrorShape(hashKey) : (Shape3DRetained)this.mirrorShape3D.get(0);
        GeometryAtom geometryAtom = Shape3DRetained.getGeomAtom(shape3DRetained);
        arrayList.add(geometryAtom);
    }

    void setBoundsAutoCompute(boolean bl) {
        if (bl != this.boundsAutoCompute) {
            Object object;
            if (bl) {
                this.localBounds = new BoundingBox();
                if (this.source.isLive() && this.morphedGeometryArray != null) {
                    object = (GeometryArrayRetained)this.morphedGeometryArray.retained;
                    ((GeometryRetained)object).incrComputeGeoBounds();
                    ((GeometryRetained)object).decrComputeGeoBounds();
                }
            }
            this.localBounds = this.getBounds();
            super.setBoundsAutoCompute(bl);
            if (this.source.isLive()) {
                object = new J3dMessage();
                ((J3dMessage)object).type = 37;
                ((J3dMessage)object).threads = 8384;
                ((J3dMessage)object).universe = this.universe;
                ((J3dMessage)object).args[0] = Shape3DRetained.getGeomAtomsArray(this.mirrorShape3D);
                ((J3dMessage)object).args[1] = this.localBounds;
                VirtualUniverse.mc.processMessage((J3dMessage)object);
            }
        }
    }

    void updateBounds() {
        this.localBounds = this.getEffectiveBounds();
        if (this.source.isLive()) {
            J3dMessage j3dMessage = new J3dMessage();
            j3dMessage.type = 37;
            j3dMessage.threads = 8384;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = Shape3DRetained.getGeomAtomsArray(this.mirrorShape3D);
            j3dMessage.args[1] = this.localBounds;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    void initMorphedGeometry() {
        GeometryArrayRetained geometryArrayRetained;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int[] nArray = null;
        GeometryArrayRetained geometryArrayRetained2 = this.geometryArrays[0];
        int n5 = (geometryArrayRetained2.getVertexFormat() | 0x80) & 0xFFFFFEFF;
        n3 = geometryArrayRetained2.getTexCoordSetCount();
        n4 = geometryArrayRetained2.getTexCoordSetMapLength();
        if (n4 > 0) {
            nArray = new int[n4];
            geometryArrayRetained2.getTexCoordSetMap(nArray);
        }
        int n6 = geometryArrayRetained2.geoType;
        switch (n6) {
            case 1: {
                this.morphedGeometryArray = new QuadArray(this.geometryArrays[0].validVertexCount, n5, n3, nArray);
                break;
            }
            case 2: {
                this.morphedGeometryArray = new TriangleArray(this.geometryArrays[0].validVertexCount, n5, n3, nArray);
                break;
            }
            case 3: {
                this.morphedGeometryArray = new PointArray(this.geometryArrays[0].validVertexCount, n5, n3, nArray);
                break;
            }
            case 4: {
                this.morphedGeometryArray = new LineArray(this.geometryArrays[0].validVertexCount, n5, n3, nArray);
                break;
            }
            case 5: {
                n2 = ((TriangleStripArrayRetained)geometryArrayRetained2).getNumStrips();
                int[] nArray2 = new int[n2];
                ((TriangleStripArrayRetained)geometryArrayRetained2).getStripVertexCounts(nArray2);
                this.morphedGeometryArray = new TriangleStripArray(this.geometryArrays[0].validVertexCount, n5, n3, nArray, nArray2);
                break;
            }
            case 6: {
                n2 = ((TriangleFanArrayRetained)geometryArrayRetained2).getNumStrips();
                int[] nArray2 = new int[n2];
                ((TriangleFanArrayRetained)geometryArrayRetained2).getStripVertexCounts(nArray2);
                this.morphedGeometryArray = new TriangleFanArray(this.geometryArrays[0].validVertexCount, n5, n3, nArray, nArray2);
                break;
            }
            case 7: {
                n2 = ((LineStripArrayRetained)geometryArrayRetained2).getNumStrips();
                int[] nArray2 = new int[n2];
                ((LineStripArrayRetained)geometryArrayRetained2).getStripVertexCounts(nArray2);
                this.morphedGeometryArray = new LineStripArray(this.geometryArrays[0].validVertexCount, n5, n3, nArray, nArray2);
                break;
            }
            case 8: {
                n = ((IndexedGeometryArrayRetained)geometryArrayRetained2).getIndexCount();
                this.morphedGeometryArray = new IndexedQuadArray(this.geometryArrays[0].getNumCoordCount(), n5, n3, nArray, n);
                break;
            }
            case 9: {
                n = ((IndexedGeometryArrayRetained)geometryArrayRetained2).getIndexCount();
                this.morphedGeometryArray = new IndexedTriangleArray(this.geometryArrays[0].getNumCoordCount(), n5, n3, nArray, n);
                break;
            }
            case 10: {
                n = ((IndexedGeometryArrayRetained)geometryArrayRetained2).getIndexCount();
                this.morphedGeometryArray = new IndexedPointArray(this.geometryArrays[0].getNumCoordCount(), n5, n3, nArray, n);
                break;
            }
            case 11: {
                n = ((IndexedGeometryArrayRetained)geometryArrayRetained2).getIndexCount();
                this.morphedGeometryArray = new IndexedLineArray(this.geometryArrays[0].getNumCoordCount(), n5, n3, nArray, n);
                break;
            }
            case 12: {
                n = ((IndexedGeometryArrayRetained)geometryArrayRetained2).getIndexCount();
                n2 = ((IndexedTriangleStripArrayRetained)geometryArrayRetained2).getNumStrips();
                int[] nArray2 = new int[n2];
                ((IndexedTriangleStripArrayRetained)geometryArrayRetained2).getStripIndexCounts(nArray2);
                this.morphedGeometryArray = new IndexedTriangleStripArray(this.geometryArrays[0].getNumCoordCount(), n5, n3, nArray, n, nArray2);
                break;
            }
            case 13: {
                n = ((IndexedGeometryArrayRetained)geometryArrayRetained2).getIndexCount();
                n2 = ((IndexedTriangleFanArrayRetained)geometryArrayRetained2).getNumStrips();
                int[] nArray2 = new int[n2];
                ((IndexedTriangleFanArrayRetained)geometryArrayRetained2).getStripIndexCounts(nArray2);
                this.morphedGeometryArray = new IndexedTriangleFanArray(this.geometryArrays[0].getNumCoordCount(), n5, n3, nArray, n, nArray2);
                break;
            }
            case 14: {
                n = ((IndexedGeometryArrayRetained)geometryArrayRetained2).getIndexCount();
                n2 = ((IndexedLineStripArrayRetained)geometryArrayRetained2).getNumStrips();
                int[] nArray2 = new int[n2];
                ((IndexedLineStripArrayRetained)geometryArrayRetained2).getStripIndexCounts(nArray2);
                this.morphedGeometryArray = new IndexedLineStripArray(this.geometryArrays[0].getNumCoordCount(), n5, n3, nArray, n, nArray2);
            }
        }
        if (this.geometryArrays[0] instanceof IndexedGeometryArrayRetained) {
            geometryArrayRetained = (IndexedGeometryArrayRetained)this.geometryArrays[0];
            IndexedGeometryArray indexedGeometryArray = (IndexedGeometryArray)this.morphedGeometryArray;
            if ((n5 & 1) != 0) {
                indexedGeometryArray.setCoordinateIndices(0, ((IndexedGeometryArrayRetained)geometryArrayRetained).indexCoord);
            }
            if ((n5 & 0x200) == 0) {
                if ((n5 & 2) != 0) {
                    indexedGeometryArray.setNormalIndices(0, ((IndexedGeometryArrayRetained)geometryArrayRetained).indexNormal);
                }
                if ((n5 & 4) != 0) {
                    indexedGeometryArray.setColorIndices(0, ((IndexedGeometryArrayRetained)geometryArrayRetained).indexColor);
                }
                if ((n5 & 0x460) != 0) {
                    for (int i = 0; i < n3; ++i) {
                        indexedGeometryArray.setTextureCoordinateIndices(i, 0, ((IndexedGeometryArrayRetained)geometryArrayRetained).indexTexCoord[i]);
                    }
                }
            }
        }
        this.morphedGeometryArray.setCapability(19);
        geometryArrayRetained = (GeometryArrayRetained)this.morphedGeometryArray.retained;
        geometryArrayRetained.updateData(this);
    }

    void getMirrorShape3D(ArrayList arrayList, HashKey hashKey) {
        Shape3DRetained shape3DRetained = this.inSharedGroup ? this.getMirrorShape(hashKey) : (Shape3DRetained)this.mirrorShape3D.get(0);
        arrayList.add(shape3DRetained);
    }

    void compile(CompileState compileState) {
        super.compile(compileState);
        compileState.keepTG = true;
        if (J3dDebug.debug) {
            ++compileState.numMorphs;
        }
    }

    void doErrorCheck(GeometryArrayRetained geometryArrayRetained, GeometryArrayRetained geometryArrayRetained2) {
        block12: {
            int n;
            int n2;
            int[] nArray;
            int[] nArray2;
            block11: {
                if (geometryArrayRetained.vertexFormat != geometryArrayRetained2.vertexFormat || geometryArrayRetained.validVertexCount != geometryArrayRetained2.validVertexCount || geometryArrayRetained.geoType != geometryArrayRetained2.geoType || geometryArrayRetained.texCoordSetCount != geometryArrayRetained2.texCoordSetCount) {
                    throw new IllegalArgumentException(J3dI18N.getString("MorphRetained1"));
                }
                if (geometryArrayRetained2.getTexCoordSetMapLength() != geometryArrayRetained.getTexCoordSetMapLength()) {
                    throw new IllegalArgumentException(J3dI18N.getString("MorphRetained1"));
                }
                int n3 = geometryArrayRetained2.getTexCoordSetMapLength();
                nArray2 = geometryArrayRetained.texCoordSetMap;
                nArray = geometryArrayRetained2.texCoordSetMap;
                for (n2 = 0; n2 < n3; ++n2) {
                    if (nArray2[n2] == nArray[n2]) continue;
                    throw new IllegalArgumentException(J3dI18N.getString("MorphRetained1"));
                }
                if (!(geometryArrayRetained2 instanceof GeometryStripArrayRetained)) break block11;
                nArray2 = ((GeometryStripArrayRetained)geometryArrayRetained).stripVertexCounts;
                nArray = ((GeometryStripArrayRetained)geometryArrayRetained2).stripVertexCounts;
                if (nArray2.length != nArray.length) {
                    throw new IllegalArgumentException(J3dI18N.getString("MorphRetained1"));
                }
                for (n2 = 0; n2 < nArray2.length; ++n2) {
                    if (nArray2[n2] == nArray[n2]) continue;
                    throw new IllegalArgumentException(J3dI18N.getString("MorphRetained1"));
                }
                break block12;
            }
            if (!(geometryArrayRetained2 instanceof IndexedGeometryArrayRetained)) break block12;
            if (((IndexedGeometryArrayRetained)geometryArrayRetained).validIndexCount != ((IndexedGeometryArrayRetained)geometryArrayRetained2).validIndexCount) {
                throw new IllegalArgumentException(J3dI18N.getString("MorphRetained1"));
            }
            if (geometryArrayRetained2.getNumCoordCount() != geometryArrayRetained.getNumCoordCount() || geometryArrayRetained2.getNumColorCount() != geometryArrayRetained.getNumColorCount() || geometryArrayRetained2.getNumNormalCount() != geometryArrayRetained.getNumNormalCount()) {
                throw new IllegalArgumentException(J3dI18N.getString("MorphRetained1"));
            }
            n2 = geometryArrayRetained2.getTexCoordSetCount();
            for (n = 0; n < n2; ++n) {
                if (geometryArrayRetained2.getNumTexCoordCount(n) == geometryArrayRetained.getNumTexCoordCount(n)) continue;
                throw new IllegalArgumentException(J3dI18N.getString("MorphRetained1"));
            }
            if (geometryArrayRetained2 instanceof IndexedGeometryStripArrayRetained) {
                nArray2 = ((IndexedGeometryStripArrayRetained)geometryArrayRetained).stripIndexCounts;
                nArray = ((IndexedGeometryStripArrayRetained)geometryArrayRetained2).stripIndexCounts;
                if (nArray2.length != nArray.length) {
                    throw new IllegalArgumentException(J3dI18N.getString("MorphRetained1"));
                }
                for (n = 0; n < nArray2.length; ++n) {
                    if (nArray2[n] == nArray[n]) continue;
                    throw new IllegalArgumentException(J3dI18N.getString("MorphRetained1"));
                }
            }
        }
    }

    void handleFrequencyChange(int n) {
        int n2 = 0;
        if (n == 13) {
            n2 = 1;
        } else if (n == 15) {
            n2 = 2;
        } else if (n == 21) {
            n2 = 16;
        }
        if (n2 != 0) {
            if (this.source.getCapabilityIsFrequent(n)) {
                this.changedFrequent |= n2;
            } else if (!this.source.isLive()) {
                this.changedFrequent &= ~n2;
            }
        }
    }

    void searchGeometryAtoms(UnorderList unorderList) {
        unorderList.add(Shape3DRetained.getGeomAtom((Shape3DRetained)this.mirrorShape3D.get(0)));
    }
}

