/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.gui.Overlay;
import ij.io.SaveDialog;
import ij.plugin.Animator;
import ij.plugin.GifEncoder;
import ij.plugin.PlugIn;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import javax.imageio.ImageIO;

public class GifWriter
implements PlugIn {
    static int transparentIndex = Prefs.getTransparentIndex();

    @Override
    public void run(String path) {
        ImagePlus imp = IJ.getImage();
        if (path.equals("")) {
            SaveDialog sd = new SaveDialog("Save as Gif", imp.getTitle(), ".gif");
            if (sd.getFileName() == null) {
                return;
            }
            path = sd.getDirectory() + sd.getFileName();
        }
        ImageStack stack = imp.getStack();
        Overlay overlay = imp.getOverlay();
        int nSlices = stack.getSize();
        if (nSlices == 1) {
            if (overlay != null) {
                imp = imp.flatten();
            }
            try {
                this.writeImage(imp, path, transparentIndex);
            }
            catch (Exception e) {
                String msg = e.getMessage();
                if (msg == null || msg.equals("")) {
                    msg = "" + e;
                }
                IJ.error("GifWriter", "An error occured writing the file.\n \n" + msg);
            }
            return;
        }
        GifEncoder ge = new GifEncoder();
        double fps = imp.getCalibration().fps;
        if (fps == 0.0) {
            fps = Animator.getFrameRate();
        }
        if (fps <= 0.2) {
            fps = 0.2;
        }
        if (fps > 60.0) {
            fps = 60.0;
        }
        ge.setDelay((int)(1.0 / fps * 1000.0));
        if (transparentIndex != -1) {
            ge.transparent = true;
            ge.transIndex = transparentIndex;
        }
        ge.start(path);
        ImagePlus tmp = new ImagePlus();
        for (int i = 1; i <= nSlices; ++i) {
            IJ.showStatus("writing: " + i + "/" + nSlices);
            IJ.showProgress((double)i / (double)nSlices);
            tmp.setProcessor(stack.getProcessor(i));
            if (overlay != null) {
                Overlay overlay2 = overlay.duplicate();
                overlay2.crop(i, i);
                if (overlay2.size() > 0) {
                    tmp.setOverlay(overlay2);
                    tmp = tmp.flatten();
                    new ImageConverter(tmp).convertRGBtoIndexedColor(256);
                }
            }
            try {
                ge.addFrame(tmp);
                continue;
            }
            catch (Exception e) {
                IJ.showMessage("Save as Gif", "" + e);
                return;
            }
        }
        ge.finish();
        IJ.showStatus("");
        IJ.showProgress(1.0);
    }

    private void writeImage(ImagePlus imp, String path, int transparentIndex) throws Exception {
        if (transparentIndex >= 0 && transparentIndex <= 255) {
            this.writeImageWithTransparency(imp, path, transparentIndex);
        } else {
            ImageIO.write((RenderedImage)imp.getBufferedImage(), "gif", new File(path));
        }
    }

    private void writeImageWithTransparency(ImagePlus imp, String path, int transparentIndex) throws Exception {
        int width = imp.getWidth();
        int height = imp.getHeight();
        ImageProcessor ip = imp.getProcessor();
        IndexColorModel cm = (IndexColorModel)ip.getColorModel();
        int size = cm.getMapSize();
        byte[] reds = new byte[256];
        byte[] greens = new byte[256];
        byte[] blues = new byte[256];
        cm.getReds(reds);
        cm.getGreens(greens);
        cm.getBlues(blues);
        cm = new IndexColorModel(8, size, reds, greens, blues, transparentIndex);
        WritableRaster wr = cm.createCompatibleWritableRaster(width, height);
        DataBufferByte db = (DataBufferByte)wr.getDataBuffer();
        byte[] biPixels = db.getData();
        System.arraycopy(ip.getPixels(), 0, biPixels, 0, biPixels.length);
        BufferedImage bi = new BufferedImage(cm, wr, false, null);
        ImageIO.write((RenderedImage)bi, "gif", new File(path));
    }
}

