/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex;

import cern.colt.PersistentObject;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.SparseDComplexMatrix2D;
import cern.jet.math.tdcomplex.DComplexFunctions;
import cern.jet.random.tdouble.engine.DoubleMersenneTwister;
import cern.jet.random.tdouble.sampling.DoubleRandomSamplingAssistant;

public class DComplexFactory2D
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final DComplexFactory2D dense = new DComplexFactory2D();
    public static final DComplexFactory2D sparse = new DComplexFactory2D();

    protected DComplexFactory2D() {
    }

    public DComplexMatrix2D appendColumns(DComplexMatrix2D A, DComplexMatrix2D B) {
        if (B.rows() > A.rows()) {
            B = B.viewPart(0, 0, A.rows(), B.columns());
        } else if (B.rows() < A.rows()) {
            A = A.viewPart(0, 0, B.rows(), A.columns());
        }
        int ac = A.columns();
        int bc = B.columns();
        int r = A.rows();
        DComplexMatrix2D matrix = this.make(r, ac + bc);
        matrix.viewPart(0, 0, r, ac).assign(A);
        matrix.viewPart(0, ac, r, bc).assign(B);
        return matrix;
    }

    public DComplexMatrix2D appendColumn(DComplexMatrix2D A, DComplexMatrix1D b) {
        if (b.size() > (long)A.rows()) {
            b = b.viewPart(0, A.rows());
        } else if (b.size() < (long)A.rows()) {
            A = A.viewPart(0, 0, (int)b.size(), A.columns());
        }
        int ac = A.columns();
        int bc = 1;
        int r = A.rows();
        DComplexMatrix2D matrix = this.make(r, ac + bc);
        matrix.viewPart(0, 0, r, ac).assign(A);
        matrix.viewColumn(ac).assign(b);
        return matrix;
    }

    public DComplexMatrix2D appendRows(DComplexMatrix2D A, DComplexMatrix2D B) {
        if (B.columns() > A.columns()) {
            B = B.viewPart(0, 0, B.rows(), A.columns());
        } else if (B.columns() < A.columns()) {
            A = A.viewPart(0, 0, A.rows(), B.columns());
        }
        int ar = A.rows();
        int br = B.rows();
        int c = A.columns();
        DComplexMatrix2D matrix = this.make(ar + br, c);
        matrix.viewPart(0, 0, ar, c).assign(A);
        matrix.viewPart(ar, 0, br, c).assign(B);
        return matrix;
    }

    public DComplexMatrix2D appendRow(DComplexMatrix2D A, DComplexMatrix1D b) {
        if (b.size() > (long)A.columns()) {
            b = b.viewPart(0, A.columns());
        } else if (b.size() < (long)A.columns()) {
            A = A.viewPart(0, 0, A.rows(), (int)b.size());
        }
        int ar = A.rows();
        int br = 1;
        int c = A.columns();
        DComplexMatrix2D matrix = this.make(ar + br, c);
        matrix.viewPart(0, 0, ar, c).assign(A);
        matrix.viewRow(ar).assign(b);
        return matrix;
    }

    protected static void checkRectangularShape(double[][] array) {
        int columns = -1;
        int r = 0;
        while (r < array.length) {
            if (array[r] != null) {
                if (columns == -1) {
                    columns = array[r].length;
                }
                if (array[r].length != columns) {
                    throw new IllegalArgumentException("All rows of array must have same number of columns.");
                }
            }
            ++r;
        }
    }

    protected static void checkRectangularShape(DComplexMatrix2D[][] array) {
        int columns = -1;
        int r = 0;
        while (r < array.length) {
            if (array[r] != null) {
                if (columns == -1) {
                    columns = array[r].length;
                }
                if (array[r].length != columns) {
                    throw new IllegalArgumentException("All rows of array must have same number of columns.");
                }
            }
            ++r;
        }
    }

    public DComplexMatrix2D compose(DComplexMatrix2D[][] parts) {
        int r;
        DComplexFactory2D.checkRectangularShape(parts);
        int rows = parts.length;
        int columns = 0;
        if (parts.length > 0) {
            columns = parts[0].length;
        }
        DComplexMatrix2D empty = this.make(0, 0);
        if (rows == 0 || columns == 0) {
            return empty;
        }
        int[] maxWidths = new int[columns];
        int c = 0;
        while (c < columns) {
            int maxWidth = 0;
            r = 0;
            while (r < rows) {
                DComplexMatrix2D part = parts[r][c];
                if (part != null) {
                    int width = part.columns();
                    if (maxWidth > 0 && width > 0 && width != maxWidth) {
                        throw new IllegalArgumentException("Different number of columns.");
                    }
                    maxWidth = Math.max(maxWidth, width);
                }
                ++r;
            }
            maxWidths[c] = maxWidth;
            ++c;
        }
        int[] maxHeights = new int[rows];
        int r2 = 0;
        while (r2 < rows) {
            int maxHeight = 0;
            int c2 = 0;
            while (c2 < columns) {
                DComplexMatrix2D part = parts[r2][c2];
                if (part != null) {
                    int height = part.rows();
                    if (maxHeight > 0 && height > 0 && height != maxHeight) {
                        throw new IllegalArgumentException("Different number of rows.");
                    }
                    maxHeight = Math.max(maxHeight, height);
                }
                ++c2;
            }
            maxHeights[r2] = maxHeight;
            ++r2;
        }
        int resultRows = 0;
        r = 0;
        while (r < rows) {
            resultRows += maxHeights[r];
            ++r;
        }
        int resultCols = 0;
        int c3 = 0;
        while (c3 < columns) {
            resultCols += maxWidths[c3];
            ++c3;
        }
        DComplexMatrix2D matrix = this.make(resultRows, resultCols);
        int idxr = 0;
        int r3 = 0;
        while (r3 < rows) {
            int idxc = 0;
            int c4 = 0;
            while (c4 < columns) {
                DComplexMatrix2D part = parts[r3][c4];
                if (part != null) {
                    matrix.viewPart(idxr, idxc, part.rows(), part.columns()).assign(part);
                }
                idxc += maxWidths[c4];
                ++c4;
            }
            idxr += maxHeights[r3];
            ++r3;
        }
        return matrix;
    }

    public DComplexMatrix2D composeDiagonal(DComplexMatrix2D A, DComplexMatrix2D B) {
        int ar = A.rows();
        int ac = A.columns();
        int br = B.rows();
        int bc = B.columns();
        DComplexMatrix2D sum = this.make(ar + br, ac + bc);
        sum.viewPart(0, 0, ar, ac).assign(A);
        sum.viewPart(ar, ac, br, bc).assign(B);
        return sum;
    }

    public DComplexMatrix2D composeDiagonal(DComplexMatrix2D A, DComplexMatrix2D B, DComplexMatrix2D C) {
        DComplexMatrix2D diag = this.make(A.rows() + B.rows() + C.rows(), A.columns() + B.columns() + C.columns());
        diag.viewPart(0, 0, A.rows(), A.columns()).assign(A);
        diag.viewPart(A.rows(), A.columns(), B.rows(), B.columns()).assign(B);
        diag.viewPart(A.rows() + B.rows(), A.columns() + B.columns(), C.rows(), C.columns()).assign(C);
        return diag;
    }

    public DComplexMatrix2D composeBidiagonal(DComplexMatrix2D A, DComplexMatrix2D B) {
        int ar = A.rows();
        int ac = A.columns();
        int br = B.rows();
        int bc = B.columns();
        DComplexMatrix2D sum = this.make(ar + br - 1, ac + bc);
        sum.viewPart(0, 0, ar, ac).assign(A);
        sum.viewPart(ar - 1, ac, br, bc).assign(B);
        return sum;
    }

    public void decompose(DComplexMatrix2D[][] parts, DComplexMatrix2D matrix) {
        int r;
        DComplexFactory2D.checkRectangularShape(parts);
        int rows = parts.length;
        int columns = 0;
        if (parts.length > 0) {
            columns = parts[0].length;
        }
        if (rows == 0 || columns == 0) {
            return;
        }
        int[] maxWidths = new int[columns];
        int c = 0;
        while (c < columns) {
            int maxWidth = 0;
            r = 0;
            while (r < rows) {
                DComplexMatrix2D part = parts[r][c];
                if (part != null) {
                    int width = part.columns();
                    if (maxWidth > 0 && width > 0 && width != maxWidth) {
                        throw new IllegalArgumentException("Different number of columns.");
                    }
                    maxWidth = Math.max(maxWidth, width);
                }
                ++r;
            }
            maxWidths[c] = maxWidth;
            ++c;
        }
        int[] maxHeights = new int[rows];
        int r2 = 0;
        while (r2 < rows) {
            int maxHeight = 0;
            int c2 = 0;
            while (c2 < columns) {
                DComplexMatrix2D part = parts[r2][c2];
                if (part != null) {
                    int height = part.rows();
                    if (maxHeight > 0 && height > 0 && height != maxHeight) {
                        throw new IllegalArgumentException("Different number of rows.");
                    }
                    maxHeight = Math.max(maxHeight, height);
                }
                ++c2;
            }
            maxHeights[r2] = maxHeight;
            ++r2;
        }
        int resultRows = 0;
        r = 0;
        while (r < rows) {
            resultRows += maxHeights[r];
            ++r;
        }
        int resultCols = 0;
        int c3 = 0;
        while (c3 < columns) {
            resultCols += maxWidths[c3];
            ++c3;
        }
        if (matrix.rows() < resultRows || matrix.columns() < resultCols) {
            throw new IllegalArgumentException("Parts larger than matrix.");
        }
        int idxr = 0;
        int r3 = 0;
        while (r3 < rows) {
            int idxc = 0;
            int c4 = 0;
            while (c4 < columns) {
                DComplexMatrix2D part = parts[r3][c4];
                if (part != null) {
                    part.assign(matrix.viewPart(idxr, idxc, part.rows(), part.columns()));
                }
                idxc += maxWidths[c4];
                ++c4;
            }
            idxr += maxHeights[r3];
            ++r3;
        }
    }

    public void demo1() {
        System.out.println("\n\n");
        DComplexMatrix2D[][] dComplexMatrix2DArray = new DComplexMatrix2D[3][];
        DComplexMatrix2D[] dComplexMatrix2DArray2 = new DComplexMatrix2D[3];
        dComplexMatrix2DArray2[1] = this.make(2, 2, new double[]{1.0, 2.0});
        dComplexMatrix2DArray[0] = dComplexMatrix2DArray2;
        DComplexMatrix2D[] dComplexMatrix2DArray3 = new DComplexMatrix2D[3];
        dComplexMatrix2DArray3[0] = this.make(4, 4, new double[]{3.0, 4.0});
        dComplexMatrix2DArray3[2] = this.make(4, 3, new double[]{5.0, 6.0});
        dComplexMatrix2DArray[1] = dComplexMatrix2DArray3;
        DComplexMatrix2D[] dComplexMatrix2DArray4 = new DComplexMatrix2D[3];
        dComplexMatrix2DArray4[1] = this.make(2, 2, new double[]{7.0, 8.0});
        dComplexMatrix2DArray[2] = dComplexMatrix2DArray4;
        DComplexMatrix2D[][] parts1 = dComplexMatrix2DArray;
        System.out.println("\n" + this.compose(parts1));
    }

    public void demo2() {
        System.out.println("\n\n");
        Object _ = null;
        DComplexMatrix2D A = this.make(2, 2, new double[]{1.0, 2.0});
        DComplexMatrix2D B = this.make(4, 4, new double[]{3.0, 4.0});
        DComplexMatrix2D C = this.make(4, 3, new double[]{5.0, 6.0});
        DComplexMatrix2D D = this.make(2, 2, new double[]{7.0, 8.0});
        DComplexMatrix2D[][] parts1 = new DComplexMatrix2D[][]{{_, A, _}, {B, _, C}, {_, D, _}};
        DComplexMatrix2D matrix = this.compose(parts1);
        System.out.println("\n" + matrix);
        A.assign(9.0, 9.0);
        B.assign(9.0, 9.0);
        C.assign(9.0, 9.0);
        D.assign(9.0, 9.0);
        this.decompose(parts1, matrix);
        System.out.println(A);
        System.out.println(B);
        System.out.println(C);
        System.out.println(D);
    }

    public DComplexMatrix2D diagonal(DComplexMatrix1D vector) {
        int size = (int)vector.size();
        DComplexMatrix2D diag = this.make(size, size);
        int i = 0;
        while (i < size) {
            diag.setQuick(i, i, vector.getQuick(i));
            ++i;
        }
        return diag;
    }

    public DComplexMatrix1D diagonal(DComplexMatrix2D A) {
        int min = Math.min(A.rows(), A.columns());
        DComplexMatrix1D diag = this.make1D(min);
        int i = 0;
        while (i < min) {
            diag.setQuick(i, A.getQuick(i, i));
            ++i;
        }
        return diag;
    }

    public DComplexMatrix2D identity(int rowsAndColumns) {
        DComplexMatrix2D matrix = this.make(rowsAndColumns, rowsAndColumns);
        double[] one = new double[]{1.0, 0.0};
        int i = rowsAndColumns;
        while (--i >= 0) {
            matrix.setQuick(i, i, one);
        }
        return matrix;
    }

    public DComplexMatrix2D make(double[][] values) {
        if (this == sparse) {
            return new SparseDComplexMatrix2D(values);
        }
        return new DenseDComplexMatrix2D(values);
    }

    public DComplexMatrix2D make(int rows, int columns) {
        if (this == sparse) {
            return new SparseDComplexMatrix2D(rows, columns);
        }
        return new DenseDComplexMatrix2D(rows, columns);
    }

    public DComplexMatrix2D make(int rows, int columns, double[] initialValue) {
        if (initialValue[0] == 0.0 && initialValue[1] == 0.0) {
            return this.make(rows, columns);
        }
        return this.make(rows, columns).assign(initialValue);
    }

    protected DComplexMatrix1D make1D(int size) {
        return this.make(0, 0).like1D(size);
    }

    public DComplexMatrix2D random(int rows, int columns) {
        return this.make(rows, columns).assign(DComplexFunctions.random());
    }

    public DComplexMatrix2D repeat(DComplexMatrix2D A, int rowRepeat, int columnRepeat) {
        int r = A.rows();
        int c = A.columns();
        DComplexMatrix2D matrix = this.make(r * rowRepeat, c * columnRepeat);
        int i = 0;
        while (i < rowRepeat) {
            int j = 0;
            while (j < columnRepeat) {
                matrix.viewPart(r * i, c * j, r, c).assign(A);
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    public DComplexMatrix2D sample(int rows, int columns, double[] value, double nonZeroFraction) {
        DComplexMatrix2D matrix = this.make(rows, columns);
        this.sample(matrix, value, nonZeroFraction);
        return matrix;
    }

    public DComplexMatrix2D sample(DComplexMatrix2D matrix, double[] value, double nonZeroFraction) {
        int rows = matrix.rows();
        int columns = matrix.columns();
        double epsilon = 1.0E-9;
        if (nonZeroFraction < 0.0 - epsilon || nonZeroFraction > 1.0 + epsilon) {
            throw new IllegalArgumentException();
        }
        if (nonZeroFraction < 0.0) {
            nonZeroFraction = 0.0;
        }
        if (nonZeroFraction > 1.0) {
            nonZeroFraction = 1.0;
        }
        matrix.assign(0.0, 0.0);
        int size = rows * columns;
        int n = (int)Math.round((double)size * nonZeroFraction);
        if (n == 0) {
            return matrix;
        }
        DoubleRandomSamplingAssistant sampler = new DoubleRandomSamplingAssistant(n, size, new DoubleMersenneTwister());
        int i = 0;
        while (i < size) {
            if (sampler.sampleNextElement()) {
                int row = i / columns;
                int column = i % columns;
                matrix.set(row, column, value);
            }
            ++i;
        }
        return matrix;
    }
}

