/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;

public class DoubleGivensRotation {
    private final double c;
    private final double s;

    public DoubleGivensRotation(double x, double y) {
        double roe = Math.abs(x) > Math.abs(y) ? x : y;
        double scale = Math.abs(x) + Math.abs(y);
        if (scale != 0.0) {
            double xs = x / scale;
            double ys = y / scale;
            double r = scale * Math.sqrt(xs * xs + ys * ys);
            if (roe < 0.0) {
                r *= -1.0;
            }
            this.c = x / r;
            this.s = y / r;
        } else {
            this.c = 1.0;
            this.s = 0.0;
        }
    }

    public void apply(DoubleMatrix2D H, int column, int i1, int i2) {
        double temp = this.c * H.getQuick(i1, column) + this.s * H.getQuick(i2, column);
        H.setQuick(i2, column, -this.s * H.getQuick(i1, column) + this.c * H.getQuick(i2, column));
        H.setQuick(i1, column, temp);
    }

    public void apply(DoubleMatrix1D x, int i1, int i2) {
        double temp = this.c * x.getQuick(i1) + this.s * x.getQuick(i2);
        x.setQuick(i2, -this.s * x.getQuick(i1) + this.c * x.getQuick(i2));
        x.setQuick(i1, temp);
    }
}

