/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.matrix.tdcomplex.impl.DenseLargeDComplexMatrix3D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.impl.DelegateDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseLargeDoubleMatrix3D;

public class WrapperDoubleMatrix3D
extends DoubleMatrix3D {
    private static final long serialVersionUID = 1L;
    protected DoubleMatrix3D content;

    public WrapperDoubleMatrix3D(DoubleMatrix3D newContent) {
        block3: {
            if (newContent != null) {
                try {
                    this.setUp(newContent.slices(), newContent.rows(), newContent.columns());
                }
                catch (IllegalArgumentException exc) {
                    if ("matrix too large".equals(exc.getMessage())) break block3;
                    throw exc;
                }
            }
        }
        this.content = newContent;
    }

    @Override
    public Object elements() {
        return this.content.elements();
    }

    public void dct3(boolean scale) {
        if (this.content instanceof DenseLargeDoubleMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix3D)this.content).dct3(scale);
            } else {
                DenseLargeDoubleMatrix3D copy = (DenseLargeDoubleMatrix3D)this.copy();
                copy.dct3(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dct2Slices(boolean scale) {
        if (this.content instanceof DenseLargeDoubleMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix3D)this.content).dct2Slices(scale);
            } else {
                DenseLargeDoubleMatrix3D copy = (DenseLargeDoubleMatrix3D)this.copy();
                copy.dct2Slices(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dst3(boolean scale) {
        if (this.content instanceof DenseLargeDoubleMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix3D)this.content).dst3(scale);
            } else {
                DenseLargeDoubleMatrix3D copy = (DenseLargeDoubleMatrix3D)this.copy();
                copy.dst3(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dst2Slices(boolean scale) {
        if (this.content instanceof DenseLargeDoubleMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix3D)this.content).dst2Slices(scale);
            } else {
                DenseLargeDoubleMatrix3D copy = (DenseLargeDoubleMatrix3D)this.copy();
                copy.dst2Slices(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dht3() {
        if (this.content instanceof DenseLargeDoubleMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix3D)this.content).dht3();
            } else {
                DenseLargeDoubleMatrix3D copy = (DenseLargeDoubleMatrix3D)this.copy();
                copy.dht3();
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dht2Slices() {
        if (this.content instanceof DenseLargeDoubleMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix3D)this.content).dht2Slices();
            } else {
                DenseLargeDoubleMatrix3D copy = (DenseLargeDoubleMatrix3D)this.copy();
                copy.dht2Slices();
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void fft3() {
        if (this.content instanceof DenseLargeDoubleMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix3D)this.content).fft3();
            } else {
                DenseLargeDoubleMatrix3D copy = (DenseLargeDoubleMatrix3D)this.copy();
                copy.fft3();
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public DenseLargeDComplexMatrix3D getFft3() {
        if (this.content instanceof DenseLargeDoubleMatrix3D) {
            if (this.isNoView) {
                return ((DenseLargeDoubleMatrix3D)this.content).getFft3();
            }
            return ((DenseLargeDoubleMatrix3D)this.copy()).getFft3();
        }
        throw new IllegalArgumentException("This method is not supported");
    }

    public DenseLargeDComplexMatrix3D getIfft3(boolean scale) {
        if (this.content instanceof DenseLargeDoubleMatrix3D) {
            if (this.isNoView) {
                return ((DenseLargeDoubleMatrix3D)this.content).getIfft3(scale);
            }
            return ((DenseLargeDoubleMatrix3D)this.copy()).getIfft3(scale);
        }
        throw new IllegalArgumentException("This method is not supported");
    }

    public DenseLargeDComplexMatrix3D getFft2Slices() {
        if (this.content instanceof DenseLargeDoubleMatrix3D) {
            if (this.isNoView) {
                return ((DenseLargeDoubleMatrix3D)this.content).getFft2Slices();
            }
            return ((DenseLargeDoubleMatrix3D)this.copy()).getFft2Slices();
        }
        throw new IllegalArgumentException("This method is not supported");
    }

    public DenseLargeDComplexMatrix3D getIfft2Slices(boolean scale) {
        if (this.content instanceof DenseLargeDoubleMatrix3D) {
            if (this.isNoView) {
                return ((DenseLargeDoubleMatrix3D)this.content).getIfft2Slices(scale);
            }
            return ((DenseLargeDoubleMatrix3D)this.copy()).getIfft2Slices(scale);
        }
        throw new IllegalArgumentException("This method is not supported");
    }

    public void idct3(boolean scale) {
        if (this.content instanceof DenseLargeDoubleMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix3D)this.content).idct3(scale);
            } else {
                DenseLargeDoubleMatrix3D copy = (DenseLargeDoubleMatrix3D)this.copy();
                copy.idct3(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idct2Slices(boolean scale) {
        if (this.content instanceof DenseLargeDoubleMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix3D)this.content).idct2Slices(scale);
            } else {
                DenseLargeDoubleMatrix3D copy = (DenseLargeDoubleMatrix3D)this.copy();
                copy.idct2Slices(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idst3(boolean scale) {
        if (this.content instanceof DenseLargeDoubleMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix3D)this.content).idst3(scale);
            } else {
                DenseLargeDoubleMatrix3D copy = (DenseLargeDoubleMatrix3D)this.copy();
                copy.idst3(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idst2Slices(boolean scale) {
        if (this.content instanceof DenseLargeDoubleMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix3D)this.content).idst2Slices(scale);
            } else {
                DenseLargeDoubleMatrix3D copy = (DenseLargeDoubleMatrix3D)this.copy();
                copy.idst2Slices(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idht3(boolean scale) {
        if (this.content instanceof DenseLargeDoubleMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix3D)this.content).idht3(scale);
            } else {
                DenseLargeDoubleMatrix3D copy = (DenseLargeDoubleMatrix3D)this.copy();
                copy.idht3(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idht2Slices(boolean scale) {
        if (this.content instanceof DenseLargeDoubleMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix3D)this.content).idht2Slices(scale);
            } else {
                DenseLargeDoubleMatrix3D copy = (DenseLargeDoubleMatrix3D)this.copy();
                copy.idht2Slices(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void ifft3(boolean scale) {
        if (this.content instanceof DenseLargeDoubleMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix3D)this.content).ifft3(scale);
            } else {
                DenseLargeDoubleMatrix3D copy = (DenseLargeDoubleMatrix3D)this.copy();
                copy.ifft3(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    @Override
    public synchronized double getQuick(int slice, int row, int column) {
        return this.content.getQuick(slice, row, column);
    }

    @Override
    public DoubleMatrix3D like(int slices, int rows, int columns) {
        return this.content.like(slices, rows, columns);
    }

    @Override
    public synchronized void setQuick(int slice, int row, int column, double value) {
        this.content.setQuick(slice, row, column, value);
    }

    @Override
    public DoubleMatrix1D vectorize() {
        DenseDoubleMatrix1D v = new DenseDoubleMatrix1D((int)this.size());
        int length = this.rows * this.columns;
        int s = 0;
        while (s < this.slices) {
            v.viewPart(s * length, length).assign(this.viewSlice(s).vectorize());
            ++s;
        }
        return v;
    }

    @Override
    public DoubleMatrix2D viewColumn(int column) {
        this.checkColumn(column);
        return new DelegateDoubleMatrix2D(this, 2, column);
    }

    @Override
    public DoubleMatrix3D viewColumnFlip() {
        if (this.columns == 0) {
            return this;
        }
        WrapperDoubleMatrix3D view = new WrapperDoubleMatrix3D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized double getQuick(int slice, int row, int column) {
                return this.content.getQuick(slice, row, this.columns - 1 - column);
            }

            @Override
            public synchronized void setQuick(int slice, int row, int column, double value) {
                this.content.setQuick(slice, row, this.columns - 1 - column, value);
            }

            @Override
            public synchronized double get(int slice, int row, int column) {
                return this.content.get(slice, row, this.columns - 1 - column);
            }

            @Override
            public synchronized void set(int slice, int row, int column, double value) {
                this.content.set(slice, row, this.columns - 1 - column, value);
            }
        };
        view.isNoView = false;
        return view;
    }

    @Override
    public DoubleMatrix2D viewSlice(int slice) {
        this.checkSlice(slice);
        return new DelegateDoubleMatrix2D(this, 0, slice);
    }

    @Override
    public DoubleMatrix3D viewSliceFlip() {
        if (this.slices == 0) {
            return this;
        }
        WrapperDoubleMatrix3D view = new WrapperDoubleMatrix3D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized double getQuick(int slice, int row, int column) {
                return this.content.getQuick(this.slices - 1 - slice, row, column);
            }

            @Override
            public synchronized void setQuick(int slice, int row, int column, double value) {
                this.content.setQuick(this.slices - 1 - slice, row, column, value);
            }

            @Override
            public synchronized double get(int slice, int row, int column) {
                return this.content.get(this.slices - 1 - slice, row, column);
            }

            @Override
            public synchronized void set(int slice, int row, int column, double value) {
                this.content.set(this.slices - 1 - slice, row, column, value);
            }
        };
        view.isNoView = false;
        return view;
    }

    @Override
    public DoubleMatrix3D viewDice(int axis0, int axis1, int axis2) {
        int d = 3;
        if (axis0 < 0 || axis0 >= d || axis1 < 0 || axis1 >= d || axis2 < 0 || axis2 >= d || axis0 == axis1 || axis0 == axis2 || axis1 == axis2) {
            throw new IllegalArgumentException("Illegal Axes: " + axis0 + ", " + axis1 + ", " + axis2);
        }
        WrapperDoubleMatrix3D view = null;
        if (axis0 == 0 && axis1 == 1 && axis2 == 2) {
            view = new WrapperDoubleMatrix3D(this);
        } else if (axis0 == 1 && axis1 == 0 && axis2 == 2) {
            view = new WrapperDoubleMatrix3D(this){
                private static final long serialVersionUID = 1L;

                @Override
                public synchronized double getQuick(int slice, int row, int column) {
                    return this.content.getQuick(row, slice, column);
                }

                @Override
                public synchronized void setQuick(int slice, int row, int column, double value) {
                    this.content.setQuick(row, slice, column, value);
                }

                @Override
                public synchronized double get(int slice, int row, int column) {
                    return this.content.get(row, slice, column);
                }

                @Override
                public synchronized void set(int slice, int row, int column, double value) {
                    this.content.set(row, slice, column, value);
                }
            };
        } else if (axis0 == 1 && axis1 == 2 && axis2 == 0) {
            view = new WrapperDoubleMatrix3D(this){
                private static final long serialVersionUID = 1L;

                @Override
                public synchronized double getQuick(int slice, int row, int column) {
                    return this.content.getQuick(row, column, slice);
                }

                @Override
                public synchronized void setQuick(int slice, int row, int column, double value) {
                    this.content.setQuick(row, column, slice, value);
                }

                @Override
                public synchronized double get(int slice, int row, int column) {
                    return this.content.get(row, column, slice);
                }

                @Override
                public synchronized void set(int slice, int row, int column, double value) {
                    this.content.set(row, column, slice, value);
                }
            };
        } else if (axis0 == 2 && axis1 == 1 && axis2 == 0) {
            view = new WrapperDoubleMatrix3D(this){
                private static final long serialVersionUID = 1L;

                @Override
                public synchronized double getQuick(int slice, int row, int column) {
                    return this.content.getQuick(column, row, slice);
                }

                @Override
                public synchronized void setQuick(int slice, int row, int column, double value) {
                    this.content.setQuick(column, row, slice, value);
                }

                @Override
                public synchronized double get(int slice, int row, int column) {
                    return this.content.get(column, row, slice);
                }

                @Override
                public synchronized void set(int slice, int row, int column, double value) {
                    this.content.set(column, row, slice, value);
                }
            };
        } else if (axis0 == 2 && axis1 == 0 && axis2 == 1) {
            view = new WrapperDoubleMatrix3D(this){
                private static final long serialVersionUID = 1L;

                @Override
                public synchronized double getQuick(int slice, int row, int column) {
                    return this.content.getQuick(column, slice, row);
                }

                @Override
                public synchronized void setQuick(int slice, int row, int column, double value) {
                    this.content.setQuick(column, slice, row, value);
                }

                @Override
                public synchronized double get(int slice, int row, int column) {
                    return this.content.get(column, slice, row);
                }

                @Override
                public synchronized void set(int slice, int row, int column, double value) {
                    this.content.set(column, slice, row, value);
                }
            };
        }
        int[] shape = this.shape();
        view.slices = shape[axis0];
        view.rows = shape[axis1];
        view.columns = shape[axis2];
        view.isNoView = false;
        return view;
    }

    @Override
    public DoubleMatrix3D viewPart(final int slice, final int row, final int column, int depth, int height, int width) {
        this.checkBox(slice, row, column, depth, height, width);
        WrapperDoubleMatrix3D view = new WrapperDoubleMatrix3D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized double getQuick(int i, int j, int k) {
                return this.content.getQuick(slice + i, row + j, column + k);
            }

            @Override
            public synchronized void setQuick(int i, int j, int k, double value) {
                this.content.setQuick(slice + i, row + j, column + k, value);
            }

            @Override
            public synchronized double get(int i, int j, int k) {
                return this.content.get(slice + i, row + j, column + k);
            }

            @Override
            public synchronized void set(int i, int j, int k, double value) {
                this.content.set(slice + i, row + j, column + k, value);
            }
        };
        view.slices = depth;
        view.rows = height;
        view.columns = width;
        view.isNoView = false;
        return view;
    }

    @Override
    public DoubleMatrix2D viewRow(int row) {
        this.checkRow(row);
        return new DelegateDoubleMatrix2D(this, 1, row);
    }

    @Override
    public DoubleMatrix3D viewRowFlip() {
        if (this.rows == 0) {
            return this;
        }
        WrapperDoubleMatrix3D view = new WrapperDoubleMatrix3D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized double getQuick(int slice, int row, int column) {
                return this.content.getQuick(slice, this.rows - 1 - row, column);
            }

            @Override
            public synchronized void setQuick(int slice, int row, int column, double value) {
                this.content.setQuick(slice, this.rows - 1 - row, column, value);
            }

            @Override
            public synchronized double get(int slice, int row, int column) {
                return this.content.get(slice, this.rows - 1 - row, column);
            }

            @Override
            public synchronized void set(int slice, int row, int column, double value) {
                this.content.set(slice, this.rows - 1 - row, column, value);
            }
        };
        view.isNoView = false;
        return view;
    }

    @Override
    public DoubleMatrix3D viewSelection(int[] sliceIndexes, int[] rowIndexes, int[] columnIndexes) {
        int i;
        if (sliceIndexes == null) {
            sliceIndexes = new int[this.slices];
            i = this.slices;
            while (--i >= 0) {
                sliceIndexes[i] = i;
            }
        }
        if (rowIndexes == null) {
            rowIndexes = new int[this.rows];
            i = this.rows;
            while (--i >= 0) {
                rowIndexes[i] = i;
            }
        }
        if (columnIndexes == null) {
            columnIndexes = new int[this.columns];
            i = this.columns;
            while (--i >= 0) {
                columnIndexes[i] = i;
            }
        }
        this.checkSliceIndexes(sliceIndexes);
        this.checkRowIndexes(rowIndexes);
        this.checkColumnIndexes(columnIndexes);
        final int[] six = sliceIndexes;
        final int[] rix = rowIndexes;
        final int[] cix = columnIndexes;
        WrapperDoubleMatrix3D view = new WrapperDoubleMatrix3D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized double getQuick(int i, int j, int k) {
                return this.content.getQuick(six[i], rix[j], cix[k]);
            }

            @Override
            public synchronized void setQuick(int i, int j, int k, double value) {
                this.content.setQuick(six[i], rix[j], cix[k], value);
            }

            @Override
            public synchronized double get(int i, int j, int k) {
                return this.content.get(six[i], rix[j], cix[k]);
            }

            @Override
            public synchronized void set(int i, int j, int k, double value) {
                this.content.set(six[i], rix[j], cix[k], value);
            }
        };
        view.slices = sliceIndexes.length;
        view.rows = rowIndexes.length;
        view.columns = columnIndexes.length;
        view.isNoView = false;
        return view;
    }

    @Override
    public DoubleMatrix3D viewStrides(final int _sliceStride, final int _rowStride, final int _columnStride) {
        if (_sliceStride <= 0 || _rowStride <= 0 || _columnStride <= 0) {
            throw new IndexOutOfBoundsException("illegal stride");
        }
        WrapperDoubleMatrix3D view = new WrapperDoubleMatrix3D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized double getQuick(int slice, int row, int column) {
                return this.content.getQuick(_sliceStride * slice, _rowStride * row, _columnStride * column);
            }

            @Override
            public synchronized void setQuick(int slice, int row, int column, double value) {
                this.content.setQuick(_sliceStride * slice, _rowStride * row, _columnStride * column, value);
            }

            @Override
            public synchronized double get(int slice, int row, int column) {
                return this.content.get(_sliceStride * slice, _rowStride * row, _columnStride * column);
            }

            @Override
            public synchronized void set(int slice, int row, int column, double value) {
                this.content.set(_sliceStride * slice, _rowStride * row, _columnStride * column, value);
            }
        };
        if (this.slices != 0) {
            view.slices = (this.slices - 1) / _sliceStride + 1;
        }
        if (this.rows != 0) {
            view.rows = (this.rows - 1) / _rowStride + 1;
        }
        if (this.columns != 0) {
            view.columns = (this.columns - 1) / _columnStride + 1;
        }
        view.isNoView = false;
        return view;
    }

    @Override
    protected DoubleMatrix3D getContent() {
        return this.content;
    }

    @Override
    public DoubleMatrix2D like2D(int rows, int columns) {
        throw new InternalError();
    }

    @Override
    protected DoubleMatrix2D like2D(int rows, int columns, int rowZero, int columnZero, int rowStride, int columnStride) {
        throw new InternalError();
    }

    @Override
    protected DoubleMatrix3D viewSelectionLike(int[] sliceOffsets, int[] rowOffsets, int[] columnOffsets) {
        throw new InternalError();
    }
}

