/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.decomposition;

import cern.colt.function.tfloat.FloatFloatFunction;
import cern.colt.matrix.tfloat.FloatFactory2D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.DenseFloatAlgebra;
import cern.colt.matrix.tfloat.algo.FloatProperty;
import cern.jet.math.tfloat.FloatFunctions;
import java.io.Serializable;

public class DenseFloatQRDecomposition
implements Serializable {
    static final long serialVersionUID = 1020L;
    private FloatMatrix2D QR;
    private int m;
    private int n;
    private FloatMatrix1D Rdiag;

    public DenseFloatQRDecomposition(FloatMatrix2D A) {
        FloatProperty.DEFAULT.checkRectangular(A);
        FloatFunctions F = FloatFunctions.functions;
        this.QR = A.copy();
        this.m = A.rows();
        this.n = A.columns();
        this.Rdiag = A.like1D(this.n);
        FloatFloatFunction hypot = DenseFloatAlgebra.hypotFunction();
        FloatMatrix1D[] QRcolumns = new FloatMatrix1D[this.n];
        FloatMatrix1D[] QRcolumnsPart = new FloatMatrix1D[this.n];
        int k = 0;
        while (k < this.n) {
            QRcolumns[k] = this.QR.viewColumn(k);
            QRcolumnsPart[k] = this.QR.viewColumn(k).viewPart(k, this.m - k);
            ++k;
        }
        k = 0;
        while (k < this.n) {
            float nrm = 0.0f;
            int i = k;
            while (i < this.m) {
                nrm = DenseFloatAlgebra.hypot(nrm, this.QR.getQuick(i, k));
                ++i;
            }
            if ((double)nrm != 0.0) {
                if (this.QR.getQuick(k, k) < 0.0f) {
                    nrm = -nrm;
                }
                QRcolumnsPart[k].assign(FloatFunctions.div(nrm));
                this.QR.setQuick(k, k, this.QR.getQuick(k, k) + 1.0f);
                int j = k + 1;
                while (j < this.n) {
                    FloatMatrix1D QRcolj = this.QR.viewColumn(j).viewPart(k, this.m - k);
                    float s = QRcolumnsPart[k].zDotProduct(QRcolj);
                    s = -s / this.QR.getQuick(k, k);
                    int i2 = k;
                    while (i2 < this.m) {
                        this.QR.setQuick(i2, j, this.QR.getQuick(i2, j) + s * this.QR.getQuick(i2, k));
                        ++i2;
                    }
                    ++j;
                }
            }
            this.Rdiag.setQuick(k, -nrm);
            ++k;
        }
    }

    public FloatMatrix2D getH() {
        return DenseFloatAlgebra.DEFAULT.trapezoidalLower(this.QR.copy());
    }

    public FloatMatrix2D getQ() {
        FloatFunctions F = FloatFunctions.functions;
        FloatMatrix2D Q = this.QR.like();
        int k = this.n - 1;
        while (k >= 0) {
            FloatMatrix1D QRcolk = this.QR.viewColumn(k).viewPart(k, this.m - k);
            Q.setQuick(k, k, 1.0f);
            int j = k;
            while (j < this.n) {
                if (this.QR.getQuick(k, k) != 0.0f) {
                    FloatMatrix1D Qcolj = Q.viewColumn(j).viewPart(k, this.m - k);
                    float s = QRcolk.zDotProduct(Qcolj);
                    s = -s / this.QR.getQuick(k, k);
                    Qcolj.assign(QRcolk, FloatFunctions.plusMultSecond(s));
                }
                ++j;
            }
            --k;
        }
        return Q;
    }

    public FloatMatrix2D getR() {
        FloatMatrix2D R = this.QR.like(this.n, this.n);
        int i = 0;
        while (i < this.n) {
            int j = 0;
            while (j < this.n) {
                if (i < j) {
                    R.setQuick(i, j, this.QR.getQuick(i, j));
                } else if (i == j) {
                    R.setQuick(i, j, this.Rdiag.getQuick(i));
                } else {
                    R.setQuick(i, j, 0.0f);
                }
                ++j;
            }
            ++i;
        }
        return R;
    }

    public boolean hasFullRank() {
        int j = 0;
        while (j < this.n) {
            if (this.Rdiag.getQuick(j) == 0.0f) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public FloatMatrix1D solve(FloatMatrix1D b) {
        FloatFunctions F = FloatFunctions.functions;
        if (b.size() != (long)this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.hasFullRank()) {
            throw new IllegalArgumentException("Matrix is rank deficient.");
        }
        FloatMatrix1D x = b.copy();
        int k = 0;
        while (k < this.n) {
            float s = 0.0f;
            int i = k;
            while (i < this.m) {
                s += this.QR.getQuick(i, k) * x.getQuick(i);
                ++i;
            }
            s = -s / this.QR.getQuick(k, k);
            i = k;
            while (i < this.m) {
                x.setQuick(i, x.getQuick(i) + s * this.QR.getQuick(i, k));
                ++i;
            }
            ++k;
        }
        k = this.n - 1;
        while (k >= 0) {
            x.setQuick(k, x.getQuick(k) / this.Rdiag.getQuick(k));
            int i = 0;
            while (i < k) {
                x.setQuick(i, x.getQuick(i) - x.getQuick(k) * this.QR.getQuick(i, k));
                ++i;
            }
            --k;
        }
        return x.viewPart(0, this.n).copy();
    }

    public FloatMatrix2D solve(FloatMatrix2D B) {
        int j;
        FloatFunctions F = FloatFunctions.functions;
        if (B.rows() != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.hasFullRank()) {
            throw new IllegalArgumentException("Matrix is rank deficient.");
        }
        int nx = B.columns();
        FloatMatrix2D X = B.copy();
        int k = 0;
        while (k < this.n) {
            j = 0;
            while (j < nx) {
                float s = 0.0f;
                int i = k;
                while (i < this.m) {
                    s += this.QR.getQuick(i, k) * X.getQuick(i, j);
                    ++i;
                }
                s = -s / this.QR.getQuick(k, k);
                i = k;
                while (i < this.m) {
                    X.setQuick(i, j, X.getQuick(i, j) + s * this.QR.getQuick(i, k));
                    ++i;
                }
                ++j;
            }
            ++k;
        }
        k = this.n - 1;
        while (k >= 0) {
            j = 0;
            while (j < nx) {
                X.setQuick(k, j, X.getQuick(k, j) / this.Rdiag.getQuick(k));
                ++j;
            }
            int i = 0;
            while (i < k) {
                int j2 = 0;
                while (j2 < nx) {
                    X.setQuick(i, j2, X.getQuick(i, j2) - X.getQuick(k, j2) * this.QR.getQuick(i, k));
                    ++j2;
                }
                ++i;
            }
            --k;
        }
        return X.viewPart(0, 0, this.n, nx);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String unknown = "Illegal operation or error: ";
        buf.append("-----------------------------------------------------------------\n");
        buf.append("QRDecomposition(A) --> hasFullRank(A), H, Q, R, pseudo inverse(A)\n");
        buf.append("-----------------------------------------------------------------\n");
        buf.append("hasFullRank = ");
        try {
            buf.append(String.valueOf(this.hasFullRank()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(String.valueOf(unknown) + exc.getMessage());
        }
        buf.append("\n\nH = ");
        try {
            buf.append(String.valueOf(this.getH()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(String.valueOf(unknown) + exc.getMessage());
        }
        buf.append("\n\nQ = ");
        try {
            buf.append(String.valueOf(this.getQ()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(String.valueOf(unknown) + exc.getMessage());
        }
        buf.append("\n\nR = ");
        try {
            buf.append(String.valueOf(this.getR()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(String.valueOf(unknown) + exc.getMessage());
        }
        buf.append("\n\npseudo inverse(A) = ");
        try {
            buf.append(String.valueOf(this.solve(FloatFactory2D.dense.identity(this.QR.rows()))));
        }
        catch (IllegalArgumentException exc) {
            buf.append(String.valueOf(unknown) + exc.getMessage());
        }
        return buf.toString();
    }
}

