/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.map.tfloat.AbstractLongFloatMap;
import cern.colt.map.tfloat.OpenLongFloatHashMap;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.impl.SelectedSparseFloatMatrix3D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix2D;

public class SparseFloatMatrix3D
extends FloatMatrix3D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongFloatMap elements;

    public SparseFloatMatrix3D(float[][][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length, values.length == 0 ? 0 : (values[0].length == 0 ? 0 : values[0][0].length));
        this.assign(values);
    }

    public SparseFloatMatrix3D(int slices, int rows, int columns) {
        this(slices, rows, columns, slices * rows * (columns / 1000), 0.2f, 0.5f);
    }

    public SparseFloatMatrix3D(int slices, int rows, int columns, int initialCapacity, float minLoadFactor, float maxLoadFactor) {
        block2: {
            try {
                this.setUp(slices, rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.elements = new OpenLongFloatHashMap(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    protected SparseFloatMatrix3D(int slices, int rows, int columns, AbstractLongFloatMap elements, int sliceZero, int rowZero, int columnZero, int sliceStride, int rowStride, int columnStride) {
        block2: {
            try {
                this.setUp(slices, rows, columns, sliceZero, rowZero, columnZero, sliceStride, rowStride, columnStride);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.elements = elements;
        this.isNoView = false;
    }

    @Override
    public FloatMatrix3D assign(float value) {
        if (this.isNoView && value == 0.0f) {
            this.elements.clear();
        } else {
            super.assign(value);
        }
        return this;
    }

    @Override
    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    @Override
    public AbstractLongFloatMap elements() {
        return this.elements;
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        this.elements.ensureCapacity(minCapacity);
    }

    @Override
    public synchronized float getQuick(int slice, int row, int column) {
        return this.elements.get((long)this.sliceZero + (long)slice * (long)this.sliceStride + (long)this.rowZero + (long)row * (long)this.rowStride + (long)this.columnZero + (long)column * (long)this.columnStride);
    }

    @Override
    public long index(int slice, int row, int column) {
        return (long)this.sliceZero + (long)slice * (long)this.sliceStride + (long)this.rowZero + (long)row * (long)this.rowStride + (long)this.columnZero + (long)column * (long)this.columnStride;
    }

    @Override
    public FloatMatrix3D like(int slices, int rows, int columns) {
        return new SparseFloatMatrix3D(slices, rows, columns);
    }

    @Override
    public FloatMatrix2D like2D(int rows, int columns) {
        return new SparseFloatMatrix2D(rows, columns);
    }

    @Override
    public synchronized void setQuick(int slice, int row, int column, float value) {
        long index = (long)this.sliceZero + (long)slice * (long)this.sliceStride + (long)this.rowZero + (long)row * (long)this.rowStride + (long)this.columnZero + (long)column * (long)this.columnStride;
        if (value == 0.0f) {
            this.elements.removeKey(index);
        } else {
            this.elements.put(index, value);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.slices).append(" x ").append(this.rows).append(" x ").append(this.columns).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        int s = 0;
        while (s < this.slices) {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    float elem = this.getQuick(s, r, c);
                    if (elem != 0.0f) {
                        builder.append('(').append(s).append(',').append(r).append(',').append(c).append(')').append('\t').append(elem).append('\n');
                    }
                    ++c;
                }
                ++r;
            }
            ++s;
        }
        return builder.toString();
    }

    @Override
    public void trimToSize() {
        this.elements.trimToSize();
    }

    @Override
    public FloatMatrix1D vectorize() {
        SparseFloatMatrix1D v = new SparseFloatMatrix1D((int)this.size());
        int length = this.rows * this.columns;
        int s = 0;
        while (s < this.slices) {
            v.viewPart(s * length, length).assign(this.viewSlice(s).vectorize());
            ++s;
        }
        return v;
    }

    @Override
    protected boolean haveSharedCellsRaw(FloatMatrix3D other) {
        if (other instanceof SelectedSparseFloatMatrix3D) {
            SelectedSparseFloatMatrix3D otherMatrix = (SelectedSparseFloatMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof SparseFloatMatrix3D) {
            SparseFloatMatrix3D otherMatrix = (SparseFloatMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    protected FloatMatrix2D like2D(int rows, int columns, int rowZero, int columnZero, int rowStride, int columnStride) {
        return new SparseFloatMatrix2D(rows, columns, this.elements, rowZero, columnZero, rowStride, columnStride);
    }

    @Override
    protected FloatMatrix3D viewSelectionLike(int[] sliceOffsets, int[] rowOffsets, int[] columnOffsets) {
        return new SelectedSparseFloatMatrix3D(this.elements, sliceOffsets, rowOffsets, columnOffsets, 0);
    }
}

