/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong;

import cern.colt.ConcurrencyUtils;
import cern.colt.function.tlong.IntIntLongFunction;
import cern.colt.function.tlong.LongFunction;
import cern.colt.function.tlong.LongLongFunction;
import cern.colt.function.tlong.LongProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tlong.LongArrayList;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix1DProcedure;
import cern.colt.matrix.tlong.algo.LongFormatter;
import cern.colt.matrix.tlong.algo.LongProperty;
import cern.colt.matrix.tlong.algo.LongSorting;
import cern.colt.matrix.tlong.impl.DenseLongMatrix1D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix2D;
import cern.jet.math.tlong.LongFunctions;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class LongMatrix2D
extends AbstractMatrix2D {
    private static final long serialVersionUID = 1L;

    protected LongMatrix2D() {
    }

    public long aggregate(final LongLongFunction aggr, final LongFunction f) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        long a = 0L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long a = f.apply(LongMatrix2D.this.getQuick(firstRow, 0));
                        int d = 1;
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = d;
                            while (c < LongMatrix2D.this.columns) {
                                a = aggr.apply(a, f.apply(LongMatrix2D.this.getQuick(r, c)));
                                ++c;
                            }
                            d = 0;
                            ++r;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(0, 0));
            int d = 1;
            int r = 0;
            while (r < this.rows) {
                int c = d;
                while (c < this.columns) {
                    a = aggr.apply(a, f.apply(this.getQuick(r, c)));
                    ++c;
                }
                d = 0;
                ++r;
            }
        }
        return a;
    }

    public long aggregate(final LongLongFunction aggr, final LongFunction f, final LongProcedure cond) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        long a = 0L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long elem = LongMatrix2D.this.getQuick(firstRow, 0);
                        long a = 0L;
                        if (cond.apply(elem)) {
                            a = aggr.apply(a, f.apply(elem));
                        }
                        int d = 1;
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = d;
                            while (c < LongMatrix2D.this.columns) {
                                elem = LongMatrix2D.this.getQuick(r, c);
                                if (cond.apply(elem)) {
                                    a = aggr.apply(a, f.apply(elem));
                                }
                                ++c;
                            }
                            d = 0;
                            ++r;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            long elem = this.getQuick(0, 0);
            if (cond.apply(elem)) {
                a = aggr.apply(a, f.apply(elem));
            }
            int d = 1;
            int r = 0;
            while (r < this.rows) {
                int c = d;
                while (c < this.columns) {
                    elem = this.getQuick(r, c);
                    if (cond.apply(elem)) {
                        a = aggr.apply(a, f.apply(elem));
                    }
                    ++c;
                }
                d = 0;
                ++r;
            }
        }
        return a;
    }

    public long aggregate(final LongLongFunction aggr, final LongFunction f, IntArrayList rowList, IntArrayList columnList) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        int size = rowList.size();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        long a = 0L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long a = f.apply(LongMatrix2D.this.getQuick(rowElements[firstIdx], columnElements[firstIdx]));
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            long elem = LongMatrix2D.this.getQuick(rowElements[i], columnElements[i]);
                            a = aggr.apply(a, f.apply(elem));
                            ++i;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(rowElements[0], columnElements[0]));
            int i = 1;
            while (i < size) {
                long elem = this.getQuick(rowElements[i], columnElements[i]);
                a = aggr.apply(a, f.apply(elem));
                ++i;
            }
        }
        return a;
    }

    public long aggregate(final LongMatrix2D other, final LongLongFunction aggr, final LongLongFunction f) {
        this.checkShape(other);
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        long a = 0L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long a = f.apply(LongMatrix2D.this.getQuick(firstRow, 0), other.getQuick(firstRow, 0));
                        int d = 1;
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = d;
                            while (c < LongMatrix2D.this.columns) {
                                a = aggr.apply(a, f.apply(LongMatrix2D.this.getQuick(r, c), other.getQuick(r, c)));
                                ++c;
                            }
                            d = 0;
                            ++r;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(0, 0), other.getQuick(0, 0));
            int d = 1;
            int r = 0;
            while (r < this.rows) {
                int c = d;
                while (c < this.columns) {
                    a = aggr.apply(a, f.apply(this.getQuick(r, c), other.getQuick(r, c)));
                    ++c;
                }
                d = 0;
                ++r;
            }
        }
        return a;
    }

    public LongMatrix2D assign(final LongFunction f) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < LongMatrix2D.this.columns) {
                                LongMatrix2D.this.setQuick(r, c, f.apply(LongMatrix2D.this.getQuick(r, c)));
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    this.setQuick(r, c, f.apply(this.getQuick(r, c)));
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public LongMatrix2D assign(final LongProcedure cond, final LongFunction f) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < LongMatrix2D.this.columns) {
                                long elem = LongMatrix2D.this.getQuick(r, c);
                                if (cond.apply(elem)) {
                                    LongMatrix2D.this.setQuick(r, c, f.apply(elem));
                                }
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    long elem = this.getQuick(r, c);
                    if (cond.apply(elem)) {
                        this.setQuick(r, c, f.apply(elem));
                    }
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public LongMatrix2D assign(final LongProcedure cond, final long value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < LongMatrix2D.this.columns) {
                                long elem = LongMatrix2D.this.getQuick(r, c);
                                if (cond.apply(elem)) {
                                    LongMatrix2D.this.setQuick(r, c, value);
                                }
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    long elem = this.getQuick(r, c);
                    if (cond.apply(elem)) {
                        this.setQuick(r, c, value);
                    }
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public LongMatrix2D assign(final long value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < LongMatrix2D.this.columns) {
                                LongMatrix2D.this.setQuick(r, c, value);
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    this.setQuick(r, c, value);
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public LongMatrix2D assign(final long[] values) {
        if (values.length != this.rows * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + "rows()*columns()=" + this.rows() * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = firstRow * LongMatrix2D.this.columns;
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < LongMatrix2D.this.columns) {
                                LongMatrix2D.this.setQuick(r, c, values[idx++]);
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = 0;
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    this.setQuick(r, c, values[idx++]);
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public LongMatrix2D assign(final int[] values) {
        if (values.length != this.rows * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + "rows()*columns()=" + this.rows() * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = firstRow * LongMatrix2D.this.columns;
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < LongMatrix2D.this.columns) {
                                LongMatrix2D.this.setQuick(r, c, values[idx++]);
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = 0;
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    this.setQuick(r, c, values[idx++]);
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public LongMatrix2D assign(final long[][] values) {
        if (values.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + values.length + "rows()=" + this.rows());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            long[] currentRow = values[r];
                            if (currentRow.length != LongMatrix2D.this.columns) {
                                throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + LongMatrix2D.this.columns());
                            }
                            int c = 0;
                            while (c < LongMatrix2D.this.columns) {
                                LongMatrix2D.this.setQuick(r, c, currentRow[c]);
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                long[] currentRow = values[r];
                if (currentRow.length != this.columns) {
                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
                }
                int c = 0;
                while (c < this.columns) {
                    this.setQuick(r, c, currentRow[c]);
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public LongMatrix2D assign(LongMatrix2D other) {
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        final LongMatrix2D other_loc = this.haveSharedCells(other) ? other.copy() : other;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < LongMatrix2D.this.columns) {
                                LongMatrix2D.this.setQuick(r, c, other_loc.getQuick(r, c));
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    this.setQuick(r, c, other_loc.getQuick(r, c));
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public LongMatrix2D assign(final LongMatrix2D y, final LongLongFunction function) {
        this.checkShape(y);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < LongMatrix2D.this.columns) {
                                LongMatrix2D.this.setQuick(r, c, function.apply(LongMatrix2D.this.getQuick(r, c), y.getQuick(r, c)));
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    this.setQuick(r, c, function.apply(this.getQuick(r, c), y.getQuick(r, c)));
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public LongMatrix2D assign(final LongMatrix2D y, final LongLongFunction function, IntArrayList rowList, IntArrayList columnList) {
        this.checkShape(y);
        int size = rowList.size();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            LongMatrix2D.this.setQuick(rowElements[i], columnElements[i], function.apply(LongMatrix2D.this.getQuick(rowElements[i], columnElements[i]), y.getQuick(rowElements[i], columnElements[i])));
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < size) {
                this.setQuick(rowElements[i], columnElements[i], function.apply(this.getQuick(rowElements[i], columnElements[i]), y.getQuick(rowElements[i], columnElements[i])));
                ++i;
            }
        }
        return this;
    }

    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < LongMatrix2D.this.columns) {
                                if (LongMatrix2D.this.getQuick(r, c) != 0L) {
                                    ++cardinality;
                                }
                                ++c;
                            }
                            ++r;
                        }
                        return cardinality;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Integer)futures[j].get();
                    ++j;
                }
                cardinality = results[0];
                j = 1;
                while (j < nthreads) {
                    cardinality += results[j].intValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    if (this.getQuick(r, c) != 0L) {
                        ++cardinality;
                    }
                    ++c;
                }
                ++r;
            }
        }
        return cardinality;
    }

    public LongMatrix2D copy() {
        return this.like().assign(this);
    }

    public abstract Object elements();

    public boolean equals(long value) {
        return LongProperty.DEFAULT.equals(this, value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LongMatrix2D)) {
            return false;
        }
        return LongProperty.DEFAULT.equals(this, (LongMatrix2D)obj);
    }

    public LongMatrix2D forEachNonZero(final IntIntLongFunction function) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < LongMatrix2D.this.columns) {
                                long a;
                                long value = LongMatrix2D.this.getQuick(r, c);
                                if (value != 0L && (a = function.apply(r, c, value)) != value) {
                                    LongMatrix2D.this.setQuick(r, c, a);
                                }
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    long a;
                    long value = this.getQuick(r, c);
                    if (value != 0L && (a = function.apply(r, c, value)) != value) {
                        this.setQuick(r, c, a);
                    }
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public long get(int row, int column) {
        if (column < 0 || column >= this.columns || row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + row + ", column:" + column);
        }
        return this.getQuick(row, column);
    }

    protected LongMatrix2D getContent() {
        return this;
    }

    public void getNegativeValues(IntArrayList rowList, IntArrayList columnList, LongArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int r = 0;
        while (r < this.rows) {
            int c = 0;
            while (c < this.columns) {
                long value = this.getQuick(r, c);
                if (value < 0L) {
                    rowList.add(r);
                    columnList.add(c);
                    valueList.add(value);
                }
                ++c;
            }
            ++r;
        }
    }

    public void getNonZeros(IntArrayList rowList, IntArrayList columnList, LongArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int r = 0;
        while (r < this.rows) {
            int c = 0;
            while (c < this.columns) {
                long value = this.getQuick(r, c);
                if (value != 0L) {
                    rowList.add(r);
                    columnList.add(c);
                    valueList.add(value);
                }
                ++c;
            }
            ++r;
        }
    }

    public void getPositiveValues(IntArrayList rowList, IntArrayList columnList, LongArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int r = 0;
        while (r < this.rows) {
            int c = 0;
            while (c < this.columns) {
                long value = this.getQuick(r, c);
                if (value > 0L) {
                    rowList.add(r);
                    columnList.add(c);
                    valueList.add(value);
                }
                ++c;
            }
            ++r;
        }
    }

    public abstract long getQuick(int var1, int var2);

    protected boolean haveSharedCells(LongMatrix2D other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(other.getContent());
    }

    protected boolean haveSharedCellsRaw(LongMatrix2D other) {
        return false;
    }

    public LongMatrix2D like() {
        return this.like(this.rows, this.columns);
    }

    public abstract LongMatrix2D like(int var1, int var2);

    public abstract LongMatrix1D like1D(int var1);

    protected abstract LongMatrix1D like1D(int var1, int var2, int var3);

    public long[] getMaxLocation() {
        int rowLocation = 0;
        int columnLocation = 0;
        long maxValue = 0L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            long[][] results = new long[nthreads][2];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<long[]>(){

                    @Override
                    public long[] call() throws Exception {
                        int rowLocation = firstRow;
                        int columnLocation = 0;
                        long maxValue = LongMatrix2D.this.getQuick(rowLocation, 0);
                        int d = 1;
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = d;
                            while (c < LongMatrix2D.this.columns) {
                                long elem = LongMatrix2D.this.getQuick(r, c);
                                if (maxValue < elem) {
                                    maxValue = elem;
                                    rowLocation = r;
                                    columnLocation = c;
                                }
                                ++c;
                            }
                            d = 0;
                            ++r;
                        }
                        return new long[]{maxValue, rowLocation, columnLocation};
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (long[])futures[j].get();
                    ++j;
                }
                maxValue = results[0][0];
                rowLocation = (int)results[0][1];
                columnLocation = (int)results[0][2];
                j = 1;
                while (j < nthreads) {
                    if (maxValue < results[j][0]) {
                        maxValue = results[j][0];
                        rowLocation = (int)results[j][1];
                        columnLocation = (int)results[j][2];
                    }
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            maxValue = this.getQuick(0, 0);
            int d = 1;
            int r = 0;
            while (r < this.rows) {
                int c = d;
                while (c < this.columns) {
                    long elem = this.getQuick(r, c);
                    if (maxValue < elem) {
                        maxValue = elem;
                        rowLocation = r;
                        columnLocation = c;
                    }
                    ++c;
                }
                d = 0;
                ++r;
            }
        }
        return new long[]{maxValue, rowLocation, columnLocation};
    }

    public long[] getMinLocation() {
        int rowLocation = 0;
        int columnLocation = 0;
        long minValue = 0L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            long[][] results = new long[nthreads][2];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<long[]>(){

                    @Override
                    public long[] call() throws Exception {
                        int rowLocation = firstRow;
                        int columnLocation = 0;
                        long minValue = LongMatrix2D.this.getQuick(rowLocation, 0);
                        int d = 1;
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = d;
                            while (c < LongMatrix2D.this.columns) {
                                long elem = LongMatrix2D.this.getQuick(r, c);
                                if (minValue > elem) {
                                    minValue = elem;
                                    rowLocation = r;
                                    columnLocation = c;
                                }
                                ++c;
                            }
                            d = 0;
                            ++r;
                        }
                        return new long[]{minValue, rowLocation, columnLocation};
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (long[])futures[j].get();
                    ++j;
                }
                minValue = results[0][0];
                rowLocation = (int)results[0][1];
                columnLocation = (int)results[0][2];
                j = 1;
                while (j < nthreads) {
                    if (minValue > results[j][0]) {
                        minValue = results[j][0];
                        rowLocation = (int)results[j][1];
                        columnLocation = (int)results[j][2];
                    }
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            minValue = this.getQuick(0, 0);
            int d = 1;
            int r = 0;
            while (r < this.rows) {
                int c = d;
                while (c < this.columns) {
                    long elem = this.getQuick(r, c);
                    if (minValue > elem) {
                        minValue = elem;
                        rowLocation = r;
                        columnLocation = c;
                    }
                    ++c;
                }
                d = 0;
                ++r;
            }
        }
        return new long[]{minValue, rowLocation, columnLocation};
    }

    public void set(int row, int column, long value) {
        if (column < 0 || column >= this.columns || row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + row + ", column:" + column);
        }
        this.setQuick(row, column, value);
    }

    public abstract void setQuick(int var1, int var2, long var3);

    public long[][] toArray() {
        final long[][] values = new long[this.rows][this.columns];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            long[] currentRow = values[r];
                            int c = 0;
                            while (c < LongMatrix2D.this.columns) {
                                currentRow[c] = LongMatrix2D.this.getQuick(r, c);
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                long[] currentRow = values[r];
                int c = 0;
                while (c < this.columns) {
                    currentRow[c] = this.getQuick(r, c);
                    ++c;
                }
                ++r;
            }
        }
        return values;
    }

    public String toString() {
        return new LongFormatter().toString(this);
    }

    public abstract LongMatrix1D vectorize();

    protected LongMatrix2D view() {
        return (LongMatrix2D)this.clone();
    }

    public LongMatrix1D viewColumn(int column) {
        this.checkColumn(column);
        int viewSize = this.rows;
        int viewZero = (int)this.index(0, column);
        int viewStride = this.rowStride;
        return this.like1D(viewSize, viewZero, viewStride);
    }

    public LongMatrix2D viewColumnFlip() {
        return (LongMatrix2D)this.view().vColumnFlip();
    }

    public LongMatrix2D viewDice() {
        return (LongMatrix2D)this.view().vDice();
    }

    public LongMatrix2D viewPart(int row, int column, int height, int width) {
        return (LongMatrix2D)this.view().vPart(row, column, height, width);
    }

    public LongMatrix1D viewRow(int row) {
        this.checkRow(row);
        int viewSize = this.columns;
        int viewZero = (int)this.index(row, 0);
        int viewStride = this.columnStride;
        return this.like1D(viewSize, viewZero, viewStride);
    }

    public LongMatrix2D viewRowFlip() {
        return (LongMatrix2D)this.view().vRowFlip();
    }

    public LongMatrix2D viewSelection(LongMatrix1DProcedure condition) {
        IntArrayList matches = new IntArrayList();
        int i = 0;
        while (i < this.rows) {
            if (condition.apply(this.viewRow(i))) {
                matches.add(i);
            }
            ++i;
        }
        matches.trimToSize();
        return this.viewSelection(matches.elements(), null);
    }

    public LongMatrix2D viewSelection(int[] rowIndexes, int[] columnIndexes) {
        int i;
        if (rowIndexes == null) {
            rowIndexes = new int[this.rows];
            i = 0;
            while (i < this.rows) {
                rowIndexes[i] = i;
                ++i;
            }
        }
        if (columnIndexes == null) {
            columnIndexes = new int[this.columns];
            i = 0;
            while (i < this.columns) {
                columnIndexes[i] = i;
                ++i;
            }
        }
        this.checkRowIndexes(rowIndexes);
        this.checkColumnIndexes(columnIndexes);
        int[] rowOffsets = new int[rowIndexes.length];
        int[] columnOffsets = new int[columnIndexes.length];
        int i2 = 0;
        while (i2 < rowIndexes.length) {
            rowOffsets[i2] = this._rowOffset(this._rowRank(rowIndexes[i2]));
            ++i2;
        }
        i2 = 0;
        while (i2 < columnIndexes.length) {
            columnOffsets[i2] = this._columnOffset(this._columnRank(columnIndexes[i2]));
            ++i2;
        }
        return this.viewSelectionLike(rowOffsets, columnOffsets);
    }

    public LongMatrix2D viewSelection(Set<int[]> indexes) {
        int n = indexes.size();
        int[] rowIndexes = new int[n];
        int[] columnIndexes = new int[n];
        int idx = 0;
        for (int[] is : indexes) {
            rowIndexes[idx] = is[0];
            columnIndexes[idx] = is[1];
            ++idx;
        }
        this.checkRowIndexes(rowIndexes);
        this.checkColumnIndexes(columnIndexes);
        int[] rowOffsets = new int[rowIndexes.length];
        int[] columnOffsets = new int[columnIndexes.length];
        int i = 0;
        while (i < rowIndexes.length) {
            rowOffsets[i] = this._rowOffset(this._rowRank(rowIndexes[i]));
            ++i;
        }
        i = 0;
        while (i < columnIndexes.length) {
            columnOffsets[i] = this._columnOffset(this._columnRank(columnIndexes[i]));
            ++i;
        }
        return this.viewSelectionLike(rowOffsets, columnOffsets);
    }

    protected abstract LongMatrix2D viewSelectionLike(int[] var1, int[] var2);

    public LongMatrix2D viewSorted(int column) {
        return LongSorting.mergeSort.sort(this, column);
    }

    public LongMatrix2D viewStrides(int rowStride, int columnStride) {
        return (LongMatrix2D)this.view().vStrides(rowStride, columnStride);
    }

    public LongMatrix1D zMult(LongMatrix1D y, LongMatrix1D z) {
        return this.zMult(y, z, 1L, z == null ? 1 : 0, false);
    }

    public LongMatrix1D zMult(final LongMatrix1D y, LongMatrix1D z, final long alpha, final long beta, boolean transposeA) {
        if (transposeA) {
            return this.viewDice().zMult(y, z, alpha, beta, false);
        }
        final LongMatrix1D z_loc = z == null ? new DenseLongMatrix1D(this.rows) : z;
        if ((long)this.columns != y.size() || (long)this.rows > z_loc.size()) {
            throw new IllegalArgumentException("Incompatible args: " + this.toStringShort() + ", " + y.toStringShort() + ", " + z_loc.toStringShort());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int s = 0;
                            int c = 0;
                            while (c < LongMatrix2D.this.columns) {
                                s = (int)((long)s + LongMatrix2D.this.getQuick(r, c) * y.getQuick(c));
                                ++c;
                            }
                            z_loc.setQuick(r, alpha * (long)s + beta * z_loc.getQuick(r));
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                int s = 0;
                int c = 0;
                while (c < this.columns) {
                    s = (int)((long)s + this.getQuick(r, c) * y.getQuick(c));
                    ++c;
                }
                z_loc.setQuick(r, alpha * (long)s + beta * z_loc.getQuick(r));
                ++r;
            }
        }
        return z_loc;
    }

    public LongMatrix2D zMult(LongMatrix2D B, LongMatrix2D C) {
        return this.zMult(B, C, 1L, C == null ? 1 : 0, false, false);
    }

    public LongMatrix2D zMult(final LongMatrix2D B, LongMatrix2D C, final long alpha, final long beta, boolean transposeA, boolean transposeB) {
        if (transposeA) {
            return this.viewDice().zMult(B, C, alpha, beta, false, transposeB);
        }
        if (transposeB) {
            return this.zMult(B.viewDice(), C, alpha, beta, transposeA, false);
        }
        final int m = this.rows;
        final int n = this.columns;
        int p = B.columns;
        final LongMatrix2D C_loc = C == null ? new DenseLongMatrix2D(m, p) : C;
        if (B.rows != n) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + B.toStringShort());
        }
        if (C_loc.rows != m || C_loc.columns != p) {
            throw new IllegalArgumentException("Incompatibe result matrix: " + this.toStringShort() + ", " + B.toStringShort() + ", " + C_loc.toStringShort());
        }
        if (this == C_loc || B == C_loc) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, p);
            Future[] futures = new Future[nthreads];
            int k = p / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? p : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int a = firstIdx;
                        while (a < lastIdx) {
                            int b = 0;
                            while (b < m) {
                                int s = 0;
                                int c = 0;
                                while (c < n) {
                                    s = (int)((long)s + LongMatrix2D.this.getQuick(b, c) * B.getQuick(c, a));
                                    ++c;
                                }
                                C_loc.setQuick(b, a, alpha * (long)s + beta * C_loc.getQuick(b, a));
                                ++b;
                            }
                            ++a;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int a = 0;
            while (a < p) {
                int b = 0;
                while (b < m) {
                    long s = 0L;
                    int c = 0;
                    while (c < n) {
                        s += this.getQuick(b, c) * B.getQuick(c, a);
                        ++c;
                    }
                    C_loc.setQuick(b, a, alpha * s + beta * C_loc.getQuick(b, a));
                    ++b;
                }
                ++a;
            }
        }
        return C_loc;
    }

    public long zSum() {
        if (this.size() == 0L) {
            return 0L;
        }
        return this.aggregate(LongFunctions.plus, LongFunctions.identity);
    }
}

