/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.tdouble.quantile;

class DoubleQuantileCalc {
    DoubleQuantileCalc() {
    }

    public static double binomial(long n, long k) {
        if (k == 0L || k == n) {
            return 1.0;
        }
        if ((double)k > (double)n / 2.0) {
            k = n - k;
        }
        double binomial = 1.0;
        long N = n - k + 1L;
        long i = k;
        while (i > 0L) {
            binomial *= (double)N++ / (double)i--;
        }
        return binomial;
    }

    public static long ceiling(double value) {
        return Math.round(Math.ceil(value));
    }

    public static long[] known_N_compute_B_and_K(long N, double epsilon, double delta, int quantiles, double[] returnSamplingRate) {
        if (delta > 0.0) {
            return DoubleQuantileCalc.known_N_compute_B_and_K_slow(N, epsilon, delta, quantiles, returnSamplingRate);
        }
        returnSamplingRate[0] = 1.0;
        return DoubleQuantileCalc.known_N_compute_B_and_K_quick(N, epsilon);
    }

    protected static long[] known_N_compute_B_and_K_quick(long N, double epsilon) {
        long k;
        long b;
        if (epsilon <= 0.0) {
            long[] result = new long[]{1L, N};
            return result;
        }
        int maxBuffers = 50;
        int maxHeight = 50;
        double N_double = N;
        double c = N_double * epsilon * 2.0;
        int[] heightMaximums = new int[49];
        int b2 = 2;
        while (b2 <= 50) {
            int h = 3;
            while (h <= 50 && (double)(h - 2) * (double)Math.round(DoubleQuantileCalc.binomial(b2 + h - 2, h - 1)) - (double)Math.round(DoubleQuantileCalc.binomial(b2 + h - 3, h - 3)) + (double)Math.round(DoubleQuantileCalc.binomial(b2 + h - 3, h - 2)) - c > 0.0) {
                ++h;
            }
            while (h <= 50 && (double)(h - 2) * (double)Math.round(DoubleQuantileCalc.binomial(b2 + h - 2, h - 1)) - (double)Math.round(DoubleQuantileCalc.binomial(b2 + h - 3, h - 3)) + (double)Math.round(DoubleQuantileCalc.binomial(b2 + h - 3, h - 2)) - c <= 0.0) {
                ++h;
            }
            int hMax = --h >= 50 && (double)(h - 2) * (double)Math.round(DoubleQuantileCalc.binomial(b2 + h - 2, h - 1)) - (double)Math.round(DoubleQuantileCalc.binomial(b2 + h - 3, h - 3)) + (double)Math.round(DoubleQuantileCalc.binomial(b2 + h - 3, h - 2)) - c > 0.0 ? Integer.MIN_VALUE : h;
            heightMaximums[b2 - 2] = hMax;
            ++b2;
        }
        long[] kMinimums = new long[49];
        int b3 = 2;
        while (b3 <= 50) {
            double value;
            long tmpK;
            int h = heightMaximums[b3 - 2];
            long kMin = Long.MAX_VALUE;
            if (h > Integer.MIN_VALUE && (tmpK = DoubleQuantileCalc.ceiling(N_double / (value = (double)Math.round(DoubleQuantileCalc.binomial(b3 + h - 2, h - 1))))) <= Long.MAX_VALUE) {
                kMin = tmpK;
            }
            kMinimums[b3 - 2] = kMin;
            ++b3;
        }
        long multMin = Long.MAX_VALUE;
        int minB = -1;
        int b4 = 2;
        while (b4 <= 50) {
            long mult;
            if (kMinimums[b4 - 2] < Long.MAX_VALUE && (mult = (long)b4 * kMinimums[b4 - 2]) < multMin) {
                multMin = mult;
                minB = b4;
            }
            ++b4;
        }
        if (minB != -1) {
            b = minB;
            k = kMinimums[minB - 2];
        } else {
            b = 1L;
            k = N;
        }
        long[] result = new long[]{b, k};
        return result;
    }

    protected static long[] known_N_compute_B_and_K_slow(long N, double epsilon, double delta, int quantiles, double[] returnSamplingRate) {
        if (epsilon <= 0.0) {
            long[] result = new long[]{1L, N};
            returnSamplingRate[0] = 1.0;
            return result;
        }
        int maxBuffers = 50;
        int maxHeight = 50;
        double N_double = N;
        long ret_b = 1L;
        long ret_k = N;
        double sampling_rate = 1.0;
        long memory = N;
        double logarithm = Math.log(2.0 * (double)quantiles / delta);
        double c = 2.0 * epsilon * N_double;
        long b = 2L;
        while (b < 50L) {
            long h = 3L;
            while (h < 50L) {
                double binomial = DoubleQuantileCalc.binomial(b + h - 2L, h - 1L);
                long tmp = DoubleQuantileCalc.ceiling(N_double / binomial);
                if (b * tmp < memory && (double)(h - 2L) * binomial - DoubleQuantileCalc.binomial(b + h - 3L, h - 3L) + DoubleQuantileCalc.binomial(b + h - 3L, h - 2L) <= c) {
                    ret_k = tmp;
                    ret_b = b;
                    memory = ret_k * b;
                    sampling_rate = 1.0;
                }
                if (delta > 0.0) {
                    double t = (double)(h - 2L) * DoubleQuantileCalc.binomial(b + h - 2L, h - 1L) - DoubleQuantileCalc.binomial(b + h - 3L, h - 3L) + DoubleQuantileCalc.binomial(b + h - 3L, h - 2L);
                    double u = logarithm / epsilon;
                    double v = DoubleQuantileCalc.binomial(b + h - 2L, h - 1L);
                    double w = logarithm / (2.0 * epsilon * epsilon);
                    double x = 0.5 + 0.5 * Math.sqrt(1.0 + 4.0 * t / u);
                    long k = DoubleQuantileCalc.ceiling(w * x * x / v);
                    if (b * k < memory) {
                        ret_k = k;
                        ret_b = b;
                        memory = b * k;
                        sampling_rate = N_double * 2.0 * epsilon * epsilon / logarithm;
                    }
                }
                ++h;
            }
            ++b;
        }
        long[] result = new long[]{ret_b, ret_k};
        returnSamplingRate[0] = sampling_rate;
        return result;
    }

    public static void main(String[] args) {
        DoubleQuantileCalc.test_B_and_K_Calculation(args);
    }

    public static void test_B_and_K_Calculation(String[] args) {
        boolean known_N = args == null ? false : new Boolean(args[0]);
        int[] quantiles = new int[]{1, 1000};
        long[] sizes = new long[]{100000L, 1000000L, 10000000L, 1000000000L};
        double[] deltas = new double[]{0.0, 0.001, 1.0E-4, 1.0E-5};
        double[] epsilons = new double[]{0.0, 0.1, 0.05, 0.01, 0.005, 0.001, 1.0E-7};
        if (!known_N) {
            sizes = new long[1];
        }
        System.out.println("\n\n");
        if (known_N) {
            System.out.println("Computing b's and k's for KNOWN N");
        } else {
            System.out.println("Computing b's and k's for UNKNOWN N");
        }
        System.out.println("mem [elements/1024]");
        System.out.println("***********************************");
        int q = 0;
        while (q < quantiles.length) {
            int p = quantiles[q];
            System.out.println("------------------------------");
            System.out.println("computing for p = " + p);
            int s = 0;
            while (s < sizes.length) {
                long N = sizes[s];
                System.out.println("   ------------------------------");
                System.out.println("   computing for N = " + N);
                int d = 0;
                while (d < deltas.length) {
                    double delta = deltas[d];
                    System.out.println("      ------------------------------");
                    System.out.println("      computing for delta = " + delta);
                    int e = 0;
                    while (e < epsilons.length) {
                        double epsilon = epsilons[e];
                        double[] returnSamplingRate = new double[1];
                        long[] result = known_N ? DoubleQuantileCalc.known_N_compute_B_and_K(N, epsilon, delta, p, returnSamplingRate) : DoubleQuantileCalc.unknown_N_compute_B_and_K(epsilon, delta, p);
                        long b = result[0];
                        long k = result[1];
                        System.out.print("         (e,d,N,p)=(" + epsilon + "," + delta + "," + N + "," + p + ") --> ");
                        System.out.print("(b,k,mem");
                        if (known_N) {
                            System.out.print(",sampling");
                        }
                        System.out.print(")=(" + b + "," + k + "," + b * k / 1024L);
                        if (known_N) {
                            System.out.print("," + returnSamplingRate[0]);
                        }
                        System.out.println(")");
                        ++e;
                    }
                    ++d;
                }
                ++s;
            }
            ++q;
        }
    }

    public static long[] unknown_N_compute_B_and_K(double epsilon, double delta, int quantiles) {
        if (epsilon <= 0.0 || delta <= 0.0) {
            long[] result = new long[]{1L, Long.MAX_VALUE, Long.MAX_VALUE};
            return result;
        }
        int max_b = 50;
        int max_h = 50;
        int max_H = 50;
        int max_Iterations = 2;
        long best_b = Long.MAX_VALUE;
        long best_k = Long.MAX_VALUE;
        long best_h = Long.MAX_VALUE;
        long best_memory = Long.MAX_VALUE;
        double pow = Math.pow(2.0, max_H);
        double logDelta = Math.log(2.0 / (delta / (double)quantiles)) / (2.0 * epsilon * epsilon);
        while (best_b == Long.MAX_VALUE && max_Iterations-- > 0) {
            int b = 2;
            while (b <= max_b) {
                int h = 2;
                while (h <= max_h) {
                    double beta;
                    double cc;
                    double d;
                    double Ls;
                    double Ld = DoubleQuantileCalc.binomial(b + h - 2, h - 1);
                    double c = logDelta / Math.min(Ld, 8.0 * (Ls = DoubleQuantileCalc.binomial(b + h - 3, h - 1)) / 3.0);
                    double f = c * c + 4.0 * c * (d = ((double)(h + 3) + (cc = ((beta = Ld / Ls) - 2.0) * ((double)max_H - 2.0) / (beta + pow - 2.0))) / (2.0 * epsilon));
                    if (!(f < 0.0)) {
                        double root = Math.sqrt(f);
                        double alpha_one = (c + 2.0 * d + root) / (2.0 * d);
                        double alpha_two = (c + 2.0 * d - root) / (2.0 * d);
                        boolean alpha_one_OK = false;
                        boolean alpha_two_OK = false;
                        if (0.0 < alpha_one && alpha_one < 1.0) {
                            alpha_one_OK = true;
                        }
                        if (0.0 < alpha_two && alpha_two < 1.0) {
                            alpha_two_OK = true;
                        }
                        if (alpha_one_OK || alpha_two_OK) {
                            long memory;
                            double alpha = alpha_one;
                            if (alpha_one_OK && alpha_two_OK) {
                                alpha = Math.max(alpha_one, alpha_two);
                            } else if (alpha_two_OK) {
                                alpha = alpha_two;
                            }
                            long k = DoubleQuantileCalc.ceiling(Math.max(d / alpha, (double)(h + 1) / (2.0 * epsilon)));
                            if (k > 0L && (memory = (long)b * k) < best_memory) {
                                best_k = k;
                                best_b = b;
                                best_h = h;
                                best_memory = memory;
                            }
                        }
                    }
                    ++h;
                }
                ++b;
            }
            if (best_b != Long.MAX_VALUE) continue;
            System.out.println("Warning: Computing b and k looks like a lot of work!");
            max_b *= 2;
            max_h *= 2;
            max_H *= 2;
        }
        long[] result = new long[3];
        if (best_b == Long.MAX_VALUE) {
            result[0] = 1L;
            result[1] = Long.MAX_VALUE;
            result[2] = Long.MAX_VALUE;
        } else {
            result[0] = best_b;
            result[1] = best_k;
            result[2] = best_h;
        }
        return result;
    }
}

