/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.csparsej.tdouble.demo;

import edu.emory.mathcs.csparsej.tdouble.Dcs_add;
import edu.emory.mathcs.csparsej.tdouble.Dcs_chol;
import edu.emory.mathcs.csparsej.tdouble.Dcs_cholsol;
import edu.emory.mathcs.csparsej.tdouble.Dcs_common;
import edu.emory.mathcs.csparsej.tdouble.Dcs_compress;
import edu.emory.mathcs.csparsej.tdouble.Dcs_dmperm;
import edu.emory.mathcs.csparsej.tdouble.Dcs_droptol;
import edu.emory.mathcs.csparsej.tdouble.Dcs_dropzeros;
import edu.emory.mathcs.csparsej.tdouble.Dcs_dupl;
import edu.emory.mathcs.csparsej.tdouble.Dcs_fkeep;
import edu.emory.mathcs.csparsej.tdouble.Dcs_gaxpy;
import edu.emory.mathcs.csparsej.tdouble.Dcs_ifkeep;
import edu.emory.mathcs.csparsej.tdouble.Dcs_ipvec;
import edu.emory.mathcs.csparsej.tdouble.Dcs_load;
import edu.emory.mathcs.csparsej.tdouble.Dcs_lsolve;
import edu.emory.mathcs.csparsej.tdouble.Dcs_ltsolve;
import edu.emory.mathcs.csparsej.tdouble.Dcs_lusol;
import edu.emory.mathcs.csparsej.tdouble.Dcs_multiply;
import edu.emory.mathcs.csparsej.tdouble.Dcs_norm;
import edu.emory.mathcs.csparsej.tdouble.Dcs_permute;
import edu.emory.mathcs.csparsej.tdouble.Dcs_pinv;
import edu.emory.mathcs.csparsej.tdouble.Dcs_pvec;
import edu.emory.mathcs.csparsej.tdouble.Dcs_qrsol;
import edu.emory.mathcs.csparsej.tdouble.Dcs_schol;
import edu.emory.mathcs.csparsej.tdouble.Dcs_transpose;
import edu.emory.mathcs.csparsej.tdouble.Dcs_updown;
import edu.emory.mathcs.csparsej.tdouble.Dcs_util;
import java.util.Random;

public class Dcs_demo {
    private static int is_sym(Dcs_common.Dcs dcs) {
        int n = dcs.n;
        int n2 = dcs.m;
        int[] nArray = dcs.p;
        int[] nArray2 = dcs.i;
        if (n2 != n) {
            return 0;
        }
        boolean bl = true;
        boolean bl2 = true;
        for (int i = 0; i < n; ++i) {
            for (int j = nArray[i]; j < nArray[i + 1]; ++j) {
                if (nArray2[j] > i) {
                    bl = false;
                }
                if (nArray2[j] >= i) continue;
                bl2 = false;
            }
        }
        return bl ? 1 : (bl2 ? -1 : 0);
    }

    private static Dcs_common.Dcs make_sym(Dcs_common.Dcs dcs) {
        Dcs_common.Dcs dcs2 = Dcs_transpose.cs_transpose(dcs, true);
        Dcs_fkeep.cs_fkeep(dcs2, new Dropdiag(), null);
        Dcs_common.Dcs dcs3 = Dcs_add.cs_add(dcs, dcs2, 1.0, 1.0);
        return dcs3;
    }

    private static void rhs(double[] dArray, double[] dArray2, int n) {
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            dArray2[n2] = 1.0 + (double)n2 / (double)n;
        }
        for (n2 = 0; n2 < n; ++n2) {
            dArray[n2] = dArray2[n2];
        }
    }

    private static double norm(double[] dArray, int n) {
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d = Math.max(d, Math.abs(dArray[i]));
        }
        return d;
    }

    private static void print_resid(boolean bl, Dcs_common.Dcs dcs, double[] dArray, double[] dArray2, double[] dArray3) {
        if (!bl) {
            System.out.print("    (failed)\n");
            return;
        }
        int n = dcs.m;
        int n2 = dcs.n;
        for (int i = 0; i < n; ++i) {
            dArray3[i] = -dArray2[i];
        }
        Dcs_gaxpy.cs_gaxpy(dcs, dArray, dArray3);
        System.out.print(String.format("resid: %8.2e\n", Dcs_demo.norm(dArray3, n) / (n2 == 0 ? 1.0 : Dcs_norm.cs_norm(dcs) * Dcs_demo.norm(dArray, n2) + Dcs_demo.norm(dArray2, n))));
    }

    private static double tic() {
        return System.nanoTime();
    }

    private static double toc(double d) {
        double d2 = Dcs_demo.tic();
        return Math.max(0.0, d2 - d) / 1000000.0;
    }

    private static void print_order(int n) {
        switch (n) {
            case 0: {
                System.out.print("natural    ");
                break;
            }
            case 1: {
                System.out.print("amd(A+A')  ");
                break;
            }
            case 2: {
                System.out.print("amd(S'*S)  ");
                break;
            }
            case 3: {
                System.out.print("amd(A'*A)  ");
            }
        }
    }

    public static Dproblem get_problem(String string, boolean bl, double d) {
        int n;
        Dcs_common.Dcs dcs;
        Dproblem dproblem = new Dproblem();
        Dcs_common.Dcs dcs2 = Dcs_load.cs_load(string, bl);
        dproblem.A = dcs = Dcs_compress.cs_compress(dcs2);
        dcs2 = null;
        Dcs_dupl.cs_dupl(dcs);
        dproblem.sym = n = Dcs_demo.is_sym(dcs);
        int n2 = dcs.m;
        int n3 = dcs.n;
        int n4 = Math.max(n2, n3);
        int n5 = dcs.p[n3];
        Dcs_dropzeros.cs_dropzeros(dcs);
        int n6 = dcs.p[n3];
        if (d > 0.0) {
            Dcs_droptol.cs_droptol(dcs, d);
        }
        Dcs_common.Dcs dcs3 = n != 0 ? Dcs_demo.make_sym(dcs) : dcs;
        dproblem.C = dcs3;
        if (dcs3 == null) {
            return null;
        }
        System.out.print(String.format("\n--- Matrix: %d-by-%d, nnz: %d (sym: %d: nnz %d), norm: %8.2e\n", n2, n3, dcs.p[n3], n, n != 0 ? dcs3.p[n3] : 0, Dcs_norm.cs_norm(dcs3)));
        if (n5 != n6) {
            System.out.print(String.format("zero entries dropped: %d\n", n5 - n6));
        }
        if (n6 != dcs.p[n3]) {
            System.out.print(String.format("tiny entries dropped: %d\n", n6 - dcs.p[n3]));
        }
        dproblem.b = new double[n4];
        dproblem.x = new double[n4];
        dproblem.resid = new double[n4];
        return dproblem;
    }

    public static boolean demo2(Dproblem dproblem) {
        boolean bl;
        double d;
        int n;
        if (dproblem == null) {
            return false;
        }
        Dcs_common.Dcs dcs = dproblem.A;
        Dcs_common.Dcs dcs2 = dproblem.C;
        double[] dArray = dproblem.b;
        double[] dArray2 = dproblem.x;
        double[] dArray3 = dproblem.resid;
        int n2 = dcs.m;
        int n3 = dcs.n;
        double d2 = dproblem.sym != 0 ? 0.001 : 1.0;
        Dcs_common.Dcsd dcsd = Dcs_dmperm.cs_dmperm(dcs2, 1);
        if (dcsd == null) {
            return false;
        }
        int n4 = dcsd.nb;
        int[] nArray = dcsd.r;
        int[] nArray2 = dcsd.s;
        int[] nArray3 = dcsd.rr;
        int n5 = nArray3[3];
        int n6 = 0;
        for (int i = 0; i < n4; ++i) {
            if (nArray[i + 1] != nArray[i] + 1 || nArray2[i + 1] != nArray2[i] + 1) continue;
            ++n6;
        }
        System.out.print(String.format("blocks: %d singletons: %d structural rank: %d\n", n4, n6, n5));
        dcsd = null;
        for (n = 0; n <= 3; n += 3) {
            if (n == 0 && n2 > 1000) continue;
            System.out.print("QR   ");
            Dcs_demo.print_order(n);
            Dcs_demo.rhs(dArray2, dArray, n2);
            d = Dcs_demo.tic();
            bl = Dcs_qrsol.cs_qrsol(n, dcs2, dArray2);
            System.out.print(String.format("time: %8.2f ms ", Dcs_demo.toc(d)));
            Dcs_demo.print_resid(bl, dcs2, dArray2, dArray, dArray3);
        }
        if (n2 != n3 || n5 < n3) {
            return true;
        }
        for (n = 0; n <= 3; ++n) {
            if (n == 0 && n2 > 1000) continue;
            System.out.print("LU   ");
            Dcs_demo.print_order(n);
            Dcs_demo.rhs(dArray2, dArray, n2);
            d = Dcs_demo.tic();
            bl = Dcs_lusol.cs_lusol(n, dcs2, dArray2, d2);
            System.out.print(String.format("time: %8.2f ms ", Dcs_demo.toc(d)));
            Dcs_demo.print_resid(bl, dcs2, dArray2, dArray, dArray3);
        }
        if (dproblem.sym == 0) {
            return true;
        }
        for (n = 0; n <= 1; ++n) {
            if (n == 0 && n2 > 1000) continue;
            System.out.print("Chol ");
            Dcs_demo.print_order(n);
            Dcs_demo.rhs(dArray2, dArray, n2);
            d = Dcs_demo.tic();
            bl = Dcs_cholsol.cs_cholsol(n, dcs2, dArray2);
            System.out.print(String.format("time: %8.2f ms ", Dcs_demo.toc(d)));
            Dcs_demo.print_resid(bl, dcs2, dArray2, dArray, dArray3);
        }
        return true;
    }

    public static boolean demo3(Dproblem dproblem) {
        int n;
        Dcs_common.Dcs dcs = null;
        Dcs_common.Dcs dcs2 = null;
        int[] nArray = null;
        double[] dArray = null;
        Dcs_common.Dcss dcss = null;
        Dcs_common.Dcsn dcsn = null;
        if (dproblem == null || dproblem.sym == 0 || dproblem.A.n == 0) {
            return false;
        }
        Dcs_common.Dcs dcs3 = dproblem.A;
        Dcs_common.Dcs dcs4 = dproblem.C;
        double[] dArray2 = dproblem.b;
        double[] dArray3 = dproblem.x;
        double[] dArray4 = dproblem.resid;
        int n2 = dcs3.n;
        if (dproblem.sym == 0 || n2 == 0) {
            return true;
        }
        Dcs_demo.rhs(dArray3, dArray2, n2);
        System.out.print("\nchol then update/downdate ");
        Dcs_demo.print_order(1);
        dArray = new double[n2];
        double d = Dcs_demo.tic();
        dcss = Dcs_schol.cs_schol(1, dcs4);
        System.out.print(String.format("\nsymbolic chol time %8.2f ms\n", Dcs_demo.toc(d)));
        d = Dcs_demo.tic();
        dcsn = Dcs_chol.cs_chol(dcs4, dcss);
        System.out.print(String.format("numeric  chol time %8.2f ms\n", Dcs_demo.toc(d)));
        if (dcss == null || dcsn == null) {
            return false;
        }
        d = Dcs_demo.tic();
        Dcs_ipvec.cs_ipvec(dcss.pinv, dArray2, dArray, n2);
        Dcs_lsolve.cs_lsolve(dcsn.L, dArray);
        Dcs_ltsolve.cs_ltsolve(dcsn.L, dArray);
        Dcs_pvec.cs_pvec(dcss.pinv, dArray, dArray3, n2);
        System.out.print(String.format("solve    chol time %8.2f ms\n", Dcs_demo.toc(d)));
        System.out.println("original: ");
        Dcs_demo.print_resid(true, dcs4, dArray3, dArray2, dArray4);
        int n3 = n2 / 2;
        dcs = Dcs_util.cs_spalloc(n2, 1, n2, true, false);
        int[] nArray2 = dcsn.L.p;
        int[] nArray3 = dcsn.L.i;
        double[] dArray5 = dcsn.L.x;
        int[] nArray4 = dcs.p;
        int[] nArray5 = dcs.i;
        double[] dArray6 = dcs.x;
        nArray4[0] = 0;
        nArray4[1] = nArray2[n3 + 1] - n;
        double d2 = dArray5[n];
        Random random = new Random(1L);
        for (n = nArray2[n3]; n < nArray2[n3 + 1]; ++n) {
            int n4 = n - nArray2[n3];
            nArray5[n4] = nArray3[n];
            dArray6[n4] = d2 * random.nextDouble();
        }
        d = Dcs_demo.tic();
        boolean bl = Dcs_updown.cs_updown(dcsn.L, 1, dcs, dcss.parent);
        double d3 = Dcs_demo.toc(d);
        System.out.print(String.format("update:   time: %8.2f ms\n", d3));
        if (!bl) {
            return false;
        }
        d = Dcs_demo.tic();
        Dcs_ipvec.cs_ipvec(dcss.pinv, dArray2, dArray, n2);
        Dcs_lsolve.cs_lsolve(dcsn.L, dArray);
        Dcs_ltsolve.cs_ltsolve(dcsn.L, dArray);
        Dcs_pvec.cs_pvec(dcss.pinv, dArray, dArray3, n2);
        d = Dcs_demo.toc(d);
        nArray = Dcs_pinv.cs_pinv(dcss.pinv, n2);
        Dcs_common.Dcs dcs5 = Dcs_permute.cs_permute(dcs, nArray, null, true);
        Dcs_common.Dcs dcs6 = Dcs_transpose.cs_transpose(dcs5, true);
        Dcs_common.Dcs dcs7 = Dcs_multiply.cs_multiply(dcs5, dcs6);
        dcs6 = null;
        dcs5 = null;
        dcs2 = Dcs_add.cs_add(dcs4, dcs7, 1.0, 1.0);
        dcs7 = null;
        if (dcs2 == null || nArray == null) {
            return false;
        }
        System.out.print(String.format("update:   time: %8.2f ms(incl solve) ", d3 + d));
        Dcs_demo.print_resid(true, dcs2, dArray3, dArray2, dArray4);
        dcsn = null;
        d = Dcs_demo.tic();
        dcsn = Dcs_chol.cs_chol(dcs2, dcss);
        if (dcsn == null) {
            return false;
        }
        Dcs_ipvec.cs_ipvec(dcss.pinv, dArray2, dArray, n2);
        Dcs_lsolve.cs_lsolve(dcsn.L, dArray);
        Dcs_ltsolve.cs_ltsolve(dcsn.L, dArray);
        Dcs_pvec.cs_pvec(dcss.pinv, dArray, dArray3, n2);
        d = Dcs_demo.toc(d);
        System.out.print(String.format("rechol:   time: %8.2f ms(incl solve) ", d));
        Dcs_demo.print_resid(true, dcs2, dArray3, dArray2, dArray4);
        d = Dcs_demo.tic();
        bl = Dcs_updown.cs_updown(dcsn.L, -1, dcs, dcss.parent);
        d3 = Dcs_demo.toc(d);
        if (!bl) {
            return false;
        }
        System.out.print(String.format("downdate: time: %8.2f\n", d3));
        d = Dcs_demo.tic();
        Dcs_ipvec.cs_ipvec(dcss.pinv, dArray2, dArray, n2);
        Dcs_lsolve.cs_lsolve(dcsn.L, dArray);
        Dcs_ltsolve.cs_ltsolve(dcsn.L, dArray);
        Dcs_pvec.cs_pvec(dcss.pinv, dArray, dArray3, n2);
        d = Dcs_demo.toc(d);
        System.out.print(String.format("downdate: time: %8.2f ms(incl solve) ", d3 + d));
        Dcs_demo.print_resid(true, dcs4, dArray3, dArray2, dArray4);
        return true;
    }

    private static class Dropdiag
    implements Dcs_ifkeep {
        private Dropdiag() {
        }

        public boolean fkeep(int n, int n2, double d, Object object) {
            return n != n2;
        }
    }

    public static class Dproblem {
        public Dcs_common.Dcs A;
        public Dcs_common.Dcs C;
        public int sym;
        public double[] x;
        public double[] b;
        public double[] resid;
    }
}

