/*
*   Class  Chars
*
*   Methods for editing and examining a character
*
*   WRITTEN BY: Dr Michael Thomas Flanagan
*
*   DATE:       March 2013
*   REVISED:    
*
*   DOCUMENTATION:
*   See Michael Thomas Flanagan's Java library on-line web page:
*   http://www.ee.ucl.ac.uk/~mflanaga/java/Chars.html
*   http://www.ee.ucl.ac.uk/~mflanaga/java/
*
*   Copyright (c)2013 Michael Thomas Flanagan
*
*
***************************************************************************************/

package flanagan.util;

public class Chars{
        
    private char enteredChar = ' ';                                         // Entered character
    private char editedChar = ' ';                                          // Edited character
    
    // Accent replacement arrays
    private char[] symbolsA = {'', '', '', '', '', '', '', '', '', '', '', '?', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '?', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', ''};

    private char[] replSymbolsA = {'A', 'A', 'A', 'A', 'A', 'A', 'C', 'E', 'E', 'E', 'E',  'G','I', 'I', 'I', 'I', 'D', 'N', 'O', 'O', 'O', 'O', 'O', 'O', 'U', 'U', 'U', 'U', 'Y', 'a', 'a', 'a', 'a', 'a', 'a', 'c', 'e', 'e', 'e', 'e', 'g', 'i', 'i', 'i', 'i', 'd', 'n', 'o', 'o', 'o', 'o', 'o', 'o', 'u', 'u', 'u', 'u', 'y', 'y', 's', 's', 'y', 'f'};

    private int[] decNumbersA = {192, 193, 194, 195, 196, 197, 199, 200, 201, 202, 203, 286, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 216, 217, 218, 219, 220, 221, 224, 225, 226, 227, 228, 229, 231, 232, 233, 234, 235, 287, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 248, 249, 250, 251, 252, 253, 255, 352, 353, 376, 402}; 
    
    private int nSymbolsA = symbolsA.length;
    
    // Question marks
    private int[] decNumbersQ = {34, 39, 130, 132, 139, 145, 146, 147, 148, 155, 171, 187};
    
    private int nSymbolsQ = decNumbersQ.length;
    
    
    // Constructor 
    public Chars(char cc){
        this.enteredChar = cc;
        this.editedChar = cc;
    }
    
    // Return edited character as char
    public char getEdited_as_char(){
        return this.editedChar;
    }
    
    // Return edited character as Character
    public Character getEdited_as_Character(){
        return new Character(this.editedChar);
    }
    
   // Return entered character as char
    public char getEntered_as_char(){
        return this.enteredChar;
    }
    
     // Return entered character as Character
    public Character getEntered_as_Character(){
        return new Character(this.enteredChar);
    }
        
    // Returns true if char is a quotation mark
    // instance method
    public boolean isQuotationMark(){
        boolean check = false;
        for(int i=0; i<this.nSymbolsQ; i++){
            if((int)this.editedChar==this.decNumbersQ[i]){
                check = true;
                break;
            }
        }
        return check;
    } 
    
    // Returns true if char is a quotation mark
    // static method
    public static boolean isQuotationMark(char cc){
        Chars ccc = new Chars(cc);
        return ccc.isQuotationMark();
    }
    
    // Returns true if char is a upper case
    // instance method
    public boolean isUpperCase(){
        return Character.isUpperCase(this.editedChar);
    } 
    
    // Returns true if char is a lower case
    // instance method
    public boolean isLowerCase(){
        return Character.isLowerCase(this.editedChar);
    } 
    
    // Converts to upper case
    // instance method
    public char toUpperCase(){
        this.editedChar = Character.toUpperCase(this.editedChar);
        return this.editedChar;
    }
    
    // Converts to upper case
    // static method
    public static char toUpperCase(char cc){
        return Character.toUpperCase(cc);
    }
    
    // Converts to lower case
    // instance method
    public char toLowerCase(){
        this.editedChar = Character.toLowerCase(this.editedChar);
        return this.editedChar;
    }
    
    // Converts to lower case
    // static method
    public static char toLowerCase(char cc){
        return Character.toLowerCase(cc);
    }
    
    
    
    // Removes all accents and replaces the accented letter with its non-accented equivalent 
    // instance method
    public char removeAccent(){
        
        for(int i=0; i<this.nSymbolsA; i++){
            if(this.editedChar==this.symbolsA[i]){
                this.editedChar = this.replSymbolsA[i];
                break;
            }
        }
        return this.editedChar;

    }
    
    // Removes all accents and replaces the accented letter with its non-accented equivalent 
    // static method
    public static char removeAccent(char cc){
        Chars ccc = new Chars(cc);
        return ccc.removeAccent();
    }
    
    // Returns true if character is alphabetic
    // instance method
    public boolean isAlphabetic(){     
        boolean check = false;
        if(Character.isLetter(editedChar));
        return check;
    }
    
    // Returns true if character is a digit (0 to 9)
    // instance method
    public boolean isDigit(){     
        boolean check = false;
        if(Character.isDigit(editedChar));
        return check;
    }
    
    // Returns true if character is either alphabetic or a digit (0 to 9)
    // instance method
    public boolean isAlphanumeric(){     
        boolean check = false;
        if(Character.isLetterOrDigit(editedChar));
        return check;
    }
    
}