package plugins.ylemontag.sequencecomparator;


/**
 * 
 * @author Yoann Le Montagner
 *
 * Object used to control and interrupt a potentially long comparison operation
 */
public class Controller
{	
	/**
	 * Exception thrown when an operation interruption have been requested
	 * (for instance by the user)
	 */
	public static class CanceledByUser extends Exception
	{
		private static final long serialVersionUID = 1L;
	}
	
	private boolean _cancelFlag;
	private Object  _mutex     ;
	
	/**
	 * Constructor
	 */
	public Controller()
	{
		_cancelFlag = false;
		_mutex      = new Object();
	}
	
	/**
	 * Method to call to ask the corresponding operation to stop as soon as possible
	 * @warning Calling this method does not mean the computation will actually
	 *          be interrupted. The operation is interrupted if a CanceledByUser
	 *          exception is thrown.
	 */
	public void cancelComputation()
	{
		_cancelFlag = true;
	}
	
	/**
	 * Reset the cancel flag
	 */
	public void reset()
	{
		_cancelFlag = false;
	}
	
	/**
	 * Check-point function called by the working thread
	 */
	public void checkPoint() throws CanceledByUser
	{
		if(_cancelFlag) {
			throw new CanceledByUser();
		}
	}
	
	/**
	 * Object to synchronize on to ensure that only one operation is performed
	 * at one time
	 */
	public Object getMutex()
	{
		return _mutex;
	}
}
