/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.Line;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.gui.TextRoi;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.plugin.filter.Analyzer;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.TextEvent;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

public class CalibrationBar
implements PlugIn {
    static final int BAR_LENGTH = 128;
    static final int BAR_THICKNESS = 12;
    static final int XMARGIN = 10;
    static final int YMARGIN = 10;
    static final int WIN_HEIGHT = 128;
    static final int BOX_PAD = 0;
    static final String CALIBRATION_BAR = "|CB|";
    static int nBins = 256;
    static final String[] colors = new String[]{"White", "Light Gray", "Dark Gray", "Black", "Red", "Green", "Blue", "Yellow", "None"};
    static final String[] locations = new String[]{"Upper Right", "Lower Right", "Lower Left", "Upper Left", "At Selection"};
    static final int UPPER_RIGHT = 0;
    static final int LOWER_RIGHT = 1;
    static final int LOWER_LEFT = 2;
    static final int UPPER_LEFT = 3;
    static final int AT_SELECTION = 4;
    static String fillColor = colors[0];
    static String textColor = colors[3];
    static String location = locations[0];
    static double zoom = 1.0;
    static int numLabels = 5;
    static int fontSize = 12;
    static int decimalPlaces = 0;
    ImagePlus imp;
    LiveDialog gd;
    ImageStatistics stats;
    Calibration cal;
    int[] histogram;
    Image img;
    Button setup;
    Button redraw;
    Button insert;
    Button unInsert;
    Checkbox ne;
    Checkbox nw;
    Checkbox se;
    Checkbox sw;
    CheckboxGroup locGroup;
    Label value;
    Label note;
    int newMaxCount;
    boolean logScale;
    int win_width;
    int userPadding = 0;
    int fontHeight = 0;
    boolean boldText;
    boolean showUnit;
    static boolean staticFlatten;
    boolean flatten = staticFlatten;
    Object backupPixels;
    byte[] byteStorage;
    int[] intStorage;
    short[] shortStorage;
    float[] floatStorage;
    String boxOutlineColor = colors[8];
    String barOutlineColor = colors[3];
    ImageProcessor ip;
    String[] fieldNames = null;
    int insetPad;
    boolean decimalPlacesChanged;

    @Override
    public void run(String arg) {
        double mag;
        this.imp = IJ.getImage();
        if (this.imp.getBitDepth() == 24 || this.imp.getCompositeMode() == 1) {
            IJ.error("Calibration Bar", "RGB and composite images are not supported");
            return;
        }
        if (this.imp.getRoi() != null && this.imp.getRoi().isArea()) {
            location = locations[4];
        } else if (location.equals(locations[4])) {
            location = locations[0];
        }
        ImageCanvas ic = this.imp.getCanvas();
        double d = mag = ic != null ? ic.getMagnification() : 1.0;
        if (zoom <= 1.0 && mag < 1.0) {
            zoom = 1.0 / mag;
        }
        this.insetPad = this.imp.getWidth() / 50;
        if (this.insetPad < 4) {
            this.insetPad = 4;
        }
        this.updateColorBar();
        if (IJ.isMacro()) {
            this.flatten = true;
            fillColor = colors[0];
            textColor = colors[3];
            location = locations[0];
            zoom = 1.0;
            numLabels = 5;
            fontSize = 12;
            decimalPlaces = 0;
        }
        if (!this.showDialog()) {
            Overlay overlay = this.imp.getOverlay();
            if (overlay != null) {
                overlay.remove(CALIBRATION_BAR);
                this.imp.draw();
            }
            return;
        }
        this.updateColorBar();
        if (this.flatten) {
            this.imp.deleteRoi();
            IJ.wait(100);
            ImagePlus imp2 = this.imp.flatten();
            imp2.setTitle(this.imp.getTitle() + " with bar");
            Overlay overlay = this.imp.getOverlay();
            if (overlay != null) {
                overlay.remove(CALIBRATION_BAR);
                this.imp.draw();
            }
            imp2.show();
        }
    }

    private void updateColorBar() {
        Roi roi = this.imp.getRoi();
        if (roi != null && location.equals(locations[4])) {
            Rectangle r = roi.getBounds();
            this.drawBarAsOverlay(this.imp, r.x, r.y);
        } else if (location.equals(locations[3])) {
            this.drawBarAsOverlay(this.imp, this.insetPad, this.insetPad);
        } else if (location.equals(locations[0])) {
            this.calculateWidth();
            this.drawBarAsOverlay(this.imp, this.imp.getWidth() - this.insetPad - this.win_width, this.insetPad);
        } else if (location.equals(locations[2])) {
            this.drawBarAsOverlay(this.imp, this.insetPad, this.imp.getHeight() - (int)(128.0 * zoom + (double)(2 * (int)(10.0 * zoom))) - (int)((double)this.insetPad * zoom));
        } else if (location.equals(locations[1])) {
            this.calculateWidth();
            this.drawBarAsOverlay(this.imp, this.imp.getWidth() - this.win_width - this.insetPad, this.imp.getHeight() - (int)(128.0 * zoom + (double)(2 * (int)(10.0 * zoom))) - this.insetPad);
        }
        this.imp.updateAndDraw();
    }

    private boolean showDialog() {
        this.gd = new LiveDialog("Calibration Bar");
        this.gd.addChoice("Location:", locations, location);
        this.gd.addChoice("Fill color: ", colors, fillColor);
        this.gd.addChoice("Label color: ", colors, textColor);
        this.gd.addNumericField("Number of labels:", numLabels, 0);
        this.gd.addNumericField("Decimal places:", decimalPlaces, 0);
        this.gd.addNumericField("Font size:", fontSize, 0);
        this.gd.addNumericField("Zoom factor:", zoom, 1);
        String[] labels = new String[]{"Bold text", "Overlay", "Show unit"};
        boolean[] states = new boolean[]{this.boldText, !this.flatten, this.showUnit};
        this.gd.setInsets(10, 30, 0);
        this.gd.addCheckboxGroup(2, 2, labels, states);
        this.gd.showDialog();
        if (this.gd.wasCanceled()) {
            return false;
        }
        location = this.gd.getNextChoice();
        fillColor = this.gd.getNextChoice();
        textColor = this.gd.getNextChoice();
        numLabels = (int)this.gd.getNextNumber();
        decimalPlaces = (int)this.gd.getNextNumber();
        fontSize = (int)this.gd.getNextNumber();
        zoom = this.gd.getNextNumber();
        this.boldText = this.gd.getNextBoolean();
        this.flatten = !this.gd.getNextBoolean();
        this.showUnit = this.gd.getNextBoolean();
        if (!IJ.isMacro()) {
            staticFlatten = this.flatten;
        }
        return true;
    }

    private void drawBarAsOverlay(ImagePlus imp, int x, int y) {
        Roi roi = imp.getRoi();
        if (roi != null) {
            imp.deleteRoi();
        }
        this.stats = imp.getStatistics(16, nBins);
        if (roi != null) {
            imp.setRoi(roi);
        }
        this.histogram = this.stats.histogram;
        this.cal = imp.getCalibration();
        Overlay overlay = imp.getOverlay();
        if (overlay == null) {
            overlay = new Overlay();
        } else {
            overlay.remove(CALIBRATION_BAR);
        }
        int maxTextWidth = this.addText(null, 0, 0);
        this.win_width = (int)(10.0 * zoom) + 5 + (int)(12.0 * zoom) + maxTextWidth + (int)(5.0 * zoom);
        if (x == -1 && y == -1) {
            return;
        }
        Color c = this.getColor(fillColor);
        if (c != null) {
            Roi r = new Roi(x, y, this.win_width, (int)(128.0 * zoom + (double)(2 * (int)(10.0 * zoom))));
            r.setFillColor(c);
            overlay.add(r, CALIBRATION_BAR);
        }
        int xOffset = x;
        int yOffset = y;
        if (decimalPlaces == -1) {
            decimalPlaces = Analyzer.getPrecision();
        }
        x = (int)(10.0 * zoom) + xOffset;
        y = (int)(10.0 * zoom) + yOffset;
        this.addVerticalColorBar(overlay, x, y, (int)(12.0 * zoom), (int)(128.0 * zoom));
        this.addText(overlay, x + (int)(12.0 * zoom), y);
        c = this.getColor(this.boxOutlineColor);
        overlay.setIsCalibrationBar(true);
        if (imp.getCompositeMode() > 0) {
            for (int i = 0; i < overlay.size(); ++i) {
                overlay.get(i).setPosition(imp.getC(), 0, 0);
            }
        }
        imp.setOverlay(overlay);
    }

    private void addVerticalColorBar(Overlay overlay, int x, int y, int thickness, int length) {
        byte[] bLUT;
        byte[] gLUT;
        byte[] rLUT;
        int width = thickness;
        int height = length;
        int mapSize = 0;
        ColorModel cm = this.imp.getProcessor().getCurrentColorModel();
        if (cm instanceof IndexColorModel) {
            IndexColorModel m = (IndexColorModel)cm;
            mapSize = m.getMapSize();
            rLUT = new byte[mapSize];
            gLUT = new byte[mapSize];
            bLUT = new byte[mapSize];
            m.getReds(rLUT);
            m.getGreens(gLUT);
            m.getBlues(bLUT);
        } else {
            mapSize = 256;
            rLUT = new byte[mapSize];
            gLUT = new byte[mapSize];
            bLUT = new byte[mapSize];
            for (int i = 0; i < mapSize; ++i) {
                rLUT[i] = (byte)i;
                gLUT[i] = (byte)i;
                bLUT[i] = (byte)i;
            }
        }
        double colors = mapSize;
        int start = 0;
        ImageProcessor ipOrig = this.imp.getProcessor();
        if (ipOrig instanceof ByteProcessor) {
            int max;
            int min = (int)ipOrig.getMin();
            if (min < 0) {
                min = 0;
            }
            if ((max = (int)ipOrig.getMax()) > 255) {
                max = 255;
            }
            colors = max - min + 1;
            start = min;
        }
        for (int i = 0; i < (int)(128.0 * zoom); ++i) {
            int iMap = start + (int)Math.round((double)i * colors / (128.0 * zoom));
            if (iMap >= mapSize) {
                iMap = mapSize - 1;
            }
            int j = (int)(128.0 * zoom) - i - 1;
            Line line = new Line(x, j + y, thickness + x, j + y);
            line.setStrokeColor(new Color(rLUT[iMap] & 0xFF, gLUT[iMap] & 0xFF, bLUT[iMap] & 0xFF));
            line.setStrokeWidth(1.0001);
            overlay.add(line, CALIBRATION_BAR);
        }
        Color c = this.getColor(this.barOutlineColor);
        if (c != null) {
            Roi r = new Roi(x, y, width, height);
            r.setStrokeColor(c);
            r.setStrokeWidth(1.0);
            overlay.add(r, CALIBRATION_BAR);
        }
    }

    private int addText(Overlay overlay, int x, int y) {
        Color c = this.getColor(textColor);
        if (c == null) {
            return 0;
        }
        double hmin = this.cal.getCValue(this.stats.histMin);
        double hmax = this.cal.getCValue(this.stats.histMax);
        double barStep = 128.0 * zoom;
        if (numLabels > 2) {
            barStep /= (double)(numLabels - 1);
        }
        int fontType = this.boldText ? 1 : 0;
        Font font = null;
        font = fontSize < 9 ? new Font("SansSerif", fontType, 9) : new Font("SansSerif", fontType, (int)((double)fontSize * zoom));
        int maxLength = 0;
        Image img = GUI.createBlankImage(128, 64);
        Graphics g = img.getGraphics();
        FontMetrics metrics = g.getFontMetrics(font);
        this.fontHeight = metrics.getHeight();
        for (int i = 0; i < numLabels; ++i) {
            int iLength;
            double yLabelD = (int)(10.0 * zoom + 128.0 * zoom - (double)i * barStep - 1.0);
            int yLabel = (int)Math.round((double)y + 128.0 * zoom - (double)i * barStep - 1.0);
            Calibration cal = this.imp.getCalibration();
            String s = "";
            if (this.showUnit) {
                s = cal.getValueUnit();
            }
            ImageProcessor ipOrig = this.imp.getProcessor();
            double min = ipOrig.getMin();
            double max = ipOrig.getMax();
            if (ipOrig instanceof ByteProcessor) {
                if (min < 0.0) {
                    min = 0.0;
                }
                if (max > 255.0) {
                    max = 255.0;
                }
            }
            double grayLabel = min + (max - min) / (double)(numLabels - 1) * (double)i;
            if (cal.calibrated()) {
                grayLabel = cal.getCValue(grayLabel);
                double cmin = cal.getCValue(min);
                double cmax = cal.getCValue(max);
                if (!(this.decimalPlacesChanged || decimalPlaces != 0 || (double)((int)cmax) == cmax && (double)((int)cmin) == cmin)) {
                    decimalPlaces = 2;
                }
            }
            String todisplay = this.d2s(grayLabel) + " " + s;
            if (overlay != null) {
                TextRoi label = new TextRoi(todisplay, (double)(x + 5), (double)(yLabel + this.fontHeight / 2), font);
                label.setStrokeColor(c);
                overlay.add(label, CALIBRATION_BAR);
            }
            if ((iLength = metrics.stringWidth(todisplay)) <= maxLength) continue;
            maxLength = iLength + 5;
        }
        return maxLength;
    }

    String d2s(double d) {
        return IJ.d2s(d, decimalPlaces);
    }

    int getFontHeight() {
        Image img = GUI.createBlankImage(64, 64);
        Graphics g = img.getGraphics();
        int fontType = this.boldText ? 1 : 0;
        Font font = new Font("SansSerif", fontType, (int)((double)fontSize * zoom));
        FontMetrics metrics = g.getFontMetrics(font);
        return metrics.getHeight();
    }

    Color getColor(String color) {
        Color c = Color.white;
        if (color.equals(colors[1])) {
            c = Color.lightGray;
        } else if (color.equals(colors[2])) {
            c = Color.darkGray;
        } else if (color.equals(colors[3])) {
            c = Color.black;
        } else if (color.equals(colors[4])) {
            c = Color.red;
        } else if (color.equals(colors[5])) {
            c = Color.green;
        } else if (color.equals(colors[6])) {
            c = Color.blue;
        } else if (color.equals(colors[7])) {
            c = Color.yellow;
        } else if (color.equals(colors[8])) {
            c = null;
        }
        return c;
    }

    void calculateWidth() {
        this.drawBarAsOverlay(this.imp, -1, -1);
    }

    class LiveDialog
    extends GenericDialog {
        LiveDialog(String title) {
            super(title);
        }

        @Override
        public void textValueChanged(TextEvent e) {
            if (CalibrationBar.this.fieldNames == null) {
                CalibrationBar.this.fieldNames = new String[4];
                for (int i = 0; i < 4; ++i) {
                    CalibrationBar.this.fieldNames[i] = ((TextField)this.numberField.elementAt(i)).getName();
                }
            }
            TextField tf = (TextField)e.getSource();
            String name = tf.getName();
            String value = tf.getText();
            if (value.equals("")) {
                return;
            }
            int i = 0;
            boolean needsRefresh = false;
            if (name.equals(CalibrationBar.this.fieldNames[0])) {
                i = this.getValue(value).intValue();
                if (i < 1) {
                    return;
                }
                needsRefresh = true;
                numLabels = i;
            } else if (name.equals(CalibrationBar.this.fieldNames[1])) {
                i = this.getValue(value).intValue();
                if (i < 0) {
                    return;
                }
                needsRefresh = true;
                decimalPlaces = i;
                CalibrationBar.this.decimalPlacesChanged = true;
            } else if (name.equals(CalibrationBar.this.fieldNames[2])) {
                i = this.getValue(value).intValue();
                if (i < 1) {
                    return;
                }
                needsRefresh = true;
                fontSize = i;
            } else if (name.equals(CalibrationBar.this.fieldNames[3])) {
                double d = 0.0;
                d = this.getValue("0" + value);
                if (d <= 0.0) {
                    return;
                }
                needsRefresh = true;
                zoom = d;
            }
            if (needsRefresh) {
                CalibrationBar.this.updateColorBar();
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            location = ((Choice)this.choice.elementAt(0)).getSelectedItem();
            fillColor = ((Choice)this.choice.elementAt(1)).getSelectedItem();
            textColor = ((Choice)this.choice.elementAt(2)).getSelectedItem();
            CalibrationBar.this.boldText = ((Checkbox)this.checkbox.elementAt(0)).getState();
            CalibrationBar.this.flatten = !((Checkbox)this.checkbox.elementAt(1)).getState();
            CalibrationBar.this.showUnit = ((Checkbox)this.checkbox.elementAt(2)).getState();
            CalibrationBar.this.updateColorBar();
        }
    }
}

