/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.SparseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.WrapperFComplexMatrix2D;

public class SparseRCMFComplexMatrix2D
extends WrapperFComplexMatrix2D {
    private static final long serialVersionUID = 1L;
    private SparseFComplexMatrix1D[] elements;

    public SparseRCMFComplexMatrix2D(int rows, int columns) {
        block3: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block3;
                throw exc;
            }
        }
        this.elements = new SparseFComplexMatrix1D[rows];
        int i = 0;
        while (i < rows) {
            this.elements[i] = new SparseFComplexMatrix1D(columns);
            ++i;
        }
    }

    public SparseFComplexMatrix1D[] elements() {
        return this.elements;
    }

    @Override
    public float[] getQuick(int row, int column) {
        return this.elements[row].getQuick(column);
    }

    @Override
    public void setQuick(int row, int column, float[] value) {
        this.elements[row].setQuick(column, value);
    }

    @Override
    public void setQuick(int row, int column, float re, float im) {
        this.elements[row].setQuick(column, re, im);
    }

    @Override
    public void trimToSize() {
        int r = 0;
        while (r < this.rows) {
            this.elements[r].trimToSize();
            ++r;
        }
    }

    @Override
    public SparseFComplexMatrix1D viewRow(int row) {
        return this.elements[row];
    }

    @Override
    protected FComplexMatrix2D getContent() {
        return this;
    }

    @Override
    public FComplexMatrix2D like(int rows, int columns) {
        return new SparseRCMFComplexMatrix2D(rows, columns);
    }
}

