/*
 * Decompiled with CFR 0.152.
 */
package microTiPi.microscopy;

import mitiv.array.Array3D;
import mitiv.base.Shape;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;

public abstract class MicroscopeModel {
    protected int PState = 0;
    protected static final boolean NORMALIZED = true;
    protected static final double DEUXPI = Math.PI * 2;
    protected double dxy;
    protected double dz;
    protected int Nx;
    protected int Ny;
    protected int Nz;
    protected boolean single = false;
    protected Shape psfShape;
    protected Array3D psf;
    protected DoubleShapedVectorSpace[] parameterSpace;
    protected DoubleShapedVector[] parameterCoefs;

    public MicroscopeModel(Shape psfShape, double dxy, double dz, boolean single) {
        this.dxy = dxy;
        this.dz = dz;
        if (psfShape.rank() != 3) {
            throw new IllegalArgumentException("PSF rank should be 3");
        }
        this.Nx = psfShape.dimension(0);
        this.Ny = psfShape.dimension(1);
        this.Nz = psfShape.dimension(2);
        this.psfShape = psfShape;
        this.single = single;
    }

    public abstract void computePsf();

    public abstract Array3D getPsf();

    public abstract void setParam(DoubleShapedVector var1);

    public abstract DoubleShapedVector apply_Jacobian(ShapedVector var1, ShapedVectorSpace var2);

    public abstract void freeMem();

    public abstract int[] getParametersFlags();

    public void setSingle(boolean single) {
        this.single = single;
    }
}

