/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.in;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import ij.IJ;
import ij.gui.GenericDialog;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.event.ItemEvent;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JPanel;
import loci.common.Location;
import loci.formats.FilePattern;
import loci.formats.FilePatternBlock;
import loci.plugins.in.ImportProcess;
import loci.plugins.in.ImporterDialog;

public class FilePatternDialog
extends ImporterDialog {
    private FilePattern fp;
    private String originalID;
    private int[] paddingZeros;

    public FilePatternDialog(ImportProcess process) {
        super(process);
    }

    @Override
    protected boolean needPrompt() {
        return !this.process.isWindowless() && this.options.isGroupFiles();
    }

    @Override
    protected GenericDialog constructDialog() {
        Location idLoc = new Location(this.options.getId());
        String id = FilePattern.findPattern(idLoc);
        if (id == null) {
            if (!this.options.isQuiet()) {
                IJ.showMessage((String)"Bio-Formats", (String)"Warning: Bio-Formats was unable to determine a grouping that\nincludes the file you chose. The most common reason for this\nsituation is that the folder contains extraneous files with\nsimilar names and numbers that confuse the detection algorithm.\n \nFor example, if you have multiple datasets in the same folder\nnamed series1_z*_c*.tif, series2_z*_c*.tif, etc., Bio-Formats\nmay try to group all such files into a single series.\n \nFor best results, put each image series's files in their own\nfolder, or type in a file pattern manually.\n");
            }
            id = idLoc.getAbsolutePath();
        }
        GenericDialog gd = new GenericDialog("Bio-Formats File Stitching"){

            public void itemStateChanged(ItemEvent e) {
                super.itemStateChanged(e);
                Object source = e.getSource();
                if (!(source instanceof Checkbox)) {
                    return;
                }
                boolean selected = e.getStateChange() == 1;
                Vector checkboxes = this.getCheckboxes();
                for (Object checkbox : checkboxes) {
                    if (!checkbox.equals(source)) {
                        if (!selected) continue;
                        ((Checkbox)checkbox).setState(false);
                        continue;
                    }
                    if (selected || !checkbox.equals(source)) continue;
                    ((Checkbox)checkbox).setState(true);
                }
            }
        };
        gd.addMessage("The list of files to be grouped can be specified in one of the following ways:");
        int len = id.length() + 1;
        if (len > 80) {
            len = 80;
        }
        this.originalID = id;
        this.fp = new FilePattern(id);
        String[] prefixes = this.fp.getPrefixes();
        if (prefixes.length > 0) {
            gd.addCheckbox("Dimensions", true);
            int[] counts = this.fp.getCount();
            this.paddingZeros = new int[counts.length];
            String[][] elements = this.fp.getElements();
            BigInteger[] first = this.fp.getFirst();
            BigInteger[] step = this.fp.getStep();
            for (int i = 0; i < prefixes.length; ++i) {
                String prefix = "Axis_" + (i + 1);
                gd.addStringField(prefix + "_number_of_images", "" + counts[i]);
                gd.addStringField(prefix + "_axis_first_image", first[i].toString());
                gd.addStringField(prefix + "_axis_increment", step[i].toString());
                try {
                    this.paddingZeros[i] = elements[i][0].length() - String.valueOf(Integer.parseInt(elements[i][0])).length();
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        gd.addCheckbox("File_name", false);
        gd.addStringField("contains", "");
        gd.addCheckbox("Pattern", false);
        gd.addStringField("name", id, len);
        this.rebuild(gd);
        return gd;
    }

    @Override
    protected boolean harvestResults(GenericDialog gd) {
        String[] counts = new String[this.fp.getPrefixes().length];
        String[] firsts = new String[counts.length];
        String[] increments = new String[counts.length];
        int[] count = this.fp.getCount();
        boolean useRanges = counts.length > 0 ? gd.getNextBoolean() : false;
        boolean useRegex = gd.getNextBoolean();
        for (int i = 0; i < counts.length; ++i) {
            counts[i] = gd.getNextString();
            firsts[i] = gd.getNextString();
            increments[i] = gd.getNextString();
        }
        String contains = gd.getNextString();
        String id = gd.getNextString();
        if (useRegex) {
            if (contains.trim().length() > 0) {
                String dir = this.originalID.substring(0, this.originalID.lastIndexOf(File.separator) + 1);
                id = dir + ".*" + contains + ".*";
            }
        } else if (useRanges) {
            StringBuilder pattern = new StringBuilder();
            for (int i = 0; i < counts.length; ++i) {
                BigInteger first = new BigInteger(firsts[i]);
                BigInteger fileCount = new BigInteger(counts[i]);
                BigInteger increment = new BigInteger(increments[i]);
                FilePatternBlock block = new FilePatternBlock(this.fp.getBlock(i));
                fileCount = fileCount.subtract(BigInteger.ONE).multiply(increment).add(first);
                pattern.append(this.fp.getPrefix(i));
                pattern.append('<');
                int firstPadding = this.paddingZeros[i] - first.toString().length() + 1;
                for (int zero = 0; zero < firstPadding; ++zero) {
                    pattern.append('0');
                }
                pattern.append(first);
                pattern.append('-');
                int lastPadding = this.paddingZeros[i] - fileCount.toString().length() + 1;
                for (int zero = 0; zero < lastPadding; ++zero) {
                    pattern.append('0');
                }
                pattern.append(fileCount);
                pattern.append(':');
                pattern.append(increment);
                pattern.append('>');
            }
            pattern.append(this.fp.getSuffix());
            id = pattern.toString();
        }
        this.options.setId(id);
        return true;
    }

    private void rebuild(GenericDialog gd) {
        Vector checkboxes = gd.getCheckboxes();
        Vector fields = gd.getStringFields();
        ArrayList<Label> labels = new ArrayList<Label>();
        for (Component c : gd.getComponents()) {
            if (!(c instanceof Label)) continue;
            labels.add((Label)c);
        }
        String cols = "pref, 3dlu, pref, 3dlu, pref";
        StringBuilder sb = new StringBuilder("pref, 3dlu, pref");
        for (int s = 1; s < fields.size(); ++s) {
            sb.append(", 3dlu, pref");
        }
        String rows = sb.toString();
        PanelBuilder builder = new PanelBuilder(new FormLayout("pref, 3dlu, pref, 3dlu, pref", rows));
        CellConstraints cc = new CellConstraints();
        int row = 1;
        if (checkboxes.size() > 2 && fields.size() > 2) {
            builder.add((Component)labels.get(0), cc.xyw(1, row, 5));
            builder.add((Component)checkboxes.get(0), cc.xy(1, row += 2));
            for (int i = 0; i < fields.size() - 2; ++i) {
                builder.add((Component)labels.get(i + 1), cc.xy(3, row));
                builder.add((Component)fields.get(i), cc.xy(5, row));
                row += 2;
            }
        }
        builder.add((Component)checkboxes.get(checkboxes.size() - 2), cc.xy(1, row));
        builder.add((Component)labels.get(labels.size() - 2), cc.xy(3, row));
        builder.add((Component)fields.get(fields.size() - 2), cc.xy(5, row));
        builder.add((Component)checkboxes.get(checkboxes.size() - 1), cc.xy(1, row += 2));
        builder.add((Component)labels.get(labels.size() - 1), cc.xy(3, row));
        builder.add((Component)fields.get(fields.size() - 1), cc.xy(5, row));
        row += 2;
        JPanel masterPanel = builder.getPanel();
        gd.removeAll();
        GridBagLayout gdl = (GridBagLayout)gd.getLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.gridheight = fields.size();
        gdl.setConstraints(masterPanel, gbc);
        gd.add((Component)masterPanel);
        gd.setBackground(Color.white);
    }
}

