package plugins.lagache.colocalizationstudio;

import java.util.ArrayList;
import java.util.Vector;

import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.WorkbookUtil;
import icy.file.FileUtil;
import icy.gui.frame.progress.AnnounceFrame;
import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.roi.BooleanMask3D;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROI3D;
import icy.roi.ROIUtil;
import icy.sequence.Sequence;
import icy.type.point.Point3D;
import icy.type.point.Point5D;
import icy.util.StringUtil;
import icy.util.XLSUtil;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.lang.VarDouble;
import plugins.adufour.vars.lang.VarDoubleArrayNative;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.adufour.vars.lang.VarSequence;
import plugins.adufour.vars.lang.VarWorkbook;
import plugins.kernel.roi.roi2d.ROI2DRectangle;
import plugins.kernel.roi.roi3d.ROI3DArea;
import plugins.lagache.sodasuite.Methods_distance;
import plugins.lagache.sodasuite.Ripley2D;
import plugins.lagache.sodasuite.Ripley3D;
import plugins.lagache.sodasuite.SODAblock;
import plugins.lagache.sodasuite.Window2D;
import plugins.lagache.sodasuite.Window3D;
import plugins.lagache.sodasuite.non_parametric_object;
import plugins.nchenouard.spot.Spot;



public class ColocalizationStudio_Object  extends Plugin implements Block, PluginBundled {	
				
		
	
	VarSequence input_sequence1 = new VarSequence("Input sequence 1", null);
	VarSequence input_sequence2 = new VarSequence("Input sequence 2", null);
	VarROIArray	ROIs		= new VarROIArray("ROI of Analysis");	
	VarROIArray	detections1		= new VarROIArray("List of detections 1 (ROIS)");
	VarROIArray	detections2		= new VarROIArray("List of detections 2 (ROIS)");
	
	VarBoolean distance = new VarBoolean("Positions 1 inside Masks 2",true);
	VarBoolean fit = new VarBoolean("Fit of Ripley's function",true);
	VarBoolean soda = new VarBoolean("SODA",true);
	VarBoolean export_colocalized_rois = new VarBoolean("Export colocalized detections (ROIs)", false);	
	VarROIArray	detections1Coloc		= new VarROIArray("List of colocalized detections 1 (ROIS)");
	VarROIArray	detections2Coloc		= new VarROIArray("List of colocalized detections 2 (ROIS)");
	VarDoubleArrayNative probas12 = new VarDoubleArrayNative("Coupling probabilities", null);
	VarDoubleArrayNative dist12 = new VarDoubleArrayNative("Coupling distances", null);
	VarROIArray	detections1S		= new VarROIArray("List of single detections 1 (ROIS)");
	VarROIArray	detections2S		= new VarROIArray("List of single detections 2 (ROIS)");
	
		
	
			
	VarDouble maxdistance_in =  new VarDouble("Max. Radius (in pixels)", 5);	
	VarDouble Step = new VarDouble("Step", 1.0);	
		
	
	VarWorkbook                book              = new VarWorkbook("Workbook", (Workbook) null);
    double maxdist;
    double step;
	double[] results = null;
	int N_h;
	ArrayList<Double> distance_fit=new ArrayList<Double>();
	    ArrayList<ROI> list_roi = new ArrayList<ROI>();
	    private  ArrayList<Double> K = new ArrayList<Double>();
	    
	@Override
	public void declareInput(VarList inputMap)
	{
		inputMap.add("Input Sequence 1", input_sequence1);
		inputMap.add("Input Sequence 2", input_sequence2);				
		inputMap.add("ROI of Analysis", ROIs);
		inputMap.add("Detections 1 (ROIs)", detections1);
		inputMap.add("Detections 2 (ROIs)", detections2);
		inputMap.add("Positions 1 inside masks 2", distance);
		inputMap.add("Fit of Ripley's K function", fit);
		inputMap.add("SODA", soda);
		inputMap.add("Max. Radius (in pixels) for Ripley analysis", maxdistance_in);	
		inputMap.add("Step (in pixels)",Step);
		inputMap.add("Export colocalized spots (ROIs)", export_colocalized_rois);		
		}

	@Override
	public void declareOutput(VarList outputMap)
	{						
		outputMap.add("Colocalized Detections 1",detections1Coloc);
		outputMap.add("Colocalized Detections 2",detections2Coloc);
		outputMap.add("Single Detections 1",detections1S);
		outputMap.add("Single Detections 2",detections2S);
		outputMap.add("Coupling Probabilities", probas12);
		outputMap.add("Coupling Distances", dist12);
		outputMap.add("Workbook", book);
	}
	// N: nb entre dmin et dmax avec pas donne
	@Override
	public void run() {
		apparatedSpots.coloc1.clear();
		apparatedSpots.coloc2.clear();
		if (maxdistance_in.getValue() <= 0) {
			new AnnounceFrame("Max. radius must be > 0");
			return;
		}
		if (detections1 == null || detections2 == null) {
			new AnnounceFrame("Please first select two detection sets");
			return;
		} else {

			maxdist = maxdistance_in.getValue();
			step=Step.getValue();
			if (input_sequence1.getValue() == null || input_sequence2.getValue() == null) {
				new AnnounceFrame("Please first select two sequences");
				return;
			}

			else {
				// creation du workbook
				if (book.getValue() == null) {
					book.setValue(new HSSFWorkbook());
				}
				book.getValue().setMissingCellPolicy(Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
				performAnalysis();
			}
		}
	}

	private void performAnalysis() {

		// initialisation du workbook
		Workbook wb = book.getValue();
		// create the sheet
		String sheetName = "Coloc. Object Analysis";
		Sheet sheet = wb.getSheet(sheetName);
		if (sheet == null)
			sheet = wb.createSheet(sheetName);
		Sequence sequence = input_sequence1.getValue();
		Sequence sequence2 = input_sequence2.getValue();
		int dim = 2;
		if (sequence.getSizeZ() > 1)
			dim = 3;

		// gestion des rois d'analyse en entr�e

		list_roi.clear();
		ROI[] roiArray = ROIs.getValue();// TODO Ou sont les ROIs???
		if (roiArray.length == 0) {
			for (int t = 0; t < input_sequence1.getValue().getSizeT(); t++) {
				ROI roi = null;

				ROI2DRectangle r = new ROI2DRectangle(sequence.getBounds2D());
				for (int h = 0; h < sequence.getSizeZ(); h++) {
					r.setZ(h);
					r.setT(t);
					roi = r.getUnion(roi);
				}
				list_roi.add(roi);
			}
		} else
			for (ROI roi : roiArray) {
				list_roi.add(roi);
			}

		// on teste si les dimension en c sonts compatible
		double c1 = list_roi.get(0).getPosition5D().getC();
		for (ROI r : list_roi) {
			double c = r.getPosition5D().getC();
			if ((c != c1) && (c != (-1))) {
				new AnnounceFrame("ROI channels are incompatibles");
				return;
			}
		}

		// on teste si les dimensions en temps/z sont incompatibles pour une
		// union
		boolean one_z = false;
		boolean all_z = true;

		for (ROI r : list_roi) {
			if (r.getBounds5D().isInfiniteZ() == false) {
				all_z = false;
			}
			if (r.getBounds5D().isInfiniteZ()) {
				one_z = true;
			}
		}
		// gestion de l'exception
		if (one_z == true && all_z == false) {
			new AnnounceFrame("Incompatibility in Z dimensions between ROIs");
			return;
		}

		//définition du ration pixel z/pixel x
				double ratio_zx = 1.0;
				if (sequence.getSizeZ() > 1) {
					ratio_zx = sequence.getPixelSizeZ() / sequence.getPixelSizeX();
				}
		// create the header row

		Row header = sheet.getRow(0);
		int row=0;
		if (header == null) {
			header = sheet.createRow(0);			
			header.getCell(0).setCellValue("Time");			
			header.getCell(1).setCellValue("Nb detections 1");
			header.getCell(2).setCellValue("Nb detections 2");
			header.getCell(3).setCellValue("% of coloc. (% 1 inside 2)");
			header.getCell(4).setCellValue("p-value (1 inside 2)");
			header.getCell(5).setCellValue("log p-value (% 1 inside 2)");
			
			header.getCell(6).setCellValue("Step Ripley");
			header.getCell(7).setCellValue("r max Ripley");
			header.getCell(8).setCellValue("% of 1 coloc. with 2 (fit)");
			header.getCell(9).setCellValue("Mean coloc. distance (fit)");
			header.getCell(10).setCellValue("% of 1 coloc. with 2 (SODA)");
			header.getCell(11).setCellValue("Mean coloc. distance (SODA)");
			
			header.getCell(12).setCellValue("p-value (SODA)");
			header.getCell(13).setCellValue("log p-value (SODA)");
			row++;
		}
		//construction de la liste des distances		
 		betaCorrection(maxdist/10,100); 				 	 		
 		distance_fit.clear();			
 		distance_fit.add(0.);
 		double temp = 0.;		
 		while (temp + step <= maxdist) {
 			temp += step;
 			distance_fit.add(temp);}
 		int N_fit = distance_fit.size();
 		if (N_fit == 1) {
 			distance_fit.add(maxdist);
 			N_fit = distance_fit.size();}
 		int numT = input_sequence1.getValue().getSizeT();	
 			//déclaration initiale des tableaux pour stocker valeurs et ROIs au cours du temps
 			double[][] proba_dist = new double[numT][N_fit - 1];
 			int ind_row = 0;	
 			//coloc. ROIs
 			ArrayList<ROI> c_1 = new ArrayList<ROI>();
 			ArrayList<ROI> c_2 = new ArrayList<ROI>();
 			//distance and coupling probability per couple of spots
 			ArrayList<Double> probas = new ArrayList<Double>();
 			ArrayList<Double> dist = new ArrayList<Double>();
 			
 			//single ROIs
 			ArrayList<ROI> s_1 = new ArrayList<ROI>();
 			ArrayList<ROI> s_2 = new ArrayList<ROI>();		
 			// d�marrage boucle en temps
 			for (int t = 0; t < numT; t += 1) {						
 				ArrayList<ROI> roi_t = SODAblock.ROI_t(dim, list_roi, t, -1);
 				if (roi_t.size()==0){}
 				else{		 									
 							//on délectionne les ROIs spots qui sont bien dans ROI_t
				ROI[] detection = SODAblock.detectionsInRoi(detections1.getValue(), roi_t);
				ROI[] detection2 = SODAblock.detectionsInRoi(detections2.getValue(), roi_t);
				// calcul des parametres globaux: aire totale des rois et nb de detections
				double volume = ROIUtil.getUnion(roi_t).getNumberOfPoints() * ratio_zx;
				if (ROIUtil.getUnion(roi_t).getBounds5D().isInfiniteZ()) {
					volume = volume * sequence.getSizeZ() * ratio_zx;
				}				
				int nbdeta = detection.length;
				int nbdetb = detection2.length;
			
				//Analyse Distance-based (center of mass in spots)
				double[] distance_based = new double[2];						
				distance_based=Methods_distance.distance(detection, detection2, sequence, sequence2, roi_t, t, volume);
				//////////////////////////////////////////////////////////////////////////
				//Analyse Ripley (Fit et SODA)
				////////////////////////////////////////////////////////////
				//on divise la ROI d'étude pour accélerer le calcul de la fonction de Ripley		 				
					double window_size = maxdist;
					double max_z = maxdist/ratio_zx;	 					
				// on crée des listes de points 2D ou 3D avec les positions (centres
					// d'intensité ou de masse en 3D) des spots			
					ArrayList<Point3D> positions_1_2D = new ArrayList<Point3D>();
					ArrayList<Point3D> positions_2_2D = new ArrayList<Point3D>();
					//on crée aussi une liste potentielle de points 3d
					ArrayList<Point3D> positions_1_3D = new ArrayList<Point3D>();
					ArrayList<Point3D> positions_2_3D = new ArrayList<Point3D>();
					//sous-listes des detections pour accelerer le temps de calcul
					Window2D[][] imageWindows_1_2D = new Window2D[(int) (sequence.getWidth()/ window_size)][(int) (sequence.getHeight() / window_size)];
					Window2D[][] imageWindows_2_2D = new Window2D[(int) (sequence.getWidth()/ window_size)][(int) (sequence.getHeight() / window_size)];
					Window3D[][][] imageWindows_1_3D = new Window3D[(int) (sequence.getWidth() / window_size)][(int) (sequence.getHeight()/ window_size)][(int) (sequence.getSizeZ() / max_z)];
					Window3D[][][] imageWindows_2_3D = new Window3D[(int) (sequence.getWidth() / window_size)][(int) (sequence.getHeight()/ window_size)][(int) (sequence.getSizeZ() / max_z)];
					if (dim==2){				
						for (ROI r : detection) {				
							Point3D pos = Ripley2D.getIntensityCenter( r, sequence);
							positions_1_2D.add(pos);}
						for (ROI r : detection2) {				
							Point3D pos = Ripley2D.getIntensityCenter(r, sequence2);
							positions_2_2D.add(pos);}																		
						imageWindows_1_2D = Window2D.window_tab(positions_1_2D, sequence, window_size);			
						imageWindows_2_2D = Window2D.window_tab(positions_2_2D, sequence2, window_size);
					}
					else // if dim==3
					{					
						for (ROI r : detection) {
							if (r.getDimension()==3){
								Point3D pos = Ripley3D.getIntensityCenter((ROI3D) r,sequence);
								positions_1_3D.add(pos);}
							else{Point3D pos = Ripley2D.getIntensityCenter((ROI2D) r,sequence);
							positions_1_3D.add(pos);}}
						for (ROI r : detection2) {
							if (r.getDimension()==3){
								Point3D pos = Ripley3D.getIntensityCenter((ROI3D) r,sequence2);
								positions_2_3D.add(pos);}
							else{Point3D pos = Ripley2D.getIntensityCenter((ROI2D) r,sequence2);
							positions_2_3D.add(pos);}}				
						imageWindows_1_3D = Window3D.window_tab(positions_1_3D, sequence, maxdist,max_z);				
						imageWindows_2_3D = Window3D.window_tab(positions_2_3D, sequence, maxdist,max_z);
					}
					
					//déclaration des tableaux de p-value
					double[] maximum = new double[N_fit-1];
					double[] pvalue = new double[N_fit-1];
					double[] log_pvalue = new double[N_fit-1];
					double[] delta_K = new double[N_fit - 1];
					double[][] Ktemp = new double[N_fit - 1][3];	 					
					double[] col_ev = new double[N_fit - 1];

					//calcul des fonctions de Ripley
					if (sequence.getSizeZ() > 1) {					
						Ktemp = Ripley3D.correlation_new(roi_t, imageWindows_1_3D,imageWindows_2_3D, volume, N_fit, distance_fit, sequence,nbdeta, nbdetb, ratio_zx);} 
					else {
						Ktemp = Ripley2D.correlation_new(roi_t, imageWindows_1_2D, imageWindows_2_2D, volume, N_fit, distance_fit, nbdeta, nbdetb);}

					for (int k = 0; k < N_fit - 1; k++) {
						delta_K[k] = Ktemp[k][0];
					}
		
					if (dim==2)
					{
						non_parametric_object.main2D_corr(N_fit, sequence, roi_t, positions_1_2D, positions_2_2D, imageWindows_1_2D,imageWindows_2_2D, distance_fit, N_h, volume, results, delta_K, Ktemp, proba_dist[t],maximum,pvalue);					
					}
					else
					{
						non_parametric_object.main3D_corr(N_fit,sequence,roi_t,positions_1_3D ,positions_2_3D, imageWindows_1_3D,imageWindows_2_3D,distance_fit,N_h,ratio_zx,volume,results, delta_K, Ktemp,proba_dist[t],maximum,pvalue);
					}
					double total_coloc_temp =0;	
					for (int j = 0; j < N_fit - 1; j++) {
						col_ev[j] = proba_dist[t][j] * (nbdetb * nbdeta / volume) * delta_K[j];
						total_coloc_temp += col_ev[j];
						if (maximum[j]<4.){
							log_pvalue[j] = Math.log10(pvalue[j]);}
						else {
							double x = maximum[j] / Math.sqrt(2.);
							double y = (N_fit - 1) / (2 * Math.sqrt(Math.PI) * x);
							double exponent = (Math.log(y) - Math.pow(x, 2)) / Math.log(10);
							log_pvalue[j] = exponent;
						}
					}
		
		ArrayList<apparatedSpots> liste_app_detect = apparatedSpots.appDetectConstruction(detection, detection2,proba_dist[t], distance_fit, sequence, sequence2);
		for (apparatedSpots as : liste_app_detect) {
		c_1.add(as.s1);
		c_2.add(as.s2);
		dist.add(as.distance);
		probas.add(as.proba);				
		}
		// calcul de la distance moyenne
		double dist_moy = apparatedSpots.distance_moyenne(liste_app_detect, distance_fit.get(N_fit-1));
		
		apparatedSpots.roiSingle(t, liste_app_detect, detection, detection2);
		for (ROI s:apparatedSpots.single1) {
			s_1.add(s);
		}
		for (ROI s:apparatedSpots.single2) {
			s_2.add(s);
		}				
		//calcul des variances de la fonction delta_K
		double[] delta_var=new double[N_fit-1];
		if (sequence.getSizeZ()>1){
			delta_var = Ripley3D.variance_theo_delta_new(roi_t, imageWindows_1_3D, imageWindows_2_3D, volume, nbdeta, nbdetb, N_fit, distance_fit, sequence, ratio_zx);}
			else					
			{delta_var = Ripley2D.variance_theo_delta_new(roi_t, imageWindows_1_2D, imageWindows_2_2D, volume, nbdeta, nbdetb, N_fit, distance_fit, N_h,results);
			}
		

		//calcul des fonctions de Ripley (cumulative) et variance pour fitting
		
		K.clear();
		K.add(0,0.0);
		for (int h = 1; h < N_fit; h++) {		
			K.add(K.get(h-1)+delta_K[h-1]);					
		}
		double[] var=new double[N_fit];
		var[0]=0.0;
		for (int i=1;i<N_fit;i++){
			var[i]=var[i-1]+delta_var[i-1];
		}
		//calcul de la fonction de Ripley normalisée
		for (int p = 1; p < N_fit; p++) {
			double expected_mean=0;
			if (dim==2){expected_mean=Math.PI*Math.pow(distance_fit.get(p), 2);}
			else{expected_mean=4/3*Math.PI*Math.pow(distance_fit.get(p), 3);}
			K.set(p, (K.get(p)-expected_mean)/var[p]);}

// fit sur K (cumulative fonction)	
		double[] start_est = new double[3];
		start_est[0] = 0.1D; // initial estimate of alpha
		start_est[1] = 1.01D; // initial estimate of mu
		start_est[2] = 0.3D;//sigma_ini.getValue(); // initial estimate of sigma
		double[] coeffs = new double[3];
		fit_data.main_manual(distance_fit, K, volume, nbdeta,dim,var);	
		coeffs = fit_data.coeffs;		
		//export des data dans le workbook
		//sauvegarde workbook
		   Row ro = sheet.createRow(row);		   
		   ro.getCell(0).setCellValue(t);
		   ro.getCell(1).setCellValue(nbdeta);
		   ro.getCell(2).setCellValue(nbdetb);
		   ro.getCell(3).setCellValue(distance_based[0]);
		   ro.getCell(4).setCellValue(distance_based[2]);
		   ro.getCell(5).setCellValue(distance_based[1]);		   
		   ro.getCell(6).setCellValue(step);
		   ro.getCell(7).setCellValue(maxdist);		   		   
		   ro.getCell(8).setCellValue(coeffs[0]);
		   ro.getCell(9).setCellValue(coeffs[1]);		   
		   ro.getCell(10).setCellValue((double)(total_coloc_temp/nbdetb));
		   ro.getCell(11).setCellValue(dist_moy);		   
		   ro.getCell(12).setCellValue(pvalue[N_fit-2]);
		   ro.getCell(13).setCellValue(log_pvalue[N_fit-2]);
		   row++;
 				}
 			}
 			//export des roi single, coloc et des tableau de probas etc
 			ROI[] c_1_tab = new ROI[c_1.size()];
 			ROI[] c_2_tab = new ROI[c_2.size()];
 			double[] dist_tab = new double[dist.size()];
 			double[] probas_tab = new double[probas.size()];		
 		for (int i=0;i<c_1.size();i++)
 		{c_1_tab[i]=c_1.get(i);c_2_tab[i]=c_2.get(i);dist_tab[i]=dist.get(i);probas_tab[i]=probas.get(i);}
 		
 		detections1Coloc.setValue(c_1_tab);
 		detections2Coloc.setValue(c_2_tab);
 		probas12.setValue(probas_tab);
 		dist12.setValue(dist_tab);
 		// calcul des ROIs single
 		ROI[] s_1_tab = new ROI[s_1.size()];
 		ROI[] s_2_tab = new ROI[s_2.size()];
 		
 		for (int i=0;i<s_1.size();i++){
 			s_1_tab[i]=s_1.get(i);
 		}
 		for (int i=0;i<s_2.size();i++){
 			s_2_tab[i]=s_2.get(i);
 		}	
 		detections1S.setValue(s_1_tab);
 		detections2S.setValue(s_2_tab);
	}
 				
	

	private void betaCorrection(double pas, int nbN) {

		Double valN = 1 / (1 / (double) nbN);
		N_h = valN.intValue() + 1; // / ATTENTION AUX BORNES

		double[] alpha = new double[N_h + 1];
		results = new double[N_h + 1];

		for (int i = 0; i < results.length; i++) {
			results[i] = 0;
			alpha[i] = 0.0d;

		}

		for (int i = 1; i < results.length; i++) {
			alpha[i] = (i / (double) N_h);
		}
		for (int i = 0; i < results.length; i++) {
			double h, j;
			for (h = alpha[i] + (pas), j = 2; h <= 1; j++) {
				results[i] = results[i] + h * pas / (1 - 1 / Math.PI * Math.acos(alpha[i] / h));
				h = alpha[i] + (j * pas);
			}

			results[i] = results[i] * 2 + alpha[i] * alpha[i];
		}

	}

	public static ROI[] detectionsInRoi(VarROIArray detections, ArrayList<ROI> roi) {
		// SEQUENCE A remplacer par w,h

		// create a hashMap with the detections binded to ROI

		if (roi.size()==0){return new ROI[0];}else{
		ROI[] detec = detections.getValue();
		ArrayList<ROI> ROIDetection = new ArrayList<ROI>();
		ArrayList<ROI> TestList = new ArrayList<ROI>();

		ROI union = ROIUtil.getUnion(roi);
		Point5D pos = union.getPosition5D();
		// fill hashMap
		for (ROI r : detec) {
			boolean b = false;
			for (ROI rt : TestList) {
				if (r == rt) {
					b = true;
				}
			}
			if (b == false) // si le spot n'a pas encore �t� pris en compte
			{
				TestList.add(r);
				if (union.contains(r.getPosition5D().getX(), r.getPosition5D().getY(),pos.getZ() , r.getPosition5D().getT(), pos.getC())) {
					ROIDetection.add(r);
				}
			}
		}
		ROI[] ROIDetection_ = new ROI[ROIDetection.size()];
		int ind=0;
		for (ROI r:ROIDetection){
			ROIDetection_[ind] = r;
			ind++;
		}
		return (ROIDetection_);}
	}

	public static ArrayList<ROI> ROI_t(int dim, ArrayList<ROI> list_roi, int t, int c) {

		ArrayList<ROI> list_roi_copy = new ArrayList<ROI>();
		for (ROI r:list_roi){
			list_roi_copy.add(r.getCopy());
		}
		// check compatibility en z si dim =3
		if (dim == 3) {
			boolean one_z = false;
			boolean all_z = true;
			for (ROI r0 : list_roi_copy) {
				if (r0.getBounds5D().isInfiniteZ() == false) {
					all_z = false;
				}
				if (r0.getBounds5D().isInfiniteZ()) {
					one_z = true;
				}
			}
			// gestion de l'exception
			if (one_z == true && all_z == false) {
				return null;
			}
		}

		ArrayList<ROI> roi_t = new ArrayList<ROI>();

		for (ROI r : list_roi_copy) {
			Point5D pt0 = r.getPosition5D();
			if (dim == 2) {
				pt0.setZ(-1);
			}
			if ((r.getBounds5D().isInfiniteC()) || (c == -1)) {
				pt0.setC(c);
			}
			if ((r.getBounds5D().isInfiniteT()) || (t == -1)) {
				pt0.setT(t);
			}
			r.setPosition5D(pt0);
			if ((pt0.getT() == t) && (pt0.getC() == c)) {
				roi_t.add(r);
			}
		}
		return roi_t;
	}

	public static void manual_computation2D(ArrayList<Point3D> positions1, ArrayList<Point3D> positions2,
			ArrayList<Double> distances, double[] col_ev) {
		for (Point3D s1Pos : positions1) {			
			for (Point3D s2Pos : positions2) {				
				double distance_12 = s1Pos.distance(s2Pos);
				for (int i = 1; i < distances.size(); i++) {
					if (distance_12 < distances.get(i)) {
						col_ev[i - 1] += 1;
						break;
					}
				}
			}
		}
	}

	public static void manual_computation3D(ArrayList<Point3D> positions1, ArrayList<Point3D> positions2,ArrayList<Double> distances, double[] col_ev,double ratio_zx) {
		for (Point3D s1Pos : positions1) {			
			for (Point3D s2Pos : positions2) {				
				double distance_12 = Math.sqrt(Math.pow(s1Pos.getX()-s2Pos.getX(), 2)+Math.pow(s1Pos.getY()-s2Pos.getY(), 2)+Math.pow((s1Pos.getZ()-s2Pos.getZ())* ratio_zx, 2));
				for (int i = 1; i < distances.size(); i++) {
					if (distance_12 < distances.get(i)) {
						col_ev[i - 1] += 1;
						break;
					}
				}
			}
		}
	}

	private String getDataSetName(Sequence sequence) {
		String dataSetName = "";
		// replace the sheet name by the file or sequence name
		dataSetName = FileUtil.getFileName(sequence.getFilename());
		if (dataSetName.isEmpty())
			dataSetName = sequence.getName();

		// make the name "safe"
		return WorkbookUtil.createSafeSheetName(dataSetName);
	}

	@Override
		public String getMainPluginClassName() {
			// TODO Auto-generated method stub
			return ColocalizationStudio.class.getName();
		}


}