package plugins.fab.singlemousetracker;

import java.awt.Color;
import java.awt.geom.Point2D;

import icy.roi.BooleanMask2D;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROIUtil;

import plugins.kernel.roi.roi2d.ROI2DArea;
import plugins.kernel.roi.roi2d.ROI2DRectangle;

/** store data to compute nose location */
public class Nose {

	ROI2DArea previousMouseROI;
	int timePointOfPreviousMouseROI;
	Point2D nosePosition = null;
	Point2D previousNosePosition = null;

	/** points computed by minor and major axis */
	Point2D pA = null;
	Point2D pB = null;

	public void computeNoseLocation(ROI2DArea mouseROI , int t, double speedThreshold ) {

		nosePosition = null;

		if ( mouseROI == null )
		{
			return;
		}

		if ( timePointOfPreviousMouseROI == t-1 && previousMouseROI != null )
		{
			// compute vector speed from previous detection
			Point2D previousMassCenter = ROIUtil.getMassCenter( (ROI2D) previousMouseROI );
			Point2D currentMassCenter = ROIUtil.getMassCenter( (ROI2D) mouseROI );

			Point2D vector = new Point2D.Double(
					currentMassCenter.getX()-previousMassCenter.getX(),
					currentMassCenter.getY()-previousMassCenter.getY() ) ;

			findMinorAndMajorAxis( mouseROI, currentMassCenter );

			double speed = Math.sqrt( Math.pow( vector.getX(),2 ) + Math.pow( vector.getY() , 2 ) );
			if ( speed > speedThreshold )
			{
				// use speed
				// take point that is closest to previous detection + speed * constant
				Point2D pointFarAhead = new Point2D.Double(
						currentMassCenter.getX() + 10.0 * vector.getX() ,
						currentMassCenter.getY() + 10.0 * vector.getY() );

				double distancePA = pA.distance( pointFarAhead );
				double distancePB = pB.distance( pointFarAhead );
				if ( distancePA < distancePB )
				{
					nosePosition = new Point2D.Double( pA.getX() , pA.getY() );
				}else
				{
					nosePosition = new Point2D.Double( pB.getX() , pB.getY() );
				}
			}
			else
			{
				if ( previousNosePosition != null )
				{
					// keep closest to last nose position.
					double distancePA = pA.distance( previousNosePosition );
					double distancePB = pB.distance( previousNosePosition );

					if ( distancePA < distancePB )
					{
						nosePosition = new Point2D.Double( pA.getX() , pA.getY() );
					}else
					{
						nosePosition = new Point2D.Double( pB.getX() , pB.getY() );
					}
				}
			}

			previousNosePosition = nosePosition;

		}

		this.previousMouseROI = mouseROI;
		this.timePointOfPreviousMouseROI = t;


	}

	private void findMinorAndMajorAxis( ROI2DArea mouseROI, Point2D massCenter) {

		BooleanMask2D mouseROIMask = mouseROI.getBooleanMask( true );
		Moment moment = new Moment( mouseROIMask );

		double angle = moment.aoipar.theta;
		double longAxis = moment.aoipar.longAxis;
		double shorterAxis = moment.aoipar.shorterAxis;

		pA = new Point2D.Double( massCenter.getX() + Math.cos( angle ) * longAxis /2d ,
				massCenter.getY() + Math.sin( angle ) * longAxis /2d
				);
		pB = new Point2D.Double( massCenter.getX() - Math.cos( angle ) * longAxis / 2d ,
				massCenter.getY() - Math.sin( angle ) * longAxis / 2d
				);

	}



	public ROI2DRectangle getROI() {

		if ( nosePosition != null )
		{
			ROI2DRectangle roiRectangle = new ROI2DRectangle(
					nosePosition.getX()-5, nosePosition.getY()-5,
					nosePosition.getX()+5, nosePosition.getY()+5
					);
			roiRectangle.setColor( Color.red );
			return roiRectangle;
		}
		return null;
	}

}
