package plugins.fab.singlemousetracker;

import icy.common.exception.UnsupportedFormatException;
import icy.file.Saver;
import icy.gui.dialog.MessageDialog;
import icy.gui.dialog.OpenDialog;
import icy.gui.frame.IcyFrame;
import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.frame.progress.ProgressFrame;
import icy.gui.frame.progress.ToolTipFrame;
import icy.gui.util.GuiUtil;
import icy.gui.viewer.Viewer;
import icy.gui.viewer.ViewerEvent;
import icy.gui.viewer.ViewerListener;
import icy.image.IcyBufferedImage;
import icy.plugin.abstract_.PluginActionable;
import icy.preferences.XMLPreferences;
import icy.roi.BooleanMask2D;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROIUtil;
import icy.sequence.MetaDataUtil;
import icy.sequence.Sequence;
import icy.system.profile.Chronometer;
import icy.system.thread.ThreadUtil;
import icy.type.DataType;
import icy.util.XLSUtil;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import loci.formats.ome.OMEXMLMetadataImpl;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

import plugins.kernel.roi.roi2d.ROI2DArea;
import plugins.kernel.roi.roi2d.ROI2DPoint;
import plugins.kernel.roi.roi2d.ROI2DPolygon;
import plugins.kernel.roi.roi2d.ROI2DRectangle;
import plugins.stef.importer.xuggler.VideoImporter;
import sun.awt.image.PixelConverter.Bgrx;

public class SingleMouseTracker extends PluginActionable implements ActionListener, ViewerListener {

	JPanel mainPanel = GuiUtil.generatePanel();
	IcyFrame icyFrame = GuiUtil.generateTitleFrame("Single Mouse Tracker", mainPanel, new Dimension(0,0), true, true ,true ,true );

	JButton selectAndProcessMultipleInputFileButton;
	JButton selectInputFileButton;
	JButton startComputationButton;
	JButton stopComputationButton;
	JButton testShortestPathButton;
	JButton saveROIButton;

	JTextField startFrameTextField;
	JTextField endFrameTextField;
	JTextField thresholdTextField;

	JCheckBox whiteMiceCheckBox = new JCheckBox("Track White Mice");

	ChartPanel distanceToInterestChartPanel ;
	JFreeChart distanceToInterestChart;
	XYSeriesCollection xyDistanceToInterestDataset = new XYSeriesCollection();

	ChartPanel distanceTraveledChartPanel ;
	JFreeChart distanceTraveledChart;
	XYSeriesCollection xyDistanceTraveledDataset = new XYSeriesCollection();

	ChartPanel timeAreaChartPanel ;
	JFreeChart timeAreaChart;
	XYSeriesCollection xyTimeAreaDataset = new XYSeriesCollection();


	protected VideoImporter importer;
	protected int nbFrame;
	Sequence inputSequence = new Sequence();

	enum State { NORMAL, STOP_COMPUTATION };

	State state = State.NORMAL;

	@Override
	public void run() {

		new ToolTipFrame(
				"<html>" +
				"<br>This plugin is a very simple single mouse tracker" +
				"<br>It is based on threshold and can run on video with black" +
				"<br>mice very differenciated from the background" +
				"<br><br>*** This is still a toy plugin ***" +
				"<br><br>Input should come as follow:"+
				"<br>Infos provided by ROIs in a sequence:" +
				"<br>The cage should be a ROI2DPolygon named cage"+
				"<br>Areas should be a ROI2DPolygon named area xxx"+
				"<br>Areas of interst should be an ROI named interest xxx" +
				"<br><br>Click to close" +
				"</html>"
				);

		// build and display the GUI

		selectInputFileButton = new JButton("Select input file");
		selectAndProcessMultipleInputFileButton = new JButton("Select and process multiple input file");
		startComputationButton = new JButton("Start computation");
		stopComputationButton = new JButton("Stop computation");
		testShortestPathButton = new JButton("Test shortest path");
		saveROIButton = new JButton("Save ROIs");

		startFrameTextField = new JTextField("0");
		endFrameTextField = new JTextField("99999999");
		thresholdTextField = new JTextField("50");

		selectInputFileButton.addActionListener( this );
		selectAndProcessMultipleInputFileButton.addActionListener( this );
		startComputationButton.addActionListener( this );
		stopComputationButton.addActionListener( this );
		testShortestPathButton.addActionListener( this );
		startComputationButton.setEnabled( false );
		saveROIButton.addActionListener( this );

		//mainFrame.getContentPane().setLayout( new BoxLayout( mainFrame.getContentPane() , BoxLayout.PAGE_AXIS ));
		mainPanel.add( GuiUtil.createLineBoxPanel( selectInputFileButton , selectAndProcessMultipleInputFileButton ) );
		mainPanel.add( GuiUtil.createLineBoxPanel( startComputationButton , stopComputationButton ) );
		//mainPanel.add( GuiUtil.createLineBoxPanel( testShortestPathButton ) );
		mainPanel.add( GuiUtil.createLineBoxPanel( saveROIButton ) );

		mainPanel.add( GuiUtil.createLineBoxPanel( new JLabel("StartFrame:"), startFrameTextField ) );
		mainPanel.add( GuiUtil.createLineBoxPanel( new JLabel("EndFrame:"), endFrameTextField ) );
		mainPanel.add( GuiUtil.createLineBoxPanel( new JLabel("Threshold:"), thresholdTextField ) );
		mainPanel.add( GuiUtil.createLineBoxPanel( whiteMiceCheckBox ) );

		// place distance to interest chart

		distanceToInterestChart = ChartFactory.createXYLineChart(
				"Distance to interest", "", "distance to interest", xyDistanceToInterestDataset,
				PlotOrientation.VERTICAL, true, true, true);
		distanceToInterestChartPanel = new ChartPanel(distanceToInterestChart, 500, 200, 500, 200, 500, 500, false, false, true, true, true, true);
		mainPanel.add(  GuiUtil.createLineBoxPanel( distanceToInterestChartPanel ) );
		distanceToInterestChart.setAntiAlias( true );
		distanceToInterestChart.setTextAntiAlias( true );

		// place distance traveled chart

		distanceTraveledChart = ChartFactory.createXYLineChart(
				"Distance traveled", "", "cumulated distance traveled", xyDistanceTraveledDataset,
				PlotOrientation.VERTICAL, true, true, true);
		distanceTraveledChartPanel = new ChartPanel(distanceTraveledChart, 500, 200, 500, 200, 500, 500, false, false, true, true, true, true);
		mainPanel.add(  GuiUtil.createLineBoxPanel( distanceTraveledChartPanel ) );
		distanceTraveledChart.setAntiAlias( true );
		distanceTraveledChart.setTextAntiAlias( true );

		// place time in area chart

		timeAreaChart = ChartFactory.createXYLineChart(
				"cumulated time in area", "", "t (in frame)", xyTimeAreaDataset,
				PlotOrientation.VERTICAL, true, true, true);
		timeAreaChartPanel = new ChartPanel(timeAreaChart, 500, 200, 500, 200, 500, 500, false, false, true, true, true, true);
		mainPanel.add( GuiUtil.createLineBoxPanel( timeAreaChartPanel ) );
		timeAreaChart.setAntiAlias( true );
		timeAreaChart.setTextAntiAlias( true );

		// end display

		icyFrame.pack();
		icyFrame.addToDesktopPane();

		inputSequence.setName("Simple Mouse Tracker Sequence");
		addSequence( inputSequence );


	}

	@Override
	public void actionPerformed(ActionEvent e ) {

		if ( e.getSource() == saveROIButton )
		{
			inputSequence.saveXMLData();
		}

		if ( e.getSource() == selectInputFileButton )
		{
			selectInputFile( null, true );
		}

		if ( e.getSource() == selectAndProcessMultipleInputFileButton )
		{
			selectAndProcessMultipleFile();
		}

		if ( e.getSource() == startComputationButton )
		{
			ThreadUtil.bgRun( new Runnable() {

				@Override
				public void run() {
					startComputation();
				}
			});
		}

		if ( e.getSource() == stopComputationButton )
		{
			state = State.STOP_COMPUTATION;
		}

		if ( e.getSource() == testShortestPathButton )
		{
			testShortestPath();
		}

	}

	private void selectAndProcessMultipleFile() {

		XMLPreferences prefPath = getPreferences("pref");
		String defaultPath = prefPath.get("openDialogPath", "");
		System.out.println("Default path: " +  defaultPath );

		JFileChooser chooser = new JFileChooser("Select several mp4 to process.");
		if ( defaultPath != null )
		{
			chooser.setCurrentDirectory( new File ( defaultPath ) );
		}
		chooser.setFileFilter( new FileFilter() {

			@Override
			public String getDescription() {
				return "mp4 video files (*.mp4)";
			}

			@Override
			public boolean accept(File f) {
				if ( f.isDirectory()) return true;
				return f.getName().toLowerCase().endsWith(".mp4");
			}
		});

		chooser.setMultiSelectionEnabled(true);
		if ( JFileChooser.APPROVE_OPTION != chooser.showOpenDialog( null ) )
		{
			return;
		}

		File[] files = chooser.getSelectedFiles();

		if ( files == null ) return;
		if ( files.length == 0 ) return;

		ThreadUtil.bgRun( new Runnable() {
			@Override
			public void run() {
				ProgressFrame progressFrame = new ProgressFrame("Processing...");
				int nbFile = 0;
				nbFile++;
				for ( File file : files )
				{
					progressFrame.setPosition( 100.0 * nbFile / files.length );
					progressFrame.setMessage("Processing file " + file.getName() + "..." + " ( " + nbFile + "/"+ files.length + ")");
					selectInputFile( file,false );
					startComputation();
				}
				progressFrame.setPosition( 100 );
				progressFrame.setMessage("Done");
			}
		});

	}

	private void testShortestPath() {

		System.out.println("Generating results...");

		System.out.println( "polygon ROI Test");


		ROI2DPolygon roiPoly = (ROI2DPolygon) getROI( "poly");
		ROI2DPoint roiP1 = (ROI2DPoint) getROI( "p1");
		ROI2DPoint roiP2 = (ROI2DPoint) getROI( "p2");

		// create a line between p1 et p2

		ROI roiPath = getROI( "path");
		getActiveSequence().removeROI( roiPath );

		ShortestPathSolver shortestPathSolver =
				new ShortestPathSolver( roiPoly, roiPoly.getBooleanMask(true), roiP1.getPoint() , roiP2.getPoint() );

		getActiveSequence().addROI( shortestPathSolver.getBestPathAsROI() );
	}


	private ROI getROI(String string) {

		for( ROI roi : 	getActiveSequence().getROIs() )
		{
			if ( roi.getName().startsWith( string ) ) return roi;
		}
		return null;
	}

	private void startComputation() {

		System.out.println("Computation Started...");

		int startingFrame = Integer.parseInt( startFrameTextField.getText() );
		int endingFrame = Integer.parseInt( endFrameTextField.getText() );

		if ( inputSequence.getSizeT() < endingFrame )
		{
			endingFrame = inputSequence.getSizeT();
		}

		System.out.println("Starting Frame: " + startingFrame );
		System.out.println("Ending Frame: " + endingFrame );

		Chronometer chrono = new Chronometer("Tracking computation" );

		System.out.println("TEST A");

		// prepare heatMap
		Sequence heatMapSequence = new Sequence();
		IcyBufferedImage heatMapImage = new IcyBufferedImage(
				inputSequence.getWidth(),
				inputSequence.getHeight(),
				1,
				DataType.INT );
		int[] heatMapDataBuffer = heatMapImage.getDataXYAsInt( 0 );
		heatMapSequence.addImage( heatMapImage );
		heatMapSequence.setName("HeatMap " + inputSequence.getName() );
		addSequence( heatMapSequence );
		int width = inputSequence.getWidth();

		System.out.println("TEST B");

		// prepare plot
		xyDistanceToInterestDataset.removeAllSeries();
		xyTimeAreaDataset.removeAllSeries();
		xyDistanceTraveledDataset.removeAllSeries();

		HashMap<ROI, XYSeries> graphDistanceSeries = new HashMap<ROI, XYSeries>();
		HashMap<ROIData, XYSeries> graphTimeAreaSeries = new HashMap<ROIData, XYSeries>();

		XYSeries seriesDistanceTraveledXY = new XYSeries("Cumulated mouse distance" );
		xyDistanceTraveledDataset.addSeries( seriesDistanceTraveledXY );
		// process
		System.out.println("TEST C");

		int threshold = 0;
		try
		{
			threshold = Integer.parseInt( thresholdTextField.getText() );
		}catch( Exception e )
		{
			new AnnounceFrame("Can't interpret the threshold value.");
			return;
		}
		boolean trackWhite = whiteMiceCheckBox.isSelected();

		Sequence workSequence = new Sequence();
		addSequence( workSequence );

		ProgressFrame progress = new ProgressFrame("Processing...");
		ROI2DRectangle sequenceBoundingROI = new ROI2DRectangle( 0 , 0 , inputSequence.getSizeX(), inputSequence.getSizeY() );

		ROI cageLimitROI = null;
		BooleanMask2D cageMask=null;

		System.out.println("TEST D");


		ArrayList<ROI2D> roiList = inputSequence.getROI2Ds();
		inputSequence.beginUpdate();

		ArrayList<ROI> resultMousePositionArrayList = new ArrayList<ROI>();


		System.out.println("TEST E");


		ArrayList<Point2D> point2DXYMousePosition = new ArrayList<Point2D>();

		for ( ROI2D roi : roiList )
		{
			if ( roi.getName().contains( "cage") )
			{
				System.out.println("Cage ROI (named cage) found.");
				cageLimitROI = roi;
				if ( ! ( cageLimitROI instanceof ROI2DPolygon ) )
						{
					new AnnounceFrame("The cage must be a ROI 2D POLYGON");
					progress.canRemove();
					return;
						}
				cageMask = cageLimitROI.getBooleanMask2D( 0 , 0, 1, true );
			}
			if ( roi.getName().contains("det") )
			{
				inputSequence.removeROI(roi);
			}

			if ( roi.getName().contains("nose") )
			{
				inputSequence.removeROI(roi);
			}

			if ( roi.getName().startsWith("interest") )
			{
				final XYSeries seriesXY = new XYSeries("Distance To "+ roi.getName() );
				seriesXY.setDescription( "Distance To "+ roi.getName() );
				xyDistanceToInterestDataset.addSeries( seriesXY );
				for (int i=0 ; i<= startingFrame ; i++ )
				{
					seriesXY.add( i , 0 );
				}				//seriesXY.add( inputSequence.getSizeT() , 0 );
				graphDistanceSeries.put( roi, seriesXY );
			}
			if ( roi.getName().startsWith("area") || roi.getName().startsWith("interest") )
			{
				// to compute time spent in area

				final XYSeries seriesXY = new XYSeries("Area "+ roi.getName() );
				seriesXY.setDescription( "Area "+ roi.getName() );
				xyTimeAreaDataset.addSeries( seriesXY );

				for (int i=0 ; i<= startingFrame ; i++ )
				{
					seriesXY.add( i , 0 );
				}

				graphTimeAreaSeries.put( new ROIData( roi ), seriesXY );
			}


		}

		for (int i=0 ; i<= startingFrame ; i++ )
		{
			seriesDistanceTraveledXY.add( i , 0 );
			System.out.println("seriesDistanceTraveledXY : Adding " + i );
		}

		inputSequence.endUpdate();

		System.out.println("TEST FF");


		try {
		System.out.println("Ending frame = " + endingFrame );
		double cumulatedDistance = 0;

		// to compute nose.
		Nose nose = new Nose();
		Point2D previousMousePosition = null;

			for ( int t = startingFrame ; t < endingFrame ; t ++ )
			{
				//System.out.println("Current t : " + t );
				if ( state == State.STOP_COMPUTATION ) break;

				int pos = (int)(100d * (double)t / (double)nbFrame);
				progress.setPosition( pos );
				int nbSecond =  (int) (chrono.getNanos() / 1000000000f);
				progress.setMessage( "Processing: " + pos + " %" + "  " + nbSecond + " s");

				IcyBufferedImage image = importer.getImage( 0 ,  t );

				workSequence.setImage( 0 , 0 , image);

				ROI2DArea roi = threshold( workSequence , threshold , trackWhite );

				if ( cageLimitROI!=null )
				{
					roi = new ROI2DArea( roi.getBooleanMask( true ).getIntersection( cageMask ) );
				}

				ROI2DArea mouseROI = null;
				// find biggest component in the threshold
				int max = 0;
				BooleanMask2D bestMask = null;
				for ( BooleanMask2D mask : roi.getBooleanMask( true ).getComponents() )
				{
					if ( mask.getPoints().length > max )
					{
						bestMask = mask;
						max = mask.getPoints().length;
					}
				}
				if ( bestMask != null )
				{
					mouseROI = new ROI2DArea( bestMask );
				}

				// 10 for 1280x720 video
				// 10 1280
				// x width
				nose.computeNoseLocation( mouseROI, t , 10.0*image.getWidth()/1280.0 );

				workSequence.removeAllROI();

				if ( mouseROI == null )
				{
					continue;
				}

				workSequence.addROI( mouseROI );
				ROI2DRectangle noseROI = nose.getROI();

				if ( nose.nosePosition != null )
				{
					workSequence.addROI( noseROI );
				}

				ROI2DArea mouseROICopy = (ROI2DArea) mouseROI.getCopy();
				mouseROICopy.setT( t );
				mouseROICopy.setName("det " + t );
				resultMousePositionArrayList.add( mouseROICopy );
				//inputSequence.addROI( mouseROICopy );

				// heatmap increase

				if ( bestMask != null )
				{
					for ( Point p : bestMask.getPoints() )
					{
						heatMapDataBuffer[ p.x + p.y * width ]++;
					}
					//heatMapSequence.dataChanged();
				}

				// compute the ran distance of the animal

				// mousePosition

				Point2D mousePosition = ROIUtil.getMassCenter( mouseROI );

				// compute graphs
				{
					// Distance graph
					for ( ROI roiI : graphDistanceSeries.keySet() )
					{
						//Point2D massCenter = ROIUtil.getMassCenter( (ROI2D ) roiI );
						XYSeries series = graphDistanceSeries.get( roiI );

						Point2D interestPoint = ROIUtil.getMassCenter( (ROI2D) roiI );
						ShortestPathSolver shortestPathSolver =
								new ShortestPathSolver( (ROI2DPolygon) cageLimitROI, cageMask,
										mousePosition , interestPoint );



						//series.add( t , massCenter.distance( mousePosition ) );
						series.add( t , shortestPathSolver.shortestDistance );
						workSequence.addROI( shortestPathSolver.getBestPathAsROI() );
						//shortestPathSolver.shortestDistance
					}
				}

				{
					// Time in area graph
					for ( ROIData roiI : graphTimeAreaSeries.keySet() )
					{
						XYSeries series = graphTimeAreaSeries.get( roiI );
						//System.out.println( series );
						{
//							int val = 0;
							//System.out.println( "Current t in ROI loop: " + t );
							if ( t > startingFrame )
							{
								//	System.out.println( "startingFrame : " + startingFrame );
								//probleme ici
								//val = roiI.cumulatedTime;
										//series.getY( t-1 ).intValue();
								if ( roiI.roi !=null )
								{
								///	System.out.println("okay " + roiI.cumulatedTime );
									if ( roiI.roi.getName().toLowerCase().contains( "nose") )
									{
										if ( noseROI != null )
										{
											if ( roiI.roi.intersects( noseROI ) ) roiI.cumulatedTime++;
										}
									}else
									{
										if ( roiI.roi.intersects( mouseROI ) ) roiI.cumulatedTime++;
									}

								}
							}

							series.add( t , roiI.cumulatedTime );
						}
					}

					// cumulated mouse traveled time
					{

						if ( t > startingFrame )
						{
							//System.out.println("T:" + t );
							//System.out.println("index: " + seriesDistanceTraveledXY.getItemCount() );
							if ( previousMousePosition != null )
							{
								//cumulatedDistance = seriesDistanceTraveledXY.getY( t-1 ).doubleValue();
								//System.out.println( "A:"+ val );
								cumulatedDistance+= previousMousePosition.distance( mousePosition );
								//System.out.println( "B:"+ val );
							}
							seriesDistanceTraveledXY.add( t , cumulatedDistance );
						}

						//System.out.println( "C:" + t +":"+ val );
						previousMousePosition = mousePosition;
						point2DXYMousePosition.add( mousePosition );
						}
					}

				}

// live update
//				distanceToInterestChart.fireChartChanged();
//				timeAreaChart.fireChartChanged();
//				distanceTraveledChart.fireChartChanged();




		} catch (UnsupportedFormatException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} finally
		{

			progress.close();
			workSequence.close();
			state = State.NORMAL;
		}

		heatMapSequence.dataChanged();
		distanceToInterestChart.fireChartChanged();
		timeAreaChart.fireChartChanged();
		distanceTraveledChart.fireChartChanged();


		// copy created ROIs to inputSequence

		System.out.println("Copying results to input sequence");
		try
		{
			inputSequence.beginUpdate();
			for ( ROI roi : resultMousePositionArrayList )
			{
				inputSequence.addROI( roi );
			}
		}
		finally
		{
			inputSequence.endUpdate();
		}

		// xls output

		System.out.println("XLS output");

		try {
			WritableWorkbook xlsWorkBook = XLSUtil.createWorkbook( inputSequence.getFilename()+ ".trackingResults.xls");

			// --------------
			WritableSheet distanceToInterest = XLSUtil.createNewPage( xlsWorkBook , "cum distance to interest" );

			for ( int i = 0 ; i < xyDistanceToInterestDataset.getSeries().size() ; i++ )
			{
				XYSeries serie = xyDistanceToInterestDataset.getSeries( i );
				XLSUtil.setCellString( distanceToInterest , 0, 0, "Frame" );
				XLSUtil.setCellString( distanceToInterest , i+1, 0, serie.getDescription() );

				for ( int t = startingFrame ; t < endingFrame; t++ )
				{
					try{
						serie.getY( t ).doubleValue();
						XLSUtil.setCellNumber( distanceToInterest , 0 , t+1 , t ); // display frame number
						XLSUtil.setCellNumber( distanceToInterest , i+1 , t+1 , serie.getY( t ).doubleValue() ); // display value
					}catch( IndexOutOfBoundsException e)
					{
						// value don't exist.
					}
				}
			}

			// --------------
			WritableSheet distanceTraveled = XLSUtil.createNewPage( xlsWorkBook , "cum distance traveled" );

			for ( int i = 0 ; i < xyDistanceTraveledDataset.getSeries().size() ; i++ )
			{
				XYSeries serie = xyDistanceTraveledDataset.getSeries( i );
				XLSUtil.setCellString( distanceTraveled , 0, 0, "Frame" );
				XLSUtil.setCellString( distanceTraveled , i+1, 0, serie.getDescription() );

				for ( int t = startingFrame ; t < endingFrame; t++ )
				{
					try
					{
						XLSUtil.setCellNumber( distanceTraveled , 0 , t+1 , t ); // display frame number
						XLSUtil.setCellNumber( distanceTraveled , i+1 , t+1 , serie.getY( t ).doubleValue() ); // display value
					}catch ( IndexOutOfBoundsException e )
					{
						// no value for this t.
					}
				}
			}

			// --------------
			WritableSheet xyTimeAreaDatasetPage = XLSUtil.createNewPage( xlsWorkBook , "cum time in area" );

			for ( int i = 0 ; i < xyTimeAreaDataset.getSeries().size() ; i++ )
			{
				XYSeries serie = xyTimeAreaDataset.getSeries( i );
				XLSUtil.setCellString( xyTimeAreaDatasetPage , 0, 0, "Frame" );
				XLSUtil.setCellString( xyTimeAreaDatasetPage , i+1, 0, serie.getDescription() );

				for ( int t = startingFrame ; t < endingFrame ; t++ )
				{
					try
					{
					XLSUtil.setCellNumber( xyTimeAreaDatasetPage , 0 , t+1 , t ); // display frame number
					XLSUtil.setCellNumber( xyTimeAreaDatasetPage , i+1 , t+1 , serie.getY( t ).doubleValue() ); // display value
					}catch ( IndexOutOfBoundsException e )
					{
						// no value for this t.
					}
				}
			}

			// --------------
			WritableSheet xyMousePositionPage = XLSUtil.createNewPage( xlsWorkBook , "xy mass center" );
			XLSUtil.setCellString( xyMousePositionPage , 0, 0, "Frame" );
			XLSUtil.setCellString( xyMousePositionPage , 1, 0, "x" );
			XLSUtil.setCellString( xyMousePositionPage , 2, 0, "y" );
			for ( int t = startingFrame ; t < endingFrame;  t++ )
			{
				try
				{
					Point2D mousePosition = point2DXYMousePosition.get( t - startingFrame );
					XLSUtil.setCellNumber( xyMousePositionPage, 0 , t+1 , t ); // frame number
					XLSUtil.setCellNumber( xyMousePositionPage, 1 , t+1 , mousePosition.getX() ); // x location
					XLSUtil.setCellNumber( xyMousePositionPage, 2 , t+1 , mousePosition.getY() ); // y location
				}catch( IndexOutOfBoundsException e)
				{
					// no mouse Position
				}

			}

			XLSUtil.saveAndClose( xlsWorkBook );


		} catch (IOException e) {
			e.printStackTrace();
		} catch (WriteException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		// Save heatMapFile

		heatMapSequence.setFilename( inputSequence.getFilename() + ".heatmap.tif");
		Saver.save( heatMapSequence , new File( heatMapSequence.getFilename() ) );
		heatMapSequence.close();

		chrono.displayInSeconds();

		System.out.println("Computation Finished.");
		inputSequence.saveXMLData();

	}

	private ROI2DArea threshold(Sequence workSequence, int threshold , boolean white ) {

		byte[] arrayRed = workSequence.getDataXYAsByte( 0, 0, 0);
		byte[] arrayGreen = workSequence.getDataXYAsByte( 0, 0, 1);
		byte[] arrayBlue = workSequence.getDataXYAsByte( 0, 0, 2);

		boolean[] mask = new boolean[ arrayRed.length ];

		if ( white)
		{
			for ( int i = 0 ; i < arrayRed.length ; i++ )
			{
				float r = ( arrayRed[i] & 0xFF );
				float g = ( arrayGreen[i] & 0xFF );
				float b = ( arrayBlue[i] & 0xFF );
				float intensity = (r+g+b)/3f;

				if ( Math.abs( r-g ) > 10 )
				{
					mask[i] = false;
					continue;
				}
				if ( Math.abs( r-b ) > 10 )
				{
					mask[i] = false;
					continue;
				}

				mask[i] = ( intensity ) > threshold ;
			}
		}else
		{ // black: only work with red
			for ( int i = 0 ; i < arrayRed.length ; i++ )
			{
				mask[i] = ( ((int) arrayRed[i] ) & 0xFF ) < threshold ;
			}
		}

		BooleanMask2D bmask = new BooleanMask2D( workSequence.getBounds2D(), mask );
		ROI2DArea roiResult = new ROI2DArea( bmask );

		return roiResult;

	}

	/**
	 *
	 * @param file optional. If file is specified, override all the file choosing process
	 */
	private void selectInputFile( File file , boolean threaded ) {

		// save existing data on current sequence before updating it
		inputSequence.saveXMLData();
		inputSequence.removeAllImages();
		inputSequence.removeAllROI( false );

		String fileName;

		if ( file == null )
		{

			XMLPreferences prefPath = getPreferences("pref");
			String defaultPath = prefPath.get("openDialogPath", "");
			System.out.println("Default path: " +  defaultPath );

			fileName = OpenDialog.chooseFile( defaultPath , defaultPath );

			if ( fileName == null ) return;

			if ( fileName !=null )
			{
				prefPath.put( "openDialogPath", fileName );
			}
		}else
		{
			fileName = file.getAbsoluteFile().toString();
		}

		if (importer != null )
		{
			try {
				importer.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}

		importer = new VideoImporter();


//		selectInputFileButton.setEnabled( false );
		startComputationButton.setEnabled( false );

		Runnable run =
		new Runnable() {

			@Override
			public void run() {

				ProgressFrame progressFrame = new ProgressFrame("Loading metadata of " + fileName );
				progressFrame.setPosition( -1 ); // indeterminate state.

				try {
					System.out.println( "Loading metadata for " + fileName );

					if ( importer.open( fileName, 0 ) )
					{
						// ok

						OMEXMLMetadataImpl metaData = importer.getMetaData();
						System.out.println( "time interval: " + MetaDataUtil.getTimeInterval( metaData, 0, 0 ) );
						nbFrame = MetaDataUtil.getSizeT( metaData, 0 ) - 2 ; // get one frame less as there is a little bug in the decompression of the video in h264
						System.out.println( "nb frame : " + nbFrame );
						System.out.println( "Load meta data ok.");

						inputSequence.setFilename(fileName);
						inputSequence.loadXMLData();

						startComputationButton.setEnabled( true );

						IcyBufferedImage image = importer.getImage( 0 ,  0 );
						inputSequence.setImage( 0 , 0, image);

						inputSequence.setName("Simple Mouse Tracker " + fileName );

						image = importer.getImage( 0 , nbFrame -1 );
						inputSequence.setImage( nbFrame-1 , 0, image);

						inputSequence.getFirstViewer().addListener( SingleMouseTracker.this );

					}else
					{
						cantOpenFile();
					}



				} catch (UnsupportedFormatException e) {
					cantOpenFile();
					e.printStackTrace();
				} catch (IOException e) {
					cantOpenFile();
					e.printStackTrace();
				}
				finally{
					progressFrame.close();
				}
			}

		} ;

		if ( threaded )
		{
			ThreadUtil.bgRun( run );
		}else
		{
			run.run();
		}


	}

	private void cantOpenFile() {

		startComputationButton.setEnabled( false );
		MessageDialog.showDialog( "Can't open video file. Is it an .mp4 file ?", MessageDialog.ERROR_MESSAGE );

	}

	@Override
	public void viewerChanged(ViewerEvent event) {

		if ( event.getType() == ViewerEvent.ViewerEventType.POSITION_CHANGED )
		{
			loadImageForViewerAt( inputSequence.getFirstViewer().getPositionT() );
		}

	}

	// load image at t
	private void loadImageForViewerAt(int positionT) {

		// remove all existing files

		inputSequence.beginUpdate();
		for ( int t = 1 ; t < nbFrame-1 ; t++ )
		{
			if ( Math.abs( positionT - t ) < 20 )
			{
				inputSequence.removeImage( t, 0 );
			}
		}
		inputSequence.endUpdate();


		try {

			IcyBufferedImage image;
			image = importer.getImage( 0 , positionT );
			inputSequence.setImage( positionT , 0, image);

		} catch (UnsupportedFormatException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}

	}

	@Override
	public void viewerClosed(Viewer viewer) {

	}


}
