package plugins.vannary.morphomaths.blocks;

import icy.plugin.abstract_.PluginActionable;
import icy.plugin.interface_.PluginLibrary;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarListener;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.vannary.morphomaths.MorphOp;

public class OpeningBinary extends PluginActionable implements Block, PluginLibrary {

	private static double[][][] STRUCTURING_ELEMENT_3D = new double[][][] { { { 1, 1, 1 }, { 1, 1, 1 }, { 1, 1, 1 } },
			{ { 1, 1, 1 }, { 1, 1, 1 }, { 1, 1, 1 } }, { { 1, 1, 1 }, { 1, 1, 1 }, { 1, 1, 1 } } };

	private static double[][] STRUCTURING_ELEMENT_2D = new double[][] { { 1, 1, 1 }, { 1, 1, 1 }, { 1, 1, 1 } };

	private EzVarSequence inputSequence;
	private EzVarInteger inputDistance1;
	private EzVarInteger inputDistance2;
	private EzVarBoolean inputOverwriteResult;
	private EzVarBoolean input3dModality;
	private EzVarInteger inputProcessedZ;

	@Override
	public void declareInput(VarList inputMap) {
		inputSequence = new EzVarSequence("Sequence");
		inputDistance1 = new EzVarInteger("Distance Erosion", 1, 0, Integer.MAX_VALUE, 1);
		inputDistance2 = new EzVarInteger("Distance Dilation", 1, 0, Integer.MAX_VALUE, 1);
		inputOverwriteResult = new EzVarBoolean("Results on input", false);
		input3dModality = new EzVarBoolean("Compute in 3D", false);
		inputProcessedZ = new EzVarInteger("Z value");

		inputProcessedZ.getVariable().setEnabled(false);
		input3dModality.addVarChangeListener(new EzVarListener<Boolean>() {

			@Override
			public void variableChanged(EzVar<Boolean> source, Boolean newValue) {
				if (newValue) {
					inputProcessedZ.getVariable().setEnabled(false);
				} else {
					inputProcessedZ.getVariable().setEnabled(true);
				}
			}
		});

		inputMap.add(inputSequence.name, inputSequence.getVariable());
		inputMap.add(inputDistance1.name, inputDistance1.getVariable());
		inputMap.add(inputDistance2.name, inputDistance2.getVariable());
		inputMap.add(inputOverwriteResult.name, inputOverwriteResult.getVariable());
		inputMap.add(input3dModality.name, input3dModality.getVariable());
		inputMap.add(inputProcessedZ.name, inputProcessedZ.getVariable());
	}

	private EzVarSequence outputSequence;

	@Override
	public void declareOutput(VarList outputMap) {
		outputSequence = new EzVarSequence("Dilation Sequence");
		outputMap.add(outputSequence.name, outputSequence.getVariable());
	}

	private Sequence transformedSequence;

	@Override
	public void run() {
		Sequence inSequence = inputSequence.getValue(true);
		int distance1 = inputDistance1.getValue();
		int distance2 = inputDistance2.getValue();
		boolean isReusingSequence = inputOverwriteResult.getValue();
		boolean is3D = input3dModality.getValue();
		int processedZ = inputProcessedZ.getValue();

		if (isReusingSequence) {
			transformedSequence = inSequence;
		} else {
			transformedSequence = SequenceUtil.getCopy(inSequence);
			transformedSequence.setName(inSequence.getName() + "_Dilation");
		}

		if (distance1 < 0 || distance2 < 0) {
			throw new RuntimeException("Distances must be non-negative");
		}

		for (int i = 0; i < distance1 && !Thread.interrupted(); i++) {
			if (is3D) {
				MorphOp.erodeGreyScale3D(transformedSequence, STRUCTURING_ELEMENT_3D, 1, 1, 1);
			} else {
				if (processedZ >= 0 && processedZ < transformedSequence.getSizeZ()) {
					MorphOp.erodeGreyScale(transformedSequence, processedZ, STRUCTURING_ELEMENT_2D, 1, 1);
				} else {
					throw new RuntimeException("Invalid z coordinate: " + processedZ + ". Expected [0 - "
							+ transformedSequence.getSizeZ() + ")");
				}
			}

		}

		for (int i = 0; i < distance2 && !Thread.interrupted(); i++) {
			if (is3D) {
				MorphOp.dilateGreyScale3D(transformedSequence, STRUCTURING_ELEMENT_3D, 1, 1, 1);
			} else {
				if (processedZ >= 0 && processedZ < transformedSequence.getSizeZ()) {
					MorphOp.dilateGreyScale(transformedSequence, processedZ, STRUCTURING_ELEMENT_2D, 1, 1);
				} else {
					throw new RuntimeException("Invalid z coordinate: " + processedZ + ". Expected [0 - "
							+ transformedSequence.getSizeZ() + ")");
				}
			}

		}

		transformedSequence.updateChannelsBounds();
		outputSequence.setValue(transformedSequence);
	}

}
