package plugins.hrositi.log;

import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
// import flanagan.math.DataType;
// import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarSequence;
import icy.image.IcyBufferedImage;
import icy.math.ArrayMath;

/*
 * import java.util.ArrayList;
 * 
 * import icy.roi.BooleanMask2D;
 * import icy.roi.ROI2D;
 * import icy.roi.ROI2DArea;
 * 
 * import java.awt.Rectangle;
 * import java.awt.geom.Point2D;
 * 
 * import javax.vecmath.Point2f;
 */
import icy.sequence.Sequence;
/*
 * import icy.sequence.SequenceUtil;
 * import icy.type.collection.array.Array1DUtil;
 */
import icy.type.collection.array.Array2DUtil;
// import plugins.hrositi.loglib;
import log.lib.LoG3DLib;

/**
 * Basic image processing plugin example: apply a maximum intensity projection along Z axis on the
 * active sequence
 * 
 * @author Stephane
 */
public class LoG extends EzPlug implements Block
{

    EzVarSequence seqVar = new EzVarSequence("Sequence");
    EzVarBoolean log3D = new EzVarBoolean("Apply LoG in 3D ?", true);
    EzVarBoolean scaleNorm = new EzVarBoolean("Scale Normalized ? (X sigma^2)", true);
    EzVarInteger sigMin = new EzVarInteger("SigmaMin", 3, 1, 100, 1);
    EzVarInteger sigMax = new EzVarInteger("SigmaMax", 7, 1, 100, 1);
    // EzVarDouble blobThres = new EzVarDouble("Thresholding blob response",0.6,0.1,1,0.05);
    // EzVarBoolean outThres = new EzVarBoolean("Output thresholding result ?", true);
    // EzGroup grp = new EzGroup("Output thresholding",blobThres);

    @Override
    public void declareInput(VarList inputMap)
    {
        inputMap.add(seqVar.name, seqVar.getVariable());
        inputMap.add(log3D.name, log3D.getVariable());
        inputMap.add(scaleNorm.name, scaleNorm.getVariable());
        inputMap.add(sigMin.name, sigMin.getVariable());
        inputMap.add(sigMax.name, sigMax.getVariable());
    }

    EzVarSequence resultVar = new EzVarSequence("Result");

    @Override
    public void declareOutput(VarList outputMap)
    {
        outputMap.add(resultVar.name, resultVar.getVariable());
    }

    @Override
    protected void initialize()
    {
        addEzComponent(log3D);
        addEzComponent(scaleNorm);
        addEzComponent(sigMin);
        addEzComponent(sigMax);
        /*
         * addEzComponent(outThres);
         * addEzComponent(grp);
         * outThres.addVisibilityTriggerTo(grp, true);
         * //addEzComponent(blobThres);
         */
    }

    @Override
    public void clean()
    {
    }

    @Override
    protected void execute()
    {
        Sequence seq;
        if (isHeadLess())
        {
            seq = seqVar.getValue();
        }
        else
        {
            seq = getActiveSequence(); // Retrieve Active Sequence
        }

        int nx = seq.getSizeX();
        int ny = seq.getSizeY();
        int nz = seq.getSizeZ();
        // int nt=seq.getSizeT();
        // int nc=seq.getSizeC();

        int sigSize = sigMax.getValue() - sigMin.getValue() + 1;

        int[] sigma = new int[sigSize];

        for (int i = 0; i < sigSize; i++)
            sigma[i] = sigMin.getValue() + i;

        // double minThreshold=blobThres.getValue();

        double[][] volume = new double[nz][nx * ny]; // Data in a 2D double array
        Object dataArray = null;

        dataArray = seq.getDataXYZ(0, 0);
        volume = Array2DUtil.arrayToDoubleArray(dataArray, seq.isSignedDataType()); // Convert data in a 2D array

        LoG3DLib myLog = new LoG3DLib(); // Create an instance of Log3DLib to further launch calculations

        double[][][] res = new double[sigSize][nz][nx * ny];

        for (int s = 0; s < sigSize; s++)
            if (log3D.getValue())
                res[s] = myLog.doLoG(volume, sigma[s], sigma[s], sigma[s], nx, ny, nz); // Apply LoG filter 3D
            else
                res[s] = myLog.doLoG(volume, sigma[s], sigma[s], nx, ny, nz); // Apply LoG filter 2D

        Sequence result;

        if (log3D.getValue())
            result = new Sequence("LoG 3D of " + seq.getName()); // Create a new sequence to display the result
        else
            result = new Sequence("LoG 2D of " + seq.getName()); // Create a new sequence to display the result

        result.beginUpdate();
        for (int s = 0; s < sigSize; s++)
            for (int z = 0; z < nz; z++)
            {
                if (scaleNorm.getValue()) // scale normalization => multiplication by sigma^2
                {

                    res[s][z] = ArrayMath.multiply(res[s][z], sigma[s] * sigma[s]);
                    /*
                     * for(int i=0;i<nx*ny;i++)
                     * res[s][z][i]=sigma[s]*sigma[s]*res[s][z][i];
                     */
                }

                // Array1DUtil.doubleArrayToArray(res[z],dataArray);
                result.addImage(s, new IcyBufferedImage(nx, ny, res[s][z], true));
            }
        result.endUpdate();
        if (isHeadLess())
        {
            resultVar.setValue(result);
        }
        else
        {
            addSequence(result);
        }

        /*
         * if (outThres.getValue())
         * {
         * Sequence resThres = new Sequence("Thresholding over scales of "+result.getName());
         * 
         * double [][] resultThres = new double [nz][nx*ny];
         * 
         * boolean[] mask = new boolean[nx*ny];
         * 
         * double minVal;
         * 
         * for(int z=0;z<nz;z++)
         * {
         * for(int i=0;i<nx*ny;i++) //Looking for min value over scale
         * resultThres[z][i]=Double.MAX_VALUE;
         * 
         * for(int i=0;i<nx*ny;i++) //Looking for min value over scale
         * for(int s=0;s<sigSize;s++)
         * resultThres[z][i]=(res[s][z][i]<resultThres[z][i]?res[s][z][i]:resultThres[z][i]);
         * 
         * minVal=ArrayMath.min(resultThres[z]);
         * 
         * System.out.println(minVal+" "+minThreshold);
         * 
         * for (int i=0; i <nx*ny; i++)
         * resultThres[z][i]=(resultThres[z][i]<=((1-minThreshold)*minVal)?resultThres[z][i]:0);
         * //mask[i] = (resultThres[z][i] <= (1-minThreshold)*minVal);
         * 
         * //BooleanMask2D mask2d = new BooleanMask2D(new Rectangle(0,0,nx,ny), mask);
         * //ROI2DArea roi = new ROI2DArea(mask2d);
         * 
         * 
         * 
         * resThres.addImage(new IcyBufferedImage(nx, ny, resultThres[z], true));
         * //resThres.addROI(roi);
         * }
         * addSequence(resThres);
         * }
         */

        // Compute Roi

        /*
         * 
         * ArrayList<Point2D> detection = new ArrayList<Point2D>();
         * 
         * for(int k=0;k<nz;k++) // Select detected blob as
         * for(int i=0;i<ny;i++)
         * for(int j=0;j<nx;j++)
         * if(res2[k][i*nx+j]<minVal*minThreshold)
         * detection.add(new Point2D.Double(i,j));
         * 
         * System.out.println("Nombre de détection réalisées: "+detection.size());
         */
    }
}
