package plugins.lagache.log;

import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.lang.VarInteger;
import plugins.adufour.vars.lang.VarSequence;
//import plugins.adufour.ezplug.EzVarDouble;
import icy.image.IcyBufferedImage;
import icy.math.ArrayMath;
import icy.plugin.abstract_.Plugin;
import icy.sequence.Sequence;
import icy.type.collection.array.Array2DUtil;


public class LoG2D extends Plugin implements Block
{
	
	VarBoolean scaleNorm = new VarBoolean("Scale Normalized ? (X sigma^2)", true);	
	VarInteger sig = new VarInteger("Sigma",3);
	VarSequence input = new VarSequence("Input sequence", null);
	VarSequence output = new VarSequence("Output sequence", null);
	@Override
	public void declareInput(VarList inputMap) {
		inputMap.add("Scale Normalized ? (X sigma^2)",scaleNorm);
		inputMap.add("Sigma (convolution)",sig);
		inputMap.add("Input sequence",input);
	}

	@Override
	public void declareOutput(VarList outputMap) {
		outputMap.add("Output sequence",output);		
	}

	@Override
	public void run() {
		// TODO Auto-generated method stub
		
		Sequence seq = input.getValue();
				
		int nx=seq.getSizeX();
		int ny=seq.getSizeY();
		int nz=seq.getSizeZ();
		int nt=seq.getSizeT();
		int sigma=sig.getValue();
		
		
		double[][] volume = new double[nz][nx*ny]; //Data in a 2D double array
		Object dataArray = null;	
		
		Sequence result;
		result= new Sequence("LoG 2D of "+seq.getName());
		
		for (int t=0;t<nt;t++){
		dataArray=seq.getDataXYZ(t,0);		
		volume=Array2DUtil.arrayToDoubleArray(dataArray, seq.isSignedDataType()); // Convert data in a 2D array		
		
		LoG3DLib myLog = new LoG3DLib();  // Create an instance of Log3DLib to further launch calculations
		
		double[][] res=new double[nz][nx*ny];
		
			res=myLog.doLoG(volume, sigma, sigma, nx, ny, nz); // Apply LoG filter  2D
		
			for(int z=0;z<nz;z++)
			{
				if(scaleNorm.getValue()) // scale normalization => multiplication by sigma^2
				{
					res[z]=ArrayMath.multiply(res[z], sigma*sigma);								
				}							
				result.addImage(t, new IcyBufferedImage(nx, ny, res[z], true));
			}
			
		}	
		output.setValue(result);
	}
	
}

