package plugins.lagache.matchtracks;
import plugins.adufour.ezplug.*;
import plugins.fab.trackmanager.TrackGroup;
import plugins.fab.trackmanager.TrackManager;
import plugins.fab.trackmanager.TrackSegment;
import plugins.nchenouard.spot.Detection;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import icy.gui.frame.progress.AnnounceFrame;
import icy.main.Icy;
import icy.sequence.Sequence;
import icy.swimmingPool.SwimmingObject;

public class EMC2 extends EzPlug {	
	public EzVarSwimmingObject<TrackGroup> tracks = new EzVarSwimmingObject<TrackGroup>("Tracks");
	public EzVarInteger max_nb_fiducials = new EzVarInteger("Max. number of fiducials",100,1000,1);	
	public EzVarDouble threshold = new EzVarDouble("Max. distance for track concatenation",10,0,100,0.5);
	public EzVarInteger time_window = new EzVarInteger("Max. time window for track concatenation",200,10000,1);
	//public EzVarDouble pc = new EzVarDouble("Percentile (cost factor computation)",0.9,0.0,1.0,0.01);
	public EzVarDouble cost_factor = new EzVarDouble("Alternative cost factor (for JV linear association)",1.05,1.0,10.0,0.05);
	public EzVarBoolean nomotion = new EzVarBoolean("No motion correction", false);	
	
	//public EzVarBoolean show = new EzVarBoolean("Show local deformation map", false);	 
	//public EzVarSequence sequence =  new EzVarSequence("Sequence for deformation mapping");
	@Override
	protected void initialize() {				
		// sequence selection												
				addEzComponent(tracks);	
				addEzComponent(max_nb_fiducials);								
				addEzComponent(threshold);
				addEzComponent(time_window);
				addEzComponent(cost_factor);
				addEzComponent(nomotion);
				//addEzComponent(show);
				//addEzComponent(sequence);
	}
	static Integer nb_fiducials = 300;
	static double alternative_cost_factor=1.05d;
	static double percentile=0.9;
	
	@Override
	protected void execute() {
		// first clean previous executions (will detach the painters)	
	clean();
	alternative_cost_factor=cost_factor.getValue();
	//On recupere la liste de tracks
	TrackGroup group = (TrackGroup)tracks.getValue().getObject();
	//ArrayList<TrackSegment> ts_liste = group.getTrackSegmentList();	
	ArrayList<TrackSegment> projected_tracks  = EMC2Block.project_tracks(max_nb_fiducials.getValue(), threshold.getValue(),time_window.getValue(),nomotion.getValue(),group);
	Sequence s=group.getSequence();
	TrackGroup TG = new TrackGroup(s);
			TG.setDescription(s.getName());
			for (TrackSegment ts:projected_tracks){TG.addTrackSegment(ts);
			}			
			sendTracksToPool(TG,s);		
	}
	
		public static void sendTracksToPool(final TrackGroup trackGroup,
			final Sequence sequence) {
		SwingUtilities.invokeLater(new Runnable()
		{
			@Override
			public void run() {
				// Add the given trackGroup
				SwimmingObject result = new SwimmingObject(trackGroup);// should
				Icy.getMainInterface().getSwimmingPool().add(result);
				TrackManager manager = new TrackManager();
				if (sequence != null)
					manager.setDisplaySequence(sequence );
				new AnnounceFrame("Tracking results exported to Track manager plugin");
			}
		});
	}
		public static void prune(ArrayList<Detection> liste1,ArrayList<Detection> liste2,int max)
		{
			int ind= 0;
			while (liste1.size()>max){
				//int ind = (int)(Math.random()*liste1.size());
				liste1.remove(ind);liste2.remove(ind);			
			}
		}
		@Override
	public void clean() {
		// TODO Auto-generated method stub
		
	}
	}



