package plugins.lagache.matchtracks;


import java.util.*;

import javax.swing.SwingUtilities;

import icy.gui.frame.progress.AnnounceFrame;
import icy.image.IcyBufferedImage;
import icy.main.Icy;
import icy.plugin.abstract_.Plugin;
import icy.roi.ROI;
import icy.roi.ROIUtil;
import icy.sequence.Sequence;
import icy.swimmingPool.SwimmingObject;
import icy.type.DataType;
import icy.type.point.Point5D;
import icy.type.rectangle.Rectangle5D;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.lang.VarDouble;
import plugins.adufour.vars.lang.VarInteger;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.adufour.vars.lang.VarSequence;
import plugins.fab.trackmanager.TrackGroup;
import plugins.fab.trackmanager.TrackManager;
import plugins.fab.trackmanager.TrackSegment;
import plugins.kernel.roi.roi2d.ROI2DRectangle;
import plugins.nchenouard.particleTracking.sequenceGenerator.Profile;
import plugins.nchenouard.particleTracking.sequenceGenerator.ProfileSpot;
import plugins.nchenouard.particleTracking.sequenceGenerator.TrackGeneratorWithProfiles;
import plugins.nchenouard.spot.Detection;
import plugins.nchenouard.spot.Point3D;
import flanagan.math.PsRandom;

public class SyntheticCalciumImaging extends Plugin implements Block {

	VarSequence sequence_in = new VarSequence("Input sequence", null);
	VarBoolean Confined_motion = new VarBoolean("Confined motion", false);
	VarDouble Diffusion = new VarDouble("Diffusion coefficient (px^2/s)", 1.0);
	VarDouble Radius = new VarDouble("Radius of the confined area (px)", 2.0);	
	VarBoolean Velocity_motion = new VarBoolean("Constant velocity motion", false);
	VarDouble Speed = new VarDouble("Velocity (px/s)", 1.0);		
	VarBoolean Hydra_motion = new VarBoolean("Elastic Hydra motion", false);
	public Var<TrackGroup> tracks_in = new Var<TrackGroup>("Tracks (measured)",new TrackGroup(null));
	public VarInteger max_nb_fiducials = new VarInteger("Max. nb of fiducials",100);
	VarROIArray hydra_mask = new VarROIArray("Hydra masks over time (ROIs)", null);	
	
	VarInteger num_spots_1 = new VarInteger("Number of Neurons", 100);
	VarDouble percentage_stable = new VarDouble("% of intensity-stable spots", 0.1);
	VarInteger num_groups = new VarInteger("Number of groups", 10);
	VarDouble firing_rate = new VarDouble("Individual firing rate", 0.01);
	VarDouble mu = new VarDouble("Mu", 2.0);
	VarDouble tau_rise = new VarDouble("Tau rise", 0.5);
	VarDouble tau_decay = new VarDouble("Tau decay", 15.0);
	VarDouble beta = new VarDouble("Beta (decay power)", 2.0);
	VarDouble Intensity = new VarDouble("Intensity", 100);
	VarDouble Gaussian = new VarDouble("Std Gaussian noise", 5);
	VarDouble PoissonNoise = new VarDouble("Poisson noise", 5);
	VarSequence sequence_out = new VarSequence("Synthetic sequence", null);
	public Var<TrackGroup> tracks_out = new Var<TrackGroup>("Tracks (simulated)",new TrackGroup(null));
	Random r = new Random();

	@Override
	public void declareInput(VarList inputMap) {
		
		inputMap.add("Original sequence (dimensions)", sequence_in);
		inputMap.add("Confined motion", Confined_motion);
		inputMap.add("Diffusion coefficient (px^2/s)", Diffusion);
		inputMap.add("Radius of the confined area (px)", Radius);	
		inputMap.add("Constant velocity motion", Velocity_motion);
		inputMap.add("Velocity (px/s)", Speed);		
		inputMap.add("Elastic Hydra motion", Hydra_motion);		
		inputMap.add("Measured tracks", tracks_in);
		inputMap.add("Hydra mask over time", hydra_mask);
		inputMap.add("Max. number of fiducials for deformation computation", max_nb_fiducials);		
		inputMap.add("Number of neurons", num_spots_1);		
		inputMap.add("% of intensity-stable spots", percentage_stable);
		inputMap.add("Number of groups", num_groups);
		inputMap.add("Firing rate", firing_rate);	
		inputMap.add("Mu", mu);
		inputMap.add("Tau rise", tau_rise);
		inputMap.add("Tau decay", tau_decay);
		inputMap.add("Beta (decay power)", beta);
		inputMap.add("Spots'intensity", Intensity);
		inputMap.add("Std Gaussian Noise", Gaussian);
		inputMap.add("Poisson Noise", PoissonNoise);		
	}

	@Override
	public void declareOutput(VarList outputMap) {
		outputMap.add("Simulated tracks", tracks_out);
		outputMap.add("Synthetic Hydra Sequence", sequence_out);
		}

	@Override
	public void run() {
		final Sequence out = new Sequence("Synthetic sequence");
		Sequence sequence=sequence_in.getValue();
		int time = sequence.getSizeT();
		int numOfNeurons = num_spots_1.getValue();
		ROI[] roi_liste = hydra_mask.getValue();
		double dist_min = 10.0;
		// initialisation du mask et position initiale des neurons "synthetiques"
		//forward construction
		ROI roi_t = ROI_t(sequence,roi_liste,0, -1);
		double[][] pos_x = new double[numOfNeurons][time];
		double[][] pos_y = new double[numOfNeurons][time];
		Rectangle5D bounds =roi_t.computeBounds5D();
		int compteur=0;
		while(compteur<numOfNeurons){
			double x = bounds.getMinX()+Math.random()*(bounds.getSizeX());
			double y = bounds.getMinY()+Math.random()*(bounds.getSizeY());			
			if (roi_t.contains(x, y, roi_t.getPosition5D().getZ(), roi_t.getPosition5D().getT(), roi_t.getPosition5D().getC())){
				boolean close=false;
				for (int i=0;i<compteur;i++){
					double distance = Math.sqrt(Math.pow(pos_x[i][0]-x, 2)+Math.pow(pos_y[i][0]-y, 2));
					if (distance<dist_min){
						close = true;break;}
				}
				if (close==false){
				pos_x[compteur][0]=x;
				pos_y[compteur][0]=y;
				compteur+=1;}
			}
		}		
		//we are now going to compute iteratively the deformation of positions
		if (Confined_motion.getValue()){			
			Random r = new Random();
			for (int t=0;t<time-1;t++){
			for (int i=0;i<numOfNeurons;i++){				
				double dx = Math.sqrt(2*Diffusion.getValue())*r.nextGaussian();
				double dy = Math.sqrt(2*Diffusion.getValue())*r.nextGaussian();
				double temp_x = pos_x[i][t]+dx;double temp_y =pos_y[i][t]+dy;
				//reflexion of the Brownian motion at sequence edges
				if (temp_x<0){temp_x = (temp_x)*(-1);}if (temp_y<0){temp_y = (temp_y)*(-1);}
				if (temp_x>sequence.getSizeX()){temp_x = 2*sequence.getSizeX()-temp_x;}
				if (temp_y>sequence.getSizeY()){temp_y = 2*sequence.getSizeY()-temp_y;}
				
				temp_x-=pos_x[i][0];temp_y-=pos_y[i][0];
				double temp_r = Math.sqrt(Math.pow(temp_x, 2)+Math.pow(temp_y, 2));
				double theta = Math.atan(temp_y/temp_x);
				if ((temp_x>0)&(temp_y<0))
				{theta+=2*Math.PI;}
				if ((temp_x<0))
				{theta+=Math.PI;}
				//relexion of the confined Brownian process at r = R				
				if (temp_r>Radius.getValue()){
					temp_r = 2*Radius.getValue()-temp_r;
				}				
				//incrementation of the position in cartesian coordinates											
				pos_x[i][t+1]=pos_x[i][0]+temp_r*Math.cos(theta);pos_y[i][t+1]=pos_y[i][0]+temp_r*Math.sin(theta);				
			}			
		}}
		if (Velocity_motion.getValue()){			
			for (int t=0;t<time-1;t++){
			for (int i=0;i<numOfNeurons;i++){		
				//no motion along the y axis
				pos_y[i][t+1]=pos_y[i][t];
				pos_x[i][t+1] = pos_x[i][t]+Speed.getValue();												
				if (pos_x[i][t+1]>sequence.getSizeX()){
					//the particle re-start at x=0
					pos_x[i][t+1] = Speed.getValue();}
				//for negative speeds..
				if (pos_x[i][t+1]<0){
					//the particle re-start at sequence.getSizeX()
					pos_x[i][t+1] = sequence.getSizeX()+Speed.getValue();}									
		}}}
		if (Hydra_motion.getValue()){
		TrackGroup group = tracks_in.getValue();	
		ArrayList<TrackSegment> ts_liste = group.getTrackSegmentList();	
		//computing transformations TPS forward from input tracks					
		for (int t=0;t<time-1;t++){
		//on crée ensuite autant d'objets neurons
		HashMap<Detection,Detection> coupled_detections=new HashMap<Detection,Detection>();		
		//on parcourt ensuite la liste de tracks et recupere les tracks avec des detections actives à t et t+1			
		for (TrackSegment ts:ts_liste)
		{	
			Detection d1 = ts.getDetectionAtTime(t);
			Detection d2 = ts.getDetectionAtTime(t+1);
			if ((d1!=null)&(d2!=null))
				{coupled_detections.put(d1, d2);}
		}	
		int size = Math.min(coupled_detections.size(), max_nb_fiducials.getValue());
		double[][] srcPts = new double[2][size];
		double[][] tgtPts = new double[2][size];
		int s=0;		
		for (Detection d:coupled_detections.keySet()){
		if (s<size)
		{		
		srcPts[0][s] = d.getX();
		srcPts[1][s] = d.getY();
		tgtPts[0][s] = coupled_detections.get(d).getX();
		tgtPts[1][s] = coupled_detections.get(d).getY();
		s++;
		}}		
		ThinPlateR2LogRSplineKernelTransform TPST_forward = new ThinPlateR2LogRSplineKernelTransform( 2, srcPts, tgtPts );				
		TPST_forward.solve();
		//we then compute the new positions of simulated neurons
		for (int i=0;i<numOfNeurons;i++){			
			double[] pt_old = new double[2];pt_old[0]=pos_x[i][t];pt_old[1]=pos_y[i][t];
			double[] ptnew=TPST_forward.apply(pt_old);
			pos_x[i][t+1]=ptnew[0];pos_y[i][t+1]=ptnew[1];				
		}
		}		
		}
	//we then creates track segment based on neuron position over time
		TrackGroup TG = new TrackGroup(out);
		TG.setDescription(out.getName());
		for (int n=0;n<numOfNeurons;n++){
			//for each neuron, we have potentially a list of tracks (linear motion)
			ArrayList<TrackSegment> ts_list=new ArrayList<TrackSegment>();
			ts_list.add(new TrackSegment());
			for (int t=0;t<time;t++){				
				Detection d=new Detection(pos_x[n][t], pos_y[n][t], 0, t);
				//for linear motion we test if there is a jump in trajectory corresponding to the re-start of trajectories at the beginning of the sequence.
				//in that case we create a new track segment
				if (t>0){
					if (Math.abs(pos_x[n][t]-pos_x[n][t-1])>sequence.getSizeX()/2)//jump
					{
						//we add a new track segment					
						ts_list.add(new TrackSegment());
					}
				}	
				ts_list.get(ts_list.size()-1).addDetection(d);				
			}
			for (TrackSegment ts:ts_list){
			TG.addTrackSegment(ts);}
		}
			tracks_out.setValue(TG);
	//activation times of neurons
		boolean[][] activation_times = activationTime(numOfNeurons, num_groups.getValue(), firing_rate.getValue(), sequence);
	//intensity dynamics of neurons 		
		double[][] intensities = intensity_computation(activation_times,percentage_stable.getValue(),mu.getValue(),tau_rise.getValue(),tau_decay.getValue(),beta.getValue());
	
	ArrayList<Profile> tmpProfiles1 = TrackGeneratorWithProfiles.createCLSM05Profiles_2d(numOfNeurons,
	Intensity.getValue(), Intensity.getValue(), 0, 0);		
	for (int t = 0; t < time; t++) {			
			// draw neurons across time
			ArrayList<Point3D> positions1 = new ArrayList<Point3D>();
			ArrayList<ProfileSpot> tmpProfileSpots1 = new ArrayList<ProfileSpot>();
			for (int i = 0; i < numOfNeurons; i++) {									
				Point3D p = new Point3D(pos_x[i][t], pos_y[i][t]);
				positions1.add(p);
				ProfileSpot ps = new ProfileSpot(tmpProfiles1.get(i), p);
				tmpProfileSpots1.add(ps);	
			}
			double noiseSig = Gaussian.getValue();
			double darkNoise = PoissonNoise.getValue();
			double gain = 1;			
			PsRandom ran = new PsRandom();
			int xbound = sequence.getSizeX();
			int ybound = sequence.getSizeY();			
			double[] array1 = new double[xbound*ybound];
			for (int j = 0; j < numOfNeurons; j++) {			
				int[] maxDist = new int[] { 20, 20 };
				Profile p = tmpProfileSpots1.get(j).profile;
				Point3D d = tmpProfileSpots1.get(j).mass_center;
				int minX = Math.max((int) (d.x - maxDist[0]), 0);
				int minY = Math.max((int) (d.y - maxDist[1]), 0);
				int maxX = Math.min((int) (d.x + maxDist[0]), xbound - 1);
				int maxY = Math.min((int) (d.y + maxDist[1]), ybound - 1);
				for (int y0 = minY; y0 <= maxY; y0++)
					for (int x0 = minX; x0 <= maxX; x0++)
						array1[x0 + y0 * xbound] = array1[x0 + y0 * xbound]
								+ p.getValue(new double[] { x0, y0, d.x, d.y })*intensities[j][t];
			}
			for (int i = 0; i < array1.length; i++) {
				array1[i] = ran.nextGaussian(0., noiseSig)
						+ gain * (ran.nextPoissonian(array1[i]) + ran.nextPoissonian(darkNoise));
			}

			IcyBufferedImage img1 = new IcyBufferedImage(xbound, ybound, 1, DataType.DOUBLE);
			img1.setDataXYAsDouble(0, array1);
			img1.dataChanged();
			out.setImage(t, 0, img1);			
		}
		sequence_out.setValue(out);
		}	
	
	public static boolean[][] activationTime(final Integer nb_neurons, Integer nb_groups, double rate, final Sequence sequence) {		
		boolean[][] times =new boolean[nb_neurons][sequence.getSizeT()];
		//for each group of neurons we determine the firing times
		Integer group_size = Math.floorDiv(nb_neurons, nb_groups);
		double rate_group = rate*group_size;
		boolean[][] time_act_groups = new boolean[nb_groups][sequence.getSizeT()];
		for (int i=0;i<nb_groups;i++){
			time_act_groups[i][0]=true;
			for (int t=1;t<sequence.getSizeT();t++){
				if (Math.random()<rate_group){
					time_act_groups[i][t]=true;}else{time_act_groups[i][t]=false;}
				}
			}		
		//we then associate randomly each neuron to a group		
		for (int i=0;i<nb_neurons;i++){
			int k = (int)(Math.random()*nb_groups);
			times[i] = time_act_groups[k];
		}			
		return times;
	}
	public static double[][]  intensity_computation(boolean[][] activation_times,double percentage_stable,double mu,double tau_rise,double tau_decay,double beta){
		double[][] intensities = new double[activation_times.length][activation_times[0].length];
		Integer nb_stable = (int) (intensities.length*percentage_stable);		
		for (int i=0;i<intensities.length;i++){
			ArrayList<Integer> times = new ArrayList<Integer>();
			for (int t=0;t<intensities[0].length;t++){
				if (activation_times[i][t]){
					times.add(t);}
				for (int t0:times){
					intensities[i][t] += Math.exp(-Math.pow((t-t0)/tau_decay,beta))/(1+Math.exp(-(t-t0-mu)/tau_rise));
				}
			}
		}	
		ArrayList<Integer> stable_rows= new ArrayList<Integer>();
		for (int i=0;i<nb_stable;i++){
			int r = (int)(Math.random()*intensities.length);
			if (stable_rows.contains(r)){} else{
				stable_rows.add(r);
				for (int t=0;t<intensities[0].length;t++){intensities[r][t]=1;}
			}}									
		return intensities;		
	}
	public static void sendTracksToPool(final TrackGroup trackGroup, final Sequence sequence) {
		SwingUtilities.invokeLater(new Runnable() {
			@Override
			public void run() {
				// Add the given trackGroup
				SwimmingObject result = new SwimmingObject(trackGroup);// should
				Icy.getMainInterface().getSwimmingPool().add(result);
				TrackManager manager = new TrackManager();
				if (sequence != null)
					manager.setDisplaySequence(sequence);
				new AnnounceFrame("Tracking results exported to Track manager plugin");
			}
		});
	}

				public static ROI ROI_t(Sequence sequence, ROI[] roiArray, int time, int channel) {

					ArrayList<ROI> list_roi = new ArrayList<ROI>();
					if (roiArray.length == 0) {
						for (int t = 0; t < sequence.getSizeT(); t++) {
							ROI roi = null;
							ROI2DRectangle r = new ROI2DRectangle(sequence.getBounds2D());
							for (int h = 0; h < sequence.getSizeZ(); h++) {
								r.setZ(h);
								r.setT(t);
								roi = r.getUnion(roi);
							}
							list_roi.add(roi);
						}
					} else
						for (ROI roi : roiArray) {
							if (roi==null){}else{
							list_roi.add(roi);}
						}
					// on teste si les dimension en c sonts compatible
					double c1 = list_roi.get(0).getPosition5D().getC();
					for (ROI r : list_roi) {
						double c = r.getPosition5D().getC();
						if ((c != c1) && (c != (-1))) {
							new AnnounceFrame("ROI channels are incompatibles");
							return null;
						}
					}
					// on teste si les dimensions en temps/z sont incompatibles pour une
					// union
					boolean one_z = false;
					boolean all_z = true;

					for (ROI r : list_roi) {
						if (r.getBounds5D().isInfiniteZ() == false) {
							all_z = false;
						}
						if (r.getBounds5D().isInfiniteZ()) {
							one_z = true;
						}
					}
					// gestion de l'exception
					if (one_z == true && all_z == false) {
						new AnnounceFrame("Incompatibility in Z dimensions between ROIs");
						return null;
					}

					ArrayList<ROI> list_roi_copy = new ArrayList<ROI>();
					for (ROI r:list_roi){
						list_roi_copy.add(r.getCopy());
					}					
					ArrayList<ROI> roi_t = new ArrayList<ROI>();

					for (ROI r : list_roi_copy) {
						Point5D pt0 = r.getPosition5D();						
							pt0.setZ(-1);						
						if ((r.getBounds5D().isInfiniteC()) || (channel == -1)) {
							pt0.setC(channel);
						}
						if ((r.getBounds5D().isInfiniteT()) || (time == -1)) {
							pt0.setT(time);
						}
						r.setPosition5D(pt0);
						if ((pt0.getT() == time) && (pt0.getC() == channel)) {
							roi_t.add(r);
						}
					}
					return ROIUtil.getUnion(roi_t);
				}
				
}
