package plugins.lagache.matchtracks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.SwingUtilities;

import icy.gui.dialog.MessageDialog;
import icy.main.Icy;
import icy.sequence.Sequence;
import icy.swimmingPool.SwimmingObject;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.ezplug.EzVarSwimmingObject;
import plugins.fab.trackmanager.TrackGroup;
import plugins.fab.trackmanager.TrackSegment;
import plugins.nchenouard.spot.Detection;
import plugins.nchenouard.spot.DetectionResult;
import plugins.nchenouard.spot.Spot;

public class TracksComparison extends EzPlug {
	public EzVarSequence sequence = new EzVarSequence("sequence");
	public EzVarSwimmingObject<TrackGroup> tracks_ref = new EzVarSwimmingObject<TrackGroup>("Reference Tracks");
	public EzVarSwimmingObject<TrackGroup> tracks_test = new EzVarSwimmingObject<TrackGroup>("Test Tracks");
	public EzVarSwimmingObject<Detection> detections = new EzVarSwimmingObject<Detection>("Detections");
	
	
	public EzVarDouble match_percentage = new EzVarDouble("% of detections that match reference tracks", 0.9, 0, 1.0, 0.01);
	public EzVarDouble max_distance = new EzVarDouble("Max. distance for detection association", 10, 0, 100, 1.0);
	
	public EzVarInteger nb_no_match = new EzVarInteger("Number of ref tracks with no match");	
	public EzVarInteger nb_match = new EzVarInteger("Number of ref tracks that match exactly one track");
	public EzVarInteger nb_many_match = new EzVarInteger("Number of ref tracks that match more than one track");
	public EzVarInteger nb_test_no_match = new EzVarInteger("Number of test tracks with no match");		
	public EzVarInteger nb_test_many_match = new EzVarInteger("Number of test tracks that match less than one track");
	
	public EzVarBoolean export = new EzVarBoolean("Export sub-classes of tracks", false);
	
	@Override
	protected void initialize() {				
		// sequence selection
				addEzComponent(sequence);								
				addEzComponent(tracks_ref);	
				addEzComponent(tracks_test);
				addEzComponent(detections);
				addEzComponent(max_distance);
				addEzComponent(match_percentage);
				addEzComponent(nb_no_match);
				addEzComponent(nb_match);
				addEzComponent(nb_many_match);				
				addEzComponent(nb_test_no_match);
				addEzComponent(nb_test_many_match);				
				addEzComponent(export);
				}
	@Override
	protected void execute() {
		// first clean previous executions (will detach the painters)	
	clean();
	
	if (getUI() != null) {
		getUI().setProgressBarMessage("Waiting...");
	}
	Sequence inputSequence = sequence.getValue();       
    // Check if sequence exists.
    if ( inputSequence == null)
    {
    	if (getUI() != null) {
    		MessageDialog.showDialog("Please open a sequence to use this plugin.", MessageDialog.ERROR_MESSAGE );
			return;	
    	} else {
    		// FIXME figure out what to do when headless or in BLocks
    		return;
    	}
    }
    //les trackgroups de sortie
    TrackGroup TG_matched_test = new TrackGroup(sequence.getValue());
   	TG_matched_test.setDescription(sequence.getValue().getName()+"-test-matched");
   	
   	TrackGroup TG_matched_ref = new TrackGroup(sequence.getValue());
   	TG_matched_ref.setDescription(sequence.getValue().getName()+"-ref-matched");
   	   	
   	TrackGroup TG_unmatched_ref = new TrackGroup(sequence.getValue());
   	TG_unmatched_ref.setDescription(sequence.getValue().getName()+"-ref-unmatched");
   	TrackGroup TG_unmatched_test = new TrackGroup(sequence.getValue());
   	TG_unmatched_test.setDescription(sequence.getValue().getName()+"-test-unmatched");
   	
   	
   	TrackGroup TG_many_matched_ref = new TrackGroup(sequence.getValue());
   	TG_many_matched_ref.setDescription(sequence.getValue().getName()+"-ref-many-matched");
   	TrackGroup TG_many_matched_test = new TrackGroup(sequence.getValue());
   	TG_many_matched_test.setDescription(sequence.getValue().getName()+"-test-many-matched");
   	
   	//On recupere la liste de tracks
    TrackGroup ref = (TrackGroup)tracks_ref.getValue().getObject();  	
  	TrackGroup test = (TrackGroup)tracks_test.getValue().getObject();
  	ArrayList<TrackSegment> ts_ref = ref.getTrackSegmentList();
  	ArrayList<TrackSegment> ts_test = test.getTrackSegmentList();
  	
  	//on crée la liste de détection à partir des tracks tests
  	DetectionResult detect_ = (DetectionResult) detections.getValue().getObject();
  	ArrayList<Detection> liste_totale=new ArrayList<Detection>();
  	for (int t=0;t<sequence.getValue().getSizeT();t++){
  		for (Spot s:detect_.getDetectionsAtT(t)){
  			liste_totale.add(new Detection(s.mass_center.x, s.mass_center.y, s.mass_center.z, t));
  		}
  	}
  	//on associe ensuite une liste de detections par track de reference
  	HashMap<TrackSegment, ArrayList<Detection>> tracks_ref_w_detections = new HashMap<TrackSegment, ArrayList<Detection>>();
  	//on crée une liste pour chaque track de reference
  	for (TrackSegment ts:ts_ref){
  		ArrayList<Detection> new_liste = new ArrayList<Detection>();
  		tracks_ref_w_detections.put(ts,new_liste);  		
  	}
  	//ensuite pour chaque detection, on cherche la track de reference la plus proche et on ajoute la detection à la liste  	
  	double distance_max=max_distance.getValue();
  	for (Detection d:liste_totale){  		
  		TrackSegment ts_temp = new TrackSegment();
  		double min_dist = distance_max;
  		int t=d.getT();
  		for (TrackSegment ts:ts_ref){  		
  			if (ts.getDetectionAtTime(t)!=null){
  				double dist = Math.sqrt(Math.pow(ts.getDetectionAtTime(t).getX()-d.getX(), 2)+Math.pow(ts.getDetectionAtTime(t).getY()-d.getY(), 2));
  				if (dist<min_dist)
  				{ts_temp=ts;min_dist=dist;}}}
  		if (min_dist<distance_max){
  			tracks_ref_w_detections.get(ts_temp).add(d);
  			}
  	}
  	
  //on associe ensuite une liste de detections par track test
  	HashMap<TrackSegment, ArrayList<Detection>> tracks_test_w_detections = new HashMap<TrackSegment, ArrayList<Detection>>();
  	//on crée une liste pour chaque track de reference
  	for (TrackSegment ts:ts_test){
  		ArrayList<Detection> new_liste = new ArrayList<Detection>();
  		tracks_test_w_detections.put(ts,new_liste);  		
  	}
  	//ensuite pour chaque detection, on cherche la track de reference la plus proche et on ajoute la detection à la liste  	
  	for (Detection d:liste_totale){  		
  		TrackSegment ts_temp = new TrackSegment();
  		double min_dist = distance_max;
  		int t=d.getT();
  		for (TrackSegment ts:ts_test){  		
  			if (ts.getDetectionAtTime(t)!=null){
  				double dist = Math.sqrt(Math.pow(ts.getDetectionAtTime(t).getX()-d.getX(), 2)+Math.pow(ts.getDetectionAtTime(t).getY()-d.getY(), 2));
  				if (dist<min_dist)
  				{ts_temp=ts;min_dist=dist;}}}
  		if (min_dist<distance_max){
  			tracks_test_w_detections.get(ts_temp).add(d);
  			}
  	}
  	
  	
  	//Pour chaque track de reférence, on associe les tracks test correspondantes, i.e. dont >x% detectionc correspond
  	double threshold = match_percentage.getValue();
  	//on va ensuite associer chaque track test à une track de reference			
  	HashMap<TrackSegment, ArrayList<TrackSegment>> matching_test_to_ref = new HashMap<TrackSegment, ArrayList<TrackSegment>>();
  	//initialisation de la hashmap  	
  	for (TrackSegment tsr:ts_ref)
  	{matching_test_to_ref.put(tsr, new ArrayList<TrackSegment>());}
	//on remplit ensuite la hashmap: pour chaque track de reference, on cherche les tracks test associés  	  	
  	
  	int compteur=0;
  	//on va aussi créer la liste des tous les tracks test avec au moins un match pour pouvoir ensuite isoler les tracks test sans match
  	ArrayList<TrackSegment> tst_matched = new ArrayList<TrackSegment>();
  
    for (TrackSegment tsr:ts_ref){    
    	compteur++;    	
    	//on parcourt ensuite les différents tracks test pour comparer les detections listes
    	for (TrackSegment tst:ts_test){
    		int nb_match_det=0;    				
    		//on parcourt la liste des detections
    				for (Detection d:tracks_test_w_detections.get(tst)){
    					if(tracks_ref_w_detections.get(tsr).contains(d))
    					{nb_match_det++;}
    					}
    		//ensuite si le nb de mtch est suffisant on ajoute tst à la liste de match de tsr
    		if (nb_match_det>threshold*tracks_test_w_detections.get(tst).size())
    		{matching_test_to_ref.get(tsr).add(tst);tst_matched.add(tst);}    					
    		}
    	}
    //il faut ensuite voir, parmi les track segment de ref, lesquelles sont associés à exactement 1 ts test (définit un match!)
    int no_match=0;int match =0;int many_match=0;
    int many_test_match = 0;
    
    Iterator it = matching_test_to_ref.entrySet().iterator();
    while (it.hasNext())
    {Map.Entry entry = (Map.Entry) it.next();
     ArrayList<TrackSegment> listeOfTracks = (ArrayList<TrackSegment>)entry.getValue();
     if (listeOfTracks.size()==0){
    	 TrackSegment tsref = (TrackSegment)entry.getKey();
    	 ArrayList<Detection> li = new ArrayList<Detection>(tsref.getDetectionList());
    	 TG_unmatched_ref.addTrackSegment(new TrackSegment(li));    	 
    	 no_match++;}
     
     if (listeOfTracks.size()==1){
    	 TrackSegment tsref = (TrackSegment)entry.getKey();
    	 ArrayList<TrackSegment> tstest = (ArrayList<TrackSegment>)entry.getValue();
    	 ArrayList<Detection> li = new ArrayList<Detection>(tsref.getDetectionList());    	 
    	 ArrayList<Detection> li2 = new ArrayList<Detection>(tstest.get(0).getDetectionList());
    	 TG_matched_ref.addTrackSegment(new TrackSegment(li));
    	 TG_matched_test.addTrackSegment(new TrackSegment(li2));    	 
    	 match++;}
     if (listeOfTracks.size()>1){
    	 TrackSegment tsref = (TrackSegment)entry.getKey();
    	 ArrayList<TrackSegment> tstest = (ArrayList<TrackSegment>)entry.getValue();
    	 ArrayList<Detection> li = new ArrayList<Detection>(tsref.getDetectionList()); 
    	 //il faut voir si l'aun des track segment "test" de la liste contient plus de x% des detections (i.e. "quasi-match")
    	 TG_many_matched_ref.addTrackSegment(new TrackSegment(li));    			 
    	 for (TrackSegment tst:tstest){
    				 ArrayList<Detection> li_temp = new ArrayList<Detection>();
    				 li_temp.addAll(tst.getDetectionList());
    				 TG_many_matched_test.addTrackSegment(new TrackSegment(li_temp));
    				 many_test_match++;
    			 }    	     	   	     	     	 
    	 many_match++;}
    }
    //reste à définier la liste des tst sans match
    for (TrackSegment tst:ts_test){
    	if (tst_matched.contains(tst)){}
    	else{
    		ArrayList<Detection> li = new ArrayList<Detection>();
			 li.addAll(tst.getDetectionList());
			 TG_unmatched_test.addTrackSegment(new TrackSegment(li));  
		 }   
    	}    
    
	nb_no_match.setValue(no_match);
	nb_match.setValue(match);
	nb_many_match.setValue(many_match);
	nb_test_many_match.setValue(many_test_match);
	int test_no_match = ts_test.size()-(match+many_test_match);
	nb_test_many_match.setValue(many_test_match);
	nb_test_no_match.setValue(test_no_match);
	
	if (export.getValue()){
		sendTracksToPool(TG_unmatched_ref,sequence.getValue());
		sendTracksToPool(TG_unmatched_test,sequence.getValue());
		sendTracksToPool(TG_matched_ref,sequence.getValue());
		sendTracksToPool(TG_matched_test,sequence.getValue());
		sendTracksToPool(TG_many_matched_ref,sequence.getValue());
		sendTracksToPool(TG_many_matched_test,sequence.getValue());}
	
}	
	public static void sendTracksToPool(final TrackGroup trackGroup,
			final Sequence sequence) {
		SwingUtilities.invokeLater(new Runnable()
		{
			@Override
			public void run() {
				// Add the given trackGroup
				SwimmingObject result = new SwimmingObject(trackGroup);// should
				Icy.getMainInterface().getSwimmingPool().add(result);
				
				
				/*TrackManager manager = new TrackManager();
				if (sequence != null)
					manager.setDisplaySequence(sequence );*/				
			}
		});
	}


	public static TrackSegment search_for_closest_ref_track(TrackSegment tst,HashMap<TrackSegment, ArrayList<Detection>> tracks_w_detections)
	{			
		
		HashMap<TrackSegment,Integer> matched_ref_liste = new HashMap<TrackSegment,Integer>();
		//initialisation de la hashmap
		for (TrackSegment tsr:tracks_w_detections.keySet())
		{matched_ref_liste.put(tsr, 0);}
		//for each detection of tst, let search for the closest ref_track
		for (Detection d:tst.getDetectionList()){
			double min_dist=100000;
			TrackSegment track_ref = null;
			for (TrackSegment tsr:tracks_w_detections.keySet()){				
			if (tsr.getDetectionAtTime(d.getT())!=null){
				double dist = Math.pow(d.getX()-tsr.getDetectionAtTime(d.getT()).getX(), 2)+Math.pow(d.getY()-tsr.getDetectionAtTime(d.getT()).getY(), 2);
				if (dist<min_dist){min_dist=dist;track_ref=tsr;}}}
			if (track_ref!=null){
				int nbm = matched_ref_liste.get(track_ref);
				nbm++;
				matched_ref_liste.put(track_ref,nbm);}}					
		//il faut ensuite chercher la trackd de reference avec le plus de match
		int nbm_max=0;
		TrackSegment match=null;
		for (TrackSegment tsr:matched_ref_liste.keySet()){
			if (matched_ref_liste.get(tsr)>nbm_max){
				nbm_max=matched_ref_liste.get(tsr);
				match=tsr;
			}
		}
		return match;		
		}
	@Override
	public void clean() {
		// TODO Auto-generated method stub
		
	}
	}