/*
 * Decompiled with CFR 0.152.
 */
package mitiv.base.indexing;

public enum BoundaryConditions {
    NORMAL(0, "propagate leftmost or rightmost value"),
    PERIODIC(1, "periodic boundary conditions"),
    MIRROR(2, "mirror boundary conditions");

    private final int identifier;
    private final String description;

    private BoundaryConditions(int id, String descr) {
        this.identifier = id;
        this.description = descr;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.description;
    }

    public static final void buildIndex(int[] index, int offset, BoundaryConditions condition) {
        int n = index.length;
        if (condition == PERIODIC) {
            for (int j = 0; j < n; ++j) {
                int k = j + offset;
                if (k < 0) {
                    k = n + k % n;
                }
                if (k >= n) {
                    k %= n;
                }
                index[j] = k;
            }
        } else if (condition == MIRROR) {
            int p = 2 * n;
            int pm1 = p - 1;
            for (int j = 0; j < n; ++j) {
                int k = j + offset;
                if (k < 0) {
                    k = -k;
                }
                if (k >= p) {
                    k %= p;
                }
                if (k >= n) {
                    k = pm1 - k;
                }
                index[j] = k;
            }
        } else {
            for (int j = 0; j < n; ++j) {
                int k = j + offset;
                if (k < 0) {
                    k = 0;
                }
                if (k >= n) {
                    k = n - 1;
                }
                index[j] = k;
            }
        }
    }

    public static final int[] buildIndex(int length, int offset, BoundaryConditions condition) {
        int[] index = new int[length];
        BoundaryConditions.buildIndex(index, offset, condition);
        return index;
    }

    public static String stringify(byte[] arr) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            buf.append(i == 0 ? "{" : ", ");
            buf.append(arr[i]);
        }
        buf.append("}");
        return buf.toString();
    }

    public static String stringify(short[] arr) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            buf.append(i == 0 ? "{" : ", ");
            buf.append(arr[i]);
        }
        buf.append("}");
        return buf.toString();
    }

    public static String stringify(int[] arr) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            buf.append(i == 0 ? "{" : ", ");
            buf.append(arr[i]);
        }
        buf.append("}");
        return buf.toString();
    }

    public static String stringify(long[] arr) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            buf.append(i == 0 ? "{" : ", ");
            buf.append(arr[i]);
        }
        buf.append("}");
        return buf.toString();
    }

    public static String stringify(float[] arr) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            buf.append(i == 0 ? "{" : ", ");
            buf.append(arr[i]);
        }
        buf.append("}");
        return buf.toString();
    }

    public static String stringify(double[] arr) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            buf.append(i == 0 ? "{" : ", ");
            buf.append(arr[i]);
        }
        buf.append("}");
        return buf.toString();
    }

    public static void main(String[] args) {
        int n = 10;
        int[] i1 = BoundaryConditions.buildIndex(n, -1, NORMAL);
        int[] i2 = BoundaryConditions.buildIndex(n, -1, PERIODIC);
        int[] i3 = BoundaryConditions.buildIndex(n, -1, MIRROR);
        System.out.println("i1 = " + BoundaryConditions.stringify(i1));
        System.out.println("i2 = " + BoundaryConditions.stringify(i2));
        System.out.println("i3 = " + BoundaryConditions.stringify(i3));
        System.out.println("i4 = " + BoundaryConditions.stringify(BoundaryConditions.buildIndex(n, -3, MIRROR)));
        System.out.println("i5 = " + BoundaryConditions.stringify(BoundaryConditions.buildIndex(n, -12, PERIODIC)));
        System.out.println("buildIndex(7, -1, NORMAL) -----> " + BoundaryConditions.stringify(BoundaryConditions.buildIndex(7, -1, NORMAL)));
        System.out.println("buildIndex(7, -2, PERIODIC) ---> " + BoundaryConditions.stringify(BoundaryConditions.buildIndex(7, -2, PERIODIC)));
        System.out.println("buildIndex(7, -2, MIRROR) -----> " + BoundaryConditions.stringify(BoundaryConditions.buildIndex(7, -2, MIRROR)));
    }
}

