/*
 * Decompiled with CFR 0.152.
 */
package mitiv.auto;

import mitiv.array.Array1D;
import mitiv.array.Array2D;
import mitiv.array.Array3D;
import mitiv.array.Array4D;
import mitiv.array.ArrayFactory;
import mitiv.array.Double1D;
import mitiv.array.Double2D;
import mitiv.array.Double3D;
import mitiv.array.Double4D;
import mitiv.array.Float1D;
import mitiv.array.Float2D;
import mitiv.array.Float3D;
import mitiv.array.Float4D;
import mitiv.array.ShapedArray;
import mitiv.auto.estimationMetric;
import mitiv.base.Shape;
import mitiv.psf.PsfModel;
import org.jtransforms.fft.DoubleFFT_1D;
import org.jtransforms.fft.DoubleFFT_2D;
import org.jtransforms.fft.DoubleFFT_3D;
import org.jtransforms.fft.FloatFFT_1D;
import org.jtransforms.fft.FloatFFT_2D;
import org.jtransforms.fft.FloatFFT_3D;

public class GML
extends estimationMetric {
    private PsfModel psf = null;
    private ShapedArray priorDSP;
    private ShapedArray dataDSP;
    private ShapedArray psfDSP = null;
    private int rank;
    private Shape shape;
    private boolean single;
    private long numel;
    private double hyperparam;

    public GML(Object psf, ShapedArray data) {
        if (psf instanceof PsfModel) {
            this.psf = (PsfModel)psf;
            this.single = this.psf.isSingle();
            this.shape = this.psf.getShape();
        } else if (psf instanceof ShapedArray) {
            this.single = ((ShapedArray)psf).getType() != 5;
            this.psfDSP = this.computeDSP((ShapedArray)psf, this.single);
            this.shape = ((ShapedArray)psf).getShape();
        } else {
            throw new IllegalArgumentException("bad type for PSF model");
        }
        this.rank = this.shape.rank();
        if (this.rank != data.getRank()) {
            throw new IllegalArgumentException("PSF and data does not have the same rank");
        }
        this.priorDSP = this.QuadraticSmoothDSP(this.shape, this.single);
        this.dataDSP = this.computeDSP(data, this.single);
    }

    private ShapedArray computeDSP(ShapedArray data, boolean single) {
        ShapedArray dataDSP;
        Shape dataShape = data.getShape();
        this.rank = dataShape.rank();
        int[] dataFTdims = new int[this.rank + 1];
        System.arraycopy(dataShape.copyDimensions(), 0, dataFTdims, 1, this.rank);
        dataFTdims[0] = 2;
        Shape dataFTShape = new Shape(dataFTdims);
        if (single) {
            dataDSP = ArrayFactory.create(4, dataShape);
            ShapedArray dataFT = ArrayFactory.create(4, dataFTShape);
            switch (this.rank) {
                case 1: {
                    ((Float2D)dataFT).slice(0, 0).assign(data);
                    FloatFFT_1D fft = new FloatFFT_1D((long)dataFTShape.dimension(0));
                    fft.realForwardFull(((Float2D)dataFT).getData());
                    break;
                }
                case 2: {
                    ((Float3D)dataFT).slice(0, 0).assign(data);
                    FloatFFT_1D fft = new FloatFFT_2D((long)dataFTShape.dimension(1), (long)dataFTShape.dimension(0));
                    fft.realForwardFull(((Float3D)dataFT).getData());
                    break;
                }
                case 3: {
                    ((Float4D)dataFT).slice(0, 0).assign(data);
                    FloatFFT_1D fft = new FloatFFT_3D((long)dataFTShape.dimension(2), (long)dataFTShape.dimension(1), (long)dataFTShape.dimension(0));
                    fft.realForwardFull(((Float4D)dataFT).getData());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Rank >3 unsupported");
                }
            }
            int i = 0;
            while ((long)i < dataShape.number()) {
                double a = ((Float1D)dataFT.as1D()).get(i);
                double b = ((Float1D)dataFT.as1D()).get(i + 1);
                ((Float1D)dataDSP.as1D()).set(i, (float)(a * a + b * b));
                ++i;
            }
        } else {
            dataDSP = ArrayFactory.create(5, dataShape);
            ShapedArray dataFT = ArrayFactory.create(5, dataFTShape);
            switch (this.rank) {
                case 1: {
                    ((Double2D)dataFT).slice(0, 0).assign(data);
                    DoubleFFT_1D fft = new DoubleFFT_1D((long)dataFTShape.dimension(0));
                    fft.realForwardFull(((Double2D)dataFT).getData());
                    break;
                }
                case 2: {
                    ((Double3D)dataFT).slice(0, 0).assign(data);
                    DoubleFFT_1D fft = new DoubleFFT_2D((long)dataFTShape.dimension(1), (long)dataFTShape.dimension(0));
                    fft.realForwardFull(((Double3D)dataFT).getData());
                    break;
                }
                case 3: {
                    ((Double4D)dataFT).slice(0, 0).assign(data);
                    DoubleFFT_1D fft = new DoubleFFT_3D((long)dataFTShape.dimension(2), (long)dataFTShape.dimension(1), (long)dataFTShape.dimension(0));
                    fft.realForwardFull(((Double4D)dataFT).getData());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Rank >3 unsupported");
                }
            }
            int i = 0;
            while ((long)i < dataShape.number()) {
                double a = ((Double1D)dataFT.as1D()).get(i);
                double b = ((Double1D)dataFT.as1D()).get(i + 1);
                ((Double1D)dataDSP.as1D()).set(i, a * a + b * b);
                ++i;
            }
        }
        return dataDSP;
    }

    private ShapedArray QuadraticSmoothDSP(Shape shape, boolean single2) {
        int rank = shape.rank();
        ShapedArray DSP = this.single ? ArrayFactory.create(4, shape) : ArrayFactory.create(5, shape);
        this.numel = shape.number();
        switch (rank) {
            case 1: {
                int nx = shape.dimension(0);
                for (int ix = 0; ix < nx; ++ix) {
                    double ax = Math.sin(Math.PI * (double)ix / (double)nx);
                    if (this.single) {
                        ((Float1D)DSP).set(ix, (float)(4.0 * ax * ax));
                        continue;
                    }
                    ((Double1D)DSP).set(ix, 4.0 * ax * ax);
                }
                break;
            }
            case 2: {
                int nx = shape.dimension(0);
                int ny = shape.dimension(1);
                for (int iy = 0; iy < ny; ++iy) {
                    double ay = Math.sin(Math.PI * (double)iy / (double)ny);
                    for (int ix = 0; ix < nx; ++ix) {
                        double ax = Math.sin(Math.PI * (double)ix / (double)nx);
                        if (this.single) {
                            ((Float2D)DSP).set(ix, iy, (float)(4.0 * ax * ax + 4.0 * ay * ay));
                            continue;
                        }
                        ((Double2D)DSP).set(ix, iy, 4.0 * ax * ax + 4.0 * ay * ay);
                    }
                }
                break;
            }
            case 3: {
                int nx = shape.dimension(0);
                int ny = shape.dimension(1);
                int nz = shape.dimension(2);
                for (int iz = 0; iz < nz; ++iz) {
                    double az = Math.sin(Math.PI * (double)iz / (double)nz);
                    for (int iy = 0; iy < ny; ++iy) {
                        double ay = Math.sin(Math.PI * (double)iy / (double)ny);
                        for (int ix = 0; ix < nz; ++ix) {
                            double ax = Math.sin(Math.PI * (double)ix / (double)nx);
                            if (this.single) {
                                ((Float3D)DSP).set(ix, iy, iz, (float)(4.0 * ax * ax + 4.0 * ay * ay + 4.0 * az * az));
                                continue;
                            }
                            ((Double3D)DSP).set(ix, iy, iz, 4.0 * ax * ax + 4.0 * ay * ay + 4.0 * az * az);
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Rank >3 unsupported");
            }
        }
        return DSP;
    }

    public double value(double[] arg0) {
        if (arg0.length > 1) {
            double[] param = new double[arg0.length - 1];
            System.arraycopy(arg0, 1, param, 0, arg0.length - 1);
            this.psf.setParam(param);
        }
        this.hyperparam = Math.pow(10.0, arg0[0]);
        return this.computeGML();
    }

    private double computeGML() {
        Array1D mtfR = null;
        Array1D mtfI = null;
        double num = 0.0;
        double denom = 0.0;
        long sz = 0L;
        if (this.psf != null) {
            ShapedArray mtf = this.psf.getMtf();
            switch (this.rank) {
                case 1: {
                    mtfR = ((Array2D)mtf).slice(0, 0);
                    mtfI = ((Array2D)mtf).slice(1, 0);
                    break;
                }
                case 2: {
                    mtfR = ((Array3D)mtf).slice(0, 0).as1D();
                    mtfI = ((Array3D)mtf).slice(1, 0).as1D();
                    break;
                }
                case 3: {
                    mtfR = ((Array4D)mtf).slice(0, 0).as1D();
                    mtfI = ((Array4D)mtf).slice(1, 0).as1D();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Rank >3 unsupported");
                }
            }
        }
        int i = 0;
        while ((long)i < this.numel) {
            double a = 0.0;
            double b = 0.0;
            double q = 0.0;
            double d = 0.0;
            double h2 = 0.0;
            if (this.psf != null) {
                if (this.single) {
                    a = ((Float1D)mtfR).get(i);
                    b = ((Float1D)mtfI).get(i);
                    q = this.hyperparam * (double)((Float1D)this.priorDSP.as1D()).get(i);
                    d = ((Float1D)this.dataDSP.as1D()).get(i);
                } else {
                    a = ((Double1D)mtfR).get(i);
                    b = ((Double1D)mtfI).get(i);
                    q = this.hyperparam * ((Double1D)this.priorDSP.as1D()).get(i);
                    d = ((Double1D)this.dataDSP.as1D()).get(i);
                }
                h2 = a * a + b * b;
            } else if (this.single) {
                h2 = ((Float1D)this.psfDSP.as1D()).get(i);
                q = this.hyperparam * (double)((Float1D)this.priorDSP.as1D()).get(i);
                d = ((Float1D)this.dataDSP.as1D()).get(i);
            } else {
                h2 = ((Double1D)this.psfDSP.as1D()).get(i);
                q = this.hyperparam * ((Double1D)this.priorDSP.as1D()).get(i);
                d = ((Double1D)this.dataDSP.as1D()).get(i);
            }
            double w = q / (h2 + q);
            if (w > 0.0) {
                num += w * d;
                denom += Math.log(w);
                ++sz;
            }
            ++i;
        }
        double result = sz == 0L ? Double.POSITIVE_INFINITY : num / Math.exp(denom / (double)sz);
        return result;
    }
}

