/*
 * Decompiled with CFR 0.152.
 */
package mitiv.random;

import java.util.Date;
import mitiv.random.DoubleGenerator;
import mitiv.random.FloatGenerator;
import mitiv.random.RandomEngine;

public class MersenneTwisterGenerator
extends RandomEngine
implements DoubleGenerator,
FloatGenerator {
    private int mti;
    private final int[] mt = new int[624];
    private static final int N = 624;
    private static final int M = 397;
    private static final int MATRIX_A = -1727483681;
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final int LOWER_MASK = Integer.MAX_VALUE;
    private static final int TEMPERING_MASK_B = -1658038656;
    private static final int TEMPERING_MASK_C = -272236544;
    private static final int mag0 = 0;
    private static final int mag1 = -1727483681;
    public static final int DEFAULT_SEED = 4357;
    protected static final int MIN_VALUE = Integer.MIN_VALUE;
    protected static final int MAX_VALUE = Integer.MAX_VALUE;
    public static final double DBL_SCALE = MersenneTwisterGenerator.standardScale(-2.147483648E9, 2.147483647E9);
    public static final double DBL_BIAS = MersenneTwisterGenerator.standardBias(-2.147483648E9, 2.147483647E9);
    public static final float FLT_SCALE = (float)DBL_SCALE;
    public static final float FLT_BIAS = (float)DBL_BIAS;

    public MersenneTwisterGenerator() {
        this(4357);
    }

    public MersenneTwisterGenerator(int seed) {
        this.reset(seed);
    }

    public MersenneTwisterGenerator(Date d) {
        this((int)d.getTime());
    }

    private void nextBlock() {
        int y;
        int kk;
        int p = 227;
        for (kk = 0; kk < p; ++kk) {
            y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
            this.mt[kk] = this.mt[kk + 397] ^ y >>> 1 ^ ((y & 1) == 0 ? 0 : -1727483681);
        }
        while (kk < 623) {
            y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
            this.mt[kk] = this.mt[kk - p] ^ y >>> 1 ^ ((y & 1) == 0 ? 0 : -1727483681);
            ++kk;
        }
        y = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
        this.mt[623] = this.mt[396] ^ y >>> 1 ^ ((y & 1) == 0 ? 0 : -1727483681);
        this.mti = 0;
    }

    @Override
    public int next() {
        if (this.mti == 624) {
            this.nextBlock();
        }
        int y = this.mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        return y;
    }

    @Override
    public void reset(int seed) {
        this.mt[0] = seed & 0xFFFFFFFF;
        for (int i = 1; i < 624; ++i) {
            this.mt[i] = 1812433253 * (this.mt[i - 1] ^ this.mt[i - 1] >> 30) + i;
        }
        this.mti = 624;
    }

    @Override
    public int min() {
        return Integer.MIN_VALUE;
    }

    @Override
    public int max() {
        return Integer.MAX_VALUE;
    }

    @Override
    public double nextDouble() {
        return DBL_SCALE * (double)this.next() - DBL_BIAS;
    }

    @Override
    public float nextFloat() {
        return FLT_SCALE * (float)this.next() - FLT_BIAS;
    }

    public static void main(String[] args) {
        double max;
        System.out.printf("MIN_VALUE = 0x%08x\n", Integer.MIN_VALUE);
        System.out.printf("MAX_VALUE = 0x%08x\n", Integer.MAX_VALUE);
        System.out.printf("DBL_SCALE = %g\n", DBL_SCALE);
        System.out.printf("DBL_BIAS = %g\n", DBL_BIAS);
        System.out.printf("DBL_BIAS/DBL_SCALE = %g\n", DBL_BIAS / DBL_SCALE);
        MersenneTwisterGenerator engine = new MersenneTwisterGenerator(7864);
        System.out.printf("Sample:", new Object[0]);
        for (int k = 1; k < 10; ++k) {
            System.out.printf("  %8.6f", engine.nextDouble());
        }
        System.out.printf("\n", new Object[0]);
        int n = 10000000;
        double min = max = engine.nextDouble();
        double sum = max;
        for (int k = 1; k < n; ++k) {
            double val = engine.nextDouble();
            sum += val;
            if (val < min) {
                min = val;
            }
            if (!(val > max)) continue;
            max = val;
        }
        System.out.printf("Test of %d draws: avg = %g; min = %g; 1 - max = %g;\n", n, sum / (double)n, min, 1.0 - max);
    }
}

