/*
 * Decompiled with CFR 0.152.
 */
package plugins.tinevez.pathtracing;

import icy.canvas.IcyCanvas;
import icy.gui.frame.progress.AnnounceFrame;
import icy.image.IcyBufferedImage;
import icy.painter.Overlay;
import icy.sequence.Sequence;
import icy.type.collection.array.ArrayUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Vector;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import plugins.tinevez.pathtracing.InteractiveMultipleTracing;
import plugins.tinevez.pathtracing.PathEvent;
import plugins.tinevez.pathtracing.PathListener;

public class InteractiveMultipleDjikstraTracing
extends Overlay
implements InteractiveMultipleTracing {
    Sequence seq = null;
    int width;
    int height;
    double[] dataSave = null;
    double[][] optimalPath = null;
    int[] pathMap = null;
    final boolean verticalPath;
    boolean mapReady = false;
    double maxIntensity;
    ArrayList<Thread> mapThreadList = new ArrayList();
    ArrayList<Thread> pathThreadList = new ArrayList();
    Vector<Thread> runningThreads = new Vector();
    double alpha;
    private boolean isEnabled = true;
    private boolean paused = false;
    private ArrayList<PathListener> pathListenerList;
    int xInit;
    int yInit;
    int xFinal;
    int yFinal;
    public Lock mapThreadListLock = new ReentrantLock();
    public Lock pathThreadListLock = new ReentrantLock();
    public Lock pathLock = new ReentrantLock();
    public Lock initLock = new ReentrantLock();
    public Lock dataSaveLock = new ReentrantLock();
    public Lock distanceMapLock = new ReentrantLock();
    public Lock visitedLock = new ReentrantLock();
    public Condition visitedCondition = this.visitedLock.newCondition();
    private DrawingState state;
    long secondClickTime = 0L;
    Thread storePathThread;
    ArrayList<double[][]> optimalPathList = new ArrayList();

    public InteractiveMultipleDjikstraTracing(Sequence seq) throws IllegalArgumentException {
        this(seq, 1.0E-4, false);
    }

    public InteractiveMultipleDjikstraTracing(Sequence seq, double alpha, boolean verticalPath) throws IllegalArgumentException {
        super("Path tracer");
        this.verticalPath = verticalPath;
        if (seq != null) {
            this.state = DrawingState.RESET;
            this.seq = seq;
            if (seq.getSizeT() > 1 || seq.getSizeZ() > 1) {
                new AnnounceFrame("The tracing algorithm will account for the first image of the spatio-temporal volume only", 7);
            }
            if (alpha < 0.0) {
                throw new IllegalArgumentException("Regularization parameter should be positive in InteractiveDjisktraTracing");
            }
            this.alpha = alpha;
            this.width = seq.getWidth();
            this.height = seq.getHeight();
            boolean component = false;
            IcyBufferedImage image = seq.getFirstImage();
            this.dataSaveLock.lock();
            this.dataSave = (double[])ArrayUtil.arrayToDoubleArray((Object)image.getDataXY(0), (boolean)image.isSignedDataType());
            this.maxIntensity = 0.0;
            int i = 0;
            while (i < this.dataSave.length) {
                if (this.dataSave[i] > this.maxIntensity) {
                    this.maxIntensity = this.dataSave[i];
                }
                ++i;
            }
        } else {
            throw new IllegalArgumentException("Sequence is null in InteractiveDjisktraTracing");
        }
        this.dataSaveLock.unlock();
        this.pathListenerList = new ArrayList();
    }

    public void addPathLister(PathListener listener) {
        this.pathListenerList.add(listener);
    }

    public void removePathLister(PathListener listener) {
        this.pathListenerList.remove(listener);
    }

    public void paint(Graphics2D g2d, Sequence sequence, IcyCanvas canvas) {
        Color tempLineColor = Color.YELLOW;
        Color lineColor = Color.RED;
        Color extremityColor = Color.BLUE;
        float shiftDrawX = 0.5f;
        float shiftDrawY = 0.5f;
        if (this.isEnabled && !this.paused) {
            Point p;
            Line2D.Float l;
            if (this.optimalPath != null) {
                g2d.setStroke(new BasicStroke(0.5f));
                try {
                    this.pathLock.lock();
                    int cnt = 0;
                    while (cnt < this.optimalPath.length) {
                        if (cnt > 0) {
                            g2d.setColor(tempLineColor);
                            l = new Line2D.Float((float)((int)this.optimalPath[cnt][0]) + 0.5f, (float)((int)this.optimalPath[cnt][1]) + 0.5f, (float)((int)this.optimalPath[cnt - 1][0]) + 0.5f, (float)((int)this.optimalPath[cnt - 1][1]) + 0.5f);
                            g2d.draw(l);
                        }
                        ++cnt;
                    }
                }
                finally {
                    this.pathLock.unlock();
                }
                if (!this.optimalPathList.isEmpty()) {
                    int i = 0;
                    while (i < this.optimalPathList.size()) {
                        double[][] path = this.optimalPathList.get(i);
                        int cnt = 0;
                        while (cnt < path.length) {
                            if (cnt > 0) {
                                g2d.setColor(lineColor);
                                Line2D.Float l2 = new Line2D.Float((float)((int)path[cnt][0]) + 0.5f, (float)((int)path[cnt][1]) + 0.5f, (float)((int)path[cnt - 1][0]) + 0.5f, (float)((int)path[cnt - 1][1]) + 0.5f);
                                g2d.draw(l2);
                            }
                            ++cnt;
                        }
                        ++i;
                    }
                }
            }
            if ((p = new Point((int)canvas.getMouseImagePosX(), (int)canvas.getMouseImagePosY())) != null) {
                g2d.setStroke(new BasicStroke(0.5f));
                g2d.setColor(extremityColor);
                l = new Line2D.Float((float)(p.x - 1) + 0.5f, (float)(p.y - 1) + 0.5f, (float)(p.x + 1) + 0.5f, (float)(p.y + 1) + 0.5f);
                g2d.draw(l);
                l = new Line2D.Float((float)(p.x - 1) + 0.5f, (float)(p.y + 1) + 0.5f, (float)(p.x + 1) + 0.5f, (float)(p.y - 1) + 0.5f);
                g2d.draw(l);
            }
        }
    }

    public void mousePressed(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }

    public void mouseReleased(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }

    private void finalizePath(int xF, int yF, boolean addNewPathThread) {
        if (this.mapReady) {
            this.pathThreadListLock.lock();
            for (Thread thr : this.pathThreadList) {
                ((StoppableThread)thr).stopThread();
            }
            this.pathThreadListLock.unlock();
            this.initLock.lock();
            this.xFinal = xF;
            this.yFinal = yF;
            this.storePathThread = new ComputeFinalPathThread(this.xInit, this.yInit, this.xFinal, this.yFinal, addNewPathThread);
            this.initLock.unlock();
            this.storePathThread.start();
        } else {
            this.pathThreadListLock.lock();
            for (Thread thr : this.pathThreadList) {
                ((StoppableThread)thr).stopThread();
            }
            this.pathThreadListLock.unlock();
            this.initLock.lock();
            this.xFinal = xF;
            this.yFinal = yF;
            this.storePathThread = new ComputeFinalPathThreadWaiting(this.xInit, this.yInit, this.xFinal, this.yFinal, addNewPathThread);
            this.initLock.unlock();
            this.storePathThread.start();
        }
    }

    private void initNewMapThread(int xi, int yi) {
        this.mapThreadListLock.lock();
        for (Thread t : this.mapThreadList) {
            ((StoppableThread)t).stopThread();
        }
        this.mapThreadListLock.unlock();
        this.pathThreadListLock.lock();
        for (Thread t : this.pathThreadList) {
            ((StoppableThread)t).stopThread();
        }
        this.pathThreadListLock.unlock();
        this.initLock.lock();
        this.xInit = xi;
        this.yInit = yi;
        ComputeMapThread thr = null;
        thr = this.verticalPath ? new ComputeMapThreadToTop(this.xInit, this.yInit) : new ComputeMapThreadBidirectional(this.xInit, this.yInit);
        this.initLock.unlock();
        this.mapReady = false;
        this.mapThreadListLock.lock();
        this.mapThreadList.add(thr);
        this.mapThreadListLock.unlock();
        thr.start();
    }

    public void mouseClick(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
        if (this.isEnabled && !this.paused) {
            switch (this.state) {
                case RESET: 
                case SECOND_DOUBLE_CLICKED: {
                    int xi = (int)Math.round(imagePoint.getX());
                    int yi = (int)Math.round(imagePoint.getY());
                    if (xi < 0 || xi >= this.width || yi < 0 || yi >= this.height) break;
                    this.initNewMapThread(xi, yi);
                    this.state = DrawingState.FIRST_CLICKED;
                    break;
                }
                case SECOND_CLICKED: {
                    long t = System.currentTimeMillis();
                    if (t - this.secondClickTime < 1000L) {
                        int xF = (int)Math.round(imagePoint.getX());
                        int yF = (int)Math.round(imagePoint.getY());
                        if (xF < 0 || xF >= this.width || yF < 0 || yF >= this.height) break;
                        this.paused = true;
                        this.finalizePath(xF, yF, false);
                        this.state = DrawingState.SECOND_DOUBLE_CLICKED;
                        break;
                    }
                }
                case FIRST_CLICKED: {
                    int xF = (int)Math.round(imagePoint.getX());
                    int yF = (int)Math.round(imagePoint.getY());
                    if (xF < 0 || xF >= this.width || yF < 0 || yF >= this.height) break;
                    this.paused = true;
                    this.secondClickTime = System.currentTimeMillis();
                    this.finalizePath(xF, yF, true);
                    this.state = DrawingState.SECOND_CLICKED;
                }
            }
        }
    }

    public void mouseMove(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
        if (this.isEnabled && !this.paused) {
            if (this.state == DrawingState.FIRST_CLICKED || this.state == DrawingState.SECOND_CLICKED) {
                if (this.mapReady) {
                    this.pathThreadListLock.lock();
                    for (Thread t : this.pathThreadList) {
                        ((StoppableThread)t).stopThread();
                    }
                    int xF = (int)Math.round(imagePoint.getX());
                    int yF = (int)Math.round(imagePoint.getY());
                    if (!(xF < 0 || xF >= this.width || yF < 0 || yF >= this.height || this.verticalPath && yF <= this.yInit)) {
                        this.xFinal = xF;
                        this.yFinal = yF;
                        this.initLock.lock();
                        ComputePathThread thr = new ComputePathThread(this.xInit, this.yInit, this.xFinal, this.yFinal);
                        this.initLock.unlock();
                        this.pathThreadList.add(thr);
                        thr.start();
                    }
                    this.pathThreadListLock.unlock();
                } else {
                    this.pathThreadListLock.lock();
                    for (Thread t : this.pathThreadList) {
                        ((StoppableThread)t).stopThread();
                    }
                    int xF = (int)Math.round(imagePoint.getX());
                    int yF = (int)Math.round(imagePoint.getY());
                    if (xF >= 0 && xF < this.width && yF >= 0 && yF < this.height) {
                        this.xFinal = xF;
                        this.yFinal = yF;
                        this.initLock.lock();
                        ComputePathThreadWaiting thr = new ComputePathThreadWaiting(this.xInit, this.yInit, this.xFinal, this.yFinal);
                        this.initLock.unlock();
                        this.pathThreadList.add(thr);
                        thr.start();
                    }
                    this.pathThreadListLock.unlock();
                }
            } else {
                this.seq.overlayChanged((Overlay)this);
            }
        }
    }

    public void mouseDrag(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }

    public void keyPressed(KeyEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }

    public void keyReleased(KeyEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }

    public Number getIntensityAt(double x, double y) {
        if (this.dataSave != null && x >= 0.0 && x < (double)this.width && y >= 0.0 && y < (double)this.height) {
            return this.dataSave[(int)Math.round(x) + (int)Math.round(y) * this.width];
        }
        return -1;
    }

    @Override
    public ArrayList<double[][]> getOptimalPathCopy() {
        ArrayList<double[][]> copy = new ArrayList<double[][]>();
        this.pathLock.lock();
        for (double[][] path : this.optimalPathList) {
            copy.add((double[][])path.clone());
        }
        this.pathLock.unlock();
        return copy;
    }

    public void enable() {
        this.isEnabled = true;
        this.seq.overlayChanged((Overlay)this);
    }

    public void disable() {
        this.isEnabled = false;
        this.seq.overlayChanged((Overlay)this);
    }

    private void storeOptimalPath() {
        this.pathLock.lock();
        if (this.optimalPath != null) {
            this.optimalPathList.add(this.optimalPath);
        }
        this.pathLock.unlock();
    }

    class ComputeFinalPathThread
    extends ComputePathThread {
        boolean addNewMapThread;

        public ComputeFinalPathThread(int xInit, int yInit, int xFinal, int yFinal, boolean addNewPathThread) {
            super(xInit, yInit, xFinal, yFinal);
            this.addNewMapThread = false;
            this.addNewMapThread = addNewPathThread;
        }

        @Override
        public void run() {
            try {
                ((ComputePathThread)this).runFunction();
                InteractiveMultipleDjikstraTracing.this.storeOptimalPath();
                if (this.addNewMapThread) {
                    InteractiveMultipleDjikstraTracing.this.initNewMapThread(this.xFinal, this.yFinal);
                }
            }
            finally {
                InteractiveMultipleDjikstraTracing.this.paused = false;
            }
        }
    }

    class ComputeFinalPathThreadWaiting
    extends ComputePathThreadWaiting {
        boolean addNewMapThread;

        public ComputeFinalPathThreadWaiting(int xInit, int yInit, int xFinal, int yFinal, boolean addNewMapThread) {
            super(xInit, yInit, xFinal, yFinal);
            this.addNewMapThread = false;
            this.addNewMapThread = addNewMapThread;
        }

        @Override
        public void run() {
            try {
                ((ComputePathThreadWaiting)this).runFunction();
                InteractiveMultipleDjikstraTracing.this.storeOptimalPath();
                if (this.addNewMapThread) {
                    InteractiveMultipleDjikstraTracing.this.initNewMapThread(this.xFinal, this.yFinal);
                }
            }
            finally {
                InteractiveMultipleDjikstraTracing.this.paused = false;
            }
        }
    }

    abstract class ComputeMapThread
    extends StoppableThread {
        int xInit;
        int yInit;
        double[] dist;
        int[] prev;
        boolean[] visited;
        double[] data;
        boolean run;

        public ComputeMapThread(int xInit, int yInit) {
            this.dist = new double[InteractiveMultipleDjikstraTracing.this.width * InteractiveMultipleDjikstraTracing.this.height];
            this.prev = new int[InteractiveMultipleDjikstraTracing.this.width * InteractiveMultipleDjikstraTracing.this.height];
            this.visited = new boolean[InteractiveMultipleDjikstraTracing.this.width * InteractiveMultipleDjikstraTracing.this.height];
            this.data = null;
            this.run = true;
            this.xInit = xInit;
            this.yInit = yInit;
            InteractiveMultipleDjikstraTracing.this.dataSaveLock.lock();
            this.data = new double[InteractiveMultipleDjikstraTracing.this.dataSave.length];
            System.arraycopy(InteractiveMultipleDjikstraTracing.this.dataSave, 0, this.data, 0, this.data.length);
            InteractiveMultipleDjikstraTracing.this.dataSaveLock.unlock();
        }

        @Override
        public abstract void run();

        public double dist(double i1, double i2) {
            return InteractiveMultipleDjikstraTracing.this.maxIntensity / (i2 + InteractiveMultipleDjikstraTracing.this.alpha);
        }

        protected void test(double currentDist, double refI, int currentIdx, int idx) {
            double d;
            if (!this.visited[idx] && (d = currentDist + this.dist(refI, this.data[idx])) < this.dist[idx]) {
                this.dist[idx] = d;
                this.prev[idx] = currentIdx;
            }
        }

        @Override
        public void stopThread() {
            this.run = false;
        }
    }

    class ComputeMapThreadBidirectional
    extends ComputeMapThread {
        public ComputeMapThreadBidirectional(int xInit, int yInit) {
            super(xInit, yInit);
        }

        @Override
        public void run() {
            int u = 0;
            while (u < this.dist.length) {
                this.dist[u] = Double.MAX_VALUE;
                ++u;
            }
            int idxInit = this.yInit * InteractiveMultipleDjikstraTracing.this.width + this.xInit;
            this.dist[idxInit] = 0.0;
            int currentIdx = idxInit;
            int currentX = this.xInit;
            int currentY = this.yInit;
            boolean stop = false;
            while (!stop && this.run) {
                double ival = this.data[currentIdx];
                double currentDist = this.dist[currentIdx];
                if (currentX > 0) {
                    this.test(currentDist, ival, currentIdx, currentIdx - 1);
                    if (currentY > 0) {
                        this.test(currentDist, ival, currentIdx, currentIdx - InteractiveMultipleDjikstraTracing.this.width - 1);
                        this.test(currentDist, ival, currentIdx, currentIdx - InteractiveMultipleDjikstraTracing.this.width);
                    }
                    if (currentY < InteractiveMultipleDjikstraTracing.this.height - 1) {
                        this.test(currentDist, ival, currentIdx, currentIdx + InteractiveMultipleDjikstraTracing.this.width - 1);
                        this.test(currentDist, ival, currentIdx, currentIdx + InteractiveMultipleDjikstraTracing.this.width);
                    }
                    if (currentX < InteractiveMultipleDjikstraTracing.this.width - 1) {
                        this.test(currentDist, ival, currentIdx, currentIdx + 1);
                        if (currentY > 0) {
                            this.test(currentDist, ival, currentIdx, currentIdx - InteractiveMultipleDjikstraTracing.this.width + 1);
                        }
                        if (currentY < InteractiveMultipleDjikstraTracing.this.height - 1) {
                            this.test(currentDist, ival, currentIdx, currentIdx + InteractiveMultipleDjikstraTracing.this.width + 1);
                        }
                    }
                } else if (currentX < InteractiveMultipleDjikstraTracing.this.width - 1) {
                    this.test(currentDist, ival, currentIdx, currentIdx + 1);
                    if (currentY > 0) {
                        this.test(currentDist, ival, currentIdx, currentIdx - InteractiveMultipleDjikstraTracing.this.width + 1);
                        this.test(currentDist, ival, currentIdx, currentIdx - InteractiveMultipleDjikstraTracing.this.width);
                    }
                    if (currentY < InteractiveMultipleDjikstraTracing.this.height - 1) {
                        this.test(currentDist, ival, currentIdx, currentIdx + InteractiveMultipleDjikstraTracing.this.width + 1);
                        this.test(currentDist, ival, currentIdx, currentIdx + InteractiveMultipleDjikstraTracing.this.width);
                    }
                } else {
                    if (currentY > 0) {
                        this.test(currentDist, ival, currentIdx, currentIdx - InteractiveMultipleDjikstraTracing.this.width);
                    }
                    if (currentY < InteractiveMultipleDjikstraTracing.this.height - 1) {
                        this.test(currentDist, ival, currentIdx, currentIdx + InteractiveMultipleDjikstraTracing.this.width);
                    }
                }
                this.visited[currentIdx] = true;
                InteractiveMultipleDjikstraTracing.this.visitedLock.lock();
                InteractiveMultipleDjikstraTracing.this.visitedCondition.signalAll();
                InteractiveMultipleDjikstraTracing.this.visitedLock.unlock();
                double minDist = Double.MAX_VALUE;
                int minIdx = -1;
                int cnt = 0;
                while (cnt < this.dist.length) {
                    if (!this.visited[cnt] && (this.dist[cnt] < minDist || minIdx == -1)) {
                        minDist = this.dist[cnt];
                        minIdx = cnt;
                    }
                    ++cnt;
                }
                if (minIdx == -1) {
                    stop = true;
                    continue;
                }
                currentIdx = minIdx;
                currentY = currentIdx / InteractiveMultipleDjikstraTracing.this.width;
                currentX = currentIdx - InteractiveMultipleDjikstraTracing.this.width * currentY;
            }
            if (this.run) {
                InteractiveMultipleDjikstraTracing.this.distanceMapLock.lock();
                InteractiveMultipleDjikstraTracing.this.pathMap = this.prev;
                InteractiveMultipleDjikstraTracing.this.distanceMapLock.unlock();
                InteractiveMultipleDjikstraTracing.this.mapReady = true;
            }
            InteractiveMultipleDjikstraTracing.this.mapThreadListLock.lock();
            InteractiveMultipleDjikstraTracing.this.mapThreadList.remove(this);
            InteractiveMultipleDjikstraTracing.this.mapThreadListLock.unlock();
            InteractiveMultipleDjikstraTracing.this.seq.overlayChanged((Overlay)InteractiveMultipleDjikstraTracing.this);
        }
    }

    class ComputeMapThreadToTop
    extends ComputeMapThread {
        public ComputeMapThreadToTop(int xInit, int yInit) {
            super(xInit, yInit);
        }

        @Override
        public void run() {
            int u = 0;
            while (u < this.dist.length) {
                this.dist[u] = Double.MAX_VALUE;
                ++u;
            }
            int idxInit = this.yInit * InteractiveMultipleDjikstraTracing.this.width + this.xInit;
            this.dist[idxInit] = 0.0;
            int currentIdx = idxInit;
            int currentX = this.xInit;
            int currentY = this.yInit;
            boolean stop = false;
            while (!stop && this.run) {
                double ival = this.data[currentIdx];
                double currentDist = this.dist[currentIdx];
                if (currentX > 0) {
                    this.test(currentDist, ival, currentIdx, currentIdx - 1);
                    if (currentY < InteractiveMultipleDjikstraTracing.this.height - 1) {
                        this.test(currentDist, ival, currentIdx, currentIdx + InteractiveMultipleDjikstraTracing.this.width - 1);
                        this.test(currentDist, ival, currentIdx, currentIdx + InteractiveMultipleDjikstraTracing.this.width);
                    }
                    if (currentX < InteractiveMultipleDjikstraTracing.this.width - 1) {
                        this.test(currentDist, ival, currentIdx, currentIdx + 1);
                        if (currentY < InteractiveMultipleDjikstraTracing.this.height - 1) {
                            this.test(currentDist, ival, currentIdx, currentIdx + InteractiveMultipleDjikstraTracing.this.width + 1);
                        }
                    }
                } else if (currentX < InteractiveMultipleDjikstraTracing.this.width - 1) {
                    this.test(currentDist, ival, currentIdx, currentIdx + 1);
                    if (currentY < InteractiveMultipleDjikstraTracing.this.height - 1) {
                        this.test(currentDist, ival, currentIdx, currentIdx + InteractiveMultipleDjikstraTracing.this.width + 1);
                        this.test(currentDist, ival, currentIdx, currentIdx + InteractiveMultipleDjikstraTracing.this.width);
                    }
                } else if (currentY < InteractiveMultipleDjikstraTracing.this.height - 1) {
                    this.test(currentDist, ival, currentIdx, currentIdx + InteractiveMultipleDjikstraTracing.this.width);
                }
                this.visited[currentIdx] = true;
                InteractiveMultipleDjikstraTracing.this.visitedLock.lock();
                InteractiveMultipleDjikstraTracing.this.visitedCondition.signalAll();
                InteractiveMultipleDjikstraTracing.this.visitedLock.unlock();
                double minDist = Double.MAX_VALUE;
                int minIdx = -1;
                int cnt = 0;
                while (cnt < this.dist.length) {
                    if (!this.visited[cnt] && (this.dist[cnt] < minDist || minIdx == -1)) {
                        minDist = this.dist[cnt];
                        minIdx = cnt;
                    }
                    ++cnt;
                }
                if (minIdx == -1) {
                    stop = true;
                    continue;
                }
                currentIdx = minIdx;
                currentY = currentIdx / InteractiveMultipleDjikstraTracing.this.width;
                currentX = currentIdx - InteractiveMultipleDjikstraTracing.this.width * currentY;
            }
            if (this.run) {
                InteractiveMultipleDjikstraTracing.this.distanceMapLock.lock();
                InteractiveMultipleDjikstraTracing.this.pathMap = this.prev;
                InteractiveMultipleDjikstraTracing.this.distanceMapLock.unlock();
                InteractiveMultipleDjikstraTracing.this.mapReady = true;
            }
            InteractiveMultipleDjikstraTracing.this.mapThreadListLock.lock();
            InteractiveMultipleDjikstraTracing.this.mapThreadList.remove(this);
            InteractiveMultipleDjikstraTracing.this.mapThreadListLock.unlock();
            InteractiveMultipleDjikstraTracing.this.seq.overlayChanged((Overlay)InteractiveMultipleDjikstraTracing.this);
        }
    }

    class ComputePathThread
    extends StoppableThread
    implements ActionListener {
        int xInit;
        int yInit;
        int xFinal;
        int yFinal;
        boolean run;

        public ComputePathThread(int xInit, int yInit, int xFinal, int yFinal) {
            this.run = true;
            this.xInit = xInit;
            this.yInit = yInit;
            this.xFinal = xFinal;
            this.yFinal = yFinal;
        }

        private void runFunction() {
            InteractiveMultipleDjikstraTracing.this.distanceMapLock.lock();
            int[] prev = new int[InteractiveMultipleDjikstraTracing.this.pathMap.length];
            System.arraycopy(InteractiveMultipleDjikstraTracing.this.pathMap, 0, prev, 0, prev.length);
            InteractiveMultipleDjikstraTracing.this.distanceMapLock.unlock();
            int width = InteractiveMultipleDjikstraTracing.this.seq.getWidth();
            int idxInit = this.xInit + this.yInit * width;
            int idxFinal = this.xFinal + this.yFinal * width;
            ArrayList<Integer> path = new ArrayList<Integer>();
            int idx = idxFinal;
            path.add(new Integer(idxFinal));
            while (idx != idxInit && !this.isInterrupted() && this.run) {
                idx = prev[idx];
                path.add(new Integer(idx));
            }
            int pathLength = path.size();
            double[][] pathTab = new double[pathLength][2];
            int cnt = 0;
            while (cnt < pathLength) {
                int tmp = (Integer)path.get(pathLength - cnt - 1);
                pathTab[cnt] = new double[]{tmp % width, tmp / width};
                ++cnt;
            }
            if (this.run) {
                InteractiveMultipleDjikstraTracing.this.pathLock.lock();
                InteractiveMultipleDjikstraTracing.this.optimalPath = pathTab;
                if (!InteractiveMultipleDjikstraTracing.this.pathListenerList.isEmpty()) {
                    double[][] pathClone = new double[InteractiveMultipleDjikstraTracing.this.optimalPath.length][];
                    int i = 0;
                    while (i < InteractiveMultipleDjikstraTracing.this.optimalPath.length) {
                        pathClone[i] = (double[])InteractiveMultipleDjikstraTracing.this.optimalPath[i].clone();
                        ++i;
                    }
                    if (InteractiveMultipleDjikstraTracing.this.state == DrawingState.SECOND_DOUBLE_CLICKED) {
                        FireListenersThread thr = new FireListenersThread(pathClone, PathEvent.FINAL_PATH);
                        thr.start();
                    } else {
                        FireListenersThread thr = new FireListenersThread(pathClone, PathEvent.TEMPORARY_PATH);
                        thr.start();
                    }
                }
                InteractiveMultipleDjikstraTracing.this.pathLock.unlock();
                InteractiveMultipleDjikstraTracing.this.seq.overlayChanged((Overlay)InteractiveMultipleDjikstraTracing.this);
            }
        }

        @Override
        public void run() {
            this.runFunction();
            InteractiveMultipleDjikstraTracing.this.pathThreadListLock.lock();
            InteractiveMultipleDjikstraTracing.this.pathThreadList.remove(this);
            InteractiveMultipleDjikstraTracing.this.pathThreadListLock.unlock();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.interrupt();
        }

        @Override
        public void stopThread() {
            this.run = false;
        }
    }

    class ComputePathThreadWaiting
    extends StoppableThread
    implements ActionListener {
        int xInit;
        int yInit;
        int xFinal;
        int yFinal;
        boolean run;

        public ComputePathThreadWaiting(int xInit, int yInit, int xFinal, int yFinal) {
            this.run = true;
            this.xInit = xInit;
            this.yInit = yInit;
            this.xFinal = xFinal;
            this.yFinal = yFinal;
        }

        private void runFunction() {
            boolean found = false;
            boolean wait = false;
            int idxInit = this.xInit + this.yInit * InteractiveMultipleDjikstraTracing.this.width;
            int idxFinal = this.xFinal + this.yFinal * InteractiveMultipleDjikstraTracing.this.width;
            ArrayList<Thread> threadList = new ArrayList<Thread>();
            int[] prev = new int[InteractiveMultipleDjikstraTracing.this.width * InteractiveMultipleDjikstraTracing.this.height];
            block4: while (this.run && !found) {
                InteractiveMultipleDjikstraTracing.this.mapThreadListLock.lock();
                threadList = new ArrayList();
                threadList.addAll(InteractiveMultipleDjikstraTracing.this.mapThreadList);
                InteractiveMultipleDjikstraTracing.this.mapThreadListLock.unlock();
                for (Thread thr : threadList) {
                    ComputeMapThread mapThread = (ComputeMapThread)thr;
                    if (mapThread.run && mapThread.xInit == this.xInit && mapThread.yInit == mapThread.yInit) {
                        if (mapThread.visited[idxFinal]) {
                            InteractiveMultipleDjikstraTracing.this.visitedLock.lock();
                            System.arraycopy(mapThread.prev, 0, prev, 0, mapThread.prev.length);
                            found = true;
                            InteractiveMultipleDjikstraTracing.this.visitedLock.unlock();
                            continue block4;
                        }
                        wait = true;
                        continue block4;
                    }
                    if (!wait) continue;
                    InteractiveMultipleDjikstraTracing.this.visitedLock.lock();
                    try {
                        try {
                            InteractiveMultipleDjikstraTracing.this.visitedCondition.await();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            InteractiveMultipleDjikstraTracing.this.visitedLock.unlock();
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        InteractiveMultipleDjikstraTracing.this.visitedLock.unlock();
                        throw throwable;
                    }
                    InteractiveMultipleDjikstraTracing.this.visitedLock.unlock();
                }
            }
            ArrayList<Integer> path = new ArrayList<Integer>();
            int idx = idxFinal;
            path.add(new Integer(idxFinal));
            while (idx != idxInit && !this.isInterrupted() && this.run) {
                idx = prev[idx];
                path.add(new Integer(idx));
            }
            int pathLength = path.size();
            double[][] pathTab = new double[pathLength][2];
            int cnt = 0;
            while (cnt < pathLength) {
                int tmp = (Integer)path.get(pathLength - cnt - 1);
                pathTab[cnt] = new double[]{tmp % InteractiveMultipleDjikstraTracing.this.width, tmp / InteractiveMultipleDjikstraTracing.this.width};
                ++cnt;
            }
            if (this.run) {
                InteractiveMultipleDjikstraTracing.this.pathLock.lock();
                InteractiveMultipleDjikstraTracing.this.optimalPath = pathTab;
                if (!InteractiveMultipleDjikstraTracing.this.pathListenerList.isEmpty()) {
                    double[][] pathClone = new double[InteractiveMultipleDjikstraTracing.this.optimalPath.length][];
                    int i = 0;
                    while (i < InteractiveMultipleDjikstraTracing.this.optimalPath.length) {
                        pathClone[i] = (double[])InteractiveMultipleDjikstraTracing.this.optimalPath[i].clone();
                        ++i;
                    }
                    if (InteractiveMultipleDjikstraTracing.this.state == DrawingState.SECOND_DOUBLE_CLICKED) {
                        FireListenersThread thr = new FireListenersThread(pathClone, PathEvent.FINAL_PATH);
                        thr.start();
                    } else {
                        FireListenersThread thr = new FireListenersThread(pathClone, PathEvent.TEMPORARY_PATH);
                        thr.start();
                    }
                }
                InteractiveMultipleDjikstraTracing.this.pathLock.unlock();
                InteractiveMultipleDjikstraTracing.this.seq.overlayChanged((Overlay)InteractiveMultipleDjikstraTracing.this);
            }
        }

        @Override
        public void run() {
            this.runFunction();
            InteractiveMultipleDjikstraTracing.this.pathThreadListLock.lock();
            InteractiveMultipleDjikstraTracing.this.pathThreadList.remove(this);
            InteractiveMultipleDjikstraTracing.this.pathThreadListLock.unlock();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.interrupt();
        }

        @Override
        public void stopThread() {
            this.run = false;
        }
    }

    public static enum DrawingState {
        RESET,
        FIRST_CLICKED,
        SECOND_CLICKED,
        SECOND_DOUBLE_CLICKED;

    }

    class FireListenersThread
    extends Thread {
        double[][] path;
        PathEvent pathEvent;

        public FireListenersThread(double[][] path, PathEvent event) {
            InteractiveMultipleDjikstraTracing.this.runningThreads.add(this);
            this.path = path;
            this.pathEvent = event;
        }

        @Override
        public void run() {
            for (PathListener listener : InteractiveMultipleDjikstraTracing.this.pathListenerList) {
                listener.refreshPath(this.pathEvent, InteractiveMultipleDjikstraTracing.this, this.path);
            }
            InteractiveMultipleDjikstraTracing.this.runningThreads.remove(this);
        }
    }

    abstract class StoppableThread
    extends Thread {
        StoppableThread() {
        }

        public abstract void stopThread();
    }
}

